/*
 * Some stuff that will be performed on each login.
 * The main command parsing is also run from here in a loop.
 *
 */
#include "proto.h"
#include <time.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <unistd.h>

time_t last;						// Date of user's last call

extern int doquit;

int eb_enterbbs(void)
{
	char query[QUERY_MAX];
	int mmode=1;
	int selfd;
	char entbuf[200];
	int scanf;
	struct Selected seltmp;
	struct Selected *selp;
	
	changenodestatus("Logging in...");
	
	sprintf(entbuf,"Login: %s @ %s (Security: %d)\nFrom : %s @ %s\n",user.user_realname,user.user_handle,user.user_securitylevel,user.user_zipcity,user.user_organization);
	writelog(entbuf);

	user.user_logontime=time(NULL);
	
	if ( (!(user.user_toggles & TOGGLE_ACC_STAT_1)) && (user.user_toggles &
	TOGGLE_ACC_STAT_2)) {
		TypeFile("accountfrozen",TYPE_MAKE);
		return(0);
	}
	
	if (user.user_connections==0) {
		writelog("** New User **\n\n");
	} else {
		writelog("\n");
	}

	access_flags=user.user_secflags;

	if (currnode->Node_Flags & NODE_NOTIFY) {
		char mesbuf[1024];
		sprintf(mesbuf,"\n[0m%s from %s logged on to node #%d\n",
			maincfg.CFG_FLAGS & FLAG_HANDLE ? user.user_handle : user.user_realname,
			maincfg.CFG_FLAGS & FLAG_ORGANIZATION ? user.user_organization : user.user_zipcity,
			node);
		
		olmall(2,mesbuf);
	}
	
	setprotocol();

	selfd=open("data/selected.dat",O_RDONLY);
	if (selfd==-1) 
	{
		DDPut(sd[selerrstr]);
		return(0);
	}
	
	SelectList=NewList();
	while(read(selfd,&seltmp, sizeof(struct Selected)))
	{
		selp=malloc(sizeof(struct Selected));
		memcpy(selp, &seltmp, sizeof(struct Selected));
		AddTail(SelectList, (struct Node *)selp);
	}
	close(selfd);
	
	if ((time(NULL)-user.user_lastcall>60*60*24)
		|| user.user_connections==0
		|| user.user_lastcall>time(NULL))	// Accidentally set in future?
	{
		timeleft=user.user_dailytimelimit*60;
		user.user_timeremaining=user.user_dailytimelimit;
		mi_sql_setuser(&vm_database, "user_timeremain", user.user_serial_id,
					'=', user.user_timeremaining);
	}
	else
	{
		timeleft=user.user_timeremaining*60;
	}
	
//	sprintf(entbuf, "li: %d tr: %d tl:%d\n", user.user_dailytimelimit,
//			user.user_timeremaining, timeleft);
//	DDPut(entbuf);
	
	endtime=time(NULL)+timeleft;

	if(user.user_firstcall==0)
	{
		sprintf(query, "UPDATE vmatik_user SET user_firstcall=NOW()
						WHERE user_id=%d AND user_firstcall=0",
						user.user_serial_id);
		mysql_query(&vm_database, query);

		user.user_firstcall=time(NULL);
	}

	mi_sql_setuser(&vm_database, "user_calls", user.user_serial_id,
					'+', 1);
	user.user_connections++;
	user.user_failedlogins=0;

	TypeFile("welcome",TYPE_SEC|TYPE_MAKE|TYPE_WARN);

	dp_rundoorbatch("logindoors.dat",0);
	
	scanf=0;
	if (user.user_toggles & TOGGLE_ASK_MAILSCAN) {
		DDPut(sd[scanformailstr]);
		if (HotKey(HOT_YESNO) == 1) scanf=1;
	} else if (!(user.user_toggles & TOGGLE_NOMAILCHECK)) scanf=1;

//	DDPut("Hahaha!\n");

	if (scanf) 
		ms_scanfornewmail();

//	DDPut("Hilijo!\n");

	scanf=0;
   
	if (user.user_toggles & TOGGLE_ASK_FILESCAN) {
		DDPut(sd[scanforfilesstr]);
		if (HotKey(HOT_YESNO) == 1) scanf=1;
	} else if (user.user_toggles & TOGGLE_NEWSCAN_ON) scanf=1;

	if (scanf) 
		fl_globalnewscan();
   
	checkforpartialuploads(0);
	eb_checkforftp(0,0,0);

	if(access_flags & SECB_JOINCONF)
	{
		if (!jc_joinconf(user.user_defconf_id,JC_SHUTUP)) 
		{
			if (!jc_joinconf(maincfg.CFG_JOINIFAUTOJOINFAILS,JC_SHUTUP)) 
			{
				DDPut(sd[joinconferrstr]);
				return(0);
			}
		}
	}
	else
	{
		if (!jc_joinconf(maincfg.CFG_JOINIFAUTOJOINFAILS,JC_SHUTUP)) 
		{
				DDPut(sd[joinconferrstr]);
				return(0);
		}
	}
		

	jc_changefilearea(user.user_defarea_id,JC_SHUTUP|JC_ABSOLUTE);

	while(mmode)
	{
		mmode=domenu(mmode);
		doquit=0;
	}

	return(1);
}


/* 
 * Retrieves the security flags for the user
 *
 */
bint eb_getsec(MYSQL *db, int user_id)
{
	return(mi_sql_getuserb(db, "user_secflags", user_id));
}

int setprotocol(void)
{
	if (user.user_protocol) {
		struct VMatik_Protocol *pr;
		pr=protocols;
		while (1)
		{
			if (pr->Protocol_ID==0) {
				protocol=protocols;
				user.user_protocol=protocol->Protocol_ID;
				break;
			}
			if (pr->Protocol_ID==user.user_protocol) {
				protocol=pr;
				break;
			}
			pr++;
		}
	} else {
		protocol=protocols;
		user.user_protocol=protocol->Protocol_ID;
	}
	return 1;
}

int checkforpartialuploads(int mode)
{
	int fd;
	char buf[1024];
	char buf2[256];
	sprintf(buf,"%s/users/%d/badxfer.dat",origdir,user.user_serial_id);
	fd=open(buf,O_RDONLY);
	if (fd < 0) return 0;
	
	read(fd,&buf2,256);
	close(fd);
	sprintf(buf,sd[partstr],buf2);
	DDPut(buf);
	if (!mode) {
		DDPut(sd[res1str]);
	} else {
		DDPut(sd[res2str]);
		switch(HotKey(HOT_YESNO))
		{
			case 1:
				copypartial();
			break;
			case 2:
				DDPut(sd[resdelstr]);
				switch(HotKey(HOT_YESNO))
				{
					case 1:
						sprintf(buf,"%s/users/%d/badxfer.dat",origdir,user.user_serial_id);
						unlink(buf);
					break;
					case 0:
					case -1:
						return 0;
					break;
				
				
				}
			break;
			case 0:
			case -1:
				return 0;
			break;
			
		}
	}
	return 1;
}

int copypartial()
{
	int fd, fd2;
	char buf[1024];
	char buf2[256];
	char cbuf[COPY_BUFSIZE];
	int i;
	
	sprintf(buf,"%s/users/%d/badxfer.dat",origdir,user.user_serial_id);
	fd=open(buf,O_RDONLY);
	if (fd < 0) return 0;
	read(fd,&buf2,256);

	sprintf(buf,"%s%s",currnode->Node_TempDir,buf2);

	fd2=open(buf,O_WRONLY|O_CREAT,0644);
	while((i=read(fd,&cbuf,COPY_BUFSIZE)))
	{
		write(fd2,cbuf,i);
	}
	close(fd); close(fd2);
	sprintf(buf,"%s/users/%d/badxfer.dat",origdir,user.user_serial_id);
	unlink(buf);
	return 1;
}

int eb_checkforftp(int mode, char *dp, char *log)
{
	FILE *logf=0;
	int fcount=0;
	struct dirent *dent;
	DIR *dh;
	char buf[1024];
	char buf2[1024];
	sprintf(buf,"%s/users/%d/ftp/ul",origdir,user.user_serial_id);
	
	if ((dh=opendir(buf)))
	{
		if (mode==2) {
			logf=fopen(log,"w");
		}
		while((dent=readdir(dh))) {
          		if (dent->d_name[0] == '.' && (dent->d_name[1] == '\0' || (dent->d_name[1] == '.' && dent->d_name[2] == '\0'))) continue;   
			if (mode==2) {
				struct stat st;
				
				sprintf(buf,"%s/users/%d/ftp/ul/%s",origdir,user.user_serial_id,dent->d_name);
				sprintf(buf2,"%s%s",dp,dent->d_name);
				stat(buf,&st);
				newrename(buf,buf2);
				if (logf) fprintf(logf,
						  "S %6ld %5d bps %4d cps   0 errors     0 %4d %s %d\n",
						  st.st_size,0,0,1024,dent->d_name,0);
			}
			fcount++;
		}
		if (logf) fclose(logf);
		closedir(dh);
	}
	if (fcount) {
		if (!mode) {
			DDPut(sd[ftp1str]);
		} else if (mode==1) {
			DDPut(sd[ftp2str]);
			if (HotKey(HOT_YESNO)==1) {
				eb_checkforftp(2,dp,log);
				return 1;
			}
		}
	}
	return 0;
}
