/*
 * This file includes the functions that are concerned with
 * the user editing her own datas.
 *
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "proto.h"
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

void eo_switches(void);

/*
 * Asks user to change the filearea sort order
 *
 */
void eo_changesortorder(int neworder, int area_id)
{
	char buffer[2048];
	char askbuf[20];

	changenodestatus("Changing sortorder");

	DDPut("Available filearea display orders\n\n");

	if(neworder==-1)
	{
		sprintf(buffer, "\n\n0) %-30s 1) %-30s\n2) %-30s 3) %-30s\n4) %-30s\n\nSelect a new sort order\n: ",
		   	             "Conf default", "Alphabetical", "Reverse alphabetical",
	      				 "Chronological", "Reverse chronological");
		DDPut(buffer);
		askbuf[0]='0';
		askbuf[1]=0;
		if (!(Prompt(askbuf,3,0))) return;
		neworder=atoi(askbuf);
	}

	if(neworder>=0 && neworder<=4)
	{
		char query[QUERY_MAX];

		if(neworder==0)
		{
			sprintf(query, "area_id=%d", area_id);
			neworder=mi_sql_getnum(&vm_database, "area_sortorder", 
					"vmatik_fileareas", query);
			if(neworder==0 || neworder>4)
				neworder=SORT_ALPHA;
		}

		sprintf(query, "REPLACE INTO vmatik_order
						(order_user, order_area, order_type)
						VALUES (%d,%d,%d)",
						user.user_serial_id, area_id, neworder);
		mysql_query(&vm_database, query);
		sprintf(query, "UPDATE vmatik_precalc SET
						precalc_date=0 WHERE
						precalc_user=%d AND precalc_area=%d",
						user.user_serial_id, area_id);
		mysql_query(&vm_database, query);

		DDPut("\nNew order is set.\n\n");
	}
	else
		DDPut("\nInvalid order.\n\n");

}

/*
 * This function lets the user to modify some of her own
 * datas and toggles.
 *
 */
int eo_editown(int mode)
{
	char query[QUERY_MAX];
	char askbuf[100];
	int do_repeat=0;
			
	changenodestatus("Editing personal data");
	sprintf(query, "user_id=%d", user.user_serial_id);

viewag:
	mi_loaduser(user.user_serial_id, &user);
	TypeFile("editown",TYPE_MAKE|TYPE_WARN);

	DDPut(sd[eupromptstr]);
	askbuf[0]=0;
	if (!(Prompt(askbuf,3,0)))
		return(0);

	do_repeat=1;

	if (!(strcasecmp(askbuf,"1"))) {
		if (!dm_isaccess(SECB_EDITREALNAME,access_flags)) 
			goto viewag;
		while(do_repeat)
		{
			DDPut(sd[eu1str]);
			if (!(Prompt(user.user_realname,sizeof(user.user_realname),0)))
				return(0);
			removespaces(user.user_realname);
			
			sprintf(query, "user_id=%d", user.user_serial_id);
			if(mi_sql_setstr(&vm_database, "user_name", "vmatik_user",
							query, user.user_realname))
				do_repeat=0;
			else
				DDPut(sd[newalreadystr]);
		}
		goto viewag;
	}               

	if (!(strcasecmp(askbuf,"2"))) {
		if (!dm_isaccess(SECB_EDITHANDLE,access_flags)) 
			goto viewag;
		
		while(do_repeat)
		{
			DDPut(sd[eu2str]);
			if (!(Prompt(user.user_handle,sizeof(user.user_handle),0))) 
				return(0);
			removespaces(user.user_handle);
		
			if(mi_sql_setstr(&vm_database, "user_handle", "vmatik_user",
						query, user.user_handle))
				do_repeat=0;
			else
				DDPut(sd[newalreadystr]);
		}
		goto viewag;
	}               
	
	if (!(strcasecmp(askbuf,"3"))) {
		DDPut(sd[eu10str]);
		if (!(Prompt(user.user_email,sizeof(user.user_email),0))) 
			return(0);
		mi_sql_setstr(&vm_database, "user_email", "vmatik_user",
						query, user.user_email);
		goto viewag;
	}

	if (!(strcasecmp(askbuf,"4"))) {
		DDPut(sd[eu3str]);
		if (!(Prompt(user.user_organization,sizeof(user.user_organization),0))) 
			return(0);
		
		mi_sql_setstr(&vm_database, "user_org", "vmatik_user",
						query, user.user_organization);

		goto viewag;
	}

	if (!(strcasecmp(askbuf,"5"))) {
		DDPut(sd[eu4str]);
		if (!(Prompt(user.user_zipcity,sizeof(user.user_zipcity),0))) 
			return(0);
			
		mi_sql_setstr(&vm_database, "user_city", "vmatik_user",
						query, user.user_zipcity);
		
		goto viewag;
	}

	if (!(strcasecmp(askbuf,"6"))) {
		DDPut(sd[eu5str]);
		if (!(Prompt(user.user_voicephone,sizeof(user.user_voicephone),0))) 
			return(0);
		mi_sql_setstr(&vm_database, "user_voicephone", "vmatik_user",
						query, user.user_voicephone);
		goto viewag;
	}
	
	if (!(strcasecmp(askbuf,"7"))) {
		DDPut(sd[eu9str]);
		if (!(Prompt(user.user_dataphone,sizeof(user.user_dataphone),0)))
			return(0);
	
		mi_sql_setstr(&vm_database, "user_dataphone", "vmatik_user",
						query, user.user_dataphone);
		
		goto viewag;
	}

	if (!(strcasecmp(askbuf,"8"))) {
		MD_CTX context;
		char passbuf[5*PASSWD_SIZE];

		DDPut(sd[eu6str]);
		askbuf[0]=0;
		if (!(Prompt(askbuf,sizeof(user.user_password),0))) 
			return(0);
		if (askbuf[0]==0) 
			goto viewag;
		mi_strupr(askbuf);

		MDInit(&context);
		MDUpdate(&context,askbuf,strlen(askbuf));
		MDFinal(user.user_password,&context);

		mysql_escape_string(passbuf, user.user_password, PASSWD_SIZE);
		mi_sql_setstr(&vm_database, "user_password", "vmatik_user",
						query, askbuf);
		
		goto viewag;
	}

	if (!(strcasecmp(askbuf,"9"))) {
		int newlength;
	
		newlength=nu_ask_screenl();

		if(newlength)
			mi_sql_setuser(&vm_database, "user_screenlength", 
						user.user_serial_id, '=', newlength);
		
		goto viewag;
	}

	if (!(strcasecmp(askbuf,"10"))) {
		struct VMatik_Protocol *tp;
		
		TypeFile("protocols",TYPE_MAKE|TYPE_WARN);
		DDPut(sd[eu8str]);
		askbuf[0]=0;
		if (user.user_protocol) {
			askbuf[0]=user.user_protocol;
			askbuf[1]=0;
		}
		if (!(Prompt(askbuf,3,0))) 
			return(0);
		askbuf[0]=toupper(askbuf[0]);
		if (!askbuf[0]) 
			goto viewag;
		
		tp=protocols;
		while (1)
		{
			if (tp->Protocol_ID==0) 
				goto viewag;
			if (tp->Protocol_ID==askbuf[0]) {
				protocol=tp;

				mi_sql_setuser(&vm_database, "user_protocol", 
							user.user_serial_id, '=', askbuf[0]);
				goto viewag;
			}
			tp++;
		}
	}

	if (!(strcasecmp(askbuf,"v"))) {
		goto viewag;
	}

	if (!(strcasecmp(askbuf,"s"))) {
		eo_switches();
		goto viewag;
	}

	if ((!(strcasecmp(askbuf,"q")) || (askbuf[0]==0))) {
		mi_loaduser(user.user_serial_id, &user);
		return(1);
	} else 
		goto viewag;
	
	return(0);
}

/*
 * Lets the user edit her switch (toggle) selections.
 *
 */
void eo_switches(void)
{
	char inp[82];
	char *s;
	char tok[82];
	ULONG toggles;
	
	toggles=mi_sql_getuser(&vm_database, "user_toggles", user.user_serial_id);
	user.user_toggles=toggles;
	
	for(;;)
	{
		char buffa[200];
		char *togf;

		DDPut(sd[clrscrstr]);

//		DDPut("[2J[H");

		DDPut("\n");            
		if (toggles & TOGGLE_ASK_MAILSCAN) togf=sd[tsaskstr];
			else if (toggles & TOGGLE_NOMAILCHECK) togf=sd[tsnostr];
			else togf=sd[tsyesstr];
		sprintf(buffa,sd[togglinestr],1,sd[ts1str],togf);
		DDPut(buffa);

		if (toggles & TOGGLE_ASK_FILESCAN) togf=sd[tsaskstr];
			else if (toggles & TOGGLE_NEWSCAN_ON) togf=sd[tsyesstr];
			else togf=sd[tsnostr];
		sprintf(buffa,sd[togglinestr],2,sd[ts2str],togf);
		DDPut(buffa);

		DDPut("\n");
		
		if (toggles & TOGGLE_ASK_EDITOR) togf=sd[tsaskstr];
			else if (toggles & TOGGLE_FSED) togf=sd[tsyesstr];
			else togf=sd[tsnostr];
		sprintf(buffa,sd[togglinestr],3,sd[ts3str],togf);
		DDPut(buffa);

		if (toggles & TOGGLE_NO_OLMS) togf=sd[tsnostr]; else togf=sd[tsyesstr];
		sprintf(buffa,sd[togglinestr],4,sd[ts4str],togf);
		DDPut(buffa);

		DDPut("\n");

		if (toggles & TOGGLE_QUICK_UL) togf=sd[tsyesstr]; else togf=sd[tsnostr];
		sprintf(buffa,sd[togglinestr],5,sd[ts5str],togf);
		DDPut(buffa);

		DDPut("\n");
	
		DDPut(sd[tspromptstr]);
		inp[0]=0;
		if (!(Prompt(inp,80,0))) return;
		s=inp;
		if (!*inp) {
			strcpy(inp,"s");
		}
		while( (s=strspa(s,tok)) )
		{
			int numb;
			if (!strcasecmp("s",tok)) {
				mi_sql_setuser(&vm_database, "user_toggles",
								user.user_serial_id, '=', toggles);
				user.user_toggles=toggles;
				return;
			} else if (!strcasecmp("a",tok)) {
				return;
			} else if (!strcasecmp("v",tok)) {
				break;
			} else {
				numb=atoi(tok);
				switch(numb)
				{
					case 1:
						if (toggles & TOGGLE_NOMAILCHECK) {
							toggles |= TOGGLE_ASK_MAILSCAN;
							toggles &= ~TOGGLE_NOMAILCHECK;
//							sprintf(buffa,sd[asktlinestr],sd[ts1str]);
						} else if (toggles & TOGGLE_ASK_MAILSCAN) {
							toggles &= ~TOGGLE_ASK_MAILSCAN;
							toggles &= ~TOGGLE_NOMAILCHECK;
//							sprintf(buffa,sd[ontlinestr],sd[ts1str]);
						} else {
							toggles &= ~TOGGLE_ASK_MAILSCAN;
							toggles |= TOGGLE_NOMAILCHECK;
//							sprintf(buffa,sd[offtlinestr],sd[ts1str]);
						}
//						DDPut(buffa);
						break;
					case 2:
						if (toggles & TOGGLE_NEWSCAN_ON) {
							toggles |= TOGGLE_ASK_FILESCAN;
							toggles &= ~TOGGLE_NEWSCAN_ON;
//							sprintf(buffa,sd[asktlinestr],sd[ts2str]);
						} else if (toggles & TOGGLE_ASK_FILESCAN) {
							toggles &= ~TOGGLE_ASK_FILESCAN;
							toggles &= ~TOGGLE_NEWSCAN_ON;
//							sprintf(buffa,sd[offtlinestr],sd[ts2str]);
						} else {
							toggles &= ~TOGGLE_ASK_FILESCAN;
							toggles |= TOGGLE_NEWSCAN_ON;
//							sprintf(buffa,sd[ontlinestr],sd[ts2str]);
						}
//						DDPut(buffa);
						break;
					case 3:                                 
						if (toggles & TOGGLE_FSED) {
							toggles |= TOGGLE_ASK_EDITOR;
							toggles &= ~TOGGLE_FSED;
//							sprintf(buffa,sd[asktlinestr],sd[ts3str]);
						} else if (toggles & TOGGLE_ASK_EDITOR) {
							toggles &= ~TOGGLE_ASK_EDITOR;
							toggles &= ~TOGGLE_FSED;
//							sprintf(buffa,sd[offtlinestr],sd[ts3str]);
						} else {
							toggles &= ~TOGGLE_ASK_EDITOR;
							toggles |= TOGGLE_FSED;
//							sprintf(buffa,sd[ontlinestr],sd[ts3str]);
						}
//						DDPut(buffa);
						break;
					case 4:                                 
						if (toggles & TOGGLE_NO_OLMS) {
							toggles &= ~TOGGLE_NO_OLMS;
//							sprintf(buffa,sd[ontlinestr],sd[ts4str]);
						} else {
							toggles |= TOGGLE_NO_OLMS;
//							sprintf(buffa,sd[offtlinestr],sd[ts4str]);
						}
//						DDPut(buffa);
						break;
					case 5:                                 
						if (toggles & TOGGLE_QUICK_UL) {
							toggles &= ~TOGGLE_QUICK_UL;
//							sprintf(buffa,sd[offtlinestr],sd[ts5str]);
						} else {
							toggles |= TOGGLE_QUICK_UL;
//							sprintf(buffa,sd[ontlinestr],sd[ts5str]);
						}
//						DDPut(buffa);
						break;
					default:
						break;
				}
			}
		}
	}
}

int tagmessageareas(void)
{
	char tbuf[500];
	char *sta;
	struct VMatik_MsgBase *mb;
	struct List *backup;
	int bcnt;
	char inp[90];
	char *s;
	char tok[90];
	int i,b;

	backup=CopyList(SelectList);
	
vagain:
	DDPut("[2J[H");

	bcnt=conf->CONF_MSGBASES;
		
	i=0;b=0;
	while (bcnt)
	{
		mb=&(conf->Conf_MsgBases[b]);
		i++;
		if (i==3) {
			DDPut("\n");
			i=1;
		}
		if (isbasetagged(conf->CONF_NUMBER,mb->MSGBASE_NUMBER)) {
			sta="ON";
		} else sta="OFF";
		
		sprintf(tbuf,sd[tbclinestr],mb->MSGBASE_NUMBER,mb->MSGBASE_NAME,sta);
		DDPut(tbuf);
		b++;
		bcnt--;
	}               

	DDPut("\n");
	while (1) 
	{
		DDPut(sd[tbpromptstr]);
		inp[0]=0;
		if (!(Prompt(inp,80,0))) return 0;
		s=inp;
		if (!*inp) {
			strcpy(inp,"s");
		}
		while( (s=strspa(s,tok)) )
		{
			if (!strcasecmp(tok,"c"))							// Cancel
			{
				ClearList(SelectList);
				SelectList=CopyList(backup);
				ClearList(backup);

				return 0;
			} else if (!strcasecmp(tok,"v")) 					// View
			{
				goto vagain;
			} else if (!strcasecmp(tok,"s")) 					// Save
			{
				int selfd;
				sprintf(tbuf,"users/%d/selected.dat",user.user_serial_id);
				selfd=open(tbuf,O_WRONLY|O_CREAT,0664);
				if (selfd!=-1)
				{
					struct Selected *seltmp;

					seltmp=(struct Selected *)SelectList->lh_Head;
					while(seltmp->shead.ln_Succ)
					{
						write(selfd,seltmp,sizeof(struct Selected));
						seltmp=(struct Selected *)seltmp->shead.ln_Succ;
					}	
					close(selfd);
				}
				return 0;
			} else if (!strcasecmp(tok,"-")) 				// Remove all
			{
				struct Selected *seltmp;
				struct Selected *newp;

				seltmp=(struct Selected *)SelectList->lh_Head;
				while(seltmp->shead.ln_Succ)
				{
					newp=(struct Selected *)seltmp->shead.ln_Succ;
					if(seltmp->type==SEL_MSGBASE && 
					   seltmp->conf_nr==conf->CONF_NUMBER)
					{
							Remove((struct Node *)seltmp);
							free(seltmp);
					}
					seltmp=newp;
				}
				
				DDPut(sd[tballoffstr]);
				goto vagain;
			} else if (!strcasecmp(tok,"+")) 				// Tag all
			{
				bcnt=conf->CONF_MSGBASES;

				b=0;

				while (bcnt)
				{
					struct Selected *newp;
					
					newp=malloc(sizeof(struct Selected));
					newp->type=SEL_MSGBASE;
					newp->conf_nr=conf->CONF_NUMBER;
					newp->ID=b;
		
					AddTail(SelectList, (struct Node *)newp);

					b++;
					bcnt--;
				}               
				DDPut(sd[tballonstr]);
				goto vagain;
			} else {
				if(i>=0 && i<=conf->CONF_MSGBASES)
				{
					struct Selected *newn;

					if(!isbasetagged(conf->CONF_NUMBER, i))
					{
						newn=malloc(sizeof(struct Selected));
						newn->type=SEL_MSGBASE;
						newn->conf_nr=conf->CONF_NUMBER;
						newn->ID=i;

						AddTail(SelectList, (struct Node *)newn);
					}
					else
					{
						newn=(struct Selected *)SelectList->lh_Head;
						while(newn->shead.ln_Succ)
						{
							if(newn->type==SEL_MSGBASE && 
							   newn->conf_nr==conf->CONF_NUMBER &&
							   newn->ID==i)
							{
								Remove((struct Node *)newn);
								free(newn);
								break;
							}
							newn=(struct Selected *)newn->shead.ln_Succ;
						}
					}
							   
				}
			goto vagain;
			}
		}
	}
}

/*
 * Asks user to select the conferences she wants to use
 *
 */
int tagconfs(void)
{
	struct List *backup;
	char tbuf[500];
	char *sta;
	struct VMatik_Conference *mc;
	char inp[90];
	char *s;
	char tok[90];
		
	int i;

	backup=CopyList(SelectList);

vagain:
	DDPut("[2J[H");

	mc=(struct VMatik_Conference *)confs->lh_Head;
		
	i=0;
	while (mc->chead.ln_Succ)
	{
		if (jc_checkconfaccess(mc->CONF_NUMBER,&user)) {
			i++;
			if (i==3) {
				DDPut("\n");
				i=1;
			}
			if (isconftagged(mc->CONF_NUMBER)) {
				sta="ON";
			} else sta="OFF";
		
			sprintf(tbuf,sd[togglinestr],mc->CONF_NUMBER,mc->CONF_NAME,sta);
			DDPut(tbuf);
		}                       
		mc=(struct VMatik_Conference *)mc->chead.ln_Succ;
	}
	DDPut("\n");

	while (1) 
	{
		DDPut(sd[tcpromptstr]);
		inp[0]=0;
		if (!(Prompt(inp,80,0))) return 0;
		s=inp;
		if (!*inp) {
			strcpy(inp,"s");
		}
		while( (s=strspa(s,tok)) )
		{
			if (!strcasecmp(tok,"c")) 				// Cancel
			{
				ClearList(SelectList);
				SelectList=CopyList(backup);
				ClearList(backup);
				return 0;
			} else if (!strcasecmp(tok,"v")) {		// View
				goto vagain;
			} else if (!strcasecmp(tok,"s")) {		// Save
				int selfd;
				sprintf(tbuf,"users/%d/selected.dat",user.user_serial_id);
				selfd=open(tbuf,O_WRONLY|O_CREAT,0664);
				if (selfd!=-1) 
				{
					struct Selected *seltmp;

					seltmp=(struct Selected *)SelectList->lh_Head;
					while(seltmp->shead.ln_Succ)
					{
						write(selfd,seltmp,sizeof(struct Selected));
						seltmp=(struct Selected *)seltmp->shead.ln_Succ;
					}	
					close(selfd);			
				
				}
				return 0;
			} else if (!strcasecmp(tok,"-")) 
			{
				struct Selected *seltmp;
				struct Selected *newp;

				seltmp=(struct Selected *)SelectList->lh_Head;
				while(seltmp->shead.ln_Succ)
				{
					newp=(struct Selected *)seltmp->shead.ln_Succ;
					if(seltmp->type==SEL_CONF)
					{
							Remove((struct Node *)seltmp);
							free(seltmp);
					}
					seltmp=newp;
				}
				DDPut(sd[tcalloffstr]);
				goto vagain;
			} else if (!strcasecmp(tok,"+")) {
				struct VMatik_Conference *tconf;

				tconf=(struct VMatik_Conference *)confs->lh_Head;

				while (tconf->chead.ln_Succ)
				{
					struct Selected *newp;
					
					newp=malloc(sizeof(struct Selected));
					newp->type=SEL_CONF;
					newp->conf_nr=tconf->CONF_NUMBER;
		
					AddTail(SelectList, (struct Node *)newp);

					tconf=(struct VMatik_Conference *)tconf->chead.ln_Succ;
				}  
				
				DDPut(sd[tcallonstr]);
				goto vagain;
			} else {
				i=atoi(tok);
				if (i > 0 && jc_checkconfaccess(i,&user)) {
					
					mc=(struct VMatik_Conference *)confs->lh_Head;
		
					while (mc->chead.ln_Succ)
					{
						if (i==mc->CONF_NUMBER) {
							struct Selected *newp;
						
							if(!isconftagged(i))
							{
								newp=malloc(sizeof(struct Selected));
								newp->type=SEL_CONF;
								newp->conf_nr=i;
		
								AddTail(SelectList, (struct Node *)newp);
							}
							else
							{
								newp=(struct Selected *)SelectList->lh_Head;
								while(newp->shead.ln_Succ)
								{
									if(newp->type==SEL_CONF && 
									   newp->conf_nr==i)
									{
										Remove((struct Node *)newp);
										free(newp);
										break;
									}
									newp=(struct Selected *)newp->shead.ln_Succ;
								}
							}
							break;
						}
						mc=(struct VMatik_Conference *)mc->chead.ln_Succ;
					}               
				}
			goto vagain;
			}
		}
	}
}

/*
 * strspa skips all leading spaces from 'src' and copies
 * the rest to 'dest', stopping at null or space.
 *
 */
char *strspa(char *src, char *dest)
{
	int go=1;

	if (src==0) return 0;
		
	while (*src==' ') src++;
	if (*src==0) return 0;
	while (go)
	{
		if (*src==' '||*src==0) go=0;
		else *dest++=*src++;
	}
	*dest=0;
	return src;
}

/*
 * strspa_ext skips all leading spaces from 'src' and copies
 * the rest to 'dest', stopping at null or space. If " or '
 * is given, it stops at next " or ', not space!
 *
 */
char *strspa_ext(char *src, char *dest)
{
	int go=1;
	int sepfound=0;
//	char buffa[1024];
//	char *temp=dest;

	if (src==0) 
		return 0;
		
	while(*src==' ')					// Skip leading spaces 
		src++;
	
	if (*src==0) 
		return 0;

	while (go)
	{
		if(*src==0)
		{
			go=0;
			break;
		}

		if(*src==' ')
		{
			if(sepfound)
			{
				*dest++=*src++;
			}
			else if (!sepfound)
				go=0;
		}
		else
		{
			if(*src=='\'' || *src=='\"')
			{
				if(sepfound==*src)
					sepfound=0;
				else
					sepfound=*src;
			}
			*dest++=*src++;
		}
	}
	*dest=0;
	
//	strcpy(buffa, temp);
//	DDPut("Got: ");
//	Prompt(buffa,78,0);
	return src;
}

/*
 * If base ("tbase") of conf ("tconf") is tagged, return 1, else 0
 *
 */
int isbasetagged(int tconf, int tbase)
{
	struct Selected *temp;

	temp=(struct Selected *)SelectList->lh_Head;

	while(temp->shead.ln_Succ)
	{
		if(temp->type==SEL_MSGBASE && 
		   temp->conf_nr==tconf &&
		   temp->ID==tbase)
			return(1);
		temp=(struct Selected *)temp->shead.ln_Succ;
	}
	
	return(0);
}

/*
 * If conference ("tconf") is tagged return 1, else 0
 *
 */
int isconftagged(int tconf)
{
	struct Selected *temp;

	temp=(struct Selected *)SelectList->lh_Head;

	while(temp->shead.ln_Succ)
	{
		if(temp->type==SEL_CONF && temp->conf_nr==tconf)
			return(1);
		temp=(struct Selected *)temp->shead.ln_Succ;
	}
	return(0);
}
	
/*
 * If any of the bases is tagged, return 1, else 0
 *
 */
int isanybasestagged(int tconf)
{
	struct Selected *temp;

	temp=(struct Selected *)SelectList->lh_Head;

	while(temp->shead.ln_Succ)
	{
		if(temp->type==SEL_MSGBASE && temp->conf_nr==tconf)
			return(1);
		temp=(struct Selected *)temp->shead.ln_Succ;
	}
	return(0);
}

