/*
 * This file has functions related to transferring files 
 * from system TO the user.
 *
 */
#include "proto.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

void dl_typedlprompt(void);

extern int lmode;

int dl_localdownload(void);
int dl_ftpdl(char *list, char *loog);

/*
 * This is the main download function. It lets user download files. :)
 *
 */
int dl_download(char *params, int mode)
{
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	int temp_filecred=0, temp_bytecred=0;
	char query[QUERY_MAX];
	char dl_listname[PATH_MAX];
	char skiplist[PATH_MAX];
	char parbuf[PATH_MAX];
	char bigbuf[512];
	char *srcstrh;
	int discon=0;
	FILE *listh;
	char lastfile[100];
	int total_chosen_bytes=0;
	int go=1, time_warning=0, add_ok=0;
	int starttimeleft=0;
	int newarea=0, oldarea=0;

	setprotocol();
	changenodestatus("Downloading");
	TypeFile("download",TYPE_MAKE|TYPE_CONF|TYPE_WARN);

/*
	if (!conf->CONF_FILEAREAS && !filestagged) {
		DDPut(sd[dlnoareasstr]);
		return(0);
	}
*/

	if ( (protocol->Protocol_Type == PROTOCOL_BIDIR) 
	    && !conf->CONF_UPLOADAREA) 
	{
		DDPut(sd[dlnouploadsstr]);
		return(0);
	}

	if (protocol->Protocol_Type == PROTOCOL_BIDIR) {
		char dest_area[PATH_MAX];

/****** Check for redirection */
		sprintf(query, "area_id=%d AND area_ul_redir!=%d AND area_conf=%d",
				Current_FileAreaID, Current_FileAreaID, conf->CONF_NUMBER);
		newarea=mi_sql_getnum(&vm_database, "area_ul_redir", "vmatik_fileareas",
				query);
		if(newarea)
		{
			oldarea=Current_FileAreaID;
			jc_changefilearea(newarea, JC_ABSOLUTE|JC_SHUTUP);
		}

		ul_cleandir(currnode->Node_TempDir);

		sprintf(parbuf, "area_id=%d", Current_FileAreaID);
		mi_sql_getstr(&vm_database, "area_filepath", "vmatik_fileareas",
					parbuf, dest_area);
		if (!ul_freespace(dest_area)) 
			return(0);
	}

	

	srcstrh=params;

	while((srcstrh=strspa(srcstrh,parbuf)))
	{
		te_flagfile(parbuf, mode);
	}
	
	sprintf(query, "user_id=%d", user.user_serial_id);
	user.user_filecred=mi_sql_getnum(&vm_database, "user_filecred", "vmatik_user", query);
	user.user_bytecred=mi_sql_getnum(&vm_database, "user_bytecred", "vmatik_user", query);

	while (1)
	{
		dl_typedlprompt();
		bigbuf[0]=0;
		if (!(Prompt(bigbuf,200,0))) 
			return(0);
		if (!bigbuf[0]) {
			break;
		} else if (!strcasecmp(bigbuf,"a")) {
			return 0;
		} else {
		
			srcstrh=bigbuf;
			while((srcstrh=strspa(srcstrh,parbuf)))
			{
				te_flagfile(parbuf,mode);
			}
		}
	}
	
	te_recountfiles();
	
	if (!filestagged) 
		return(0);  

	te_listflagged(&vm_database);
/*
	if (estimsecs(bytestagged) > timeleft) 
	{
		DDPut(sd[dlnotimestr]);
		return(0);
	}
*/

	while (go)
	{
		DDPut(sd[dlproceedstr]);
		bigbuf[0]=0;
		if (!(Prompt(bigbuf,3,0))) 
			return 0;
		
		switch(bigbuf[0])
		{
			case 'e':
			case 'E':
				te_taged(&vm_database,0,0);
				break;
			case 'd':
			case 'D':
				DDPut(sd[autodisconstr]);
				discon^=1;
				if(discon)
					DDPut(sd[enabledstr]);
				else
					DDPut(sd[disabledstr]);
				DDPut("\n");
				break;
			case 'a':
			case 'A':
				if(oldarea)
					jc_changefilearea(oldarea, JC_ABSOLUTE|JC_SHUTUP);
				return(0);
				break;
			case 0:
			case 'p':
			case 'P':
			default:
				go=0;
				break;
		}
	}

	if(lmode)
	{
		int retval;

		retval=dl_localdownload();
		
		if(oldarea)
			jc_changefilearea(oldarea, JC_SHUTUP|JC_ABSOLUTE);
		
		return(retval);
	}

	sprintf(dl_listname,"%sdl_filelist.%d",VMTMP,node);
	unlink(dl_listname);

	listh=fopen(dl_listname,"w");
	if(!listh)
		return(0);

	sprintf(query, "SELECT area_filepath, file_name, file_size, file_flags,
			file_integrity, area_flags
			FROM vmatik_fileareas, vmatik_filelist, vmatik_flagged 
			WHERE flagged_user=%d AND 
			flagged_id=file_id AND file_area=area_id
			ORDER BY file_name", user.user_serial_id);
	
	mysql_query(&vm_database, query);
	sql_result=mysql_use_result(&vm_database);
	while((sql_row=mysql_fetch_row(sql_result)))
	{ 
		add_ok=1;

		if(!(atoi(sql_row[3]) & FILE_FREEDL) && 
			atoi(sql_row[4])!=INTEGRITY_FAILED &&
			!(atoi(sql_row[5]) & AREA_FREEDL))
		{
			if(!(access_flags & SECB_FREEFILES))
				temp_filecred++;
			if(!(access_flags & SECB_FREEBYTES))
				temp_bytecred+=atoi(sql_row[2]);
			
			if(temp_filecred>user.user_filecred &&
				!(access_flags & SECB_FREEFILES))
				add_ok=0;
			if(temp_bytecred>user.user_bytecred && 
				!(access_flags & SECB_FREEBYTES))
				add_ok=0;
		}

		if(add_ok)
		{
			total_chosen_bytes+=atoi(sql_row[2]);
			
			if(estimsecs(total_chosen_bytes)<timeleft)
				fprintf(listh, "%s%s\n", sql_row[0], sql_row[1]);
			else
				time_warning=1;
		}
		else 
		{
			DDPut(sql_row[1]);
			DDPut(" skipped, not enough credits...\n");
		}
	}
	mysql_free_result(sql_result);
	fclose(listh);

	*lastfile=0;

	if(!total_chosen_bytes)
	{
		DDPut("Nothing to download...\n");
		unlink(dl_listname);
		if(oldarea)
			jc_changefilearea(oldarea, JC_SHUTUP|JC_ABSOLUTE);
		return(0);
	}

	if(time_warning)
		DDPut("\nWarning: You will not have enough time to download all files.\nTransfer will be aborted when your time is out.\n");

	if (protocol->Protocol_Type == PROTOCOL_BIDIR)
	{
		sprintf(skiplist, "%spathlist.%d", VMTMP, node);
		ul_gen_pathlist(skiplist);	

		starttimeleft=timeleft/60;
		mi_sql_setuser(&vm_database, "user_timeremain",
					user.user_serial_id, '=', starttimeleft);
	}

	
	
	DDPut(sd[startxferstr]);
	dl_sendfiles(dl_listname,skiplist,lastfile);


	if (protocol->Protocol_Type == PROTOCOL_BIDIR) 
	{
		timeleft=mi_sql_getuser(&vm_database, "user_timeremain",
					user.user_serial_id)*60;
		if((starttimeleft*60)<timeleft)
			endtime=time(NULL)+timeleft;

		unlink(skiplist);

		if(oldarea)
			jc_changefilearea(oldarea, JC_SHUTUP|JC_ABSOLUTE);
		
//		ul_upload(UPLOAD_JUSTCHECK);
	}

	te_recountfiles();

	unlink(dl_listname);

	if(discon) 
	{
		if (autodisconnect())
			return(2);
	}
	
	return(1);
}

/* 
 * Throws the user out if she doesn't abort in 10 seconds
 *
 */
int autodisconnect(void)
{
	int count;
	char autodb[80];
	int i;
	
	DDPut(sd[dlautodcstr]);

	for(count=9;count;count--)
	{
		sleep(1);

		i=HotKey(HOT_QUICK);
		
		while (i!=255) {
			if (!checkcarrier()) return 0;
			if (i==3) {
				DDPut("\n\n");
				return 0;
			}
		}
		sprintf(autodb,"%2.2d",count);
		DDPut(autodb);
	}
	DDPut("\n\n");
	sprintf(autodb,"Connection closed by automatic disconnection at %s\n",currt());
	writelog(autodb);
	ma_dropcarrier();
	return 1;
}

/*
 * Sends all files in file "list" using users protocol.
 *
 */
int dl_sendfiles(char *list, char *skiplist, char *lastf)
{
	char bigbuf[4002];
	char dszlog[PATH_MAX];
	pid_t bgrun;
	
	bgrun=bg_bgchecker();				// We will run bgchecker always!
	if(!bgrun)
	{
		DDPut("Can't launch background checker! This is FATAL.\n");
		writelog("Unable to launch bgchecker!\n");
		return(0);
	}

	sprintf(dszlog, "%sdszlog.%d.%d", VMTMP, node, bgrun);	// Unique! 

	switch(protocol->Protocol_Type)
	{
		case PROTOCOL_ONEDIR:
			genstdiocmdline(bigbuf,protocol->Protocol_SendCommand,
							NULL, NULL, list, dszlog, NULL);
//			DDPut("InitString: \n");
//			DDPut(bigbuf);
//			DDPut("\n");
			runstdio(bigbuf,0,2);
			break;
		case PROTOCOL_BIDIR:
			genstdiocmdline(bigbuf,protocol->Protocol_SendCommand,
						skiplist, currnode->Node_TempDir, 
						list, dszlog, NULL);
//			DDPut("InitString: \n");
//			DDPut(bigbuf);
//			DDPut("\n");
			runstdio(bigbuf,0,4);
			dl_killflood();
			break;
		case PROTOCOL_PSEUDO:
//			dl_ftpdl(list, dszlog);
			break;
		default:
			DDPut("Error: Unknown protocol->Protocol_Type\n");
			break;
	}
	
	kill(bgrun, SIGUSR1);				// Notify bgchecker that xfer ended

	return(1);
}

/*
 * BUGS: Probably unused function
 *
 */
int dl_ftpdl(char *list, char *loog)
{
	FILE *listh;
	FILE *logh;
	
	char buf[1024];
	char buf2[1024];
	
	if (!(listh=fopen(list,"r"))) 
		return(0);
		
	logh=fopen(loog,"w");

	while(fgetsnolf(buf,1024,listh))
	{
		sprintf(buf2,"%s/users/%d/ftp/dl/%s"
			,origdir,user.user_serial_id,mi_filepart(buf));
		symlink(buf,buf2);
		if (logh) {
			struct stat st;
			stat(buf,&st);
			fprintf(logh,
				"s %6ld %5ld bps %4d cps   0 errors     0 %4d %s %lu\n",
				(long)st.st_size,(long)0,0,1024,mi_filepart(buf),(unsigned long)0);
			
		}
	}
	fclose(listh);
	if (logh) 
		fclose(logh);

	return(1);
}

/*
 * BUGS: Unused function at the moment
 *
 */
int makepartial(char *fn)
{
	char buf[1024];
	char goobuf[COPY_BUFSIZE];
	
	int fd, fd2;
	int i;
	
	fd=open(fn,O_RDONLY);
	if (fd < 0) return 0;
	
	sprintf(buf,"%s/users/%d/badxfer.dat",origdir,user.user_serial_id);
	fd2=open(buf,O_WRONLY|O_CREAT,0644);
	if (fd2 < 0) {
		close(fd);
		sprintf(buf,"%s%s",currnode->Node_TempDir,fn);
		unlink(buf);
		return 0;
	}
	strcpy(buf,mi_filepart(fn));
	write(fd2,buf,256);
	while( (i=read(fd,&goobuf,COPY_BUFSIZE)))
	{
		write(fd2,goobuf,i);
	}
	close(fd); close(fd2);
	unlink(fn);
	return 1;
}

void dl_typedlprompt(void)
{
	char filesleft[50];
	char bytesleft[50];
	char pbuf[500];

	te_recountfiles();
	
	dl_freefstr(filesleft);
	
	dl_freebstr(bytesleft);
	
	sprintf(pbuf,sd[dlpromptstr],filestagged,filesleft,bytestagged,bytesleft);
	
	DDPut(pbuf);
}

/*
 * Prints the amount of available file credits to *db
 *
 */
int dl_freefstr(char *db)
{
	if(access_flags & SECB_FREEFILES)
		strcpy(db,sd[dlunlimitedstr]);
	else
		sprintf(db,"%d",user.user_filecred
				- filestagged + ffilestagged);

	return(1);
}

/*
 * Prints the amount of available byte credits to *db
 *
 */
int dl_freebstr(char *db)
{
	if(access_flags & SECB_FREEBYTES)
		strcpy(db,sd[dlunlimitedstr]);
	else
		sprintf(db,"%d",(int)user.user_bytecred
				- bytestagged + fbytestagged);
				
	return(1);
}

/*
 * BUGS: Might be broken
 *
 */
void dl_killflood(void)
{
//	char buffer[100];

	DDPut(sd[dlkillfloodstr]);
	
	delayt=1;
	while (1)
	{
		int i;
		if (!checkcarrier()) 
			break;
//		DDPut("Tittirii!\n");
		i=HotKey(HOT_DELAY);
//		DDPut("VItulus!\n");
		if (!checkcarrier()) 
			break;
//		DDPut("molomoo!\n");
//		sprintf(buffer, "%d\n", i);
//		DDPut(buffer);
		if (i==0 || i==255 || i=='y' || i=='Y') 
			break;
	}
	DDPut("\n");
}

int dl_localdownload(void)
{
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	char query[QUERY_MAX];
	char buffer[PATH_MAX];
	char old_tbu[PATH_MAX];
	char new_tbu[PATH_MAX];

	memset(&buffer,0,PATH_MAX);

	DDPut("\nWhere do you want to copy the files?\n: ");
	if(!(Prompt(buffer, 75, 0)))
		return(0);

	if(buffer[0]==0)
	{
		DDPut("\nAborted...\n\n");
		return(0);
	}

	if(buffer[strlen(buffer)-1]!='/')
		strcat(buffer, "/");

	DDPut("\n");

	sprintf(query, "SELECT area_filepath, file_name, file_id 
					FROM vmatik_fileareas,
					vmatik_filelist, vmatik_flagged 
					WHERE flagged_user=%d AND
					flagged_id=file_id AND file_area=area_id", 
					user.user_serial_id);

	mysql_query(&vm_database, query);
	sql_result=mysql_store_result(&vm_database);
	while((sql_row=mysql_fetch_row(sql_result)))
	{
		sprintf(old_tbu,"%s%s",sql_row[0], sql_row[1]);
		sprintf(new_tbu,"%s%s",buffer,sql_row[1]);
	
//		DDPut(old_tbu);
//		DDPut("\n");
//		DDPut(new_tbu);
//		DDPut("\n");
		DDPut(sql_row[1]);
		DDPut("... ");

		if(newcopy(old_tbu,new_tbu)==0)
		{
			sprintf(query, "DELETE FROM vmatik_flagged WHERE
							flagged_user=%d AND flagged_id=%d",
							user.user_serial_id, atoi(sql_row[2]));
			mysql_query(&vm_database, query);
			DDPut("copied\n");
		}
		else
			DDPut("failed\n");

	}
	mysql_free_result(sql_result);

	DDPut("\n");
	
	return(1);
}

