/*
 * This file contains the actual parsing of the main menu,
 * e.g. the accepted commands (except "external commands" aka
 * "doors") are hardcoded here.
 *
 * Its in intention to move the commands to a separate ascii
 * file, so that sysop could change the command names and thus
 * be better able to localize her system... In the fashion of
 * string.xxx and menu files...
 *
 */
#include "proto.h"
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

void dpause(void)
{
	DDPut(sd[pause2str]);
	HotKey(0);
	DDPut("\n");
}

int domenu(int p)
{
	char bufferi[500];
	
	if (p==1) {
		if (!(user.user_toggles & TOGGLE_EXPERT)) {
			dpause();
			TypeFile("commands",TYPE_SEC|TYPE_MAKE|TYPE_WARN|TYPE_CONF);
		}
	}

	changenodestatus("Main menu");  
	dm_makemainprompt(bufferi);
	DDPut(bufferi);
	
	bufferi[0]=0;

/*
	switch(Prompt(bufferi,400,PROMPT_MAIN)))
	{
		case 0:
			return(0);
			break;
		case 255:			// Idle + idle mode off
			return(1);
		default:
			break;
	}
*/
	if(!(Prompt(bufferi,400,PROMPT_MAIN)))
		return(0);
			
	if (bufferi[0]==0) return 2;

	return(docmd(bufferi,0));
	
}

/*
 * This is the function that parses the commands user gives in main menu
 *
 */
int docmd(char *bufferi, int skipd)
{
	char cmd[500];
	char buff[512];
	char *params;
	int i;
	struct VMatik_ExternalCommand *ext;
	struct SystemFunctions func;
		
	memset(&func, 0, sizeof(struct SystemFunctions));
			
	i=0;
	params=0;
	while(bufferi[i]!=0) {
		if (i>0 && isdigit(bufferi[i]) && !isdigit(bufferi[0])) // Makes e.g. "mv1-5" possible
		{
			params=&bufferi[i];
			break;
		}
		if (bufferi[i]==' ') {
			params=&bufferi[i+1];
			while (*params==' ') params++;
			break;
		}
		cmd[i]=bufferi[i];
		i++;
	}
	if (bufferi[i]==0) params=0;
	
	cmd[i]=0;

	ext=exts;
	while (ext->EXT_NAME[0]!=0 && !skipd)
	{
		if (!strcasecmp(cmd,ext->EXT_NAME)) {
			if (ext->EXT_SECLEVEL > user.user_securitylevel) {
				DDPut(sd[accessdeniedstr]);
				return 1;
			}
			switch (ext->EXT_CMDTYPE)
			{
			 case EXT_VMATIK:
				dp_rundoor(ext->EXT_COMMAND,params);
				break;
			 case EXT_STDIO:
				runstdio(ext->EXT_COMMAND,0,1);
				break;
			 case EXT_TEXT:
				TypeFile(ext->EXT_COMMAND,TYPE_MAKE|TYPE_WARN);
				break;
			 case EXT_OTHER:
				return docmd(ext->EXT_COMMAND,1);
				break;
			}
			return 1;
		}
		ext++;
	}
	
	if (!strcasecmp(cmd,"cls")) {
		DDPut("[2J[H");
		return 2;
	} else if (!strcasecmp(cmd,"ver")) {
		versioninfo();
		return 1;
	} else if (!strcasecmp(cmd,"x")) {

		if (!dm_isaccess(SECB_EXPERTMODE,access_flags)) 
			return(1);
		
		if (user.user_toggles & TOGGLE_EXPERT) {
			DDPut(sd[expertoffstr]);
		
			mi_sql_setuser(&vm_database, "user_toggles", user.user_serial_id,
							'&', ~TOGGLE_EXPERT);
			user.user_toggles &= ~TOGGLE_EXPERT;
		} else {
			DDPut(sd[expertonstr]);
			mi_sql_setuser(&vm_database, "user_toggles", user.user_serial_id,
							'|', TOGGLE_EXPERT);
			user.user_toggles |= TOGGLE_EXPERT;
		}
		return 1;
	} else if (!strcasecmp(cmd,"g")) {
		return logoff(params);
	} else if (!strcasecmp(cmd,"a")) {
		if (dm_isaccess(SECB_CHANGEINFO,access_flags)) eo_editown(0);
		return 1;
	} else if (!strcasecmp(cmd,"or")) {		// Change filearea sort order
		eo_changesortorder(params ? atoi(params) : -1, Current_FileAreaID);
		return 1;
	} else if (!strcasecmp(cmd,"f")) {
		if (dm_isaccess(SECB_FILESCAN,access_flags)) 
		{
			func.displayfunction=fl_display_normal;

			fl_browselist(params, &func, "Scan", MODE_CURRENT, &vm_database);
		}
		return(1);
	} else if (!strcasecmp(cmd,"fg")) {
		if (dm_isaccess(SECB_FILESCAN,access_flags))
		{
			func.displayfunction=fl_display_normal;
		    fl_browselist(params, &func, "GScan", MODE_ALL, &vm_database);
		}
		return(1);
	} else if (!strcasecmp(cmd,"k")) {
		if (dm_isaccess(SECB_COSYSOP,access_flags))
		{
			func.initfunction=fl_init_kill;
			func.exitfunction=fl_touch_currentarea;
			func.displayfunction=fl_display_ask;
			func.maintfunction=fl_killfile;
			
			fl_browselist(params, &func, "Kill", MODE_CURRENT|MODE_NOPROMPT,
							&vm_database);

		}
		return(1);
	} else if (!strcasecmp(cmd, "mv")) {
		if (dm_isaccess(SECB_MOVEFILE,access_flags))
		{
			func.initfunction=fl_init_move;
			func.exitfunction=fl_exit_move;
			func.displayfunction=fl_display_dummy;
			func.maintfunction=fl_movefile;

			fl_browselist(params, &func, "Move", MODE_CURRENT|MODE_NOPROMPT,
							&vm_database);
		}
		return(1);
/*} else if (!strcasecmp(cmd, "ha")) {			// BUGS: Remove this :)
		if(dm_isaccess(SECB_SYSOP,access_flags))
		{
			struct userbase temp;
			for(i=1;i<100;i++)
			{
				if(mi_loaduser(i, &temp))
					ue_set_acc_defaults(&temp);
			}
		}
		return(1);
	} else if (!strcasecmp(cmd,"molo")) {			// BUGS: REMOVE THIS TOO
		if (dm_isaccess(SECB_SYSOP, access_flags))
		{
			char buffer[512];
			
			mi_long2ascii_range(123945, buffer);
		}
		return(1);
*/
	} else if (!strcasecmp(cmd, "te")) {
		if (dm_isaccess(SECB_COSYSOP, access_flags))
		{
			func.displayfunction=fl_display_dummy;
			func.maintfunction=fl_testfile;

			fl_browselist(params, &func, "Test", 
						MODE_CURRENT|MODE_NOPROMPT, &vm_database);
		}
		return(1);
	} else if (!strcasecmp(cmd, "teg")) {
		if (dm_isaccess(SECB_COSYSOP, access_flags))
		{
			func.displayfunction=fl_display_dummy;
			func.maintfunction=fl_testfile;

			fl_browselist(params, &func, "TestGlobal", 
						MODE_ALL|MODE_NOPROMPT, &vm_database);
		}
		return(1);
	} else if (!strcasecmp(cmd, "tr")) {
		if (dm_isaccess(SECB_COSYSOP, access_flags))
		{
			func.displayfunction=fl_display_dummy;
			func.maintfunction=fl_transformfile;

			fl_browselist(params, &func, "Transform",
						MODE_CURRENT|MODE_NOPROMPT, &vm_database);
		}
		return(1);
	} else if (!strcasecmp(cmd, "trg")) {
		if (dm_isaccess(SECB_COSYSOP, access_flags))
		{
			func.displayfunction=fl_display_dummy;
			func.maintfunction=fl_transformfile;

			fl_browselist(params, &func, "TransformGlobal",
						MODE_ALL|MODE_NOPROMPT, &vm_database);
		}
		return(1);
	} else if (!strcasecmp(cmd, "va")) {
		if (dm_isaccess(SECB_COSYSOP, access_flags))
		{
			func.displayfunction=fl_display_dummy;
			func.maintfunction=fl_validatefile;
			func.exitfunction=fl_touch_currentarea;

			fl_browselist(params, &func, "Validate",
						MODE_CURRENT|MODE_NOPROMPT, &vm_database);
		}
		return(1);
	} else if (!strcasecmp(cmd, "to")) {
		if (dm_isaccess(SECB_COSYSOP, access_flags))
		{
			func.displayfunction=fl_display_dummy;
			func.maintfunction=fl_touchfile;
			func.exitfunction=fl_exit_touch;

			fl_browselist(params, &func, "Touch",
						MODE_CURRENT|MODE_NOPROMPT, &vm_database);
		}
		return(1);	
	} else if (!strcasecmp(cmd,"ml")) {
		if (dm_isaccess(SECB_SYSOP, access_flags))
		{
			ae_move_filearea(&vm_database, params);
		}
		return(1);
	} else if (!strcasecmp(cmd,"al")) {
		if (dm_isaccess(SECB_SYSOP, access_flags))
		{
			ae_add_filearea(&vm_database);
		}
		return(1);
	} else if (!strcasecmp(cmd,"*")) {
		if (dm_isaccess(SECB_TAGEDITOR, access_flags))
		{
			int tagged;
			char buffer[512];
			
			func.displayfunction=fl_display_dummy;
			func.maintfunction=fl_flagfile;

			tagged=fl_browselist(params, &func, "Flag", 
							MODE_SHUTUP|MODE_CURRENT|MODE_NOPROMPT, 
							&vm_database);
			sprintf(buffer, "\n%d files selected.\n\n", tagged);
			DDPut(buffer);
		}
		return(1);
	} else if (!strcasecmp(cmd,"*g")) {
		if (dm_isaccess(SECB_TAGEDITOR, access_flags))
		{
			func.displayfunction=fl_display_dummy;
			func.maintfunction=fl_flagfile;

			fl_browselist(params, &func, "FlagGlobal", MODE_ALL|MODE_NOPROMPT,
							&vm_database);
		}
		return(1);
	} else if (!strcasecmp(cmd,"w")) {			// Write desc
		if (dm_isaccess(SECB_COSYSOP, access_flags))
		{
			func.displayfunction=fl_display_dummy;
			func.maintfunction=fl_describefile;
		
			fl_browselist(params, &func, "Describe",MODE_CURRENT|MODE_NOPROMPT,
							&vm_database);
		}
		return(1);
	} else if (!strcasecmp(cmd,"wb")) {			// Write bulk
		if (dm_isaccess(SECB_COSYSOP, access_flags))
		{
			func.displayfunction=fl_display_dummy;
			func.maintfunction=fl_describefile_bulk;
			func.initfunction=fl_init_describe_bulk;
			func.exitfunction=fl_exit_describe_bulk;
		
			fl_browselist(params, &func, "BulkDescribe",
							MODE_CURRENT|MODE_NOPROMPT,
							&vm_database);
		}
		return(1);
	} else if (!strcasecmp(cmd,"d")) {
		if (dm_isaccess(SECB_DOWNLOAD,access_flags)) 
			if (dl_download(params, MODE_CURRENT)==2) 
				return 0;
		return(1);
	} else if (!strcasecmp(cmd,"dg")) {
		if (dm_isaccess(SECB_DOWNLOAD,access_flags)) 
			if (dl_download(params, MODE_ALL)==2) 
				return 0;
		return(1);
	} else if (!strcasecmp(cmd,"t")) {
		if (dm_isaccess(SECB_TAGEDITOR,access_flags)) 
			te_taged(&vm_database, params,0);
		return 1;
	} else if (!strcasecmp(cmd,"b")) {
		if (dm_isaccess(SECB_BULLETINS,access_flags))
			bulletins(params);
		return 1;
	} else if (!strcasecmp(cmd,"ti")) {		// Show local time
		time_t aika;
		char *aikas;
		char tmpstrh[180];
		
		if (!dm_isaccess(SECB_VIEWTIME,access_flags)) return 1;
		aika=time(0);

		aikas=ctime(&aika);
		aikas[24]=0;
		sprintf(tmpstrh,sd[ltimestr],aikas);
		DDPut(tmpstrh);
		return 1;
	} else if (!strcasecmp(cmd,"st")) {
		if (dm_isaccess(SECB_USERSTATS,access_flags)) 
			st_userstats(user.user_serial_id);
		return 1;
	} else if (!strcasecmp(cmd,"cr")) {
		if (dm_isaccess(SECB_USERSTATS,access_flags)) 
			st_show_credits(user.user_serial_id);
	} else if (!strcasecmp(cmd,"e")) {
		if (dm_isaccess(SECB_ENTERMSG,access_flags))
		{
			entermsg(0,0,params);
			sprintf(buff,"%sVMatik%d.msg",VMTMP,node);
			unlink(buff);
		}
		return 1;
	} else if (!strcasecmp(cmd,"c")) {
		if (dm_isaccess(SECB_COMMENT,access_flags)) comment();
		return 1;
	} else if (!strcasecmp(cmd,"r")) {
		DDPut("\n");
		if (dm_isaccess(SECB_READMSG,access_flags)) readmessages(-1,0);
		return 1;
	} else if (!strcasecmp(cmd,"gr")) {
		if (dm_isaccess(SECB_READMSG,access_flags)) globalread();
		return 1;
	} else if (!strcasecmp(cmd,"j")) {
		if (dm_isaccess(SECB_JOINCONF,access_flags)) 
			jc_joinconfmenu(params);
		return 1;
	} else if (!strcasecmp(cmd,"m")) {
		if (dm_isaccess(SECB_CHANGEMSGAREA,access_flags)) cmbmenu(params);
		return 1;
	} else if (!strcasecmp(cmd,"lu")) {
		if(dm_isaccess(SECB_COSYSOP, access_flags))
			ul_localupload(&vm_database, Current_FileAreaID);
		return 1;
	} else if (!strcasecmp(cmd,"l")) {
		jc_showfileareas(&vm_database, 0);
		return 1;
	} else if (!strcasecmp(cmd,"u")) {
		if (dm_isaccess(SECB_UPLOAD,access_flags)) 
			if (ul_upload(UPLOAD_NORMAL)==2) 
				return 0;
		return 1;
	} else if (!strcasecmp(cmd,"rz")) {
		if (dm_isaccess(SECB_UPLOAD,access_flags)) 
			if (ul_upload(UPLOAD_RZ)==2) 
				return 0;
		return 1;
	} else if (!strcasecmp(cmd,"v")) {
		if (dm_isaccess(SECB_VIEWFILE,access_flags)) 
		{
			func.maintfunction=fl_viewfile;
			func.displayfunction=fl_display_dummy;

			fl_browselist(params, &func, "View", MODE_CURRENT|MODE_NOPROMPT, 
							&vm_database);
		}
		return 1;
	} else if (!strcasecmp(cmd,"fv")) {
		if (dm_isaccess(SECB_VIEWFILE,access_flags))
		{
			func.maintfunction=fl_show_verbose;
			func.displayfunction=fl_display_dummy;

			fl_browselist(params, &func, "Scan verbosely",
							MODE_CURRENT|MODE_NOPROMPT, &vm_database);
		}
		return 1;
	} else if (!strcasecmp(cmd,"ms")) {
		ms_scanfornewmail();
		return 1;
	} else if (!strcasecmp(cmd,"ns")) {
		if (dm_isaccess(SECB_NEWFILES,access_flags)) 
			fl_globalnewscan();
		return 1;
	} else if (!strcasecmp(cmd,"sm")) {
		if (dm_isaccess(SECB_SELECTMSGBASES,access_flags)) tagmessageareas();
		return 1;
	} else if (!strcasecmp(cmd,"sf")) {
		if (dm_isaccess(SECB_SELECTFILECONFS,access_flags)) tagconfs();
		return 1;
	} else if (!strcasecmp(cmd,">")) {
		jc_nextconf();
		return 1;
	} else if (!strcasecmp(cmd,"<")) {
		jc_prevconf();
		return 1;
	} else if (!strcasecmp(cmd,">>")) {
		nextbase();
		return 1;
	} else if (!strcasecmp(cmd,"<<")) {
		prevbase();
		return 1;
	} else if (!strcasecmp(cmd,"who")) {
		if (dm_isaccess(SECB_WHO,access_flags)) who();
		return 1;
	} else if (!strcasecmp(cmd,"?")) {
		TypeFile("commands",TYPE_MAKE|TYPE_WARN);
		return 2;
	} else if (!strcasecmp(cmd,"?f")) {
		TypeFile("commands_file", TYPE_MAKE|TYPE_WARN);
		return 2;
	} else if (!strcasecmp(cmd,"?m")) {
		TypeFile("commands_msg", TYPE_MAKE|TYPE_WARN);
		return 2;
	} else if (!strcasecmp(cmd,"?o")) {
		TypeFile("commands_other", TYPE_MAKE|TYPE_WARN);
		return 2;
	} else if (!strcasecmp(cmd,"?s")) {
		if(dm_isaccess(SECB_SYSOP, access_flags))
			TypeFile("commands_sysop", TYPE_MAKE|TYPE_WARN);
		return 2;
	} else if (!strcasecmp(cmd,"#")) {
		DDPut("\nEnter a number, you idiot, not #!!!\n\n");
		return 2;
	} else if (!strcasecmp(cmd,"userlist")) {
		if (dm_isaccess(SECB_USERLIST,access_flags)) 
			userlist(&vm_database, params);
		return 1;
	} else if (!strcasecmp(cmd,"mode")) {
		getdisplaymode(params,1);
		return 1;
	} else if (!strcasecmp(cmd,"o")) {
		if (dm_isaccess(SECB_PAGE,access_flags)) pa_pagesysop(params);
		return 1;
	} else if (!strcasecmp(cmd,"olm")) {
		if (dm_isaccess(SECB_OLM,access_flags)) ol_olmsg(params);
		return 1;
	} else if (!strcasecmp(cmd,"dump")) {
		if (dm_isaccess(SECB_COSYSOP,access_flags)) 
			mi_dumpuser(params);
		return 1;
	} else if (!strcasecmp(cmd,"reload")) {
		if (dm_isaccess(SECB_COSYSOP,access_flags)) 
			mi_ask_user_reload(params);
		return 1;
	} else if (!strcasecmp(cmd,"usered")) {
		if (dm_isaccess(SECB_USERED,access_flags)) {
			if (maincfg.CFG_OLUSEREDPW[0]) {
				char pwbuf[20];
				pwbuf[0]=0;
				DDPut(sd[uepwstr]);
				if (!(Prompt(pwbuf,15,PROMPT_SECRET))) return 0;
				if (strcasecmp(pwbuf,maincfg.CFG_OLUSEREDPW)) return 1;
			}
			usered();
		}
		return 1;
	} else if(isdigit(cmd[0])) {	// Perhaps user wants to change the filearea
//		sprintf(buff, "\n%d\n", atoi(cmd));
//		DDPut(buff);
		jc_changefilearea(atoi(cmd), 0);
		return(1);
	} else if(cmd[0]!='\n') {
		sprintf(buff, "\nInvalid command '%s'...\n\n", cmd);
		DDPut(buff);
	}

	return(1);       
}

/* 
 * Checks if user has access bit "flag" set in "access"
 *
 * 1==yes, 0==no
 *
 */
int dm_isaccess(bint flag, bint access)
{
/* debug stuff
	char buffer[1024];

	for(i=0;i<64;i++)
	{
		if(access & (1LL<<i))
		{
			sprintf(buffer, "A: %d set\n", i);
			DDPut(buffer);
		}
	}
	for(i=0;i<64;i++)
	{
		if(flag & (1LL<<i))
		{
			sprintf(buffer, "F: %d set\n", i);
			DDPut(buffer);
		}
	}
*/

	if(access & flag) 
		return(1);

	DDPut(sd[accden2str]);

	return(0);       
}

/*
 * Makes the prompt for the main menu
 *
 */
int dm_makemainprompt(char *buf)
{
	char *t=buf;
	char *s=sd[mainmenustr];

	while (*s) {
		if (*s=='~') {
			s++;
			switch(tolower(*s++)) {
			 case 'a':
				sprintf(t,"%d",base->MSGBASE_LRP.lrp_read);
				while(*t) t++;
				break;
			 case 'c':
				strcpy(t,conf->CONF_NAME);
				while(*t) t++;
				break;
			 case 'e':
				sprintf(t,"%d",highest);
				while(*t) t++;
				break;
			 case 'l':
				sprintf(t,"%d",base->MSGBASE_NUMBER);
				while(*t) t++;
				break;
			 case 'm':
				strcpy(t,base->MSGBASE_NAME);
				while(*t) t++;
				break;
			 case 'n':
				sprintf(t,"%d",conf->CONF_NUMBER);
				while(*t) t++;
				break;
			 case 'f':						// show active filearea
			 	if(Current_FileAreaID) 
			 		sprintf(t,"%d",Current_FileAreaNumber);
				else
					sprintf(t,"-");
				while(*t) t++;
				break;
			 case 't':
				sprintf(t,"%d",timeleft/60);
				while(*t) t++;
				break;
			 case 'b':
				sprintf(t,"%d",node);
				while(*t) t++;
				break;
			 case 's':
				strcpy(t,maincfg.CFG_BOARDNAME);
				while(*t) t++;
				break;
			 case '~':
				*t++='~';
				break;
			}
		} else {
			*t++=*s++;
		}
	}
	*t=0;

	return(1);
}
	
	
/*

Control code    Meaning
========================================================================
     ~~         Print %-char
     ~A         Last read pointer
     ~C         Conference name
     ~E         Highest message
     ~L         Message base number
     ~M         Message base name
     ~N         Conference number
     ~T         Time left in minutes
     ~B         Node number
     ~S         BBS Name

 */
