/*
 * Displaymode stuff
 *
 * Displaymode determines which gfx/txt sets will be shown to user.
 *
 */
#include "proto.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

unsigned char inconvtab[256];
unsigned char outconvtab[256];
int strfile=0;

static char *strfmem=0;

char *cpstr(char *, char *);

int getdisplaymode(char *strh, int mode)
{
	char buf[70];
	int newmode;
	int lmodeh;
	char helpfile[80];
	
	if (strh) {
		strspa(strh,buf);
		if ((newmode=atoi(buf))) {
			newmode=di_changemode(newmode);
			if (newmode) return 1;
		}
	}

	lmodeh=largestmode();
	if (lmodeh==1) {
		return(di_changemode(1));
	}

	if (!mode) {
		sprintf(helpfile,"%s/display/displaymodelist.txt",origdir);
		TypeFile(helpfile,TYPE_NOSTRIP);
	
	}
	while(1) {
		if (mode) {
			sprintf(buf,"Display Mode 1-%d or H)elp: ",lmodeh);
		} else {	
			sprintf(buf,"Display Mode [1]-%d or H)elp: ",lmodeh);
		}
		DDPut(buf);
		*buf=0;
		if (!(Prompt(buf,3,0))) return -1;
		removespaces(buf);
		if (*buf=='h' || *buf=='H' || *buf=='?') {
			sprintf(helpfile,"%s/display/displaymodehelp.txt",origdir);
			TypeFile(helpfile,TYPE_NOSTRIP);
		} else if (!*buf) {
			if (mode) return 1;
			return di_changemode(1);
		} else if ((newmode=atoi(buf))) {
			if (di_changemode(newmode)) return 1;
		}
	}
} 

int largestmode(void)
{
	int highestd=0;
	
	struct VMatik_DisplayMode *d;
	d=displays;
	while(d->DISPLAY_ID)
	{
		highestd=d->DISPLAY_ID;
		d++;
	}
	return highestd;	
}

/*
 * This does the displaymode changing into a specific one.
 *
 */
int di_changemode(int newmode)
{
	struct VMatik_DisplayMode *d;
	int tabfd;
	char buffer[80];
	
	d=displays;
	
	while(d->DISPLAY_ID)
	{
		if (newmode==d->DISPLAY_ID) {
			if (d->DISPLAY_ATTRIBUTES & DISP_ENABLE_ANSI) ansi=1;
				else ansi=0;
			if (d->DISPLAY_INCOMING_TABLEID) {
				sprintf(buffer,"%s/data/conversiontable%2.2d.dat",origdir,d->DISPLAY_INCOMING_TABLEID);
				tabfd=open(buffer,O_RDONLY);
				if (tabfd < 0) {
					DDPut("Can't load incoming table!\n");
					return 0;
				}
				read(tabfd,&inconvtab,256);
				close(tabfd);
			}

			if (d->DISPLAY_OUTGOING_TABLEID) {
				sprintf(buffer,"%s/data/conversiontable%2.2d.dat",origdir,d->DISPLAY_OUTGOING_TABLEID);
				tabfd=open(buffer,O_RDONLY);
				if (tabfd < 0) {
					DDPut("Can't load outgoing table!\n");
					return 0;
				}
				read(tabfd,&outconvtab,256);
				close(tabfd);
			}
			
			if (strfile!=d->DISPLAY_STRINGS) {
				if (!di_loadstrings(d->DISPLAY_STRINGS)) 
					return(0);
			}
			display=d;
			return 1;
		}
		d++;
	}
	return 0;	
}

/*
 * Loads the display/strings.%d into memory. Where %d is "fi"
 *
 */
int di_loadstrings(int fi)
{
	char lsbuf[1024];
	char strbuf[4096];
	struct stat st;
	int stf;
	int i;
	char *currp;
	int j;
	char *tmem;
	char *tp;
		
	if (strfmem) 
		free(strfmem);
	sprintf(lsbuf,"%s/display/strings.%3.3d",origdir,fi);
	stat(lsbuf,&st);
	strfmem=(char *)malloc(st.st_size);

	tmem=(char *)malloc(st.st_size+2);
	memset(tmem,0,st.st_size+2);
	stf=open(lsbuf,O_RDONLY);
	
	read(stf,tmem,st.st_size);
	close(stf);
	tp=tmem;
	
	currp=strfmem;
	
	for (i=0;i!=MAXSTRS;i++)
	{
		tp=cpstr(strbuf,tp);
		if (!tp) {
			DDPut("Error in string file!\n");
			return 0;
		}
		j=lscpy(strbuf,currp);
		sd[i]=currp;
		currp=&currp[j];
	}	
	free(tmem);
	return(1);
}

char *cpstr(char *t, char *s)
{
	if (*s==0) return 0;
	while(*s!=10) *t++=*s++;
	*t++=0;
	return ++s;
}

int lscpy(char *s, char *t)
{
	char *u=t;
	while(*s)
	{
		if (*s=='\\') {
			s++;
			if (*s=='\\')
				*t++='\\';
			else if (*s=='n')
				*t++=10;
			else if (*s=='r')
				*t++='\r';
			else if (*s=='e')
				*t++=27;
			else if (*s=='a')
				*t++=1;
			s++;
		} else {
			*t++=*s++;
		}
	}
	*t=0;
	return strlen(u)+1;		
}

