/*
 * This file contains the "Background Checker". Like the name implies,
 * it processes uploads and downloads on the background. Its started
 * when an ul or dl starts, and it stops when everything has been
 * processed.
 *
 * There can be many of them running at the same time for the same
 * user if your connection is much faster than your machines
 * power to test/transform archives... :)
 *
 */
#include "proto.h"
#include <dirent.h>
#include <sys/param.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <utime.h>
#include <fcntl.h>
#include <stdlib.h>
#include <time.h>
#include <ctype.h>
#include <sys/mman.h>
#include <signal.h>

#ifndef NO_VFS
#include <sys/vfs.h>
#endif

#include <sys/mount.h>

int bgdone;

void bg_bghan(int sig);

/*
 * Checks upload integrity, transforms it, reads file_id.diz 
 * and inserts the file to filelist... 
 *
 */
int bg_handleupload(MYSQL *db, char *upname)
{
	struct VMatik_Archiver *arc;
	struct FileType	new_file;
	char	query[QUERY_MAX];
	char	pathname[PATH_MAX];
	char	filepath[PATH_MAX];
	char	finname[PATH_MAX];
	char buf[200];	
	struct stat st;
	time_t currtime;
	FILE *founddiz=NULL;
	struct stat fst;
				
	strcpy(finname,upname);
	memset(&new_file, 0, sizeof(struct FileType));
	
	if(stat(finname,&st)!=0)					// Hmm, it doesn't exist
		return(0);

	utime(finname, NULL);						// Set current date
	currtime=time(NULL);
	
	if(bg_checkfilename(finname))				// Make sure its a good name! :)
	{
		rename(upname,finname);
	}

	strcpy(new_file.Name, finname);

	sprintf(pathname,"%s%s",currnode->Node_TempDir,finname);
	
	arc=ar_getarchiver(finname);
		
	if (arc && arc->ARC_EXTRACTFILEID[0]) 
	{
		struct dirent *dent;
		DIR *dh;
		char olddirri[PATH_MAX];
		char extdiz[1024];

		DDPut(sd[checkdizstr]);
		
		mkdir(".packtmp",0700);
		deldir(".packtmp");

		getcwd(olddirri,PATH_MAX);
		chdir(".packtmp");

		genstdiocmdline(extdiz,arc->ARC_EXTRACTFILEID,pathname,
						NULL,NULL,NULL,NULL);
		runstdio(extdiz,0,3); 

		chdir(olddirri);

		if ((dh=opendir(".packtmp")))
		{
			while((dent=readdir(dh)))
			{
				if (!strcasecmp("file_id.diz",dent->d_name)) {
					sprintf(buf,".packtmp/%s",dent->d_name);
					founddiz=fopen(buf,"r");
					stat(buf,&fst);
					break;
				}
			}
			closedir(dh);
		}

		if (founddiz) 
		{
			new_file.Description=malloc(fst.st_size+1);

			fread(new_file.Description, fst.st_size, 1, founddiz);
			fclose(founddiz);
			new_file.Description[fst.st_size]=0;
		
			deldir(".packtmp");
			rmdir(".packtmp");
		}
	}

	if (arc && (arc->ARC_FLAGS & ARC_GETDATE) && founddiz) 
	{
		new_file.UploadDate=fst.st_mtime;
	}
	else
	{
		new_file.UploadDate=currtime;
	}

	if ( (conf->CONF_ATTRIBUTES & CONF_NO_FILECHECK)==0 && arc && 
		  *arc->ARC_CMD_TEST) 
	{
		if(!ar_test_archive(pathname, arc))
			new_file.Integrity=INTEGRITY_FAILED;
		else
		{
			char newname[PATH_MAX];
		
			new_file.Integrity=INTEGRITY_PASSED;
			if(ar_transform_archive(pathname, arc, newname))
			{
				new_file.Flags|=FILE_TRANSFORMED;
			
				if(strcmp(pathname, newname)!=0)	// Name has changed
				{
					unlink(pathname);				// Remove old
					strcpy(pathname, newname);
					strcpy(new_file.Name, mi_filepart(newname));
				}	
			}
		}	
	}
	else
	{
		if(!arc || !(*arc->ARC_CMD_TEST))
			new_file.Integrity=INTEGRITY_NOT_TESTABLE;
	}

	mi_sql_setuser(db, "user_filesup", user.user_serial_id,
					'+', 1);
	mi_sql_setuser(db, "user_bytesup", user.user_serial_id,
					'+', st.st_size);
	
	if(new_file.Integrity==INTEGRITY_FAILED)
	{
		mi_sql_setuser(db, "user_filesup_bad",
						user.user_serial_id, '+', 1);
		mi_sql_setuser(db, "user_bytesup_bad",
						user.user_serial_id, '+', st.st_size);
	}

	if (!(conf->CONF_ATTRIBUTES & CONF_NO_CREDITS)) 
	{
		new_file.Files_To_ULer=user.user_fileratio1;
		new_file.Bytes_To_ULer=user.user_byteratio1*st.st_size;

		if(new_file.Integrity!=INTEGRITY_FAILED && 
			!(conf->CONF_ATTRIBUTES & CONF_VALIDATE_UPLOADS))
		{
				mi_sql_setuser(db, "user_filecred",
								user.user_serial_id, '+',
								user.user_fileratio1);
				mi_sql_setuser(db, "user_bytecred",
								user.user_serial_id, '+',
								user.user_byteratio1*st.st_size);
		}
	}

	if(stat(pathname, &st)!=0)			// Check for new size
		return(0);						// Oops, we've lost the file

	new_file.Size=st.st_size;
	new_file.ByID=user.user_serial_id;

	if(!(conf->CONF_ATTRIBUTES & CONF_VALIDATE_UPLOADS))
		new_file.Flags|=FILE_VALIDATED;

	if(!ul_add_file(db, &new_file, Current_FileAreaID))
	{
		writelog("bg_handleupload(): ul_add_file() error\n");
		return(0);
	}

	sprintf(buf, "area_id=%d", Current_FileAreaID);
	mi_sql_getstr(db, "area_filepath", "vmatik_fileareas", buf,
		filepath);			

	mi_correct_path(filepath);

	sprintf(buf, "%s%s", filepath, finname);


//	founddiz=fopen("/tmp/bglog", "a");
//	fprintf(founddiz, "Old: %s New: %s\n", pathname, buf);
//	fclose(founddiz);

	newrename(pathname,buf);

	sprintf(query, "UPDATE vmatik_fileareas SET area_newestfile=NOW(),
			area_lasttouch=NOW() WHERE area_id=%d", Current_FileAreaID);
	mysql_query(db,query);
	
	return(1);
}

/*
 * Checks a filename. Anything goes except wildcards and '/'. 
 *
 * Note: Filenames "." and ".." are converted to "a" and "aa"
 *
 * "BUGS:" Converts the filename to lowercase :)
 *
 */
int bg_checkfilename(char *name)
{
	int len=0;

	if(!name)
		return(0);

	while(*name)
	{
		switch(*name)
		{
			case '/':
				*name='_';
				break;
			case '?':
				*name='&';
				break;
			case '*':
				*name='^';
				break;
			default:
				*name=tolower(*name);
				break;
		}
		name++;
		len++;
	}

	if(len==1)
	{
		if(name[0]=='.' && name[1]==0)
			name[0]='a';
	}
	else
	{
		if(len==2)
		{
			if(name[0]=='.' && name[1]=='.' && name[2]==0)
			{
				name[0]='a';
				name[1]='a';
			}
		}
	}

	return(1);
}

/*
 * BGChecker signal handler. Tells bg_bgchecker() that the upload has
 * finished.
 *
 */
void bg_bghan(int sig)
{
	bgdone=1;
}

/*
 * This function launches the background file checker. 
 *
 * Idea: While files are transferred, read the log, 
 *       add files to the system (with testing & transforming them)
 *       and remove downloaded files from flaglist in the background.
 *
 * Techshit: Process a logline. If Parent has not signalled the
 *           bgdone, we will sleep(1) and then try to open the logfile
 *           again and read a new line. However, if bgdone is
 *           signalled, we process the whole log to its end,
 *           do our job and then quit.
 *
 * Note: Making sure we really have got EVERYTHING from the log
 *       that there is to get [AFTER the usr1 signal is received]
 *       makes it look a bit shite... :)
 *
 */
pid_t bg_bgchecker(void)
{
	MYSQL	db;
	pid_t	bgrun;
	char	dszlog[PATH_MAX];
	FILE 	*log;
	int     bytesup, bytesdn, filesup, filesdn;
	int		faileddn=0;
	int 	reallydie=0;

	bgrun=fork();
	if (bgrun<0) 				// Failure
	{
		return(0);
	}
	if (bgrun>0)				// Child proceeds exec, return Parent 
		return(bgrun);
	
	signal(SIGUSR1,bg_bghan);		// Set signal handler

	bytesup=bytesdn=filesup=filesdn=0;
	
	bgmode=1;
	bgdone=0;
	carrier=0;

	mysql_connect(&db, NULL, SQL_USER, SQL_PASSWD);	// We need our own
	mysql_select_db(&db, "vmatik");                 // connection

	sprintf(dszlog,"%sdszlog.%d.%d",VMTMP,node, getpid());

	while(!reallydie) 
	{
		log=fopen(dszlog,"r");
		if(log)									// Great, got the log open! 
		{
			int oldloc;
			char oldwd[PATH_MAX];
			char fname[PATH_MAX];
			char logentry[PATH_MAX];
			char buf[1024];
			int stop_forever=0;
			int fsize, cps;
		
			while(stop_forever<2)
			{
				oldloc=ftell(log);
				if(fgets(buf, 1024, log))
				{
					if(buf[strlen(buf)-1]!='\n')			// Ahem, we got
					{										// sth unexpected
						if(bgdone<2)
						{
							fseek(log, oldloc, SEEK_SET);	// Go back,
							if(bgdone) 
								bgdone++;
						}
						sleep(1);							// Try again later
						continue;
					}
					switch(bg_getdszstuff(buf, fname, &fsize, &cps))
					{
						case XFER_UPLOAD:
							getcwd(oldwd, PATH_MAX);
							chdir(currnode->Node_TempDir);
							bg_handleupload(&db, mi_filepart(fname));
							chdir(oldwd);
							sprintf(logentry, "Up(%c): %-25s [%8db, %5d cps]\n", 
									user.user_protocol, mi_filepart(fname), 
									fsize, cps);
							writelog(logentry);
							filesup++;
							bytesup+=fsize;
							if(cps>0)
							{
								mi_sql_setuser(&db, "user_timeremain", 
											user.user_serial_id, '+',
											((int)(fsize/cps)*
											((float)conf->CONF_UL_TIMEREWARD/
											(float)100))/60);
							}
							break;
						case XFER_DOWNLOAD:
							bg_handledownload(&db, mi_filepart(fname), fsize);
							sprintf(logentry, "Dn(%c): %-25s [%8db, %5d cps]\n", 
									user.user_protocol, mi_filepart(fname), 
									fsize, cps);
							writelog(logentry);
							filesdn++;
							bytesdn+=fsize;
							break;
						case XFER_UP_ERROR:			// A skip, for example
							sprintf(logentry, "UE(%c): %-25s [%8db, %5d cps]\n",
									user.user_protocol, mi_filepart(fname), 
									fsize, cps);
							writelog(logentry);
							break;
						case XFER_DOWN_ERROR:		// Receiver skip, 4 examp.
							sprintf(logentry, "DE(%c): %-25s [%8db, %5d cps]\n",
									user.user_protocol, mi_filepart(fname),
									fsize, cps);
							writelog(logentry);
							faileddn++;
							break;
						default:
							break;
					// Somewhere here should be makepartial(fname) ?!?!?
					}
				}
				else
				{
					if(bgdone)					// fgets failed and we can
						stop_forever++;         // read no more. Buhuhuhuuu.
					else
						sleep(2);				// Try more later
				}
			}

			reallydie=1;
			fclose(log);
		}
		else									// No log yet
		{
			if(bgdone)							// We try just once more
				bgdone++;
			if(bgdone>2)				 		// Its not going to be there.
				reallydie=1;
			
			sleep(1);							// Take a nap (try again?)
		}
	}

	// Ok, the upload is finished now, remove the logfile. 
	
	unlink(dszlog);

	mysql_close(&db);

	if(filesup || filesdn)						// Inform user
	{
		char msgbuffer[NODEMSGSIZE_MAX];

		sprintf(msgbuffer, "\n\nBGChecker finished. [Up: %d files, %d bytes] [Down: %d files, %d bytes]\n\n",
				filesup, bytesup, filesdn, bytesdn);
		ol_privateolm(node, user.user_serial_id, msgbuffer);
	}
	else
	{	
		ol_privateolm(node, user.user_serial_id, "\n\nBGChecker finished. No files transferred!\n\n");
	}
	
	/* Commit suicide with style */

	kill(getpid(), SIGKILL);

	return(0);
}

/*
 * Returns the type of transfer. Fills in filename, fsize & cps accordingly.
 *
 * Note: -1 is returned on log parsing error.
 *
 */
int bg_getdszstuff(char *logline, char *filename, int *fsize, int *cps)
{
	int xfer_type, assignments;
	
	if(!logline)
		return(-1);
	
	switch(logline[0])
	{
		case 'S':
		case 'R':
			xfer_type=XFER_UPLOAD;
			break;
		case 'H':
		case 's':
			xfer_type=XFER_DOWNLOAD;
			break;
		case 'E':
			xfer_type=XFER_UP_ERROR;		// An UPLOAD error
			break;
		case 'e':
			xfer_type=XFER_DOWN_ERROR;		// A DOWNLOAD error
		case 0:
			return(-1);
			break;
		default:
			xfer_type=XFER_UNKNOWN;
			break;
	}

//	assignments=sscanf(logline, "%*c %d %*d bps %d cps %*d errors %*d %*d %s %*d", fsize, cps, filename);
	assignments=sscanf(logline, "%*c %d %*d %*s %d %*s %*d %*s %*d %*d %s %*d", fsize, cps, filename);
	if(assignments!=3)
		return(-1);

	return(xfer_type);
}

/*
 * This function updates files dlcounter, last dl date,
 * and removes the downloaded file from users flaglist.
 * (All this providing it IS in there in the first place)... 
 *
 * And removes credits from the user! Nyah nyah!
 *
 */
int bg_handledownload(MYSQL *db, char *filename, int fsize)
{
	char query[QUERY_MAX];
	int file_id;
	
	mi_sql_setuser(db, "user_bytesdn", user.user_serial_id,
						'+', fsize);
	mi_sql_setuser(db, "user_filesdn", user.user_serial_id,
						'+', 1);

	sprintf(query, "file_name='%s' AND flagged_user=%d AND
					flagged_id=file_id", filename, user.user_serial_id);
	file_id=mi_sql_getnum(db, "file_id",
					"vmatik_flagged, vmatik_filelist",
					query);	
		
	if(file_id)
	{
/*************** Update file counters ****************************/
		sprintf(query, "file_id=%d", file_id);
		mi_sql_setval(db, "file_downloads", 
					"vmatik_filelist", query, '+', 1);
					
		sprintf(query, "UPDATE vmatik_filelist 
						SET file_dldate=NOW() 
						WHERE file_id=%d", file_id);
		mysql_query(db, query);

/****************** Handle credits ****************************/

// Check that it's not a freedl
		sprintf(query, "flagged_user=%d AND flagged_id=%d AND
						file_id=flagged_id AND area_id=file_area
						AND NOT (file_flags & %ld) 
						AND NOT (area_flags & %ld)
						AND (file_integrity!=%d)",
						user.user_serial_id, file_id, FILE_FREEDL, 
						AREA_FREEDL, INTEGRITY_FAILED);
		if(mi_sql_getnum(db, "1", 
						"vmatik_flagged,vmatik_filelist,vmatik_fileareas",
						query) > 0)
		{
			mi_sql_setuser(db, "user_bytecred", user.user_serial_id,
						'-', fsize);
			mi_sql_setuser(db, "user_filecred", user.user_serial_id,
						'-', 1);
		}

/**************** Delete entry from flaglist****************************/

		sprintf(query, "DELETE FROM vmatik_flagged
						WHERE flagged_user=%d AND flagged_id=%d",
						user.user_serial_id, file_id);
		mysql_query(db, query);

		return(1);
	}

	return(0);
}


