/*
 * This file includes functions related to editing/adding/moving fileareas
 *
 */
#include "proto.h"
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/mman.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>

/*
 * This adds a filearea to the current conference.
 *
 * Returns area_id, or 0 on failure
 *
 * Bugs: no access flags
 *
 */
int ae_add_filearea(MYSQL *db)
{
	char query[QUERY_MAX];
	char area_name[50];
	char area_filepath[255];
	char nametemp[512];
	char pathtemp[512];

	DDPut("\n");

	area_name[0]=0;
	DDPut("Area name: ");
	Prompt(area_name, sizeof(area_name),0);
	if(!area_name[0])
	{
		DDPut(sd[euabortedstr]);
		return(0);
	}
	
	area_filepath[0]=0;
	DDPut("Area filepath: ");
	Prompt(area_filepath, sizeof(area_filepath),0);
	if(!area_filepath[0])
	{
		DDPut(sd[euabortedstr]);
		return(0);
	}

	mi_correct_path(area_filepath);				// Add '/' if missing

	mysql_escape_string(nametemp, area_name, strlen(area_name));
	mysql_escape_string(pathtemp, area_filepath, strlen(area_filepath));
	
	sprintf(query, "INSERT INTO vmatik_fileareas (area_name,area_conf,
					area_filepath,area_displayat) VALUES
					('%s',%d,'%s',%d)",
					nametemp, conf->CONF_NUMBER, pathtemp, INT_MAX);
	mysql_query(db, query);
	if(mysql_error(db)[0])
	{
		DDPut(mysql_error(db));
		return(0);
	}

	DDPut("\nAdded.\n\n");

	return(mysql_insert_id(db));
}
/*
 * This function changes the location of a filearea in the list
 * of fileareas.
 *
 * Note: Currently this is quite a heavy function...
 *
 */
int ae_move_filearea(MYSQL *db, char *params)
{
	int src_area, dst_loc, old_area;
	char *srcstrh;
	char query[QUERY_MAX];
	char buffer[100];
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;

	old_area=Current_FileAreaID;

	srcstrh=params;
	srcstrh=strspa(srcstrh, buffer);
	if(!srcstrh)
	{
		DDPut("Usage: ML <src_area> <dst_loc>\n");
		return(0);
	}
	src_area=atoi(buffer);
	if(!src_area)
	{
		DDPut("Aborted...");
		return(0);
	}
	jc_changefilearea(src_area, JC_SHUTUP);		// Find out the real area ID
	src_area=Current_FileAreaID;
	jc_changefilearea(old_area, JC_SHUTUP);
	if(!src_area)
	{
		DDPut("Area to be moved doesn't exist...\n");
		return(0);
	}

	srcstrh=strspa(srcstrh, buffer);
	if(!srcstrh)
	{
		DDPut("Usage: ML <src_area> <dst_loc>\n");
		return(0);
	}
	dst_loc=atoi(buffer);
	if(!dst_loc)
	{
		DDPut("Aborted...");
		return(0);
	}

	sprintf(query, "UPDATE vmatik_fileareas 
					SET area_displayat=area_displayat+1
					WHERE area_conf=%d AND area_displayat>=%d", 
					conf->CONF_NUMBER, dst_loc);
	mysql_query(db, query);

	sprintf(query, "area_id=%d", src_area);
	mi_sql_setval(db, "area_displayat", "vmatik_fileareas", query, '=', 
					dst_loc);

	sprintf(query, "SELECT area_id
					FROM vmatik_fileareas
					WHERE area_conf=%d
					ORDER BY area_displayat", conf->CONF_NUMBER);
	mysql_query(db, query);
	sql_result=mysql_store_result(db);
	if(sql_result)
	{
		int i;
	
		for(i=0;i<mysql_num_rows(sql_result);i++)		// Renumber
		{
			sql_row=mysql_fetch_row(sql_result);
			sprintf(query, "UPDATE vmatik_fileareas
							SET area_displayat=%d
							WHERE area_id=%s", i+1, sql_row[0]);
			mysql_query(db, query);
		}
		mysql_free_result(sql_result);
	}

	return(1);
}
