/*
 * Library for vuohimatik doors
 *
 * BUGS: A shiteload of 'em. Some in doorport.c
 *
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ddlib.h"

void writedm(struct dif *);

struct VMatik_Conference *__confdatas=0;

struct dif *VMatik_initdoor(char *node)
{
	struct dif *mydif;
	struct sockaddr_un socknfo;
	char portname[80];
	
	mydif=(struct dif *)malloc(sizeof(struct dif));
	sprintf(portname,"%sVMatik_door%s",VMTMP,node);
	strcpy(socknfo.sun_path,portname);
	socknfo.sun_family=AF_UNIX;
	
	mydif->dif_sockfd=socket(AF_UNIX,SOCK_STREAM,0);
	if (mydif->dif_sockfd==-1) {
		free(mydif);
		fprintf(stderr, "Hier!\n");
		return(NULL);
	}	
	if (connect(mydif->dif_sockfd,(struct sockaddr *)&socknfo,
				sizeof(struct sockaddr_un)) == -1) 
	{
		close(mydif->dif_sockfd);
		free(mydif);
		fprintf(stderr, "Bier!\n");
		return(NULL);
	}
	signal(SIGHUP,SIG_IGN);

	return(mydif);
}

void VMatik_close(struct dif *d)
{
	if (__confdatas) {
		struct VMatik_Conference *conftmp;

		conftmp=__confdatas;
		while(conftmp->CONF_NUMBER!=255)
		{
			if(conftmp->Conf_MsgBases)
				free(conftmp->Conf_MsgBases);
			conftmp++;
		}
		free(__confdatas);
	}
	d->dif_dm.ddm_command=1;
	writedm(d);
}

struct VMatik_Conference *VMatik_getconfdata(void)
{
	struct stat fib;
	struct VMatik_Conference *conftmp;
	int datafd;
	if (!__confdatas) {
		char tbuf[1024];
		sprintf(tbuf,"%s/data/conferences.dat",getenv("VMATIK"));
		datafd=open(tbuf,O_RDONLY);

		if (datafd==-1) {
			return 0;
		}

		fstat(datafd,&fib);
	
		__confdatas=(struct VMatik_Conference *)malloc(fib.st_size+2);
		memset(__confdatas, 255, fib.st_size+2);
		conftmp=__confdatas;

		while(read(datafd,conftmp, sizeof(struct VMatik_Conference)))
		{
			if(conftmp->CONF_MSGBASES>0)
			{
				int i;

				i=conftmp->CONF_MSGBASES*sizeof(struct VMatik_MsgBase);
				conftmp->Conf_MsgBases=(struct VMatik_MsgBase *)malloc(i);
				read(datafd, conftmp->Conf_MsgBases, i);
			}
			conftmp++;
		}
		close(datafd);
	} 
	return __confdatas;
}
struct VMatik_Conference *VMatik_getconf(int cnum)
{
	struct VMatik_Conference *tconf;
	struct VMatik_MsgBase *tbase;
	int bcnt;
			
	if (!(tconf=VMatik_getconfdata())) return 0;
	
	while (1)
	{
		if(tconf->CONF_NUMBER==255) {
			return 0;
		}

		if (tconf->CONF_NUMBER==cnum) {
			return tconf;
		}
		(struct VMatik_Conference *)tbase=tconf+1;	
		bcnt=tconf->CONF_MSGBASES;
		while(bcnt)
		{
			tbase++;
			bcnt--;
		}
		tconf=(struct VMatik_Conference *)tbase;
	}

}

struct VMatik_MsgBase *VMatik_getbase(int cnum, int bnum)
{
	struct VMatik_Conference *tconf;
	int bcnt;
	struct VMatik_MsgBase *tbase;
	
	tconf=VMatik_getconf(cnum);
	if (!tconf) return 0;

	(struct VMatik_Conference *)tbase=tconf+1;	
	bcnt=tconf->CONF_MSGBASES;
	while(bcnt)
	{
		if (tbase->MSGBASE_NUMBER==bnum) return tbase;
		tbase++;
		bcnt--;
	}
	return 0;
}

void VMatik_sendstring(struct dif *d, char *str)
{
	while(strlen(str) > 299)
	{
		d->dif_dm.ddm_command=2;
		strncpy(d->dif_dm.ddm_string,str,299);
		d->dif_dm.ddm_string[299]=0;
		writedm(d);
		str=&str[299];
	}
	d->dif_dm.ddm_command=2;
	strncpy(d->dif_dm.ddm_string,str,300);
	writedm(d);
}

int VMatik_prompt(struct dif *d, char *buffer, int len, int flags)
{
	strcpy(d->dif_dm.ddm_string,buffer);
	d->dif_dm.ddm_data1=len;
	d->dif_dm.ddm_data2=flags;
	d->dif_dm.ddm_command=3;
	writedm(d);
	strcpy(buffer,d->dif_dm.ddm_string);
	return d->dif_dm.ddm_data1;
}

int VMatik_hotkey(struct dif *d, int flags)
{
	d->dif_dm.ddm_command=4;
	d->dif_dm.ddm_data1=flags;
	writedm(d);
	return d->dif_dm.ddm_data1;
}

int VMatik_typefile(struct dif *d, char *text, int flags)
{
	d->dif_dm.ddm_command=5;
	d->dif_dm.ddm_data1=flags;
	strcpy(d->dif_dm.ddm_string,text);
	writedm(d);
	return d->dif_dm.ddm_data1;
}

int VMatik_flagsingle(struct dif *d, char *file, int flags)
{
	d->dif_dm.ddm_command=6;
	d->dif_dm.ddm_data1=flags;
	strcpy(d->dif_dm.ddm_string,file);
	writedm(d);
	return d->dif_dm.ddm_data1;
}

int VMatik_findusername(struct dif *d, char *user)
{
	d->dif_dm.ddm_command=7;
	strcpy(d->dif_dm.ddm_string,user);
	writedm(d);
	return d->dif_dm.ddm_data1;
}

int VMatik_system(struct dif *d, char *user, int mode)
{
	d->dif_dm.ddm_command=8;
	d->dif_dm.ddm_data1=mode;
	strcpy(d->dif_dm.ddm_string,user);
	writedm(d);

	return(1);
}

int VMatik_docmd(struct dif *d, char *cmd)
{
	d->dif_dm.ddm_command=9;
	strcpy(d->dif_dm.ddm_string,cmd);
	writedm(d);

	return(1);
}

int VMatik_writelog(struct dif *d, char *cmd)
{
	d->dif_dm.ddm_command=10;
	strcpy(d->dif_dm.ddm_string,cmd);
	writedm(d);

	return(1);
}

int VMatik_changestatus(struct dif *d, char *stat)
{
	d->dif_dm.ddm_command=11;
	strcpy(d->dif_dm.ddm_string,stat);
	writedm(d);

	return(1);
}

void VMatik_pause(struct dif *d)
{
	d->dif_dm.ddm_command=12;
	writedm(d);
}

int VMatik_joinconf(struct dif *d, int dc, int fl)
{
	d->dif_dm.ddm_command=13;
	d->dif_dm.ddm_data1=dc;
	d->dif_dm.ddm_data2=fl;
	writedm(d);
	return d->dif_dm.ddm_data1;	
}

int VMatik_isfreedl(struct dif *d, char *s)
{
	d->dif_dm.ddm_command=14;
	strcpy(d->dif_dm.ddm_string,s);
	writedm(d);
	return d->dif_dm.ddm_data1;	
}

int VMatik_flagfile(struct dif *d, char *s, int i)
{
	d->dif_dm.ddm_command=15;
	d->dif_dm.ddm_data1=i;
	strcpy(d->dif_dm.ddm_string,s);
	writedm(d);
	return d->dif_dm.ddm_data1;	
}

void VMatik_getstrval(struct dif *d, char *buf, int val)
{
	d->dif_dm.ddm_command=val;
	d->dif_dm.ddm_data1=0;
	writedm(d);
	strcpy(buf,d->dif_dm.ddm_string);
}

void VMatik_setstrval(struct dif *d, char *buf, int val)
{
	d->dif_dm.ddm_command=val;
	d->dif_dm.ddm_data1=1;
	strcpy(d->dif_dm.ddm_string,buf);
	writedm(d);
}

int VMatik_getintval(struct dif *d, int val)
{
	d->dif_dm.ddm_command=val;
	d->dif_dm.ddm_data1=0;
	writedm(d);
	return d->dif_dm.ddm_data1;
}

void VMatik_setintval(struct dif *d, int val, int new)
{
	d->dif_dm.ddm_command=val;
	d->dif_dm.ddm_data1=1;
	d->dif_dm.ddm_data2=new;
	writedm(d);
}

unsigned long long VMatik_getlintval(struct dif *d, int val)
{
	d->dif_dm.ddm_command=val;
	d->dif_dm.ddm_data1=0;
	writedm(d);
	return d->dif_dm.ddm_ldata;
}

void VMatik_setlintval(struct dif *d, int val, unsigned long long new)
{
	d->dif_dm.ddm_command=val;
	d->dif_dm.ddm_data1=1;
	d->dif_dm.ddm_ldata=new;
	writedm(d);
}

void VMatik_getlprs(struct dif *d, struct VMatik_LRP *lp)
{
	d->dif_dm.ddm_command=16;
	writedm(d);
	lp->lrp_read=d->dif_dm.ddm_data1;
	lp->lrp_scan=d->dif_dm.ddm_data2;
}

void VMatik_setlprs(struct dif *d, struct VMatik_LRP *lp)
{
	d->dif_dm.ddm_command=17;
	d->dif_dm.ddm_data1=lp->lrp_read;
	d->dif_dm.ddm_data2=lp->lrp_scan;
	writedm(d);
}

void writedm(struct dif *d)
{
	write(d->dif_sockfd,&d->dif_dm,sizeof(struct VMatik_DoorMsg));
	read(d->dif_sockfd,&d->dif_dm,sizeof(struct VMatik_DoorMsg));
}

int VMatik_isconfaccess(struct dif *d, int confn)
{
	d->dif_dm.ddm_command=18;
	d->dif_dm.ddm_data1=confn;
	writedm(d);
	return d->dif_dm.ddm_data1;
}

int VMatik_isanybasestagged(struct dif *d, int confa)
{
	d->dif_dm.ddm_command=19;
	d->dif_dm.ddm_data1=confa;
	writedm(d);
	return d->dif_dm.ddm_data1;
}

int VMatik_isconftagged(struct dif *d, int n)
{
	d->dif_dm.ddm_command=20;
	d->dif_dm.ddm_data1=n;
	writedm(d);
	return d->dif_dm.ddm_data1;
}

int VMatik_isbasetagged(struct dif *d, int n, int b)
{
	d->dif_dm.ddm_command=21;
	d->dif_dm.ddm_data1=n;
	d->dif_dm.ddm_data2=b;
	writedm(d);
	return d->dif_dm.ddm_data1;
}

void VMatik_getmprs(struct dif *d, struct VMatik_MsgPointers *lp)
{
	d->dif_dm.ddm_command=22;
	writedm(d);
	lp->msp_high=d->dif_dm.ddm_data1;
	lp->msp_low=d->dif_dm.ddm_data2;
}

void VMatik_setmprs(struct dif *d, struct VMatik_MsgPointers *lp)
{
	d->dif_dm.ddm_command=23;
	d->dif_dm.ddm_data1=lp->msp_high;
	d->dif_dm.ddm_data2=lp->msp_low;
	writedm(d);
}

int VMatik_changemsgbase(struct dif *d, int base, int flags)
{
	d->dif_dm.ddm_command=24;
	d->dif_dm.ddm_data1=base;
	d->dif_dm.ddm_data2=flags;
	writedm(d);
	return d->dif_dm.ddm_data1;
}

void VMatik_sendfiles(struct dif *d, char *flist)
{
	d->dif_dm.ddm_command=25;
	strcpy(d->dif_dm.ddm_string,flist);
	writedm(d);
}

void VMatik_getfiles(struct dif *d, char *path)
{
	d->dif_dm.ddm_command=26;
	strcpy(d->dif_dm.ddm_string,path);
	writedm(d);
}

/* VMatik_fileattach is a private command :) */

int VMatik_fileattach(struct dif *d)
{
	d->dif_dm.ddm_command=27;
	writedm(d);

	return(1);
}

int VMatik_unflagfile(struct dif *d, char *s)
{
	d->dif_dm.ddm_command=28;
	strcpy(d->dif_dm.ddm_string,s);
	writedm(d);
	return d->dif_dm.ddm_data1;
}

int VMatik_findfilestolist(struct dif *d, char *file, char *list)
{
	if (strlen(file)>48) return 0;

	d->dif_dm.ddm_command=29;
	strcpy(d->dif_dm.ddm_string,file);
	strcpy(&d->dif_dm.ddm_string[50],list);
	writedm(d);
	return d->dif_dm.ddm_data1;
}

int VMatik_getfidounique(void)
{
	int fn;
	char buf[1024];
	int i=0;
	
	sprintf(buf,"%s/data/fidocnt.dat",getenv("VMATIK"));
	fn=open(buf,O_CREAT|O_RDWR,0644);
	if (fn < 0) return 0;
	read(fn,&i,sizeof(int));
	i++;
	lseek(fn,0,SEEK_SET);
	write(fn,&i,sizeof(int));
	close(fn);
	return i;
}

int VMatik_isfiletagged(struct dif *d, char *str)
{
	d->dif_dm.ddm_command=30;
	strcpy(d->dif_dm.ddm_string,str);
	writedm(d);
	return d->dif_dm.ddm_data1;
}
