/*
 * Library for VMatik door interface
 *
 */

#ifndef VMATIK_LIB_H
#define VMATIK_LIB_H

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <signal.h>

#include "struct.h"

/*
	dif structure
 */
struct dif {
	struct VMatik_DoorMsg dif_dm;
	int dif_sockfd;
};

/*
	prototypes for libcalls
 */
struct dif *VMatik_initdoor(char *);
void VMatik_close(struct dif *);
int VMatik_fileattach(struct dif *d);
void VMatik_sendstring(struct dif *, char *);
int VMatik_prompt(struct dif *, char *, int, int);
int VMatik_hotkey(struct dif *, int);
int VMatik_typefile(struct dif *, char *, int);
int VMatik_changestatus(struct dif *, char *);
void VMatik_pause(struct dif *);
int VMatik_joinconf(struct dif *, int, int);
int VMatik_isfreedl(struct dif *, char *);
int VMatik_flagfile(struct dif *, char *, int);
void VMatik_getmprs(struct dif *d, struct VMatik_MsgPointers *lp);
void VMatik_setmprs(struct dif *d, struct VMatik_MsgPointers *lp);
void VMatik_getstrval(struct dif *, char *, int);
void VMatik_setstrval(struct dif *, char *, int);
int VMatik_getintval(struct dif *, int);
void VMatik_setintval(struct dif *, int, int);
unsigned long long VMatik_getlintval(struct dif *, int);
void VMatik_setlintval(struct dif *, int, unsigned long long);
struct VMatik_Conference *VMatik_getconf(int);
struct VMatik_MsgBase *VMatik_getbase(int, int);
void VMatik_getlprs(struct dif *, struct VMatik_LRP *);
void VMatik_setlprs(struct dif *, struct VMatik_LRP *);
struct VMatik_Conference *VMatik_getconfdata(void);
int VMatik_isconfaccess(struct dif *d, int);
int VMatik_isanybasestagged(struct dif *d, int);
int VMatik_isconftagged(struct dif *d, int);
int VMatik_isbasetagged(struct dif *d, int, int);
void VMatik_sendfiles(struct dif *d, char *);
void VMatik_getfiles(struct dif *d, char *);
int VMatik_getfidounique(void);
int VMatik_unflagfile(struct dif *d, char *);
int VMatik_findfilestolist(struct dif *d, char *, char *);

int VMatik_changemsgbase(struct dif *, int, int);

/*
	variable values
 */
#define BBS_NAME 100
#define BBS_SYSOP 101
#define USER_REALNAME 102
#define USER_HANDLE 103
#define USER_ORGANIZATION 104
#define USER_ZIPCITY 105
#define USER_VOICEPHONE 106
#define USER_COMPUTERMODEL 107
#define USER_SIGNATURE 108
#define USER_SCREENLENGTH 109
#define USER_TOGGLES 110
#define USER_ULFILES 113
#define USER_DLFILES 114
#define USER_PUBMESSAGES 115
#define USER_PVTMESSAGES 116
#define USER_CONNECTIONS 117
#define USER_FILERATIO 118
#define USER_BYTERATIO 119
#define USER_FREEDLBYTES 120
#define USER_FREEDLFILES 121
#define USER_SECURITYLEVEL 122
#define USER_JOINCONFERENCE 123
#define USER_CONFERENCEACC1 124
#define USER_CONFERENCEACC2 125
#define USER_DAILYTIMELIMIT 126
#define USER_ACCOUNT_ID 127
#define USER_TIMELEFT 128
#define DOOR_PARAMS 129
#define VMatik_ORIGDIR 130
#define VCONF_NUMBER 131
#define USER_ULBYTES 132
#define USER_DLBYTES 133
#define USER_FIRSTCALL 134
#define USER_FLINES 135
#define USER_LASTCALL 136
#define USER_PROTOCOL 137
#define USER_FAKEDFILES 138
#define USER_FAKEDBYTES 139

#endif
