/*
 * VuohiMatik fullscreen EDitor
 *
 * INSERTLINER has bugs
 *
 */
#include "../lib/ddlib.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

FILE *debu;

struct dif *d;

int max_lines=ED_DEFAULT_MAX_LINES;				// To begin with
int max_columns=ED_DEFAULT_MAX_COLUMNS;

int slen;										// User screen length
int spos;
int xpos;
int ypos;
int lines=0;
int highline;
int linelen;

char *data=NULL;					// The text that is edited
char *datapos;
char *lineadd;
char *sodobuf;						// Size of max_columns
int node;

int abortmsg(void);
int arrowleft(void);
int arrowright(void);
int backspace(void);
int clearmessage(void);
int help(void);
void insertliner(int);
int jump_to_bottom(void);
int jump_to_top(void);
int newline(void);
int process(int key);
void redraw(int);
void insertchar(unsigned char );
int previewmsg(void);
int savemessage(void);
void scrolldown(void);
void scrollup(void);
void started(char *node, char *params);
void delete_restofline(void);
void kill_line(void);
int attach(void);

int main(int argc, char *argv[])
{
	char cmdline[512];
	int go=1;

/*
	fopen("/tmp/debug", "w+");
	fprintf(debu, "Starting...\n");
	fclose(debu);

	d=VMatik_initdoor(argv[1]);
	VMatik_close(d);
	exit(1);
*/

	if (argc==1) {
		printf("This program requires Bill Gates!\n");
		exit(1);
	}
	d=VMatik_initdoor(argv[1]);
	if (d==NULL) {
		printf("Couldn't find socket!\n");
		exit(-1);
	}

    VMatik_changestatus(d,"Running FSEditor..");

/*
	fopen("/tmp/debug", "w+");
	fprintf(debu, "Tarting...\n");
	fclose(debu);
*/

	node=atoi(argv[1]);
	VMatik_getstrval(d,cmdline,DOOR_PARAMS);

/*
		fopen("/tmp/debug", "w+");
		fprintf(debu, "Farting...\n");
		fclose(debu);
*/
	do
		switch(getopt(argc-1, &argv[1], "l:c:"))
		{
			case 'l':
				max_lines=atoi(optarg);
				if(max_lines<1)
					max_lines=ED_DEFAULT_MAX_LINES;
				break;
			case 'c':
				max_columns=atoi(optarg);
				if(max_columns<1)
					max_columns=ED_DEFAULT_MAX_COLUMNS;
				max_columns+=2;
				break;
			case -1:
				go=0;
				break;
		}
	while(go);
	
	sodobuf=(char *)malloc(max_columns);
	data=(char *)malloc(max_lines*max_columns);

/*
		fopen("/tmp/debug", "w+");
		fprintf(debu, "Blarting...\n");
		fclose(debu);
*/

	started(argv[1],cmdline);

	go=1;

	while(go)
	{
		int key;

/*
		fopen("/tmp/debug", "w+");
		fprintf(debu, "Starting...\n");
		fclose(debu);
*/
	
		for (key=0;key<max_columns-1;key++)	// Clear to EOL 
		{
			if (lineadd[key]==0) 
			{
				memset(&lineadd[key], 0, max_columns-1-key);
				break;
			}
		}

		key=VMatik_hotkey(d,HOT_CURSOR);

		go=process(key);

/*
	fopen("/tmp/debug", "w+");
	fprintf(debu, "Ending...\n");
	fclose(debu);
*/
	}

	VMatik_sendstring(d,"[0m[2J[H");
	VMatik_close(d);

	free(data);
	free(sodobuf);

	return(0);
}

int attach(void)
{
	char fabuf[1024];
	struct VMatik_Message msg;
	int head;
	
	sprintf(fabuf,"%smsgheader.%d",VMTMP,node);
	head=open(fabuf,O_RDONLY);
	if (head > -1) {
		read(head,&msg,sizeof(struct VMatik_Message));
		close(head);
		if (*msg.MSG_ATTACH==1) {
			VMatik_sendstring(d,"[2J[H");
			VMatik_fileattach(d);
			redraw(1);
		}
		return(1);
	}
	return(0);
}

/*
 * fgets without linefeed
 *
 */
char *fgetsnolf(char *buf, int n, FILE *fh)
{
	char *hih;
	char *s;
	
	hih=fgets(buf,n,fh);
	if (!hih) 
		return(0);
	s=buf;
	while (*s)
	{
		if (*s==13 || *s==10) 
		{
			*s=0;
			break;
		}
		s++;
	}
	return(hih);
}

void started(char *node, char *params)
{
	char *quotena, *qbuf;
	FILE *myf;
	
	quotena=(char *)malloc(max_columns);
	qbuf=(char *)malloc(max_columns-1);

	slen=VMatik_getintval(d,USER_SCREENLENGTH);
	if(slen>max_lines+3)			// Header takes 3
		slen=max_lines+3;
	
	clearmessage();

	sprintf(quotena,"%sVMatik%s.msg",VMTMP,node);
	myf=fopen(quotena,"r");
	
	if (myf)
	{
		int go=1;

		while(go && fgetsnolf(qbuf,max_columns-1,myf)) 
		{
			if (lines >= max_lines) 
				break;

			strcpy(&data[lines*max_columns], qbuf);

			lines++;

		}
		jump_to_top();
		
		fclose(myf);

		redraw(1);
	} 
	else 
	{
		VMatik_sendstring(d,"[2J[H[0;44;35mvmEd V0.0                                                                      \n[33mCtrl-Z=Save, Ctrl-A=Abort, Ctrl-U=Help, Cursor keys to move.                   \n[36m<---+----1----+----2----+----3----+----4----+----5----+----6----+----7->--+--->[0m\n");
	}
	
	free(quotena);
	free(qbuf);
}

void scrollup(void)
{
	char buf[500];
	if (!ypos) return;
	if (spos==4) {
		sprintf(buf,"[%d;0H[M",slen);
		VMatik_sendstring(d,buf);
		sprintf(buf,"[4;0H[L%s\n",&lineadd[-max_columns]);
 		VMatik_sendstring(d,buf);
		spos++;
		highline--;
	}		
	spos--;
	lineadd=&lineadd[-max_columns];
	linelen=strlen(lineadd);
	ypos--;
	if (xpos > linelen) {
		xpos=linelen;
		if (xpos==0) VMatik_sendstring(d,"\r");
		else {
			sprintf(buf,"\r[%dC",xpos);
			VMatik_sendstring(d,buf);
		}
	}			
	VMatik_sendstring(d,"[A");
	datapos=&lineadd[xpos];
}			

void scrolldown(void)
{
	char buf[500];
	
	if (lines==ypos) 
		return;
	if (slen==spos) 
	{
		VMatik_sendstring(d,"[4;0H[M");
		sprintf(buf,"[%d;0H%s\n%s[A\r",spos-1,lineadd,&lineadd[max_columns]);
		VMatik_sendstring(d,buf);
		spos--;
		highline++;
	}
	spos++;
	lineadd=&lineadd[max_columns];
	linelen=strlen(lineadd);
	ypos++;
	if (xpos > linelen) 
	{
		xpos=linelen;
		if (xpos==0) 
			VMatik_sendstring(d,"\r");
		else 
		{
			sprintf(buf,"\r[%dC",xpos);
			VMatik_sendstring(d,buf);
		}
	}			
	VMatik_sendstring(d,"[B");
	datapos=&lineadd[xpos];
}

void insertchar(unsigned char c) 
{
	char buf[90];
	char buf2[100];
	char *s, *t, *u;	
	char *a0, *a1;
	
	int i=0, j=0;

	if (lines > max_lines) 
	{
		VMatik_sendstring(d,"[0;44;33m[1;11H- Out of space! ");
		VMatik_hotkey(d,0);
		VMatik_sendstring(d,"[0;44;33m[1;11H                ");
		redraw(0);
		return;
	}
	if (linelen==max_columns-2) 
	{
		if (xpos!=max_columns-2) {
			s=&lineadd[linelen];
			while(1) {
				if (s==lineadd) 
					return;
				if (s==datapos) 
					return;
				if (*s==' ') 
					break;
				j++;
				s--;
			}
			t=&lineadd[max_columns];
			while (*t) 
			{
				i++;
				t++;
			}
			if ((j+i) > max_columns-3) return;
			s++;
			u=buf;
			while (*s) {
				*u++=*s;
				*s++=0;
			}
			*u=0;
			sprintf(buf2,"[%d;%dH[K",spos,linelen-j+1);
			VMatik_sendstring(d,buf2);
			if (spos!=slen) {
				sprintf(buf2,"[%d;0H[%d@%s",spos+1,j,buf);
				VMatik_sendstring(d,buf2);
			}
			sprintf(buf2,"[%d;%dH",spos,xpos+1);
			VMatik_sendstring(d,buf2);
			a0=&lineadd[max_columns+i];
			a1=&a0[j];
			while (i+1) {
				*--a1=*--a0;
				i--;
			}
			a0=buf;
			a1=&lineadd[max_columns];
			while(*a0) 
			{
				*a1++=*a0++;
			}
			if (!*a1) 
				*a1++=' ';
			linelen=strlen(lineadd);
			linelen--;
			lineadd[linelen]=0;
			if (lines==ypos) lines++;
		} else {
			if (*datapos==' ') {
				*sodobuf=0;
			} else {
				s=datapos;
				while(1) 
				{
					if (s==lineadd) 
						return;
					if (*s==' ') 
						break;
					j++;
					s--;
				}
				*s++=0;
				t=sodobuf;
				while (*s) 
				{
					*t++=*s;
					*s++=0;
				}
				*t=c;
				t[1]=0;
				sprintf(buf2,"[%dD[K",j);
				VMatik_sendstring(d,buf2);
			}
			insertliner(1);
			return;
		}
	}
	if (xpos!=linelen) {
		s=&lineadd[linelen];
		t=&lineadd[xpos];
		while (1)
		{
			s[1]=*s;
			if (s==t) break;
			s--;
		}
		*s=c;
		VMatik_sendstring(d,"[@");
		buf[0]=c;
		buf[1]=0;
		VMatik_sendstring(d,buf);
		linelen++;
		datapos++;
		xpos++;
		return ;
	}

	linelen++;
	xpos++;
	*datapos++=(char)c;
	buf[0]=c;
	buf[1]=0;
	VMatik_sendstring(d,buf);
}

void redraw(int mode)
{
	char buf[500];
	int i;
	char *s;
	int lin;

	mode=1;		// Debug purposes
	
	if (mode) {
		VMatik_sendstring(d,"[2J[H[0;44;35mvmEd V0.0                                                                      \n[33mCtrl-Z=Save, Ctrl-A=Abort, Ctrl-U=Help, Cursor keys to move.                   \n[36m<---+----1----+----2----+----3----+----4----+----5----+----6----+----7->--+--->[0m\n");
	}

	s=&data[highline*max_columns];
	lin=highline;
	for (i=slen-3;i;i--,lin++) {
		if (lin>lines) break;
		VMatik_sendstring(d,s);
		VMatik_sendstring(d,"\n");
		s=&s[max_columns];
	}
	sprintf(buf,"[%d;%dH",spos,xpos+1);
	VMatik_sendstring(d,buf);
}

void insertliner(int mode)
{
	char buf[500];
	int k;
	char *s, *t, *a1; 
	int ii;

/*
	fopen("/tmp/debug", "w+");
	fprintf(debu, "Ins1...\n");
	fclose(debu);
*/
	
	sprintf(buf,"[%d;0H[M",slen);
	VMatik_sendstring(d,buf);
	
	if (slen==spos) {
		VMatik_sendstring(d,"[4;0H[M");
		sprintf(buf,"[%d;0H%s\n%s[A\r",spos-1,lineadd,&lineadd[max_columns]);
		VMatik_sendstring(d,buf);
		spos--;
		highline++;
	}
	spos++;
	
	if (mode) {
		sprintf(buf,"[%d;0H[L%s",spos,sodobuf);
	} else {
		sprintf(buf,"[%d;0H[L%s[%d;0H",spos,sodobuf,spos);
	}
	VMatik_sendstring(d,buf);
	lineadd=&lineadd[max_columns];
	xpos=0;
	linelen=0;
	datapos=lineadd;
	
	if (lines!=ypos) 
	{
		s=&data[((lines+1)*max_columns)];
		t=&lineadd[-max_columns];
		while (1) {
			if (s==t) break;
			a1=&s[max_columns];
			for (ii=max_columns;ii;ii--) {
				*a1++=*s++;
			}
			s=&s[-2*max_columns];
		}
	}
	ypos++;
	
	strcpy(datapos,sodobuf);
	if (mode) {
		k=strlen(datapos);
		xpos=k;
		datapos=&datapos[k];
		linelen=k;
	}	
	lines++;
	if (!*datapos) {
		for(ii=0;ii<max_columns-1;ii++) datapos[ii]=0;
	}

}

/*
 * Deletes all characters from cursor location to EOL
 *
 */
void delete_restofline(void)
{
	char *s;
			
	if (xpos==linelen) 
		return;
	s=datapos;
	while (*s) *s++=0;
		VMatik_sendstring(d,"[K");
	linelen=xpos;
}

/*
 * Kills a line, moving rest of the lines upwards
 *
 */
void kill_line()
{
	char buf[4096];
	char *s, *u;
	int i, j;
			
	if (ypos==lines)			// If last line, act as delete_line();
	{
		xpos=0;
		datapos=lineadd;
		VMatik_sendstring(d, "\r");
		delete_restofline();
		return;
	}
//	fprintf(stderr, "Teep\n");
	sprintf(buf,"[M[%d;0H%s[%d;%dH",slen,&data[max_columns*(highline-3+slen)],spos,xpos);
	VMatik_sendstring(d,buf);

//	fprintf(stderr, "Heep\n");
	memset(lineadd,0,max_columns-1);			
	u=lineadd;
	i=ypos;
	while (i!=lines) 
	{
		s=&u[max_columns];
		for (j=0;j!=max_columns;j++)
		{
			*u++=*s++;	
		}
		i++;
	}

//	fprintf(stderr, "Geep\n");
	linelen=strlen(lineadd);
	if (xpos > linelen)
	{
		xpos=linelen;
		if (xpos==0) 
			VMatik_sendstring(d,"\r");
		else 
		{
			sprintf(buf,"\r[%dC",xpos);
			VMatik_sendstring(d,buf);
		}
	}			
	datapos=&lineadd[xpos];
	lines--;
//	fprintf(stderr, "Meep\n");
	return;
}

int backspace(void)
{
	char buf[512];
	char *s, *u, *t;
	int i,j;

	if (!xpos) 
	{
		if (!ypos) 
			return(0);
		s=&lineadd[-max_columns];
		i=strlen(s);
		j=strlen(lineadd);
		if ((i+j) > max_columns-3) 
			return(0);
		sprintf(buf,"[M[%d;0H%s[%d;%dH",slen,&data[max_columns*(highline-3+slen)],spos,xpos);
		VMatik_sendstring(d,buf);

		if (spos==4) 
		{
			sprintf(buf,"[%d;0H[M",slen);
			VMatik_sendstring(d,buf);
			sprintf(buf,"[4;0H[L%s\n",&lineadd[max_columns]);
			VMatik_sendstring(d,buf);
			spos++;
			highline--;
		}
		spos--;
		t=&s[i];
		sprintf(buf,"[%d;%dH%s[%d;%dH",spos,i+1,lineadd,spos,i+1);
		xpos=i;
		VMatik_sendstring(d,buf);
		u=lineadd;
		while(*u)
		{
			*t++=*u++;
		}
		*u++=0;

		u=lineadd;
		i=ypos;
		while (i!=lines) 
		{
			s=&u[max_columns];
			for (j=0;j!=max_columns;j++)
			{
				*u++=*s++;	
			}
			i++;
		}
		lineadd=&lineadd[-max_columns];
		linelen=strlen(lineadd);
		datapos=&lineadd[xpos];
		memset(&data[lines*max_columns],0,max_columns);
		ypos--;
		lines--;
		return(0);
	}
	if (xpos!=linelen) 
	{
		datapos--;
		s=datapos;
		while (*(s+1))
		{
			*s=*(s+1);
			s++;
		}
		*s=0;
		VMatik_sendstring(d,"[D[P");
		xpos--;
		linelen--;
		return(0);
	}
	VMatik_sendstring(d,"[D [D");
	datapos--;
	*datapos=0;
	xpos--;
	linelen--;

	return(1);
}

int savemessage(void)
{
	char buf1[100];
	char buf2[100];
	int i;
	char *s;
	FILE *myf;
			
	sprintf(buf1,"%sfsed%d.txt",VMTMP,node);

/*
	fopen("/tmp/debug", "w+");
	fprintf(debu, "Save start...\n");
	fclose(debu);
*/

/*
	fopen("/tmp/debug", "w+");
	fprintf(debu, "Hier...\n");
	fclose(debu);
*/

/*
	if((myf=fopen("/tmp/moloheppi", "w")))
	{
		fwrite("a", 1, 1, myf);
		fopen("/tmp/debug", "w+");
		fprintf(debu, "moloh...\n");
		fclose(debu);
		fclose(myf);
	}
	else
	{
	fopen("/tmp/debug", "w+");
	fprintf(debu, "Openerr...\n");
	fclose(debu);
	}

	fopen("/tmp/debug", "w+");
	fprintf(debu, "Saved whole...\n");
	fclose(debu);
*/

// Remove empty lines from the end of msg

//	fprintf(stderr, "\nS: %d\n", max_columns*(lines-1));

/*
	s=&data[(max_columns*lines)-1];
	
	while(s>=data && (*s==0 || *s==' ' || *s=='\n'))
	{
		*s--=0;
		if(s==&data[max_columns*(lines-1)])
			lines--;
	}

	if((myf=fopen("/tmp/molo", "w")))
	{
		fwrite(data, max_columns*max_lines, 1, myf);
		fclose(myf);
	}
*/

/*
	sprintf(buf2, "Press %d...", lines);
	VMatik_sendstring(d,buf2);
	i=VMatik_hotkey(d,HOT_CURSOR);
	if (i==0 || i==-1)
		return(0);
*/

// Save the message

	if ((myf=fopen(buf1,"w"))) 
	{
		s=data;
		for (i=0;i<lines;i++) 
		{
			if(s[0])
				sprintf(buf2,"%s\n",s);
			else
				sprintf(buf2,"\n");
			s=&s[max_columns];
			if(fputs(buf2,myf)==EOF)
			{
				VMatik_sendstring(d, "Write error...\n");
				fclose(myf);
				return(0);
			}
		}

	/*
	fopen("/tmp/debug", "w+");
	fprintf(debu, "hier...\n");
	fclose(debu);
	*/
	
		if (*s)							// The last line 
		{
			if(s[0])
				sprintf(buf2,"%s\n", s);
			else
				sprintf(buf2,"\n");
			if(fputs(buf2,myf)==EOF)
			{
				VMatik_sendstring(d, "Write error...\n");
				fclose(myf);
				return(0);
			}
		}
		fclose(myf);
	}
	else
		VMatik_sendstring(d, "Unable to open destination file...\n");

/*
	VMatik_sendstring(d,"Press any key to continue...");
	i=VMatik_hotkey(d,HOT_CURSOR);
	if (i==0 || i==-1)
		return(0);
*/

	return(1);
}

int arrowright(void)
{
	char buf[50];

	if (xpos==linelen) 
	{
		if (lines == ypos) 
			return(0);
		scrolldown();
		datapos=lineadd;
		xpos=0;
						
		sprintf(buf,"[%d;%dH",spos,xpos+1);
		VMatik_sendstring(d,buf);
		return(0);
	}		
	datapos++;
	xpos++;
	VMatik_sendstring(d,"[C");
	return(0);
}

int arrowleft(void)
{
	if (!xpos && !ypos) 
		return(0);
	if (!xpos) 
	{
		scrollup();
		datapos=&lineadd[strlen(lineadd)];
		xpos=strlen(lineadd);
		if (xpos) 
		{
			char buf[50];
			sprintf(buf,"[%d;%dH",spos,xpos+1);
			VMatik_sendstring(d,buf);
		}
		return(0);
	}

	VMatik_sendstring(d,"[D");
	datapos--;
	xpos--;
	return(0);
}

int help(void)
{
	VMatik_sendstring(d,"[4;0H[J");
	VMatik_sendstring(d,"\n       Enter = new line                   Backspace = delete prev char\n       Del = delete current char          TAB = skip 8 columns\n\nCTRL/Z save and quit       CTRL/Y delete rest of line   CTRL/R redraw screen\nCTRL/A abort message       CTRL/K Kill line             CTRL/T jump to top\nCTRL/B jump to bottom      CTRL/F File attach\n\n                          Press any key to continue\n");
	if (VMatik_hotkey(d,0)==-1)
		return(0);

	VMatik_sendstring(d,"[4;0H[J");
	redraw(0);
	return(1);
}

int newline(void)
{
	char *s, *t;

	if(lines>max_lines)
		return(0);

	s=datapos;
	t=sodobuf;
	while(*s) 
	{
		*t++=*s;
		*s++=0;
	}
	*t=0;
	VMatik_sendstring(d,"[K");
/*
	fopen("/tmp/debug", "w+");
	fprintf(debu, "Newl...\n");
	fclose(debu);
*/
	insertliner(0);

	return(1);
}

/* 
 * returns: 1==DO ABORT, 0==DO NOT
 *
 */
int abortmsg(void)
{
	VMatik_sendstring(d,"[0;44;33m[1;11H- Abort message [Yes]?: ");
	if (VMatik_hotkey(d,HOT_YESNO)!=2) 
		return(1);
	VMatik_sendstring(d,"[0;44;33m[1;11H                              ");
	{
		char buf[50];

		sprintf(buf,"[%d;%dH[0m",spos,xpos+1);
		VMatik_sendstring(d,buf);
	}
	return(0);
}

int jump_to_bottom(void)
{
	lineadd=datapos=&data[lines*max_columns];
	ypos=lines;
	highline=lines+4-slen;
	if (highline < 0) 
		highline=0;

	spos=slen-4-ypos;
	if (spos > 0) 
	{
		spos=ypos+4;
	} else 
		spos=slen;
				
	linelen=strlen(lineadd);
	xpos=0;
			
	VMatik_sendstring(d,"[4;0H[J");
	redraw(0);
	return(1);
}

int previewmsg(void)
{
	int i;
				
	VMatik_sendstring(d,"[2J[H[0;44;35m[0m\n");
	VMatik_sendstring(d,"\n---[Message starts]----------------\n");
				
	for(i=0;i<=lines;i++)
	{
		VMatik_sendstring(d, &data[i*max_columns]);
		VMatik_sendstring(d, "\n");
	}

	VMatik_sendstring(d,"---[Message ends]-----------------\n\n");

	VMatik_sendstring(d,"Press any key to continue...");
	i=VMatik_hotkey(d,HOT_CURSOR);
	if (i==0 || i==-1)
		return(0);
	
	redraw(1);
	return(1);
}

int jump_to_top(void)
{
	datapos=lineadd=data;
	ypos=highline=0;
	spos=4;

	linelen=strlen(lineadd);
	xpos=0;
			
	VMatik_sendstring(d,"[4;0H[J");
	redraw(0);

	return(1);
}

int clearmessage(void)
{
	memset(data,0,max_lines*max_columns);
	lines=xpos=ypos=highline=linelen=0;
	datapos=lineadd=data;
	spos=4;

	return(1);
}

int process(int key)
{
/*
	fopen("/tmp/debug", "w+");
	fprintf(debu, "Key...\n");
	fclose(debu);
*/
	switch(key)
	{
		case 0:							// Probably an error
		case -1:
			return(0);
			break;
		case 1:							// CTRL-A : Abort
			if(abortmsg())
				return(0);
			break;
		case 2:							// CTRL-B : Jump to bottom
			jump_to_bottom();			// BROKEN?!?!
			break;
		case 14:						// CTRL-N : New message
			clearmessage();
			redraw(1);
			break;
		case 16:                		// CTRL-P : Preview
			return(previewmsg());
			break;
		case 20:				// CTRL-T : Jump to top 
			jump_to_top();
			break;
		case 10:				// CTRL-J :
		case 13:				// CTRL-M or Enter : Add new line
	 		newline();
			break;
		case 25:				// CTRL-Y : Delete rest of line
			delete_restofline();
			break;
		case 6:					// CTRL-F : File Attach
			attach();
			break;
		case 24:				// CTRL-X
		case 26:				// CTRL-Z : Save & Quit
			savemessage();
			return(0);
			break;
		case 8:					// CTRL-H or Backspace :
		case 127:				// DEL : Remove one character
			backspace();
			break;
		case 18:				// CTRL-R : Redraw screen
			redraw(1);
			break;
		case 9:					// CTRL-I or Tab : Insert "tab" 
		{
			int i;
			for (i=0;i<8;i++) 
				insertchar(' ');
			break;
		}
		case 11:				// CTRL-K : Kill line
			kill_line();
			break;
		case 21:				// CTRL-U : Help
			return(help());
			break;
		case 250:				// Arrow up
			scrollup();
			break;
		case 251:				// Arrow down
			scrolldown();
			break;
		case 252:				// Arrow right
			arrowright();
			break;
		case 253:				// Arrow left
			arrowleft();
			break;
		default:				// Probably ordinary character
			insertchar(key);
			break;
	}
	return(1);
}

