/*
 * Converts filenames in argv[1] dir to lowercase.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>
#include <unistd.h>
#include <ctype.h>

int strtolower(char *str)
{
	if(!str)
		return(0);

	while(*str)
	{
		*str=tolower(*str);
		str++;
	}

	return(1);
}

int main(int argc, char *argv[])
{
	DIR *dirri;
	struct dirent *guts;
	char dest_buf[PATH_MAX];
	char olddir[PATH_MAX];
	char newname[PATH_MAX];

	if(argc!=2)
	{
		printf("Converts filenames to lowercase in <src>\n\nUsage: %s <src_dir>\n", argv[0]);
		return(0);	
	}
	
	dirri=opendir(argv[1]);
	if(!dirri)
	{
		printf("Unable to open %s\n", argv[1]);
		return(0);
	}

	getcwd(olddir, PATH_MAX);
	chdir(argv[1]);
	
	while((guts=readdir(dirri)))
	{
		if(guts->d_name[0]=='.' && guts->d_name[1]==0)
			continue;
		if(guts->d_name[0]=='.' && guts->d_name[1]=='.' &&
			guts->d_name[2]==0)
			continue;

		strcpy(newname, guts->d_name);
		strtolower(newname);

		if(strcmp(newname, guts->d_name)!=0)
		{
			sprintf(dest_buf, "mv \"%s\" \"%s\"", 
					guts->d_name, newname);
			system(dest_buf);
		}
	}

	closedir(dirri);

	chdir(olddir);

	return(0);
}

	
