/* 
 * Makes a shadow dir, single level
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>
#include <unistd.h>

int main(int argc, char *argv[])
{
	DIR *dirri;
	struct dirent *guts;
	char dest_buf[PATH_MAX];

	if(argc!=3)
	{
		printf("Creates single-level symlinks from all files in <src> to <dst>\n\nUsage: <src_dir> <dest_dir>\n");
		return(0);	
	}

	dirri=opendir(argv[1]);
	if(!dirri)
	{
		printf("Unable to open %s\n", argv[1]);
		return(0);
	}

	while((guts=readdir(dirri)))
	{
		if(guts->d_name[0]=='.' && guts->d_name[1]==0)
			continue;
		if(guts->d_name[0]=='.' && guts->d_name[1]=='.' &&
			guts->d_name[2]==0)
			continue;

		sprintf(dest_buf, "ln -f -s %s/%s %s/%s", 
				argv[1], guts->d_name,argv[2], guts->d_name);
		printf("%s\n",dest_buf);
		system(dest_buf);
	}

	closedir(dirri);

	return(0);
}

	
