/*Copyright (C) 1998 Darren Braun
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *   Any comments or questions can be directed to darren@theboard.dyn.ml.org
 */

/*terminal.c - terminal routines for The Board*/

#include <headers.h>

extern struct user_dat user;
char graphmode = 'A';
int linenum = 1;
struct termios orig_attributes;


int tbc_save_term(void)
{
   tcgetattr(STDIN_FILENO, &orig_attributes);
   return 0;
}


int tbc_reset_term(void)
{
   tcsetattr(STDIN_FILENO, TCSANOW, &orig_attributes);
   return 0;
}


int tbc_setup_term(void)
{
   struct termios term_attrib;
   tcgetattr(STDIN_FILENO, &term_attrib);
   term_attrib.c_lflag &= ~(ICANON|ECHO);
   term_attrib.c_cc[VMIN] = 0;
   term_attrib.c_cc[VTIME] = 10;
   tcsetattr(STDIN_FILENO, TCSANOW, &term_attrib);
   return 0;
}

int tbc_echo(void)
{
   struct termios term_attrib;
   tcgetattr(STDIN_FILENO, &term_attrib);
   
   
   return 0;
}

int tbc_noecho(void)
{
   struct termios term_attrib;
   tcgetattr(STDIN_FILENO, &term_attrib);
   
   
   return 0;
}


int tbc_newline(void)
{
   tbc_checkpl();
   printf("\n");
   linenum++;
   return 0;
}


int tbc_newlines(int num)
{
   int a;
   for(a = 1;a <= num; a++){
      tbc_checkpl();
      printf("\n");
      linenum++;
   }
   return 0;
}


int tbc_checkpl(void)
{
   if(linenum >= user.pagelen){
      tbc_wait();
   }
   return 0;
}


int putcolor(char bg_color, char fg_color)
{
   if(graphmode == 'N'){
      return 1;
   }
   switch(fg_color){
    case 0:
      break;
    case '0':
      printf("%s", cblk);
      break;
    case '1':
      printf("%s", cdblu);
      break;
    case '2':
      printf("%s", cdgrn);
      break;
    case '3':
      printf("%s", cdcyn);
      break;
    case '4':
      printf("%s", cdred);
      break;
    case '5':
      printf("%s", cdprp);
      break;
    case '6':
      printf("%s", cbrn);
      break;
    case '7':
      printf("%s", clgry);
      break;
    case '8':
      printf("%s", cdgry);
      break;
    case '9':
      printf("%s", clblu);
      break;
    case 'A':
      printf("%s", clgrn);
      break;
    case 'B':
      printf("%s", clcyn);
      break;
    case 'C':
      printf("%s", clred);
      break;
    case 'D':
      printf("%s", clprp);
      break;
    case 'E':
      printf("%s", cyel);
      break;
    case 'F':
      printf("%s", cwht);
      break;
    default:
      break;
   }
   switch(bg_color){
    case 0:
      break;
    case '0':
      printf("%s", cbblk);
      break;
    case '1':
      printf("%s", cbblu);
      break;
    case '2':
      printf("%s", cbgrn);
      break;
    case '3':
      printf("%s", cbcyn);
      break;
    case '4':
      printf("%s", cbred);
      break;
    case '5':
      printf("%s", cbprp);
      break;
    case '6':
      printf("%s", cbbrn);
      break;
    case '7':
      printf("%s", cbgry);
      break;
    default:
      break;
   }
   return 0;
}

char *sputcolor(char bg_color, char fg_color)
{
   static char temp[50];
   if(graphmode == 'N'){
      return "";
   }
   switch(fg_color){
    case 0:
      strcpy(temp, "");
      break;
    case '0':
      strcpy(temp, cblk);
      break;
    case '1':
      strcpy(temp, cdblu);
      break;
    case '2':
      strcpy(temp, cdgrn);
      break;
    case '3':
      strcpy(temp, cdcyn);
      break;
    case '4':
      strcpy(temp, cdred);
      break;
    case '5':
      strcpy(temp, cdprp);
      break;
    case '6':
      strcpy(temp, cbrn);
      break;
    case '7':
      strcpy(temp, clgry);
      break;
    case '8':
      strcpy(temp, cdgry);
      break;
    case '9':
      strcpy(temp, clblu);
      break;
    case 'A':
      strcpy(temp, clgrn);
      break;
    case 'B':
      strcpy(temp, clcyn);
      break;
    case 'C':
      strcpy(temp, clred);
      break;
    case 'D':
      strcpy(temp, clprp);
      break;
    case 'E':
      strcpy(temp, cyel);
      break;
    case 'F':
      strcpy(temp, cwht);
      break;
    default:
      strcpy(temp, "");
      break;
   }
   switch(bg_color){
    case 0:
      strcat(temp, "");
      break;
    case '0':
      strcat(temp, cbblk);
      break;
    case '1':
      strcat(temp, cbblu);
      break;
    case '2':
      strcat(temp, cbgrn);
      break;
    case '3':
      strcat(temp, cbcyn);
      break;
    case '4':
      strcat(temp, cbred);
      break;
    case '5':
      strcat(temp, cbprp);
      break;
    case '6':
      strcat(temp, cbbrn);
      break;
    case '7':
      strcat(temp, cbgry);
      break;
    default:
      strcat(temp, "");
      break;
   }
   return temp;
}

int ansipos(int x, int y)
{
   printf("\x1B[%d;%dH", y, x);
   return 0;
}

int clrscr(void)
{
   printf("%s%s", cclr, chome);
   return 0;
}

int scrcolor(char color)
{
   if(graphmode == 'N'){
      return 1;
   }
   switch(color){
    case '0':
      printf("%s", cbblk);
      break;
    case '1':
      printf("%s", cbblu);
      break;
    case '2':
      printf("%s", cbgrn);
      break;
    case '3':
      printf("%s", cbcyn);
      break;
    case '4':
      printf("%s", cbred);
      break;
    case '5':
      printf("%s", cbprp);
      break;
    case '6':
      printf("%s", cbbrn);
      break;
    case '7':
      printf("%s", cbgry);
      break;
    default:
      printf("%s", cbblk);
      break;
   }
   clrscr();
   return 0;
}

int line_fill(int color)
{
   putcolor(color,0);
   printf("%80s", " ");
   return 0;
}


int tb_banner(int x, int y)
{
   box_3d(x, y, 60, 5, 1, 0);
   return 0;
}

int get_input(char *buf, int length, int num, int letter, int space, int dot, int format)
{
   int quit = 0, a = 0;
   char temp, temp2;
   if(dot == 1){
      temp2 = '.';
   }
   while(!quit){
      if(buf[a] == '\0'){
	 quit = 1;
	 continue;
      }
      if(dot == 0){
	 printf("%c", buf[a]);
      }
      else{
	 printf("%c", '.');
      }
      a++;
   }
   quit = 0;
   while(!quit){
      if(format == 1){
	 if(a == 5){
	    printf("-");
	    buf[a] = '-';
	    a++;
	 }
      }
      if(format == 2){
	 if(a == 0){
	    printf("(");
	    buf[a] = '(';
	    a++;
	 }
	 else if(a == 4){
	    printf(")");
	    buf[a] = ')';
	    a++;
	    printf(" ");
	    buf[a] = ' ';
	    a++;
	 }
	 else if(a == 9){
	    printf("-");
	    buf[a] = '-';
	    a++;
	 }
      }
      temp = getchar();
      if(dot == 0){
	 temp2 = temp;
      }
      if(temp == '\n'){
	 quit = 1;
	 continue;
      }
      if(temp == ''){
	 if(a > 0){
	    if(format){
	       switch(format){
		case 1:
		  if(a == 6){
		     printf("\b\b \b");
		     a = a - 2;
		     continue;
		  }
		  else{
		     printf("\b \b");
		     a--;
		     continue;
		  }
		  break;
		case 2:
		  if(a == 5){
		     printf("\b\b \b");
		     a = a - 2;
		     continue;
		  }
		  else if(a == 10){
		     printf("\b\b \b");
		     a = a - 2;
		     continue;
		  }
		  else{
		     printf("\b \b");
		     a--;
		     continue;
		  }
		  break;
		default:
		  break;
	       }
	    }
	    printf("\b \b");
	    a--;
	    continue;
	 }
      }
      if(a >= length){
	 continue;
      }
      if(isalpha(temp) && letter == 1){
	 buf[a] = temp;
	 a++;
	 printf("%c",temp2);
	 continue;
      }
      if(isdigit(temp) && num == 1){
	 buf[a] = temp;
	 a++;
	 printf("%c",temp2);
	 continue;
      }
      if(isspace(temp) && space == 1){
	 buf[a] = temp;
	 a++;
	 printf("%c",temp2);
	 continue;
      }
      if(isprint(temp) && space == 1 && num == 1 && letter == 1){
	 buf[a] = temp;
	 a++;
	 printf("%c",temp2);
	 continue;
      }
   }
   buf[a] = '\0';
   return 0;
}


int toggle_graph(void)
{
   if(graphmode == 'A'){
      graphmode = 'N';
   }
   else if(graphmode == 'N'){
      graphmode = 'A';
   }
   return 0;
}


