/*Copyright (C) 1998 Darren Braun
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *   Any comments or questions can be directed to darren@theboard.dyn.ml.org
 */

/*menu.c - The Board's Menu Shell*/

#include<headers.h>
#include<menu.h>

extern char tb_logon[10][80];
extern char logs[10][80];
extern int displogon_max;
extern char temp_buf[4096];
extern char graphmode;
extern int to_int_return;
extern struct tm *cur_time;
extern time_t cur_rawtime;
extern time_t logon_time;
extern int orig_timeon;
extern struct user_dat user;
extern struct user_stat user2;
extern struct user_dat alt_user;
extern struct user_stat alt_user2;
extern struct user_index user3;
extern int linenum;
extern int time_limit[1002];
extern struct tb_dat dat_main;

int menu_num = 0;
int menu_hist[50];
int menu_max = 1;
int menup_max = 0;
int command_max = 0;
int box_max = 0;
int menu_prv = 0;
char menu_disp[80];
char menu_name[40];
int menu_box_ypos = 1, menu_box_xpos = 1, menu_box_xlen = 10, menu_box_ylen = 5, menu_box_color = 1;
char menus[200][80];
char menusp[200][80];
key_t k_who;
key_t k_ask;
key_t k_yn;
key_t k_chat;
key_t k_page;
int qid_who;
int qid_ask;
int qid_yn;
int qid_chat;
int qid_page;
int qid_channel;
int l_who;
int l_ask;
int l_yn;
int l_chat;
int l_page;
int l_channel;
struct msg_yn s_yn;
struct msg_ask s_ask;
struct msg_who s_who;
struct msg_chat s_chat;
struct msg_page s_page;
struct msg_channel s_channel;
int Node;
struct tb_menu menu_choice[40];
struct tb_box boxes[20];
struct dirent *cur_file_ent;
struct dirent *default_file_ent;
struct stat *cur_file_stat;
int chk_pl = 1;



int main(void)
{
   int end;
   signal(SIGTERM,tbc_shutdown);
   signal(SIGHUP,tbc_shutdown);
   /*system("setterm -term linux");*/
   tbc_save_term();
   tbc_setup_term();
   clrscr();
   /*Read theboard.dat*/
   read_vars();
   /*Read .tbsetup*/
   read_usetup();
   /*Check for default files*/
   check_files();
   /*Read menu list*/
   read_menu_list();
   /*Read .tbstat*/
   read_ustats();
   /*Check last on and time left*/
   update_time();
   logon_time = cur_rawtime;
   end = get_daynum();
   if(!strcmp("guest",user.login)){
      user2.last_on = end;
      user2.time_on = 0;
      orig_timeon = 0;
   }
   if(end != user2.last_on){
      user2.last_on = end;
      user2.time_on = 0;
      orig_timeon = 0;
   }
   user2.last_on = end;
   user2.time_on = 0;
   orig_timeon = 0;
   end = 120;
   if(end <= 0){
      disp_prompt(3);
      tbc_cleanup();
      return 0;
   }
   else{
      orig_timeon = 120;
      disp_prompt(4);
      tbc_newline();
   }
   /*Connect to tbserver*/
   connect_tbserver();
   /*Check for New Mail*/
   check_my_mail();
   /*Read Main Menu Data File*/
   if(!strcmp("guest",user.login)){
      read_menu(10);
   }
   else{
      read_menu(1);
   }
   /*Start Loop*/
   start_menu();
   /*Disconnect tbserver*/
   tbc_cleanup();
   return 0;
}


void tbc_shutdown(int sig){
   if(sig == SIGTERM || sig == SIGHUP){
      tbc_cleanup();
      exit(1);
   }
}


int tbc_cleanup(void){
   disconnect_tbserver();
   printf("%s", cnrm);
   tbc_reset_term();
   return 0;
}



int connect_tbserver(void)
{
   int a = 0, quit = 0, end = 0;
   char node_name[30], temp[100], node_str[4];
   time_t cur_time;
   k_yn = ftok(dat_main.root, 'a');
   k_ask = ftok(dat_main.root, 'b');
   k_who = ftok(dat_main.root, 'c');
   k_chat = ftok(dat_main.root, 'd');
   qid_yn = msgget(k_yn, 0);
   qid_ask = msgget(k_ask, 0);
   qid_who = msgget(k_who, 0);
   qid_chat = msgget(k_chat, 0);
   l_yn = (sizeof(s_yn) - sizeof(long));
   l_ask = (sizeof(s_ask) - sizeof(long));
   l_who = (sizeof(s_who) - sizeof(long));
   l_chat = (sizeof(s_chat) - sizeof(long));
   strcpy(node_name,ttyname(1));
   switch(node_name[8]){
    case 'S':
      switch(node_name[9]){
       case '1':
	 Node = 1;
	 strcpy(node_str, "1");
	 break;
       case '2':
	 strcpy(node_str, "2");
	 Node = 2;
	 break;
       case '3':
	 strcpy(node_str, "3");
	 Node = 3;
	 break;
       default:
	 return -1;
	 break;
      }
      break;
    case '1':
      strcpy(node_str, "4");
      Node = 4;
      break;
    case '2':
      strcpy(node_str, "5");
      Node = 5;
      break;
    case '3':
      strcpy(node_str, "6");
      Node = 6;
      break;
    case '4':
      strcpy(node_str, "7");
      Node = 7;
      break;
    case '5':
      strcpy(node_str, "8");
      Node = 8;
      break;
    case '6':
      strcpy(node_str, "9");
      Node = 9;
      break;
    case '7':
      strcpy(node_str, "10");
      Node = 10;
      break;
    case '8':
      strcpy(node_str, "11");
      Node = 11;
      break;
    case 'p':
      switch(node_name[9]){
       case '0':
         strcpy(node_str, "12");
	 Node = 12;
	 break;
       case '1':
         strcpy(node_str, "13");
	 Node = 13;
	 break;
       case '2':
         strcpy(node_str, "14");
	 Node = 14;
	 break;
       case '3':
         strcpy(node_str, "15");
	 Node = 15;
	 break;
       case '4':
         strcpy(node_str, "16");
	 Node = 16;
	 break;
       case '5':
         strcpy(node_str, "17");
	 Node = 17;
	 break;
       case '6':
         strcpy(node_str, "18");
	 Node = 18;
	 break;
       case '7':
         strcpy(node_str, "19");
	 Node = 19;
	 break;
       case '8':
         strcpy(node_str, "20");
	 Node = 20;
	 break;
       case '9':
         strcpy(node_str, "21");
	 Node = 21;
	 break;
       default:
	 return -1;
	 break;
      }
      break;
    default:
      return -1;
      break;
   }
   s_ask.mtype = Node;
   s_ask.req = 4;
   strcpy(s_ask.name, user.login);
   msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
   msgrcv(qid_yn, (struct msgbuf *)&s_yn, l_yn, Node, 0);
   if(s_yn.yn == 1){
      tbc_cleanup();
      exit(1);
   }
   s_ask.mtype = Node;
   s_ask.req = 2;
   strcpy(s_ask.name, user.login);
   strcpy(s_ask.activity, "Logging into System");
   msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
   strcpy(temp, user.login);
   strcat(temp, " just logged in\n");
   s_ask.req = 5;
   strcpy(s_ask.message, temp);
   msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
   time(&cur_time);
   strcpy(temp, user.login);
   strcat(temp, " just logged in on ");
   strcat(temp, ttyname(1));
   strcat(temp, " at ");
   strcat(temp, ctime(&cur_time));
   temp[strlen(temp) - 1] = '\0';
   log_message(temp,2);
   disp_prompt(1);
   tbc_newlines(2);
   tbc_wait();
   for(a = 0;a < displogon_max;a++){
      tbc_dispfile(tb_logon[a]);
      tbc_newline();
      tbc_wait();
   }
   user2.total_calls++;
   quit = 0;
   while(!quit){
      end = msgrcv(qid_chat, (struct msgbuf *)&s_chat, l_chat, Node, IPC_NOWAIT);
      if(end == -1){
	 quit = 1;
      }
   }
   quit = 0;
   while(!quit){
      end = msgrcv(qid_page, (struct msgbuf *)&s_page, l_page, Node, IPC_NOWAIT);
      if(end == -1){
	 quit = 1;
      }
   }
   return 0;
}


int disconnect_tbserver(void)
{
   char temp[100];
   time_t cur_time;
   k_yn = ftok(dat_main.root, 'a');
   k_ask = ftok(dat_main.root, 'b');
   k_who = ftok(dat_main.root, 'c');
   k_chat = ftok(dat_main.root, 'd');
   qid_yn = msgget(k_yn, 0);
   qid_ask = msgget(k_ask, 0);
   qid_who = msgget(k_who, 0);
   qid_chat = msgget(k_chat, 0);
   l_yn = (sizeof(s_yn) - sizeof(long));
   l_ask = (sizeof(s_ask) - sizeof(long));
   l_who = (sizeof(s_who) - sizeof(long));
   l_chat = (sizeof(s_chat) - sizeof(long));
   s_ask.mtype = Node;
   s_ask.req = 3;
   msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
   disp_prompt(2);
   strcpy(temp, user.login);
   strcat(temp, " just logged out\n");
   s_ask.req = 5;
   strcpy(s_ask.message, temp);
   msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
   time(&cur_time);
   strcpy(temp, user.login);
   strcat(temp, " just logged out on ");
   strcat(temp, ttyname(1));
   strcat(temp, " at ");
   strcat(temp, ctime(&cur_time));
   temp[strlen(temp) - 1] = '\0';
   log_message(temp,2);
   return 0;
}


int check_files(void)
{
   int quit = 0, quitb = 0, a = 0, match = 0;
   char temp, temp2[100], temp3[100];
   DIR *default_dir, *user_dir;
   
   strcpy(temp3, dat_main.root);
   strcat(temp3, "/default/");
   default_dir = opendir(temp3);
   while(default_file_ent = readdir(default_dir)){
      if(!(strcmp(default_file_ent->d_name, ".")) || !(strcmp(default_file_ent->d_name, "."))){
	 continue;
      }
      strcpy(temp3, dat_main.root);
      strcat(temp3, "/default/");
      strcat(temp3, default_file_ent->d_name);
      match = 0;
      user_dir = opendir(user.homedir);
      while(cur_file_ent = readdir(user_dir)){
	 if(!(strcmp(cur_file_ent->d_name, default_file_ent->d_name))){
	    match = 1;
	 }
      }
      closedir(user_dir);
      if(!match){
	 strcpy(temp2, user.homedir);
	 strcat(temp2, default_file_ent->d_name);
	 copy_file(temp2,temp3);
      }
      
   }
   closedir(default_dir);
   return 0;
}


int start_menu(void)
{
   int menu_ypos[20], quit = 0, quitb = 0, a = 0, b = 0, c = 0, end, display1 = 1, display2 = 1, timechk = 0, warned = 0, warned2 = 0;
   char temp, cmd[41], bg;
   k_yn = ftok(dat_main.root, 'a');
   k_ask = ftok(dat_main.root, 'b');
   k_who = ftok(dat_main.root, 'c');
   k_chat = ftok(dat_main.root, 'd');
   qid_yn = msgget(k_yn, 0);
   qid_ask = msgget(k_ask, 0);
   qid_who = msgget(k_who, 0);
   qid_chat = msgget(k_chat, 0);
   l_yn = (sizeof(s_yn) - sizeof(long));
   l_ask = (sizeof(s_ask) - sizeof(long));
   l_who = (sizeof(s_who) - sizeof(long));
   l_chat = (sizeof(s_chat) - sizeof(long));
   s_ask.mtype = Node;
   s_ask.req = 6;
   strcpy(s_ask.name, user.login);
   strcpy(s_ask.activity, "At Menu Prompt");
   msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
   while(!quit){
      if(display1){
	 chk_pl = 0;
	 printf("%s", cnrm);
	 tbc_dispfile(menu_disp);
	 for(c = 1;c <= 19;c++){
	    menu_ypos[c] = 0;
	 }
	 for(c = 1;c <= box_max;c++){
	    box_3d(boxes[c].xpos,boxes[c].ypos,boxes[c].xlen,boxes[c].ylen,boxes[c].color,1);
	 }
	 b = 0;
	 for(b = 0;b < command_max - 1;b++){
	    to_int(menu_choice[b].sec);
	    if(to_int_return > user2.sec){
	       continue;
	    }
	    to_int(menu_choice[b].menu);
	    menu_ypos[to_int_return]++;
	    ansipos(boxes[to_int_return].xpos + 2,boxes[to_int_return].ypos + menu_ypos[to_int_return]);
	    switch(boxes[to_int_return].color){
	     case 0:
	       bg = '0';
	       break;
	     case 1:
	       bg = '1';
	       break;
	     case 2:
	       bg = '2';
	       break;
	     case 3:
	       bg = '3';
	       break;
	     case 4:
	       bg = '4';
	       break;
	     case 5:
	       bg = '5';
	       break;
	     case 6:
	       bg = '6';
	       break;
	     case 7:
	       bg = '7';
	       break;
	     default:
	       bg = 0;
	       break;
	    }
	    if(menu_choice[b].type != ' '){
	       putcolor(bg,menu_choice[b].color);
	       printf("(");
	       putcolor(bg,'E');
	       printf("%s",menu_choice[b].command);
	       putcolor(bg,menu_choice[b].color);
	       printf(")");
	    }
	    putcolor(bg,menu_choice[b].color);
	    printf("%s", menu_choice[b].display);
	 }
	 ansipos(1,23);
	 chk_pl = 1;
	 display1 = 0;
      }
      if(display2){
	 disp_prompt(50);
	 printf("%s",cmd);
	 display2 = 0;
      }
      update_timeon();
      timechk = check_timeleft();
      if(timechk == 5 && warned == 0){
	 disp_prompt(7);
	 tbc_newline();
	 warned = 1;
      }
      else if(timechk == 1 && warned2 == 0){
	 disp_prompt(7);
	 tbc_newline();
	 warned2 = 1;
      }
      else if(!timechk){
	 disp_prompt(8);
	 tbc_newline();
	 return 0;
      }
      temp = tolower(getchar());
      if(temp != EOF){
	 linenum = 1;
	 if(temp == ''){
	    if(a >= 1){
	       printf("\b \b");
	       a--;
	    }
	 }
	 else if(temp == '\n'){
	    cmd[a] = '\0';
	    tbc_newline();
	    end = tbc_docmd(cmd);
	    strcpy(cmd, "");
	    switch(end){
	     case 0:
	       break;
	     case 1:
	       display1 = 1;
	       break;
	     case 2:
	       display2 = 1;
	       break;
	     case 3:
	       display1 = 1;
	       display2 = 1;
	       break;
	     case 4:
	       quit = 1;
	       break;
	     default:
	       display2 = 1;
	       break;
	    }
	    a = 0;
	 }
	 else if(a < 40){
	    cmd[a] = temp;
	    printf("%c",temp);
	    a++;
	 }
      }
      else{
	 if(check_messages()){
	    display2 = 1;
	 }
      }
   }
   
   
   return 0;
}


int tbc_chat(int node_num)
{
   int menu_ypos[20], quit = 0, quitb = 0, a = 0, b = 0, c = 0, end, display1 = 1, display2 = 1, timechk = 0, warned = 0, warned2 = 0, choice = 0;
   int line1 = 1, line2 = 1;
   char temp, cmd[80], bg;
   strcpy(cmd, "");
   while(!quit){
      if(display1){
	 printf("%s",cnrm);
	 clrscr();
	 box_3d(1,1,79,23,1,1);
	 box_3d(2,2,77,9,1,1);
	 box_3d(2,11,77,9,1,1);
	 box_3d(2,20,77,3,1,1);
	 display2 = 1;
	 display1 = 0;
      }
      if(display2){
	 ansipos(3,21);
	 putcolor('1','F');
	 printf("%.75s",cmd);
	 ansipos(3 + strlen(cmd),21);
	 display2 = 0;
      }
      end = msgrcv(qid_channel, (struct msgbuf *)&s_channel, l_channel, Node, IPC_NOWAIT);
      if(end != -1){
	 if(!(strcmp(s_channel.message, "-quit"))){
	    quit = 2;
	    continue;
	 }
	 if(line2 >= 8){
	    for(b = 1;b < 8;b++){
	       ansipos(3, 11 + b);
	       printf("%75s", " ");
	    }
	    line2 = 1;
	 }
	 ansipos(3,11 + line2);
	 printf("%s", s_channel.message);
	 line2++;
	 display2 = 1;
	 continue;
      }
      temp = getchar();
      if(temp != EOF){
	 linenum = 1;
	 if(temp == ''){
	    if(a >= 1){
	       printf("\b \b");
	       a--;
	    }
	 }
	 else if(temp == '\n'){
	    cmd[a] = '\0';
	    a = 0;
	    ansipos(3,21);
	    putcolor('1','F');
	    printf("%75s"," ");
	    ansipos(3,21);
	    display2 = 1;
	    if(cmd[0] == '-'){
	       if(!(strcmp(cmd, "-quit"))){
		  quit = 1;
		  continue;
	       }
	    }
	    else{
	       if(line1 >= 8){
		  for(b = 1;b < 8;b++){
		     ansipos(3, 2 + b);
		     printf("%75s", " ");
		  }
		  line1 = 1;
	       }
	       ansipos(3,2+line1);
	       printf("%s", cmd);
	       s_channel.mtype = node_num;
	       s_channel.node = Node;
	       strcpy(s_channel.message, cmd);
	       msgsnd(qid_channel, (struct msgbuf *)&s_channel, l_channel, 0);
	       cmd[a] = '\0';
	       line1++;
	    }
	    cmd[a] = '\0';
	 }
	 else if(a < 75){
	    cmd[a] = temp;
	    cmd[a+1] = '\0';
	    printf("%c",temp);
	    a++;
	 }
      }
   }
   
   if(quit = 1){
      return 1;
   }
   
   
   return 0;
}



int check_my_mail(void)
{
   disp_prompt(10);
   tbc_newline();
   disp_prompt(11);
   tbc_newlines(2);
   tbc_wait();
   putcolor(0,'B');
   tbc_newline();
   system("/usr/games/fortune");
   tbc_newline();
   tbc_wait();
   return 0;
}


int read_menu(int num)
{
   FILE *fp_menu;
   int quit = 0, quitb = 0, quitc = 0, end = 0, a = 0, b = 0, c = 0, line = 0;
   c = 1;
   quit = 0;
   box_max = 0;
   if(menu_prv){
      if(num > menup_max){
	 return -1;
      }
      fp_menu = fopen(menusp[num], "r");
   }
   else{
      if(num > menu_max){
	 return -1;
      }
      fp_menu = fopen(menus[num], "r");
   }
   while(!quitc){
      end = tbc_readline(fp_menu,c,2);
      if(end == -1){
	 quitc = 1;
	 continue;
      }
      c++;
      if(temp_buf[0] == '['){
	 if(!(strcmp(temp_buf, "[MENU1]"))){
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[1].xpos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[1].ypos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[1].xlen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[1].ylen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[1].color = to_int_return;
	    c++;
	    box_max = 1;
	 }
	 else if(!(strcmp(temp_buf, "[MENU2]"))){
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[2].xpos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[2].ypos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[2].xlen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[2].ylen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[2].color = to_int_return;
	    c++;
	    box_max = 2;
	 }
	 else if(!(strcmp(temp_buf, "[MENU3]"))){
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[3].xpos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[3].ypos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[3].xlen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[3].ylen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[3].color = to_int_return;
	    c++;
	    box_max = 3;
	 }
	 else if(!(strcmp(temp_buf, "[MENU4]"))){
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[4].xpos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[4].ypos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[4].xlen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[4].ylen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[4].color = to_int_return;
	    c++;
	    box_max = 4;
	 }
	 else if(!(strcmp(temp_buf, "[MENU5]"))){
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[5].xpos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[5].ypos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[5].xlen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[5].ylen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[5].color = to_int_return;
	    c++;
	    box_max = 5;
	 }
	 else if(!(strcmp(temp_buf, "[MENU6]"))){
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[6].xpos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[6].ypos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[6].xlen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[6].ylen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[6].color = to_int_return;
	    c++;
	    box_max = 6;
	 }
	 else if(!(strcmp(temp_buf, "[MENU7]"))){
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[7].xpos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[7].ypos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[7].xlen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[7].ylen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[7].color = to_int_return;
	    c++;
	    box_max = 7;
	 }
	 else if(!(strcmp(temp_buf, "[MENU8]"))){
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[8].xpos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[8].ypos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[8].xlen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[8].ylen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[8].color = to_int_return;
	    c++;
	    box_max = 8;
	 }
	 else if(!(strcmp(temp_buf, "[MENU9]"))){
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[9].xpos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[9].ypos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[9].xlen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[9].ylen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[9].color = to_int_return;
	    c++;
	    box_max = 9;
	 }
	 else if(!(strcmp(temp_buf, "[MENU10]"))){
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[10].xpos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[10].ypos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[10].xlen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[10].ylen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[10].color = to_int_return;
	    c++;
	    box_max = 10;
	 }
	 else if(!(strcmp(temp_buf, "[MENU11]"))){
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[11].xpos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[11].ypos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[11].xlen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[11].ylen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[11].color = to_int_return;
	    c++;
	    box_max = 11;
	 }
	 else if(!(strcmp(temp_buf, "[MENU12]"))){
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[12].xpos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[12].ypos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[12].xlen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[12].ylen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[12].color = to_int_return;
	    c++;
	    box_max = 12;
	 }
	 else if(!(strcmp(temp_buf, "[MENU13]"))){
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[13].xpos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[13].ypos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[13].xlen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[13].ylen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[13].color = to_int_return;
	    c++;
	    box_max = 13;
	 }
	 else if(!(strcmp(temp_buf, "[MENU14]"))){
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[14].xpos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[14].ypos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[14].xlen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[14].ylen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[14].color = to_int_return;
	    c++;
	    box_max = 14;
	 }
	 else if(!(strcmp(temp_buf, "[MENU15]"))){
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[15].xpos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[15].ypos = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[15].xlen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[15].ylen = to_int_return;
	    c++;
	    tbc_readline(fp_menu,c,2);
	    to_int(temp_buf);
	    boxes[15].color = to_int_return;
	    c++;
	    box_max = 15;
	 }
	 else if(!(strcmp(temp_buf, "[MISC]"))){
	    tbc_readline(fp_menu,c,2);
	    strcpy(menu_name, temp_buf);
	    c++;
	    tbc_readline(fp_menu,c,2);
	    strcpy(menu_disp, temp_buf);
	    c++;
	    
	 }
	 else if(!(strcmp(temp_buf, "[COMMANDS]"))){
	    
	    quit = 0;
	    line = c;
	    command_max = 0;
	    while(!quit){
	       end = tbc_readline(fp_menu,line,2);
	       if(end == -1){
		  quit = 1;
		  continue;
	       }
	       if(temp_buf[0] == '\0' || temp_buf[0] == '#' || temp_buf[0] == ' ' || temp_buf[0] == '\n' ){
		  line++;
		  continue;
	       }
	       quitb = 0;
	       a = 0;
	       b = 0;
	       while(!quitb){
		  if(temp_buf[b] == ':'){
		     menu_choice[line - c].command[a] = '\0'; 
		     quitb = 1;
		     b++;
		     continue;
		  }
		  else{
		     menu_choice[line - c].command[a] = temp_buf[b];
		     a++;
		     b++;
		  }
		  if(a >=18){
		     menu_choice[line - c].command[a] = '\0';
		     quitb = 1;
		     continue;
		  }
		  
	       }
	       quitb = 0;
	       a = 0;
	       while(!quitb){
		  if(temp_buf[b] == ':'){
		     menu_choice[line - c].display[a] = '\0'; 
		     quitb = 1;
		     b++;
		     continue;
		  }
		  else{
		     menu_choice[line - c].display[a] = temp_buf[b];
		     a++;
		     b++;
		  }
		  if(a >=78){
		     menu_choice[line - c].display[a] = '\0';
		     quitb = 1;
		     continue;
		  }
		  
	       }
	       menu_choice[line - c].type = temp_buf[b];
	       b = b + 2;
	       menu_choice[line - c].color = temp_buf[b];
	       b = b + 2;
	       quitb = 0;
	       a = 0;
	       while(!quitb){
		  if(temp_buf[b] == ':'){
		     menu_choice[line - c].menu[a] = '\0'; 
		     quitb = 1;
		     b++;
		     continue;
		  }
		  else{
		     menu_choice[line - c].menu[a] = temp_buf[b];
		     a++;
		     b++;
		  }
		  if(a >= 4){
		     menu_choice[line - c].menu[a] = '\0';
		     quitb = 1;
		     continue;
		  }
		  
	       }
	       quitb = 0;
	       a = 0;
	       while(!quitb){
		  if(temp_buf[b] == ':' || temp_buf[b] == '\0' || temp_buf[b] == '\n'){
		     menu_choice[line - c].sec[a] = '\0'; 
		     quitb = 1;
		     b++;
		     continue;
		  }
		  else{
		     menu_choice[line - c].sec[a] = temp_buf[b];
		     a++;
		     b++;
		  }
		  if(a >=78){
		     menu_choice[line - c].sec[a] = '\0';
		     quitb = 1;
		     continue;
		  }
		  
	       }
	       quitb = 0;
	       a = 0;
	       while(!quitb){
		  if(temp_buf[b] == ':' || temp_buf[b] == '\0' || temp_buf[b] == '\n'){
		     menu_choice[line - c].action[a] = '\0'; 
		     quitb = 1;
		     b++;
		     continue;
		  }
		  else{
		     menu_choice[line - c].action[a] = temp_buf[b];
		     a++;
		     b++;
		  }
		  if(a >=78){
		     menu_choice[line - c].action[a] = '\0';
		     quitb = 1;
		     continue;
		  }
		  
	       }
	       command_max++;
	       line++;
	    }
	    c = line;
	    
	 }
	 
      }
   }
   fclose(fp_menu);
   return 0;
}

int tbc_docmd(char cmd[])
{
   int quit = 0, a = 0, match = -1, choice = 0;
   time_t cur_time;
   char cmd_line[30], temp[512], temp2[512], temp3[512], site[100], port[10];
   k_yn = ftok(dat_main.root, 'a');
   k_ask = ftok(dat_main.root, 'b');
   k_who = ftok(dat_main.root, 'c');
   k_chat = ftok(dat_main.root, 'd');
   k_page = ftok(dat_main.root, 'e');
   qid_yn = msgget(k_yn, 0);
   qid_ask = msgget(k_ask, 0);
   qid_who = msgget(k_who, 0);
   qid_chat = msgget(k_chat, 0);
   qid_page = msgget(k_page, 0);
   l_yn = (sizeof(s_yn) - sizeof(long));
   l_ask = (sizeof(s_ask) - sizeof(long));
   l_who = (sizeof(s_who) - sizeof(long));
   l_chat = (sizeof(s_chat) - sizeof(long));
   l_page = (sizeof(s_page) - sizeof(long));
   l_channel = (sizeof(s_channel) - sizeof(long));
   if(cmd[0] == '\0'){
      return 2;
   }
   if(!(strcmp("who",cmd))){
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "Spying on Nodes");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      tbc_who();
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "At Menu Prompt");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      return 3;
   }
   /*if(!(strcmp("setup",cmd))){
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "User Settings");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      tbc_settings();
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "At Menu Prompt");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      return 3;
   }*/
   if(!(strcmp("m",cmd))){
      toggle_graph();
      return 3;
   }
   if(!(strcmp("menu",cmd))){
      return 3;
   }
   if(!(strcmp("help",cmd))||!(strcmp("?",cmd))){
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "Using the Help System");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      strcpy(temp3, "/usr/bin/lynx ");
      strcat(temp3, dat_main.root);
      strcat(temp3, "/help/index.html");
      system(temp3);
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "At Menu Prompt");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      return 3;
   }
   if(!(strcmp("page",cmd))){
      s_ask.mtype = Node;
      s_ask.req = 7;
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      msgrcv(qid_yn, (struct msgbuf *)&s_yn, l_yn, Node, 0);
      if(s_yn.yn){
	 tbc_newline();
	 disp_prompt(25);
	 time(&cur_time);
	 strcpy(temp, user.login);
	 strcat(temp, " paged the sysop from ");
	 strcat(temp, ttyname(1));
	 strcat(temp, " at ");
	 strcat(temp, ctime(&cur_time));
	 temp[strlen(temp) - 1] = '\0';
	 log_message(temp,4);
	 s_page.mtype = 1000;
	 s_page.node = Node;
	 msgsnd(qid_page, (struct msgbuf *)&s_page, l_page, 0);
	 msgrcv(qid_page, (struct msgbuf *)&s_page, l_page, Node, 0);
	 if(s_page.channel == 1000){
	    qid_channel = msgget(s_page.channel_key, 0);
	    tbc_chat(1000);
	    s_channel.mtype = 1000;
	    s_channel.node = Node;
	    strcpy(s_channel.message, "-quit");
	    msgsnd(qid_channel, (struct msgbuf *)&s_channel, l_channel, 0);
	    return 3;
	 }
	 else if(s_page.channel == -1){
	    tbc_newline();
	    tbc_newline();
	    disp_prompt(27);
	    tbc_newline();
	    tbc_newline();
	    return 2;
	 }
	 else{
	    tbc_newline();
	    tbc_newline();
	    disp_prompt(26);
	    tbc_newline();
	    tbc_newline();
	    return 2;
	 }
      }
      else{
	 tbc_newline();
	 tbc_newline();
	 disp_prompt(28);
	 tbc_newline();
	 tbc_newline();
	 return 2;
      }
      return 3;
   }
   if(!(strcmp("g",cmd))){
      tbc_newline();
      disp_prompt(100);
      choice = tbc_getyn();
      tbc_newline();
      if(choice){
	 return 4;
      }
      else{
	 return 3;
      }
   }
   if(!(strcmp("bye",cmd))){
      return 4;
   }
   if(!(strcmp("yell",cmd)) || !(strcmp("shout",cmd))){
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "Shouting Something");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      strcpy(temp2, "");
      disp_prompt(90);
      tbc_newline();
      get_input(temp2,450,1,1,1,0,0);
      strcpy(temp, sputcolor(0,'E'));
      strcat(temp, user.login);
      strcat(temp, " just shouted\n    ");
      strcat(temp, sputcolor(0,'B'));
      strcat(temp, temp2);
      strcat(temp, "\n");
      k_ask = ftok(dat_main.root, 'b');
      k_chat = ftok(dat_main.root, 'd');
      qid_ask = msgget(k_ask, 0);
      qid_chat = msgget(k_chat, 0);
      l_ask = (sizeof(s_ask) - sizeof(long));
      l_chat = (sizeof(s_chat) - sizeof(long));
      s_ask.mtype = Node;
      s_ask.req = 5;
      strcpy(s_ask.message, temp);
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      tbc_newline();
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "At Menu Prompt");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      return 2;
   }
   for(a = 0;a < command_max - 1;a++){
      if(!(strcasecmp(menu_choice[a].command, cmd))){
	 match = a;
	 a = command_max;
	 continue;
      }
   }
   if(match == -1){
      disp_prompt(60);
      tbc_newline();
      return 2;
   }
   else{
      to_int(menu_choice[match].sec);
      if(to_int_return > user2.sec){
	 disp_prompt(61);
	 tbc_newline();
	 return 2;
      }
   }
   switch(menu_choice[match].type){
    case '1':
      return 3;
      break;
    case '2':
      return 3;
      break;
    case 'F':
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "Using a Forum");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      strcpy(cmd_line, dat_main.bin);
      strcat(cmd_line, "/tbforum ");
      strcat(cmd_line, menu_choice[match].action);
      system(cmd_line);
      tbc_setup_term();
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "At Menu Prompt");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      return 3;
      break;
    case 'H':
      break;
    case 'M':
      menu_prv = 0;
      to_int(menu_choice[match].action);
      read_menu(to_int_return);
      return 3;
      break;
    case 'N':
      return 2;
      break;
    case 'S':
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "Using an External Program");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      time(&cur_time);
      strcpy(temp, user.login);
      strcat(temp, " just executed ");
      strcat(temp, menu_choice[match].action);
      strcat(temp, " at      ");
      strcat(temp, ctime(&cur_time));
      temp[strlen(temp) - 1] = '\0';
      log_message(temp,4);
      system(menu_choice[match].action);
      tbc_setup_term();
      time(&cur_time);
      strcpy(temp, user.login);
      strcat(temp, " just returned from ");
      strcat(temp, menu_choice[match].action);
      strcat(temp, " at ");
      strcat(temp, ctime(&cur_time));
      temp[strlen(temp) - 1] = '\0';
      log_message(temp,4);
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "At Menu Prompt");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      return 3;
      break;
    case 'T':
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "Using Telnet");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      strcpy(site,"");
      strcpy(port,"");
      clrscr();
      disp_prompt(80);
      get_input(site,60,1,1,1,0,0);
      tbc_newline();
      disp_prompt(81);
      get_input(port,8,1,0,0,0,0);
      tbc_newline();
      strcpy(temp2,"telnet ");
      strcat(temp2, site);
      strcat(temp2, " ");
      strcat(temp2, port);
      time(&cur_time);
      strcpy(temp, user.login);
      strcat(temp, " just executed ");
      strcat(temp, temp2);
      strcat(temp, " at      ");
      strcat(temp, ctime(&cur_time));
      temp[strlen(temp) - 1] = '\0';
      log_message(temp,4);
      system(temp2);
      tbc_setup_term();
      time(&cur_time);
      strcpy(temp, user.login);
      strcat(temp, " just returned from ");
      strcat(temp, menu_choice[match].action);
      strcat(temp, " at ");
      strcat(temp, ctime(&cur_time));
      temp[strlen(temp) - 1] = '\0';
      log_message(temp,4);
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "At Menu Prompt");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      return 3;
      break;
    case 'U':
      tbc_user_edit();
      return 3;
      break;
    case 'V':
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "Viewing a File");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      tbc_dispfile(menu_choice[match].action);
      tbc_wait();
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "At Menu Prompt");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      return 3;
      break;
    case 's':
      if(!(strcmp(menu_choice[match].action, "jed"))){
	 s_ask.mtype = Node;
	 s_ask.req = 6;
	 strcpy(s_ask.name, user.login);
	 strcpy(s_ask.activity, "Editing Personal Settings");
	 msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
	 tbc_jedsettings();
	 s_ask.mtype = Node;
	 s_ask.req = 6;
	 strcpy(s_ask.name, user.login);
	 strcpy(s_ask.activity, "At Menu Prompt");
	 msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      }
      else if(!(strcmp(menu_choice[match].action, "mutt"))){
	 s_ask.mtype = Node;
	 s_ask.req = 6;
	 strcpy(s_ask.name, user.login);
	 strcpy(s_ask.activity, "Editing Personal Settings");
	 msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
	 tbc_muttsettings();
	 s_ask.mtype = Node;
	 s_ask.req = 6;
	 strcpy(s_ask.name, user.login);
	 strcpy(s_ask.activity, "At Menu Prompt");
	 msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      }
      else if(!(strcmp(menu_choice[match].action, "lynx"))){
	 s_ask.mtype = Node;
	 s_ask.req = 6;
	 strcpy(s_ask.name, user.login);
	 strcpy(s_ask.activity, "Editing Personal Settings");
	 msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
	 tbc_lynxsettings();
	 s_ask.mtype = Node;
	 s_ask.req = 6;
	 strcpy(s_ask.name, user.login);
	 strcpy(s_ask.activity, "At Menu Prompt");
	 msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      }
      else if(!(strcmp(menu_choice[match].action, "personal"))){
	 s_ask.mtype = Node;
	 s_ask.req = 6;
	 strcpy(s_ask.name, user.login);
	 strcpy(s_ask.activity, "Editing Personal Settings");
	 msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
	 tbc_psettings();
	 s_ask.mtype = Node;
	 s_ask.req = 6;
	 strcpy(s_ask.name, user.login);
	 strcpy(s_ask.activity, "At Menu Prompt");
	 msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      }
      return 3;
      break;
    default:
      return 2;
      break;
   }
   
   return 0;
}


int tbc_who(void)
{
   l_ask = (sizeof(s_ask) - sizeof(long));
   l_who = (sizeof(s_who) - sizeof(long));
   s_ask.mtype = Node;
   s_ask.req = 1;
   msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
   msgrcv(qid_who, (struct msgbuf *)&s_who, l_who, Node, 0);
   clrscr();
   box_3d(2,1,76,23,1,1);
   box_3d(3,3,74,3,1,0);
   box_3d(3,7,74,8,1,0);
   box_3d(3,16,74,7,1,0);
   putcolor('1','F');
   ansipos(35,2); printf("Dial in Lines");
   ansipos(35,6); printf("Local Nodes");
   ansipos(35,15); printf("Telnet Nodes");
   ansipos(5,4); printf("1  %.35s",s_who.ttyS1);
   ansipos(5,8); printf("4  %.35s",s_who.tty1);
   ansipos(5,9); printf("5  %.35s",s_who.tty2);
   ansipos(5,10); printf("6  %.35s",s_who.tty3);
   ansipos(5,11); printf("7  %.35s",s_who.tty4);
   ansipos(5,12); printf("8  %.35s",s_who.tty5);
   ansipos(5,13); printf("9  %.35s",s_who.tty6);
   ansipos(5,17); printf("12  %.35s",s_who.ttyp0);
   ansipos(5,18); printf("13  %.35s",s_who.ttyp1);
   ansipos(5,19); printf("14  %.35s",s_who.ttyp2);
   ansipos(5,20); printf("15  %.35s",s_who.ttyp3);
   ansipos(5,21); printf("16  %.35s",s_who.ttyp4);
   ansipos(45,6); printf("%.30s",s_who.ttyS1_act);
   ansipos(45,8); printf("%.30s",s_who.tty1_act);
   ansipos(45,9); printf("%.30s",s_who.tty2_act);
   ansipos(45,10); printf("%.30s",s_who.tty3_act);
   ansipos(45,11); printf("%.30s",s_who.tty4_act);
   ansipos(45,12); printf("%.30s",s_who.tty5_act);
   ansipos(45,13); printf("%.30s",s_who.tty6_act);
   ansipos(45,17); printf("%.30s",s_who.ttyp0_act);
   ansipos(45,18); printf("%.30s",s_who.ttyp1_act);
   ansipos(45,19); printf("%.30s",s_who.ttyp2_act);
   ansipos(45,20); printf("%.30s",s_who.ttyp3_act);
   ansipos(45,21); printf("%.30s",s_who.ttyp4_act);
   ansipos(1,24);
   tbc_wait();
   return 0;
}


int read_menu_list(void){
   FILE *fp_menu;
   int quit = 0, a = 0, end;
   char temp2[80];
   quit = 0;
   a = 1;
   strcpy(temp2, dat_main.dat);
   strcat(temp2, "/menu.dat");
   fp_menu = fopen(temp2, "r");
   if(!fp_menu){
      menu_max = 0;
      exit(1);
   }
   while(!quit){
      end = tbc_readline(fp_menu,a,2);
      if(end == -1 || temp_buf[0] == '\n'){
	 quit = 1;
	 menu_max = a - 1;
	 continue;
      }
      else{
	 strcpy(menus[a],temp_buf);
	 a++;
      }
      
      
   }
   fclose(fp_menu);
}


int check_messages(void)
{
   int end = 0;
   k_chat = ftok(dat_main.root, 'd');
   qid_chat = msgget(k_chat, 0);
   l_chat = (sizeof(s_chat) - sizeof(long));
   end = msgrcv(qid_chat, (struct msgbuf *)&s_chat, l_chat, Node, IPC_NOWAIT);
   if(end != -1){
      tbc_newline();
      printf("%s", s_chat.message);
      return 1;
   }
   
   return 0;
}


int tbc_user_edit(void)
{
   int quit = 0, quitb = 0, display = 1, display2 = 1, timechk = 0, warned = 0, warned2 = 0, a = 0;
   FILE *fp_user, *fp_stat;
   char cmd[41], temp[80], temp2, home_dir[80], udat_file[80], udat_file2[80], user_name[21];
   tbc_newline();
   disp_prompt(70);
   get_input(user_name,20,1,1,0,0,0);
   strcpy(home_dir, "/home/");
   strcat(home_dir, user_name);
   strcat(home_dir, "/");
   strcpy(udat_file, home_dir);
   strcat(udat_file, ".tbsetup");
   fp_user = fopen(udat_file, "r+");
   if(!fp_user){
      disp_prompt(71);
      return 1;
   }
   fseek(fp_user, 0, SEEK_SET);
   fread(&alt_user, sizeof(alt_user), 1, fp_user);
   strcpy(udat_file2, alt_user.homedir);
   strcat(udat_file2, ".tbstat");
   fp_stat = fopen(udat_file2, "r+");
   if(!fp_stat){
      fclose(fp_user);
      disp_prompt(71);
      return 1;
   }
   fseek(fp_stat, 0, SEEK_SET);
   fread(&alt_user2, sizeof(alt_user2), 1, fp_stat);
   quit = 0;
   while(!quit){
      if(display){
	 clrscr();
	 box_3d(2,2,76,20,1,1);
	 ansipos(3,5);
	 putcolor(0,'F');
	 printf("1 ) ");
	 putcolor(0,'E');
	 printf("First Name: ");
	 putcolor(0,'F');
	 printf("%s",alt_user.fname);
	 ansipos(3,6);
	 putcolor(0,'F');
	 printf("2 ) ");
	 putcolor(0,'E');
	 printf("Last Name: ");
	 putcolor(0,'F');
	 printf("%s",alt_user.lname);
	 ansipos(3,7);
	 putcolor(0,'F');
	 printf("3 ) ");
	 putcolor(0,'E');
	 printf("User Alias: ");
	 putcolor(0,'F');
	 printf("%s",alt_user.allias);
	 ansipos(3,8);
	 putcolor(0,'F');
	 printf("4 ) ");
	 putcolor(0,'E');
	 printf("Logon Name: ");
	 putcolor(0,'F');
	 printf("%s",alt_user.login);
	 ansipos(3,9);
	 putcolor(0,'F');
	 printf("5 ) ");
	 putcolor(0,'E');
	 printf("Home Directory: ");
	 putcolor(0,'F');
	 printf("%s",alt_user.homedir);
	 ansipos(3,11);
	 putcolor(0,'F');
	 printf("6 ) ");
	 putcolor(0,'E');
	 printf("Street Address: ");
	 putcolor(0,'F');
	 printf("%s",alt_user.saddress);
	 ansipos(3,12);
	 putcolor(0,'F');
	 printf("7 ) ");
	 putcolor(0,'E');
	 printf("City: ");
	 putcolor(0,'F');
	 printf("%s  ",alt_user.city);
	 ansipos(3,13);
	 putcolor(0,'F');
	 printf("8 ) ");
	 putcolor(0,'E');
	 printf("State: ");
	 putcolor(0,'F');
	 printf("%s  ",alt_user.state);
	 ansipos(3,14);
	 putcolor(0,'F');
	 printf("9 ) ");
	 putcolor(0,'E');
	 printf("Zip Code: ");
	 putcolor(0,'F');
	 printf("%s  ",alt_user.zip);
	 ansipos(3,15);
	 putcolor(0,'F');
	 printf("10) ");
	 putcolor(0,'E');
	 printf("H-Phone: ");
	 putcolor(0,'F');
	 printf("%s  ",alt_user.hphone);
	 ansipos(3,16);
	 putcolor(0,'F');
	 printf("11) ");
	 putcolor(0,'E');
	 printf("D-Phone: ");
	 putcolor(0,'F');
	 printf("%s",alt_user.dphone);
	 ansipos(3,17);
	 putcolor(0,'F');
	 printf("12) ");
	 putcolor(0,'E');
	 printf("Security Level: ");
	 putcolor(0,'F');
	 printf("%d",alt_user2.sec);
	 ansipos(1,22);
	 display = 0;
	 display2 = 1;
      }
      if(display2){
	 disp_prompt(50);
	 display2 = 0;
      }
      update_timeon();
      timechk = check_timeleft();
      if(timechk == 5 && warned == 0){
	 disp_prompt(7);
	 tbc_newline();
	 warned = 1;
      }
      else if(timechk == 1 && warned2 == 0){
	 disp_prompt(7);
	 tbc_newline();
	 warned2 = 1;
      }
      else if(!timechk){
	 disp_prompt(8);
	 tbc_newline();
	 return 0;
      }
      temp2 = tolower(getchar());
      if(temp2 != EOF){
	 linenum = 1;
	 if(temp2 == ''){
	    if(a >= 1){
	       printf("\b \b");
	       a--;
	    }
	 }
	 else if(temp2 == '\n'){
	    cmd[a] = '\0';
	    if(!strcmp(cmd,"q")){
	       quit = 1;
	       continue;
	    }
	    else if(!strcmp(cmd,"quit")){
	       quit = 1;
	       continue;
	    }
	    else if(!strcmp(cmd,"menu")){
	       display = 1;
	       continue;
	    }
	    else if(!strcmp(cmd,"1")){
	       tbc_newline();
	       disp_prompt(72);
	       get_input(alt_user.fname,20,0,1,0,0,0);
	       display = 1;
	    }
	    else if(!strcmp(cmd,"12")){
	       tbc_newline();
	       disp_prompt(72);
	       strcpy(temp, "");
	       get_input(temp,4,1,0,0,0,0);
	       to_int(temp);
	       alt_user2.sec = to_int_return;
	       display = 1;
	    }
	    else if(!strcmp(cmd,"")){
	       tbc_newline();
	       display2 = 1;
	       continue;
	    }
	    else{
	       tbc_newline();
	       disp_prompt(60);
	       tbc_newline();
	       display2 = 1;
	    }
	    a = 0;
	 }
	 else if(a < 40){
	    cmd[a] = temp2;
	    printf("%c",temp2);
	    a++;
	 }
      }
      
   }
   tbc_newline();
   disp_prompt(69);
   if(tbc_getyn()){
      fseek(fp_user, 0, SEEK_SET);
      printf("\nWriting .tbsetup");
      fwrite(&alt_user, sizeof(alt_user), 1, fp_user);
      fseek(fp_stat, 0, SEEK_SET);
      printf("\nWriting .tbstat");
      fwrite(&alt_user2, sizeof(alt_user2), 1, fp_stat);
      tbc_wait();
   }
   fclose(fp_user);
   fclose(fp_stat);
   read_ustats();
   read_usetup();
   return 0;
}

