/*Copyright (C) 1998 Darren Braun
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *   Any comments or questions can be directed to darren@theboard.dyn.ml.org
 */

/*box.h - Header file for box.c functions*/

/* Structures for the Display Files*/

/* This is at the beginning of all the display files
 * it keeps track of the parts of the file*/

struct disp_head{
   int box_num;      /*Number of Boxes*/
   int text_num;     /*Number of Text Entries*/
};

/* Each structure is for one box*/

struct box{
   int x;            /*X Position*/
   int y;            /*Y Position*/
   int x_len;        /*X Length*/
   int y_len;        /*Y Length*/
   int color;        /*Color Code*/
   int in_out;       /*3D in or out look*/
};

/* Each Structure is for one Text Entry*/

struct box_text{
   int x;            /*X Position*/
   int y;            /*Y Position*/
   int fg;           /*Foreground Color*/
   int bg;           /*Background Color*/
   char *text;       /*Text Field*/
};


/*Create a 3D Box - x,y = top-left position - x_len,y_len = length of sides
 *                - color = color code - in_out = 3D look (in or out)*/
int box_3d(int x, int y, int x_len, int y_len, int color, int in_out);
/*Create a Box with a Border*/
int box_norm(int x, int y, int x_len, int y_len, int bg, int fg);

