/* ix/MBox/WENDY (wendy.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #LP loop()             main loop
   #MA main()             main function

   Contact <volkers@unnet.wupper.de> for help! */









#include "wendy.h"
#include "../config.h"

unsigned char _HILFE[STRING];
#define UNSIGNED unsigned

void sig_catch()
{
  signal( SIGQUIT, SIG_IGN );
  ctrlx();
  echo( 1 );
  signal( SIGQUIT, sig_catch);
}

 
/* #LP - Read in a char and process it */
 
loop( f )
unsigned char f[];
{
  unsigned char s[STRING];
  int c, d;
  int oldy = -1;
 
  ansi2( "cm", x, y );
 
  do{
    c = getch();
 
    if(c == ESC){
        c = getch();
	d = 0;

        if(c == ':'){
                c = vi( f );
                goto ENDLOOP;
        }
	if((c == 'C') || (c == 'D')){
		d = c;
		c = 100 * '[';
	}
	else{
		if(c > 96){
			d = 0;
			c -= 96;
		
		}
		else{
			if(c == 'O') c = '[';

			c *= 100;

	    	        d = getch();

			if(d == '1') d = getch();
		}
	}

	c += d;
    }
  
    if (SCANTEST) { 
    	ansi2( "cm", 60, 2 );
    	ansi( "md" );
	if(c < 32){
		printf(" <CTRL-%c (%d)>    ", (c + 64), c);
	}
	if((c > 31) && (c < 128)){
		printf(" <%c (%d)>         ", c, c);
	}
	if(c > 127){
		printf(" <(%d)>            ", c);
	}
    	ansi2( "cm", x, y );
    	activate( RTF_attrib );
    }

    if(c ==  wBS) c = BS;
    if(c == wDEL) c = DELD;
    if(c == wINS) c = INS;
    if(c == wEND) c = END;
  
    switch(c){
        case ENTER      :       enter();
                                break;
        case CTRL_K     :
        case UP         :       ctrlk();
                                break;
#ifdef _SYS7
        case CTRL_J     :
#endif
        case DOWN       :       ctrlj();
                                break;
        case LEFT       :       if(x > 1){
                                        ansi( "kl" );
                                        x--;
                                }
				else{
					ctrlk();
					lines_end();
				}
                                break;
        case RIGHT      :       if(x < MAXX){
                                        ansi( "kr" );
                                        x++;
                                }
				else{
					ctrlj();
					x = 1;
					ansi2( "cm", x, y );
				}
                                break;
        case CTRL_B     :
	case PGUP_LI	:
        case PGUP       :       pgup();
                                break;
        case CTRL_F     :
	case PGDN_LI	:
        case PGDN       :       pgdn();
                                break;
        case CTRL_A     :
	case HOME_LI	:
        case HOME       :       x = 1;
				ansi2( "cm", x, y );
                                break;
	case CTRL_E	:
	case TLX_END	:
        case CTRL_Z     :
        case END        :       lines_end();
                                break;
        case BS         :       ctrlh();
                                CHANGED++;
                                break;
	case TLX_DEL	:
        case DELD       :       x++;
                                CHANGED++;
                                ctrlh();
                                break;
	case TAB	:	x = (int)((x+8)/8*8) + 1;
				if(x > MAXX) x = MAXX; 
				ansi2( "cm", x, y ); 
				break;
        case CTRL_O     :       help();
                                break;
        case CTRL_P     :       if(RULER == 0){
					strcpy(version, (unsigned char *) RULERLINE);
					RULER++;
					xruler = -1;
				}
				else{
					RULER = 0;
					strcpy(version, (unsigned char *) VERSION);
				}
				show_status( version );
				STATUSM = 0;
				ansi2( "cm", x, y );
				break;
        case CTRL_L     :       ansi( "me" );
				ansi2( "cm", 1, y );
                                show_line( SCREEN[y], ATTRIB[y], 1 );
				activate( RTF_attrib );
				ansi2( "cm", x, y );
                                break;
        case CTRL_R     :       show_status( version );
                                show_screen( START );
                                break;
	case CTRL_X	:	ctrlx( f );
				break;
	case CTRL_W	:	ctrlw( f );
				break;
	case CTRL_N	:	ctrln();
				break;
	case CTRL_U	:	ctrlu();
				break;
	case CTRL_T	:	ctrlt();
				break;
	case CTRL_S	:	ctrls();
				break;
	case CTRL_Y	:	ctrly();
				break;
	case CTRL_Q	:	block_set();
				break;
	case TLX_INS	:	
	case INS	:
	case CTRL_V	:	ctrlv();
				break;
	case NUM5	:
	case CTRL_G	:	ctrlg( f );
				break;
	default		:       if(c > 9100){
#ifdef _LOCAL
					show_status( " WENDY: Unbekannte Taste " );
#else
					show_status( " WENDY: Unknown key " );	
#endif
					ansi( "mr" );
					printf("<%d>. ", c);
					ansi( "me" );
					ansi2( "cm", x, y );

					c = 0;
				}
				if(c == '~') c = 0;  

				if((c > 31) && (c < 9100)){
					CHANGED++;
					if(INS_mode == 0){
						printf("%c", c);	
						if(c == ' ') c = BLANK;	
						SCREEN[y][(x-1)] = c;
						ATTRIB[y][(x-1)] = RTF_attrib;
						x++;
						if(x > MAXX){
							if(FORMATTER != 'b')
								x = wordwrap();
							if((y < MAXY) && (y < lastline))
								y++;
							else
								ctrlj();
							ansi2( "cm", x, y );
						}
					}
					else{
						insert( c );
					}
					if(FORMATTER == 'c'){
						center();
					}
					if((ypos + y) > lastline)
					lastline = ypos + y;
				}
    }




    ENDLOOP:

    if(oldy != y){
	if((FLAG[(ypos + y - 1)] & is_richtext) == is_richtext){
#ifdef _LOCAL
		show_status( "Der folgende Text ist klassifiziert als 'text/richtext'." );
#else
		show_status( "The following text is classified as 'text/richtext'.");
#endif
	}
	if((FLAG[(ypos + y - 1)] & is_plain) == is_plain){
#ifdef _LOCAL
		show_status( "Der folgende Text ist klassifiziert als 'text/plain'." );
#else
		show_status( "The following text is classified as 'text/plain'.");
#endif
	}
	ansi2( "cm", x, y );
    	/*
	if(CHANGED != 0){
		fprintf(ROLLBACK, "%05.5d %s\n", oldy, (unsigned char *) make_rtf( SCREEN[oldy], ATTRIB[oldy] ));
	}
	*/
    }
    oldy = y;

    if(RULER){
	if(x != xruler){
		if(STATUSM != 0) show_status( version );
		if(xruler != -1){
			ansi( "mr" );
			ansi2( "cm", xruler, 1 );
			printf("%c", version[(xruler - 1)]);
		}
		ansi( "me" );
		xruler = x;
		ansi2( "cm", xruler, 1 );
		printf("%c", version[(xruler - 1)]);
		ansi2( "cm", x, y );
		STATUSM = 0;
		activate( RTF_attrib );
	}
    }

  }while(c != CTRL_X);
}



/* #MA - Wendy main function */

main(argc, argv)
int argc;
unsigned char *argv[];
{
  FILE *fp;

  unsigned char s[LONGSTRING];
  unsigned char *term;
  unsigned char *home;
  int i, j;
  int RTF = 0;

#if defined(_ESTDIO) || !defined(_SYS7)
  setbuf(stdout, NULL);
#endif

  RTF_attrib = '0';

  SetGblMain();
  SCANTEST = 0;

  MAXX = 79;	/* Default Parameter */
  MAXY = 24;

  term = (unsigned char *) getenv("TERM");
  strcpy(terminal, (unsigned char *) term);
  strcpy(umlaut, (unsigned char *) "ibm" );

  wBS  = 8;
  wDEL = 9152; 
  wINS = 9151;
  wEND = 9189; 
 
  home = (unsigned char *) getenv( "HOME" );
  sprintf(s, "%s/.wendy", home);

  
  signal( SIGTERM, SIG_IGN );
  signal( SIGQUIT, sig_catch );
  signal( SIGINT, SIG_IGN );

  fp = fopen( s, "r" );
  if(fp != NULL){
	fgets(s, 80, fp); MAXY = atoi(s);
	fgets(s, 80, fp); MAXX = atoi(s);
	fgets(s, 80, fp); sscanf(s, "%s", &terminal);
	fgets(s, 80, fp); sscanf(s, "%s", &umlaut);	
	fgets(s, 80, fp); wBS = atoi(s);
	fgets(s, 80, fp); wDEL = atoi(s);
	fgets(s, 80, fp); wINS = atoi(s);
	fgets(s, 80, fp); wEND = atoi(s);
	fclose(fp);
  }
  if(MAXY > 24) MAXY = 24;
  if(MAXY <  4) MAXY =  4;
  
  if(MAXX < 10) MAXX = 80;


  ansi2( terminal, -1, -1 );
  i = ansi2( "cm" );
  ansi( "cl" );
#ifdef _LOCAL
  printf("\n\nMein Name ist "); 
#else
  printf("\n\nMy name is ");
#endif
  ansi( "md" ); printf("Wendy");
  ansi( "me" ); printf("!\n\n");

#ifdef BUGTEST
  if((i == 1) || (i == -1)){
#ifdef _LOCAL
	printf("Und ich kann Dein Terminal nicht bedienen!\n\n");
#else
	printf("And I can't handle your terminal!\n\n");
#endif
	return;
  }
#endif  
 
  if(argc < 2){
#ifdef _LOCAL
	printf("Und Du hast vergessen einen Dateinamen anzugeben!\n\n");
#else
	printf("And you've forgotten to mention a filename!\n\n");
#endif
	return;
  }
  /*
  sprintf(s, "/usr/tmp/WENDY.%d", getpid());
  ROLLBACK = fopen( s, "w" );
  if(ROLLBACK == NULL){
	printf("Rollback ???");
  }
  fprintf(ROLLBACK, "00000 %s, %s [%s] on %s\n\n", mydate( 0 ), mytime( 0 ), whoami(), ttyna());
  */
  lastline = 2;
  NEU = 0;
  RTF_toggle = 0;

  i = LINELENGTH -2;

  fp = fopen( argv[1], "r" );
  if(fp != NULL){
	FLAG[lastline] = 0;
	while(fgets(TEXT[lastline], i, fp) != 0){
		FLAG[lastline+1] = 0;
		if(strcomp("Content-Type: text/richtext", TEXT[lastline]) == 0){
			FLAG[lastline] |= is_richtext;
			lastline--;
		}
		if(strcomp("Content-Type: text/plain", TEXT[lastline]) == 0){
			FLAG[lastline] |= is_plain;
			lastline--;
		}
		lastline++;
		if(lastline > MAXLINES){
#ifdef _LOCAL
			printf("Und die Datei <%s> ist zu gross fuer mich!\n\n", argv[1]);
#else
			printf("And the file <%s> is much to big for me!\n\n", argv[1]);
#endif
			fclose(fp);
			return;
		}
	}
	  fclose(fp);
  }
  else{
	NEU++;
	RTF_toggle++;
	for(i = 0; i < 25; i++){
		strcpy(TEXT[i], (unsigned char *) "\n");
		FLAG[i] = 0;
	}
	lastline += 25;
  }
  strcpy(TEXT[lastline], (unsigned char *) "\n");
  strcpy(version, (unsigned char *) VERSION);
  show_status( version );
 
  INS_mode     = 0;
  CHANGED      = 0;
  REALLY       = 0;
  MARK	       = 0;
  START	       = 2;
  RULER	       = 0;
  STATUSM      = 0;
  FORMATTER    = 0;
  BLOCK.status = 0;

  x = 1; y = START; ypos = 1;
  
  prep_screen( ypos );
  show_screen( START );
 
  echo( 0 );
  loop( argv[1] );
  echo( 1 );
  /*
  fclose( ROLLBACK );
  */

  signal( SIGTERM, SIG_DFL );
  signal( SIGQUIT, SIG_DFL );
  signal( SIGINT,  SIG_DFL );
  
  ansi( "me" );
  ansi2( "cm", 1, MAXY );
  ansi( "ce" );
}




/* strings-funct */
unsigned char *sstrings(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j,k = NULL ;
  
for (j=NULL;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if ((b[j]>127)||(b[j]<32)) b[j]=32;
}
 b[j]='\0';
  	     
  	     
  return (unsigned char *) (b);
}






char *GRead(entry)
char *entry;
{
FILE *fd;
char *chh;
char tt[80];
int i;
static char s[2*STRING];


#ifndef BBS_HOME
 sprintf(s,"/etc/tbbs.setup/%s",entry);
#else
  sprintf(s,"%s/etc/config/%s",BBS_HOME,entry);
#endif

if ((fd=fopen(s,"r"))!=NULL)
 {
   if (fgets(s,STRING,fd)==NULL)
   {
    printf("\nBad entry in config-base (%s) (check the adjustments in \"tbbs.setup\")",entry);
    exit(-1);
   }
   strcpy(s,sstrings(s));
   for (i=0; i<120; i++)
    {
     if (s[i]==32) s[i]=0;
    }      
   fclose(fd);      
   return((char *) s);   
      
 } else 
 {
  chh=getcwd(tt,79);
  /*
  printf("\nCan't read (check the adjustments in \"tbbs.setup\") ->(%s)%s",tt, s);
  exit(-2);
  */
 }
 return(NULL);  
}

/* ++++++++++++++++++++++  Globale CFG lesen ++++++++++++++++++ */
void SetGblMain()
{
#ifdef BBS_HOME

sprintf(_HILFE,"%s/etc/languages/wendy/%s",BBS_HOME,GetLangName(0,0));

#else 

sprintf(_HILFE,"%s/etc/languages/wendy/%s",GRead("HOME"),GetLangName(0,0));

#endif



}






/* liefert Name oder Beschreibung der Sprache zurueck */
/* no	:  	Nummer der Sprache 
   mode	:  	0 -> filename
   		1 -> beschreibung
*/   	
char *GetLangName(no,mode)
int no, mode;
{
FILE *fd;
static char s[2*STRING],tmp[STRING];
int sum=0;
char *env;

no=1;
env=getenv("BBS_LANG");
printf("\menv...");
if (env!=NULL)
 no=atoi(env);

if (!no) no=1;

#ifdef BBS_HOME
  sprintf(s,"%s/etc/list.languages",BBS_HOME);
#else 
  sprintf(s,"%s/etc/list.languages",GRead("HOME"));
#endif

if ((fd=fopen(s,"r"))!=NULL)
{
  while ((fgets(s,2*STRING,fd)!=NULL) && (strpos("======",s)==NULL)) ;
  while ((fgets(s,2*STRING,fd)!=NULL) )
    {
      if ((strlen((char *) cut_bef(s))>0)&&(strlen((char *) cut_arg(s))>0))  sum++ ;
      if (sum==no) 
      {
        fclose(fd);
        if (!mode) {
         strcpy(tmp,(char *) sstrings(cut_bef(s)));   
         sum=0;
         while (sum<STRING) 
          {
           if (tmp[sum]==SPACE) tmp[sum]=0;
           sum++;
          }     
         
        } else
         strcpy(tmp,(char *) cut_arg(s));
        return( (char *) tmp);
      }      
    }  
  fclose(fd);
  printf("\nlanguage: GetLangName() failed, invaild language; no language or language missing!\n");
      exit(-12);
} else
 {
  printf("\nlanguage: GetLangName() failed, no language-support, no language!\n"); 
  exit(-11);
 }
}




UNSIGNED char *cut_arg(s)
UNSIGNED char s[];
{
  static UNSIGNED char arg[2*STRING];
  int i = 0, a = 0;


  while (s[i] > 32) i++;
  if (s[i] == 0) return (UNSIGNED char *) "";

  while (s[i] == 32) i++;

  while (s[i] != 0) {
	arg[a] = s[i];
	i++;
	a++;
  }
  arg[a] = 0;

  while((arg[(a-1)] < 33) && (a > 1)){
	a--;
	arg[a] = 0;
  }

  return (UNSIGNED char *) arg;
}




UNSIGNED char *cut_bef(s)
UNSIGNED char s[];
{
  static UNSIGNED char _bef[2*STRING];
  int i = 0;


  while (s[i] > 32) {
	_bef[i] = s[i];
	i++;
  }
  _bef[i] = 0;
  return (UNSIGNED char *) _bef;
}

