   
#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <time.h>
#include <setjmp.h>
#include <signal.h>
#include <sys/stat.h>
#define __MBD
#include "uqwk.h"
#define UNSIGNED unsigned 


#ifdef _BSD
#include <sys/signal.h>
#define sig_t void
#endif




void LogPtr()
{
FILE *fd;

fd=fopen("/tmp/tbbs.qwk.ptr_failure.debug","a");
if (fd!=NULL)
{
  fprintf(fd,"SIGSEGV: %s %s - %-12.12s: NG=(%s)%d; mode=%s\n", mydate(1), mytime(1),user_name,NG,NG_ART,TXT_MODE);
}
fclose(fd);
}


void sigcatch(sig)
int sig;
{
  UNSIGNED char tmp[2*STRING];  
  time_t is_time;


  signal(sig, SIG_IGN);

  chdir( HOME );

  switch (sig) {

	case SIGQUIT:
		CanClose(0);
		exit(-1);
		break;
	case SIGABRT:
		CanClose(0);
		exit(-1);
		break;
	case SIGINT:
	        /* ctrl-c */
	        CanClose(0);
	        signal(SIGINT, SIG_DFL);
	        signal(sig, SIG_IGN);
		break;
	case SIGHUP:
		CanClose(0);
		exit(-1);
		break; 
	case SIGSEGV:
		printf("\n!!!!! qwk-failure: SIGSEGV -> please contact <runge@nina.boerde.de>!!!!!!!\n");
		LogPtr();
		exit(-4);
		break;
	case SIGALRM:
	        signal(SIGALRM, (sig_t *) sigcatch);
		if (GET_NNTP_CHECK_ON)
  	        {
  	         alarm(NNTP_OUTTIME);
  	         time((time_t *) &is_time);
  	         if (is_time>(NNTP_TIMEOUT+(NNTP_OUTTIME)))
  	         {  /* nntp-server timeout !!!!*/
	          sprintf(buf,"NNTP-Server: Incorrect Response  <TIMEOUT>, NNTP-Service-Timeout! \n            -> Please Contact Your News-Admin%c (root, sysop...)");	   	 
	          printf("\n%s%c\nbye.\n",buf,BELL);
  	          time((time_t *) &NNTP_TIMEOUT);
  	          GET_NNTP_CHECK_ON=0;
  	          NNTP_ON=0;
  	          close_server();
  	          sprintf((char *) tmp,"failure: nntp-host (%s) is not aviable!",NNTP_HOST);
		  MailErr(1,buf,tmp);
		  exit(1);
  	         } 
  	        }
	
		break;
	case SIGTERM:
	        CanClose(0);
		exit(-1);
		break;
  }
}



void SetNNTPSig()
{
  signal(SIGALRM, (sig_t *) sigcatch);
  time((time_t *) &NNTP_TIMEOUT);
  GET_NNTP_CHECK_ON=0;
  alarm(NNTP_OUTTIME);
}
   




void SigInit()
{
	signal(SIGINT,  sigcatch);
	signal(SIGQUIT, sigcatch);
	signal(SIGHUP,  sigcatch);
	signal(SIGABRT, sigcatch);
	signal(SIGTERM, sigcatch);
	signal(SIGSEGV, sigcatch);

}





/* #YN - Get a char, but only accept GBL06_MSG (Yes, Ja, Qui) and
   GBL07_MSG (No, Nein, Non). */

int sysop_yesno()
{
  int c;

  printf("[Y,N]?"/*,GBL06_MSG,GBL07_MSG*/);
  
  do {
	c = getchar();
	if (c >= 97) c -= 32;
	if ((c != 89/*GBL06_MSG*/) && (c != 78/*GBL07_MSG*/)) c = 0;
  } while (c == 0);

  printf("%c\n", c);
  if (c==89 /*GBL06_MSG*/) c=1; else c=0; 

  return (int) c;
}

 



void CanClose(mode)
int mode;
{
unsigned char s[DSTRING];
int i;


  printf("\nbreak qwk-processing (clear all tmp-files) ");

  if (/*(sysop_yesno())&&*/(!mode))
  {
   printf("\nclear all tmp-files \nwait....");
   sprintf (s,"rm -fr %s/usr/%c/%d/qwk/spool >/dev/null 2>&1",HOME,USER_NAM,USER_ID);  
   system(s);
   CleanUp(); /* clear all LCK's */
   printf("...ok\n");
   exit(127);
  }
  SigInit();
}