
/* ix/MBox (language.c) by Sylvio Runge 10/94

   Die Funktionen fuer untersch. BBS-Sprachen    

   This C source code contains the following functions:

*/

#define __MBD
#include <sys/wait.h>
#include <dirent.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/stat.h>
#include <dirent.h>

/*#include "../mbox.h"*/

#include "../s_global.h"
#include "../language.h"
#include "uqwk.h"







/* liefert Anzahl der Sprachen */
int GetMaxLanguage()
{
 FILE *fd;
 char s[2*STRING];
 int sum=0;


sprintf(s,"%s/etc/list.languages",HOME);
if ((fd=fopen(s,"r"))!=NULL)
{
  while ((fgets(s,2*STRING,fd)!=NULL) && (strpos("======",s)==NULL)) ;
  while ((fgets(s,2*STRING,fd)!=NULL) )
    if (
          (strlen((char *) cut_bef(s))>0)      &&
          (strlen((char *) cut_arg(s))>0)
      )  
       sum++ ;
  fclose(fd);
  if (sum<1) 
  {
    nerror("language.c", 445, "tbbs: GetMaxLanguages() failed, invaild list.languages!", 
      "system: no language!", 
      "language is missing!");
      exit(-8);
  } else
    return(sum);

} else 
{
  nerror("language.c", 442, "tbbs: GetMaxLanguages() failed, invaild installation?", 
      "system: Can't open languages-support-files", 
      s);
      exit(-6);
 }
}







/* liefert Name oder Beschreibung der Sprache zurueck */
/* no	:  	Nummer der Sprache 
   mode	:  	0 -> filename
   		1 -> beschreibung
*/   	
char *GetLangName(no,mode)
int no, mode;
{
FILE *fd;
static char s[2*STRING],tmp[STRING];
int sum=0;

if (!no) no=1;

sprintf(s,"%s/etc/list.languages",HOME);
if ((fd=fopen(s,"r"))!=NULL)
{
  while ((fgets(s,2*STRING,fd)!=NULL) && (strpos("======",s)==NULL)) ;
  while ((fgets(s,2*STRING,fd)!=NULL) )
    {
      if ((strlen((char *) cut_bef(s))>0)&&(strlen((char *) cut_arg(s))>0))  sum++ ;
      if (sum==no) 
      {
        fclose(fd);
        if (!mode) {
         strcpy(tmp,(char *) strings(cut_bef(s)));   
         sum=0;
         while (sum<STRING) 
          {
           if (tmp[sum]==SPACE) tmp[sum]=0;
           sum++;
          }     
         
        } else
         strcpy(tmp,(char *) cut_arg(s));
        return( (char *) tmp);
      }      
    }  
  fclose(fd);
  nerror("language.c", 495, "tbbs: GetLangName() failed, invaild language!", 
      "system: no language!", 
      "language is missing!");
      exit(-12);
} else
  nerror("language.c", 500, "tbbs: GetLangName() failed, no language-support!", 
      "system: no language!", 
      s);
}



static struct L_TYP l_entry[MAX_LANGUAGE_ENTRY];

int USER_language=1;  /* deutsch ist voreingestellt :-) */
       
/* Einlesen der *msg-Files je nach sprache */
void L_Init()
{
int i,j=0,n;
unsigned char h[LSTRING];
unsigned char b[LSTRING];
unsigned char a[LOW_STRING];
FILE *fd;

 
 
if (!((USER_language>0)&&(USER_language<4))) {
 printf("\ninvalid user-language-id: %d\n",USER_language); 
 exit(-1);
 }

       strcpy(h,GetLangName(USER_language,0));
   
 if ((USER_language>0)/*&&(USER_language<4)*/) /* l_init */
 {
         sprintf(h,"%s/etc/languages/msg/%s",HOME,GetLangName(USER_language,0));
         for (i=0; i<=MAX_LANGUAGE_ENTRY; i++)
         {
           strcpy(l_entry[i].name,"");
           l_entry[i].txt[0]=0;
         }
         i=0;
         if ((fd=fopen(h,"r"))==NULL) printf("\nCan't read (%s), tell your sysop to complaint", h);
	 while ((fgets(h,LSTRING-2,fd)!=NULL))         
 	 {
 	   strcpy(a,(unsigned char *) cut_bef(h));
 	   strcpy(b,(unsigned char *) CutMsg(cut_arg(h)));
           strcpy(l_entry[i].name,(char *) a);
           b[99]=0;

/*         l_entry[i].txt =  malloc (n+1);*/
/*         if (l_entry[i].txt == NULL) OutOfMemory();*/
           strcpy(l_entry[i].txt,(char *) b);
           i++;
                      
 	 }
 	 if (i>(MAX_LANGUAGE_ENTRY-2)) printf("\nlanguage: msg-file to large, to many messages");
 	 fclose(fd);
 } else {
   
   exit(-1);
  }
}


unsigned char *GetText(nam)
unsigned char nam[];
{
static unsigned char  b[STRING];
int i=0;

  sprintf(b,"%s (%s) not found, tell your sysop\n",SL_04,nam);
  while  (i<MAX_LANGUAGE_ENTRY)
  {
   if (strpos(nam,l_entry[i].name)) 
    return (UNSIGNED char *) (l_entry[i].txt);    
   i++;
  }
  if (strpos(SL_04,b))
    {
       TextErrLog(0,nam);
   }
  
  
 return (UNSIGNED char *) (b);
}




int GetEChar(nam)
unsigned char nam[];
{
int i=0,b=-1;
unsigned char a[STRING];

  while  (i<MAX_LANGUAGE_ENTRY)
  {
   if ( (strpos(nam,l_entry[i].name)) && (l_entry[i].txt!=NULL)) {
      strcpy(a,l_entry[i].txt);
      b=a[0];
     }
   i++;
  }
 if (b==-1)
  {
	printf("\n\7msg-entry (char) (%s) not found, tell your sysop\n",nam);     
	sleep(1); b=0;
        TextErrLog(1,nam);
  }
  
 return (b);
}







unsigned char *CutMsg(nam)
unsigned char nam[];
{
static unsigned char  b[STRING];
int i=1;

  b[0]='\0';
  while  (i< (strlen(nam)-1))
  {
   b[i-1]=nam[i];
   i++;
  }
  b[i-1]='\0';
  
 return (UNSIGNED char *) (b);
}





unsigned char *GetLanguage()
{
static unsigned char b[LOW_STRING];

strcpy(b,(unsigned char *) GetLangName(USER_language,0));
return (UNSIGNED char *) (b);
}







void  TextErrLog(i,nam)
int i;
unsigned char nam[];
{
 FILE *fd;
 unsigned char s[STRING];
 
#ifdef LANGUAGE_LOG
     sprintf(s,"%s/etc/%s",HOME,LANGUAGE_ERR_LOG);
     if ((fd=fopen(s,"a"))!=NULL)
     {
       if (i==0) fprintf(fd,"%s: l=%d | text (%s) %s\n",mydate(1),USER_language, nam,UQWK_VERSION);
       	else     fprintf(fd,"%s: l=%d | char (%s) %s\n",mydate(1),USER_language, nam,UQWK_VERSION);
       fclose(fd);
     }
#endif
}