
#ifndef VU

#ifdef STERMIOS
#ifdef _SINIX             
#include <curses.h>       /* SINIX SVR4.1 prefers this instead of <termcap.h> */
#else 
#ifndef _SCO
#include <termcap.h>
#else
#include <curses.h>	  /* UNIX SVR4.2 prefers this instead of <termcap.h> */
			  /* As does SCO 3.2.4.3 ... */
#endif
#endif

#endif
#endif /*VU */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <unistd.h>
/*#include <stdlib.h>*/
#include <time.h>
#include <pwd.h>


#ifdef _BSD
#include <sys/termios.h>
#else
#include <termio.h>
#endif

#include <string.h>



#ifndef UNSIGNED
#if !defined(_MINIX) || defined(_ESTDIO)
#define UNSIGNED unsigned
#else
#define UNSIGNED
#endif
#endif

#ifdef _MBOX
#define EXTERN

#ifndef VU
#include "mbox.h"
#else
#include "../mbox.h"
#endif



#else
#define VERSION "Tools.C"
#define CR 13
#define TOL01_MSG	"Sonntag"
#define TOL02_MSG	"Montag"
#define TOL03_MSG	"Dienstag"
#define TOL04_MSG	"Mittwoch"
#define TOL05_MSG	"Donnerstag"
#define TOL06_MSG	"Freitag"
#define TOL07_MSG	"Samstag"
#define TOL08_MSG	"Momentchen"
#endif
#ifdef STRING
#undef STRING
#endif

#ifdef LONGSTRING
#undef LONGSTRING
#endif

#define STRING 81
#define LONGSTRING 256

UNSIGNED char headinfo[STRING];

#ifndef VU
#include "s_global.h"
#else
#include "../s_global.h"
#endif



/* #UP - Upcaseing all characters in string [st].

   This function returns the upcased string. */

UNSIGNED char *upcased(st)
unsigned char st[];		/* !!! unsigned, NOT UNSIGNED !!! */
{
  static UNSIGNED char s[STRING];

  int i = 0;

#ifdef _PROFILE
  profile( "upcased()" );
#endif

  strcpy(s, (UNSIGNED char *) strcopy(st, 0, STRING));

  while (s[i] != 0) {
	if (s[i] > 127) {
		if (s[i] == 132) s[i] = 142; /* IBM/DOS, ATARI ST */
		if (s[i] == 148) s[i] = 153;
		if (s[i] == 122) s[i] = 154;
		if (s[i] == 228) s[i] = 196; /* ISO-8859-1, AMIGA */
		if (s[i] == 246) s[i] = 214;
		if (s[i] == 252) s[i] = 220;
	}
	else{
		if (s[i] > 96) s[i] -= 32;
	}
	i++;
  }

  return (UNSIGNED char *) s;
}


int putch(int c) {
  return fputc(c, stdout);
}
      
void t_puts(char *tstr) {
 tputs(tstr, 1, putch);
 fflush(stdout);
}
                 
                       


/* #BC - Cut a part out of a long string [st].

   [v] describes the first position in [st], [b] stands for the last
   position. 

   This function returns the part between [v] and [b] as a long string. */

UNSIGNED char *bigcopy(st, v, b)
UNSIGNED char st[];
int v, b;
{
  static UNSIGNED char s[LONGSTRING];

  int i = 0, j;

#ifdef _PROFILE
  profile( "bigcopy()" );
#endif

  if (b > LONGSTRING) b = LONGSTRING;

  for (j = v; j <= b; j++) {
	s[i] = st[j];
	i++;
  }
  s[i] = 0;

  return (UNSIGNED char *) s;
}





/* #AN - Get a termcap entry or convert a command to terminal code.

   [code]   ->  'INIT'   = get a complete termcap entry and store it
                command  = find the command and show the code

   [x, y]   ->  if command is 'cm' (Cursor move), than the cursor is
                moved to [y],[x].

   This function returns -1 if terminal is not known, 1 if command 
   couldn't be found, or 0 is everything is ok. */

/*char  buf[1024]      , **area;*/


int ansi(code)			/* for compatibility reasons */
UNSIGNED char code[];
{

#ifdef _PROFILE
  profile( "ansi()" );
#endif

  ansi2(code, 0, 0);
  return(0);
}





/* 
 * <mode>
 *            0  =  Graphic Translation
 *            B  =  Normal Translation
 *            U  =  No Translation (Good For ANSI, etc.)
 *            K  =  User Defined Translation
 *            1  =  Default Translation
 */
void s_ansi(int argc, char *argv[])
{
  printf("\033(%c",argv[1][0]);
}







/* #TA - Get a termcap entry or convert a command to terminal code.

   [code]   ->  'INIT'   = get a complete termcap entry and store it
                command  = find the command and show the code

   This function returns the terminal code or '\0'. */


UNSIGNED char *termansi(code)
UNSIGNED char code[];
{
  UNSIGNED char *getenv();
  static UNSIGNED char s[STRING];
  UNSIGNED char *p = s;
  UNSIGNED char *term;

#ifdef _PROFILE
  profile( "termansi()" );
#endif

#ifndef VU
#ifdef _MBOX
  ZOPT.OPT->TERMINAL;
#else
  term = getenv("TERM");
#endif
 
  s[0]=0;

  if (strcomp("INIT", code) == 0) {
/*	if (tgetent(buf, term) != 1) return (UNSIGNED char *) "\0";*/
  }
  if (tgetstr(code, (char **) &p) == 0) return (UNSIGNED char *) s;

  if((s[0] == '2') || (s[0] == '5') ||(s[0] == '3')){		/* For the new ''VT100'' termcap enties ;-( */
	strcpy(s, (UNSIGNED char *) strcopy(s, 1, STRING));
  }
#else
  s[0]=0;
#endif
  return (UNSIGNED char *) s;
}









/* #CY - Encrypt a string [st].

   This function returns the encrypted string. */

UNSIGNED char *crypted(st)
UNSIGNED char st[];
{
  static UNSIGNED char s[STRING];
  int i = 0, a = 2; 

  strcpy(s, (UNSIGNED char *) strcopy(st, 0, STRING));

  while (s[i] != 0) {
	s[i] = (s[i] / a) + 32;
	i++;
	a++;
	if (a > 5) a = 2;
  }

  return (UNSIGNED char *) s;
}








/* #DR - Converting a (long) date into a string.

   This function returns a date string. */

UNSIGNED char *datereconv(l)
long l;
{
  static UNSIGNED char s[STRING];
  static UNSIGNED char t[STRING];


  if (l < 19000000)
	sprintf(s, "%ld", 1900000L + l);
  else
	sprintf(s, "%ld", l);

  strcpy(t, (UNSIGNED char *) strcopy(s, 6, 7));
  strcat(t, ".");
  strcat(t, (UNSIGNED char *) strcopy(s, 4, 5));
  strcat(t, ".");
  strcat(t, (UNSIGNED char *) strcopy(s, 0, 3));

  return (UNSIGNED char *) t;
}





/* #TR - Converting a (long) time into a string.

   This function returns a time string. */

UNSIGNED char *timereconv(i)
int i;
{
  static UNSIGNED char s[STRING];
  static UNSIGNED char t[STRING];


  if (i < 10000)
	sprintf(s, "%04.4d00", i);
  else
	sprintf(s, "%06.6d", i);

  strcpy(t, (UNSIGNED char *) strcopy(s, 0, 1));
  strcat(t, ":");
  strcat(t, (UNSIGNED char *) strcopy(s, 2, 3));
  strcat(t, ":");
  strcat(t, (UNSIGNED char *) strcopy(s, 4, 5));

  return (UNSIGNED char *) t;
}






/* #NS - Strip of all numerics of a string [s].

   This function returns the stripped string. */

UNSIGNED char *numstripped(s)
UNSIGNED char s[];
{
  static UNSIGNED char t[STRING];
  int i = 0, a = 0;

  while (s[i] != 0) {
	if (((s[i] > 64) && (s[i] < 127)) || (s[i] == ' ') || (s[i] == '-')) {
		t[a] = s[i];
		a++;
	}
	i++;
  }
  t[a] = 0;

  return (UNSIGNED char *) t;
}







#ifndef VU
/* #HL - Display a text [line] as headline. */

void headline(line)
UNSIGNED char line[];
{
  UNSIGNED char ex[255];
  int i;


  strcpy(ex, line);
  i = 0;
  while(line[i] != 0){
	if(line[i] == '^'){
		strcpy(ex, (UNSIGNED char *) strcopy(line, 0, (i-1)));
		line[i] = ' ';
	}
	i++;
  }
  strcpy(headinfo, ex);
  sprintf(ex, "%s                                                                          ", line);
  ex[79] = 0;
  if (ansi2("cl", 0, 0) != -1) {
	if (ansi2("mr", 0, 0) == 1) {
		if (ansi2("so", 0, 0) == 1) { 
			printf("\n\n------  %s  ------\n\n", line);
			return;
		}
	}
	printf("%s\n", ex);
	if (ansi2("me", 0, 0) == 1) {
		ansi2("se", 0, 0);
	}
  }
  else {
	printf("\n\n\n\n\n------  %s  ------\n\n", line);
  }
}

#endif





/* #TY - Find the number of a terminal.

   This function returns the number of a terminal. */

int tty()
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  int i, l, a, b;


  strcpy(s, (UNSIGNED char *) ttyname(0));
  l = strlen(s);
  i = l;

  while ((s[l] != 'y') && (l > 0)) l--;

  l++;
  a = 0;

  for (b = l; b < i; b++) {
	t[a] = s[b];
	a++;
  }
  t[a] = 0;

  return atoi(t);
}




/* #TN - Find the name of a terminal.

   This function returns the name of a terminal. */

UNSIGNED char *ttyna()
{
  static UNSIGNED char s[STRING];
  static UNSIGNED char t[STRING];
  int i, j=0, l;


  strcpy(s, (UNSIGNED char *) ttyname(0));

  l = strlen(s) + 1;

  i = 0; 
  while(s[i] != 0){
	if(s[i] == '/') j = i + 1;
	i++;
  }
  (void) strcpy(t, (UNSIGNED char *) strcopy(s, j, l));
  
  return (UNSIGNED char *) t;
}




/* #CL - Clear a screenline. */
 
void clearline()
{
  printf("%c", CR);
  if (ansi2("ce", 0, 0) == 1) {
	printf("                                                               ");
  }
  printf("%c", CR);
}




/* #IN - Check if a character [c] is in a string [pattern].

   This function returns 0 if the char isn't included or a number > 0
   otherwise. */

int isin( pattern, c )
UNSIGNED char pattern[];
int c;
{
  int i = 0;
  int ok = 0;

  while((pattern[i] != 0) && (ok == 0)){
	if(pattern[i] == c) ok++;	
	i++;
  }
  
  return (int) ok;  
}





/* #SG - Check if a pattern [pattern] is in a string [source].

   This function returns 0 if the sign isn't included or a number > 0
   otherwise. */

int sgrep( source, pattern )
UNSIGNED char source[];
UNSIGNED char pattern[];
{
  UNSIGNED char t[STRING];
  int i = 0;
 
  while(source[i] != 0){
	if(source[i] == pattern[0]){
		strcpy(t, (UNSIGNED char *) strcopy(source, i, strlen(source)));
		if(strcomp(pattern, t) == 0) return (int) i + 1;
	}
	i++;
  }

  return (int) 0;
}


/* #AF - Converts a String into a float ... */

long aftol( s )
UNSIGNED char s[];
{
  UNSIGNED char t[STRING];
  int i = sgrep(s, "."); 	/* Decimal point, Germany */ 

  if(i == 0) sgrep(s, ",");	/* Decimal point, Elsewhere */

  strcpy(t, (UNSIGNED char *) strcopy(s, 0, (i-2)));
  strcat(t, (UNSIGNED char *) strcopy(s, (i), strlen(s)));

  return (long) atol( t );
}


int orginal=0;

int ansi2(code, x, y)
UNSIGNED char code[];
int x, y;
{
static UNSIGNED char buf[1024];
 
  UNSIGNED char *getenv();
  static UNSIGNED char s[STRING];
  UNSIGNED char *p = s;
  UNSIGNED char *term;
  int i;

#ifdef _PROFILE
  profile( "ansi2()" );
#endif


#ifndef VU


if (!ZOPT.OPT->USER.terminal) return; /* bei GAST-Fehler-Mail ohne Term-Init */

#ifdef _MBOX
  term = ZOPT.OPT->TERMINAL;
#else
  term = getenv("TERM");
#endif



  if ((x == -1) && (y == -1)) {
	if (tgetent(buf, code) != 1) return -1;
  }
  if (strcomp("INIT", code) == 0) {
        if  ((ZOPT.OPT->t_init==0)||1)
        {
         ZOPT.OPT->t_init=1;
  	 if (tgetent(buf, term) != 1) return -1;
  	 ansi("is");
  	}
  }
 
 if ((ZOPT.OPT->USER.terminal==5)&&(orginal==0)) /* nur bei ANSI-COLOR */
 {
  for (i=0; i<20; i++)
  {
   if (strpos(code,ZOPT.ansi->mode[i].org)==1)
    strcpy(code,ZOPT.ansi->mode[i].usr);
  }
 } else
 {  /* Konvertierung einiger Buggy-Sequenzen */
    if (strpos("me",code)!=0) strcpy(code,"se");
 
 
 }  
 
 
  if (strcomp("cm", code) == 0) {
	if (tgetstr(code, (char **) &p) == 0) return 1;

  if((s[0] == '2') || (s[0] == '5') ||(s[0] == '3')){		/* For the new ''VT100'' termcap enties ;-( */
	strcpy(s, (UNSIGNED char *) strcopy(s, 1, STRING));
  }	
	printf("%s", (UNSIGNED char *) tgoto( s, (x -1), (y -1) ));
	return 0;
  }
  else{
	if (tgetstr(code, (char **) &p) == 0) return 1;
  }

  if((s[0] == '2') || (s[0] == '5') ||(s[0] == '3')){		/* For the new ''VT100'' termcap enties ;-( */
	strcpy(s, (UNSIGNED char *) strcopy(s, 1, STRING));
  }

  printf("%s", s);
#endif
  return 0;
}






int ansi2org(code, x, y)
UNSIGNED char code[];
int x, y;
{
orginal=1;
ansi2(code,x,y);
orginal=0;
}