/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 +  Filemen-Manager fr ix/MBox 					+
 +   (c) S.Runge 7/94							+
 +     sdl_list.c - Routinen fr Download-liste 			+
 +               							+
 ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#define __MBD

#include <stdio.h>
#include <sys/types.h>
#include <time.h>
#include <signal.h>
#include <sys/stat.h>

#include <unistd.h>
#include "mbox.h" 
#include "sfile_a.h"
#include <dirent.h>
#include <fcntl.h>
#include <stdio.h>

#undef NEW_MAIN_OWL
#undef NEW_MAIN_SIM
#define EXTERN_D
#include "proto.h"
#include "mbd.h"

/* wandelt alle Zeilchen in Grossbuchstaben */
unsigned char *touppers(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j,k = 0 ;
  
for (j=0;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if ((b[j]>64)&&(b[j]<91)) b[j]=b[j]+32;
}
 b[j]=0;
  	     
  	     
  return (UNSIGNED char *) (b);
}




/* #CB - Isolate the command from an input line [s]. */

UNSIGNED char *cut_bef(s)
UNSIGNED char s[];
{
  static UNSIGNED char bef[2*STRING];
  int i = 0;


  while (s[i] > 32) {
	bef[i] = s[i];
	i++;
  }
  bef[i] = 0;
  return (UNSIGNED char *) bef;
}



/* #CB - Isolate the command from an input line [s]. */

UNSIGNED char *cut_leer(s)
UNSIGNED char s[];
{
  static UNSIGNED char bef[STRING];
  int i = 0,j=0;


  while (s[i] == 32) i++;
  
  while (i!=strlen(s)) {
	bef[j] = s[i];
	i++;j++;
  }
  bef[j] = 0;
  return (UNSIGNED char *) bef;
}



/* Position eines Strings in einem anderen -> strpos alias PAS */
int strpos(s, t)
UNSIGNED char *s, *t;
{
  int j=0, i = 0, a = 0;


  while (t[i] != 0) {
	j=0;
	if (t[i] == s[0]){
	    a=i+1;
	    while ((s[j]==t[i])&&(s[j]!=0)) {
	       j++; i++;
	     }
	    if (s[j]==0) return (int) a ; else a='0';
	 }
	i++;
  }

  return (int) NULL;
}





char *str_fill(st,b) /* string , Soll-Lnge */
int *b;
char st[];
{
  static char s[STRING],d[STRING];
  int j = 0;
  
  if (strlen(st)>b)
  {
      strcpy(s,(char *) strcopy(st,0,b));
  } 
  else 
  {
      strcpy(s,st);strcpy(d,(char *) " ");
      for (j=(strlen(st)-1);j<STRING-2;j++) s[j]=d[0];
      s[j]=0; 
      strcpy(s,(char *) strcopy(s,0,b)); 
  }
  return (UNSIGNED char *) s;
}







/* kuerzt den Path-String ab fr Anzeige :-) */
unsigned char *snip_nam(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int i = 0;
  int j = MAX_L-1;
  int Min  = 0;
  
    b[j]=0;  
    i=strlen(s);
    j--;
    while (j!=-1) {
        b[j]=s[i];
        j--;i--;
    };
  return (UNSIGNED char *) b;
}





/* gibt string ohne Kommentar zurck (pfile.c)*/
unsigned char *s_path(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int i = 0;
  int j = MAX_L-1;
  int Min  = 0;
  
    b[j]=0;  
    for (j=(strlen(SF_295pp));j<=strlen(s);j++) /* nur global aendern in s_global !!! */
    {
      b[i]=s[j];
      i++;
    }

  strcpy(b,(char *) cut_bef(b));    
  return (UNSIGNED char *) b;
}








/* Konertierung  t_time->char[]    long->time_date  */
UNSIGNED char *sr_time(l)
time_t l;
{
  static UNSIGNED char d[STRING];
  UNSIGNED char s[STRING];
  struct tm  *t;

  t=gmtime(&l);
  sprintf(s,"%02d/%02d/%02d",t->tm_mday,t->tm_mon+1,t->tm_year);
  strcat(s,"   ");
  strcpy(d,(char *) str_fill(s,DATE_STR));
  return (UNSIGNED char *) d;
}





/* Konertierung  t_time->char[]    long->time-char */
UNSIGNED char *sr_the_time(l)
time_t l;
{
  static UNSIGNED char d[STRING];
  UNSIGNED char s[STRING];
  struct tm  *t;

  t=gmtime(&l);
  sprintf(s,"%02d:%02d:%02d",t->tm_hour,t->tm_min,t->tm_sec);
  strcat(s,"    ");
  strcpy(d,(char *) str_fill(s,DATE_STR));
  return (UNSIGNED char *) d;
}




/* findet den Names der Aera in dem String */
UNSIGNED char *cut_nam(s)
UNSIGNED char s[];
{
  static UNSIGNED char b[STRING];
  int i = 0 /*LPOS */;
  int j = 0;
  
  while ((s[i]!=32)&&(i<(strlen(s)-1))) i++;
  while ((s[i]==32)&&(i<(strlen(s)-1))) i++;
  
  while ((s[i] > 32) &&(i<(strlen(s)-1)) ) {
	b[j] = s[i];
	i++;j++;
  }
  b[j] = 0;
  return (UNSIGNED char *) b;
}



/* wandelt gruppe.untergruppe in gruppe/untergruppe - Darstellung  */
unsigned char *punkt2strich(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j,k = 0 ;
  
for (j=0;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if (b[j]==46) b[j]=47;
}
 b[j]=0;
  	     
  	     
  return (UNSIGNED char *) (b);
}








/* loest Zahlen aus STRING+ZAHL+STRING heraus*/
unsigned char *nums(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j,k = 0 ;
  
for (j=0;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if ((b[j]>57)&&(b[j]<48)) b[j]=32;
}
 b[j]=0;
 k=atoi(b);
 sprintf(b,"%d",k); 	     
  	     
  return (UNSIGNED char *) (b);
}





UNSIGNED char *s_nam(s)
UNSIGNED char s[];
{
  static UNSIGNED char arg[STRING];
  int i = 0, a = 0;

  strcpy(arg,(char *) s);

  while (arg[i] > 32) i++;
  arg[i] = 0; 
  
  return (UNSIGNED char *) arg;
}





/* Konvertiert binaer-time->CHAR */
unsigned char *t2a(bintime)
long bintime;
{
  static unsigned char b[STRING];
  
  strcpy(b,(char *) ctime(&bintime));
  return (UNSIGNED char *) b;	
}








/* #CN - Make up a uniq name for every CDROM */

UNSIGNED char *cdname2(s)
UNSIGNED char s[];
{
  FILE *fp;
  UNSIGNED char h[STRING];

  DIR *dp;
  struct dirent *actdir;
  int i;
  struct stat fst;
  long atime;
 


  sprintf(h,"%s/%s",HOME,DHOME);
  chdir(h);
  i = 2;
  while(s[i] != 0){
	if(s[i] == '/'){
		s[i] = 0;
	}
	i++;
  }
  dp = opendir( s );
  readdir(dp);
  readdir(dp);
  actdir = readdir(dp);
  
  strcat(s, (UNSIGNED char *) "/");
  strcat(s, (UNSIGNED char *) actdir->d_name);
  
  stat(s, &fst);
  atime = (long) fst.st_atime;

  if (atime < 50000000L){
        s[0]=0;
	return ((UNSIGNED char *) s);
  }
  
  closedir(dp); 

  sprintf(s, "%s/%s/%ld.dir", HOME, CDROM_INFDIR,atime);
  if(mkdir( s, 0777 ) == 0){
	sprintf(s, "%s/%s/%ld", HOME, CDROM_INFDIR,atime);
	fp = fopen( s, "w" );
	fputs(SF_NEWCD,fp);
	fclose(fp);
	
	sprintf(s,"%s/%s/%ld.EXCLUDE",HOME,CDROM_INFDIR,atime);
        if ((fp=fopen(s,"r"))==NULL)  /* Index-Datei fuer Ausschiessen eines Pfades aus dem Index (z.B. "live-Filesystem der Linux-CDs" */
        {
         fclose(fp);
         fp=fopen(s,"w");
        }
  	fclose(fp);
#ifdef MAILCDROM_ON	
	sprintf(s,"%s %ld %s &",MAIL_NEWCD,atime,MAIL_NEWCDa); 
	/* im Hintergrund eine Mail an den Adm ueber neue CD */
	system(s);
#endif
  }
  sprintf(s, "%ld", atime);
  chdir(HOME);

  return (UNSIGNED char *) s;
}





/* strings-funct */
unsigned char *strings(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j,k = 0 ;
  
for (j=0;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if ((b[j]>127)||(b[j]<32)) b[j]=32;
}
 b[j]=0;
  	     
  	     
  return (UNSIGNED char *) (b);
}




/* sicherheit-strings-funct: loescht alle kritischen Zeichen aus arg eines bef*/
unsigned char *si_strings(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j,k = 0 ;
  
for (j=0;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if ((b[j]>127)||(b[j]<40)) b[j]=32;
 if ((b[j]==124)||(b[j]==126)||(b[j]==60)||(b[j]==62)||(b[j]==33)) b[j]=32;
}
 b[j]=0;
  	     
  	     
  return (UNSIGNED char *) (b);
}





/* loest Beschreibung aus STR */
unsigned char *snip_OWL_nam(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j,k = 0 ;
  
for (j=SF_OWL_COMMENTAR-1;j<=(strlen(s));j++)
{
 b[k]=s[j]; k++;
}
 b[k]=0;
  	     
  	     
  return (UNSIGNED char *) (b);
}


/* loest Beschreibung aus STR */
unsigned char *snip_SIM_nam(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j,k = 0 ;
  
for (j=SF_SIM_COMMENTAR-1;j<=(strlen(s));j++)
{
 b[k]=s[j]; k++;
}
 b[k]=0;
  	     
  	     
  return (UNSIGNED char *) (b);
}

/* loest Beschreibung aus STR */
unsigned char *snip_SIMDIR_nam(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j,k = 0 ;
  
for (j=SF_SIMDIR_COMMENTAR-1;j<=(strlen(s));j++)
{
 b[k]=s[j]; k++;
}
 b[k]=0;
  	     
  	     
  return (UNSIGNED char *) (b);
}







/* wandelt LeerZ -> /  */
unsigned char *leer2slash(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j,k = 0 ;
  
for (j=0;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if (b[j]==32) b[j]=47;
}
 b[j]=0;
  	     
  return (UNSIGNED char *) (b);
}


unsigned char *leer2punkt(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j,k = 0 ;
  
for (j=0;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if (b[j]==32) b[j]=46;
}
 b[j]=0;
  	     
  return (UNSIGNED char *) (b);
}












/* schneidet namen aus Path-Darstellung raus  */
unsigned char *dir2nam(s)
unsigned char s[];
{
  unsigned char a[STRING];
  static unsigned char b[STRING];
  int j,i=0, k = 0 ;
  
for (j=0;j<=(strlen(s));j++)
{
 a[j]=s[j];
 if (s[j]==47) a[j]=32;
}
 a[j]=0;
 j=strlen(a);
 while((a[j]!=32)&&(j!=0)) j--;
 j++; 
 for (k=j;k<strlen(a);k++)
 {
  b[i]=a[k];
  i++; 
 }
 b[i]=0; 	     
  	     
  return (UNSIGNED char *) (b);
}




/* gibt erste Zeichen-Pos nach Leerzeichen-String zurueck   */
int PosZeichenS(s)
unsigned char s[];
{
  int j, k = 0 ;
  
for (j=0;(j<=(strlen(s))&&(k=0));j++)
{
 if (s[j]!=32) k=j;
}
  	     
  return (k);
}




/* schneidet Path-namen raus  */
unsigned char *dir2path(s)
unsigned char s[];
{
  unsigned char a[STRING];
  static unsigned char b[STRING];
  int j,i=0, k = 0 ;
  
for (j=0;j<=(strlen(s));j++)
{
 a[j]=s[j];
 if (s[j]==47) a[j]=32;
}
 /*MsgBox(s); */
 a[j]=0;
 j=strlen(a);
 while((a[j]!=32)&&(j!=0)) j--;
 for (k=0;k<j;k++)
 {
  b[k]=a[k];
 }
 b[k]=0; 	     
  	     
  return (UNSIGNED char *) (b);
}





/* wandelt / in Leerzeichen  */
unsigned char *slash2leer(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j,k = 0 ;
  
for (j=0;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if (b[j]==47) b[j]=32;
}
 b[j]=0;
  	     
  	     
  return (UNSIGNED char *) (b);
}



/* entfert Vor-Gruppe aus CDROM-Path   */
unsigned char *cdrom_arg(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j=0,i = 0 ;

 while (s[j]!=47) j++;
 j++;
 while (j<(strlen(s)+1))
 {
	b[i]=s[j];
	j++; i++;	 
 }
 b[i]=0;  	     
  	     
  return (UNSIGNED char *) (b);
}



/* Test ob Filename oder nicht   */
int int_test(s)
unsigned char *s[];
{
  int b = 0;
  int i = 0 ;
   
   return (int ) atoi(s) ;
}




/* schneidet  Daten aus news-Zeile raus ... */
unsigned char *snip_dat(c /* Subj-String */,s /* Zeile */ )
unsigned char c[],s[];
{
  static unsigned char b[STRING];
  int j,k = 0, i=0 ;

  
  k=strlen(c);  
  for (j=k+1;j<=strlen(s);j++)
  {
    b[i]=s[j];
    i++;
  }
  b[i]=32;
  b[i++]=0;
  	     
  return (UNSIGNED char *) (b);
}






/* schneidet  Leerzeichen am Ende ab ... */
unsigned char *snip_leer(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int i=0 ;

  while ((s[i]!=32)&&(s[i]!=0))
  {
   b[i]=s[i];
   i++;
  }
  b[i]=0;
  	     
  return (UNSIGNED char *) (b);
}



/* gibt Nummer des Artkels aus NamenString zurck  */
int id_nr(s)
unsigned char *s[];
{
  int j=0, i = 0 ;
  unsigned char b[20];
  
   
    i=atoi(cut_arg(s));   
   	   
   return (int ) i;
}





/* -------------------------------------*/




/* Liest Eintraege aus der Info-lib ein  */
UNSIGNED char *READ_LIB(p,s)
unsigned char p[],s[];
{
  static unsigned char b[STRING];
  unsigned char t[STRING];
  FILE *fd;
  extern int CDROM_ON;
  extern unsigned char CDNAME[LOW_STRING]; /* cd-Name-ID */

strcpy(b,(char *) "");   
if (CDROM_ON)
 { 
 strcpy(t,(char *) cdrom_arg(p));
 sprintf(b,"%s/%s/%s.dir/%s/%s%s",HOME,CDROM_INFDIR,CDNAME,t,s,INF);
  strcpy(s,b); 
  strcpy(b,"");
  if ((fd=fopen(s,"r"))!=NULL)
  {
     fgets(b,80,fd);
     fclose(fd);
  } else strcpy(b,"");    
  
  chdir(HOME);
 }; 	     
 return (UNSIGNED char *) b;
}


/* Testet auf vorhandensein einer Beschreibungs-Datei im CDROM-Pfad */
int TestOwl(pnam)
unsigned char pnam[];
{
  FILE *fd;
  DIR *dp;
  struct dirent *actdir;
  int i=0,j=1;
  unsigned char s[STRING];
  extern struct TINF FINF2[MAX_FILE_BBS];
  extern int Anz_BBS_Entry; 
 
  Anz_BBS_Entry=0;
  sprintf(s,"%s/%s",pnam,SF_OWL);

  strcpy(FINF2[0].name,"");
  if ((fd=fopen(s,"r"))!=NULL)
  {
#ifdef NEW_MAIN_OWL
    while ((fgets(FINF2[j].name,80,fd)!=NULL)&&(j+1<MAX_FILE_BBS))
    {
      if (PosZeichenS(FINF2[j].name)<SF_OWL_COMMENTAR)
      {
       j++; Anz_BBS_Entry++; 
      }
    }
#endif  
    fclose(fd);    
    i=1;
  }  
  return (i);
}




/* Testet auf vorhandensein einer Beschreibungs-Datei im CDROM-Pfad */
int TestOwlMain(p)
unsigned char p[];
{
  FILE *fd;
  int i=0;
  unsigned char s[STRING];
  extern int EXT_INDEX;
  
 
  if (!EXT_INDEX) sprintf(s,"%s/%s/%s/%s",HOME,DHOME,p,SF_OWL_DIR0);
     else {
              sprintf(s,"%s/%s",p,SF_OWL_DIR0);
              strcpy(s,(char *) leer2slash(s));
          }
#ifdef INDEX_DEBUG   
 printf("Test_OWL-FILE: %s\n",s);
#endif
  if ((fd=fopen(s,"r"))!=NULL)
  {
    fclose(fd);
    i=1;
  }
  
  return (i);
}




/* Liest Info-Eintraege aus OWL-CDROM */
UNSIGNED char *READ_OWL_MAIN(p,s)
unsigned char p[],s[];
{
  static unsigned char b[STRING];
  unsigned char t[STRING];
  FILE *fd;
  int ok=0;
  extern int EXT_INDEX;

 strcpy(b,"");   
 
 if (!EXT_INDEX) sprintf(t,"%s/%s/%s/%s",HOME,DHOME,p,SF_OWL_DIR0); 
   else  {
              sprintf(t,"%s/%s",p,SF_OWL_DIR0); 
              strcpy(t,(char *) leer2slash(t));
          }
#ifdef INDEX_DEBUG   
 printf("READ_OWL-FILE: %s\n",t);
#endif
 if ((fd=fopen(t,"r"))!=NULL)
  {
     sprintf(t,"%s%s","dir",nums(s));     
     while ((fgets(b,80,fd)!=NULL)&&(strpos(t,touppers(b))==0))
     {
      
     }
     fclose(fd);
     if (strpos(t,touppers(b))) ok=1;
  };    
  if (!ok) strcpy(b,"");    
    else strcpy(b,(char *) str_fill(b,33));
 return (UNSIGNED char *) b;
}




/* Liest Info-Eintraege aus OWL-CDROM */
UNSIGNED char *READ_OWL(p,s)
unsigned char p[],s[];
{
  static unsigned char b[STRING];
  unsigned char t[STRING];
  int j=0;
  FILE *fd;
  extern int CDROM_ON;
  extern unsigned char CDNAME[LOW_STRING]; /* cd-Name-ID */
  extern int EXT_INDEX;
  extern struct TINF FINF2[MAX_FILE_BBS];
  extern int Anz_BBS_Entry; 

 strcpy(b,"");   
 
 sprintf(t,"%s/%s/%s/%s",HOME,DHOME,p,SF_OWL);

 if (!EXT_INDEX) sprintf(t,"%s/%s/%s/%s",HOME,DHOME,p,SF_OWL); 
   else  {
              sprintf(t,"%s/%s",p,SF_OWL); 
              strcpy(t,(char *) leer2slash(t));
          }


#ifndef NEW_MAIN_OWL
 if ((fd=fopen(t,"r"))!=NULL)
  {
      
     while ((fgets(b,80,fd)!=NULL)&&(strpos(s,touppers(b))==0))
     {
      
     }
     fclose(fd);
  } else strcpy(b,"");    
#else

 
     while ((j<Anz_BBS_Entry)&&(strpos(s,touppers(FINF2[j].name))==0))
     {
 		j++;     
 		strcpy(b,(char *) FINF2[j].name);
     }
#endif  
  
 return (UNSIGNED char *) snip_OWL_nam(b);
}





/* Liest Info-Eintraege aus simtel-CDROM */
UNSIGNED char *READ_SIM(p,s)
unsigned char p[],s[];
{
  static unsigned char b[STRING];
  unsigned char t[STRING];
  int j=0,ok=0;
  FILE *fd;
  extern int CDROM_ON;
  extern unsigned char CDNAME[LOW_STRING]; /* cd-Name-ID */
  extern int EXT_INDEX;
  extern struct TINF FINF2[MAX_FILE_BBS];
  extern int Anz_BBS_Entry; 

 strcpy(b,"");   
 
 sprintf(t,"%s/%s/%s/%s",HOME,DHOME,p,SF_SIM);

 if (!EXT_INDEX) sprintf(t,"%s/%s/%s/%s",HOME,DHOME,p,SF_SIM); 
   else  {
              sprintf(t,"%s/%s",p,SF_SIM); 
              strcpy(t,(char *) leer2slash(t));
          }


#ifndef NEW_MAIN_SIM
 if ((fd=fopen(t,"r"))!=NULL)
  {
      
     while ((fgets(b,80,fd)!=NULL)&&(!(ok=strpos(s,touppers(b)))))
     {
      
     }
     fclose(fd);
  } else strcpy(b,"");    
#else

 
     while ((j<Anz_BBS_Entry)&&(strpos(s,touppers(FINF2[j].name))==0))
     {
 		j++;     
 		strcpy(b,(char *) FINF2[j].name);
     }
#endif
if (!ok) {  
   strcpy(b,"");
   return (UNSIGNED char *) (b);
  }
  else return (UNSIGNED char *) snip_SIM_nam(b);  
  
}


/* Liest Info-Eintraege aus simtel-CDROM-DIR */
UNSIGNED char *READ_SIMDIR(p,s)
unsigned char p[],s[];
{
  static unsigned char b[STRING];
  unsigned char t[STRING];
  int j=0, ok=0;
  FILE *fd;
  extern int CDROM_ON;
  extern unsigned char CDNAME[LOW_STRING]; /* cd-Name-ID */
  extern int EXT_INDEX;
  extern struct TINF FINF2[MAX_FILE_BBS];
  extern int Anz_BBS_Entry; 

 strcpy(b,"");   
 
 sprintf(t,"%s/%s/%s/%s",HOME,DHOME,p,SF_SIM);

 if (!EXT_INDEX) sprintf(t,"%s/%s/%s/%s",HOME,DHOME,p,SF_SIMDIR); 
   else  {
              sprintf(t,"%s/%s",p,SF_SIMDIR); 
              strcpy(t,(char *) leer2slash(t));
          }


#ifndef NEW_MAIN_SIM
 if ((fd=fopen(t,"r"))!=NULL)
  {
      
     while ((fgets(b,80,fd)!=NULL)&&(!(ok=strpos(s,touppers(b)))))
     {
      
     }
     fclose(fd);
  } else strcpy(b,"");    
#else

 
     while ((j<Anz_BBS_Entry)&&(strpos(s,touppers(FINF2[j].name))==0))
     {
 		j++;     
 		strcpy(b,(char *) FINF2[j].name);
     }
#endif  
 if (!ok) {  
   b[0]=0;
   return ((UNSIGNED char *) b);
  }
  else return (UNSIGNED char *) snip_SIMDIR_nam(b);
}











/* Fgt Eintraege in Info-lib ein  */
void INSERT_LIB(p,s,info)
unsigned char p[],s[],info[];
{
  unsigned char b[STRING];
  FILE *fd;
  extern int CDROM_ON;
  int E ;
  extern unsigned char CDNAME[LOW_STRING]; /* cd-Name-ID */
   
if (CDROM_ON)
 { 
  E=0;
  sprintf(b,"%s/%s/%s.dir",HOME,CDROM_INFDIR,CDNAME);
  chdir(b);
  strcpy(b,p);
  strcpy(b,(char *) slash2leer(b));
  strcpy(b,(char *) cut_arg(b));
  while (strlen(b)!=0)
  {
    mkdir(s_nam(b),0777);
    chdir(s_nam(b));
    strcpy(b,(char *) cut_arg(b));
  } 
  
  
  strcat(s,INF);
  if ((fd=fopen(s,"w"))!=NULL)
  {
     fprintf(fd,"%s",info);
     fclose(fd);
  }
  
  chdir(HOME);
 } else 
 {  /* normales Archiv/Verzeichnis */
  E=0;
  sprintf(b,"%s/%s",HOME,DHOME);
  chdir(b);
  strcpy(b,p);
  strcpy(b,(char *) slash2leer(b));
  while (strlen(b)!=0)
  {
    /* mkdir(s_nam(b),0777);  ?????? */
    chdir(s_nam(b));
    strcpy(b,(char *) cut_arg(b));
  } 
  
  strcat(s,INF);
  if ((fd=fopen(s,"w"))!=NULL)
  {
     fprintf(fd,"%s",info);
     fclose(fd);
  }
  
  chdir(HOME);   
   
 }
}


/* Fgt Eintraege in Info-lib bei MBOX-PD-Soft ein  -Spezial-Behandlung- */
void INSERT_MBOX_LIB(p,name,info,mode)
unsigned char p[],info[],name[];
int mode;
{
  unsigned char b[STRING];
  FILE *fd;
  int E ;
  int s;

if (!((mode==sfile)||(mode==slnfile)))
{   /* es ist ein File */
  E=0;
  sprintf(b,"%s/%s",NEWSPDHOME,p);
  chdir(b);
  sprintf(b,"%s%s",name,INF);
  if ((fd=fopen(b,"w"))!=NULL)
  {
     fprintf(fd,"%s",info);
     fclose(fd);
  }
  chdir(HOME);   
} /* if mode.. */
else 
{  /* ist o.k.  --->  */
  E=0; s=atoi(name);
  sprintf(b,"%s/%s",NEWSPDHOME,p);
  chdir(b);
  sprintf(b,"%d%s",s,INF);
  if ((fd=fopen(b,"w"))!=NULL)
  {
     fprintf(fd,"%s",info);
     fclose(fd);
  }
  chdir(HOME);   

}
   
}






#if defined( _SCO ) || defined( _SINIX )

usleep( usec )
unsigned long usec;
{
  int i;

  for(i = 0; i < usec; i++);  /* Isn't there any sort of "usleep" at SCO? */

}

#endif


/* #MS - Sleep a few milliseconds [t].

   This was written by:

   Richard Tobin,                  JANET: R.Tobin@uk.ac.ed             
   AI Applications Institute,       ARPA: R.Tobin%uk.ac.ed@nsfnet-relay.ac.uk
   Edinburgh University.            UUCP: ...!ukc!ed.ac.uk!R.Tobin

   
   For LINUX by:

   Jan Niehusmann		  USENET: jan@gondor.gun.de

*/

void msleep(t)	
int t;
{
#ifdef _MINIX 

   int s, f;

   f = (t * 15 + 500) / 1000;

   s = f / 15; f = f % 15;
   sleep(s + 787410671 * f);
#else
   usleep(t * 1300);
#endif
}




/* #SC - Write the output [cmdline] like a new user ;-) */

void scribble( cmdline )
UNSIGNED char cmdline[];
{
  int i = 0;
  int r = 0;

  int a, b = 9999;
  int j;



  while(cmdline[i] != 0){
	r = (rand() % 35) + 1;
	
	if(cmdline[i] < 'B') r = 20;
	if((cmdline[i] > 'Y') && (cmdline[i] < 'b')) r = 20;

	if(r == 1){
		printf("%c", cmdline[i] - 1);
		msleep( ( (100/SCRIBBLE_C) + ((rand() % 800)/SCRIBBLE_C)) );
		printf("%c", BS);
	}
	if(r == 2){
		if((strlen(cmdline) - 2) > i){
			printf("%c", cmdline[i + 2]);
			msleep( ((100 + (rand() % 40))/SCRIBBLE_C) );
			printf("%c", cmdline[i + 1]);
			msleep( ((100 + (rand() % 400))/SCRIBBLE_C) );	
			printf("%c", BS);
			msleep( ((100 + (rand() % 10))/SCRIBBLE_C) );
			printf("%c", BS);
		}
	}
	if((r == 3) && (b == 9999)){
		if((strlen(cmdline) > 30) && (i < 20)){
			printf("%c", cmdline[i + 1]);
			msleep( ((100 + (rand() % 40))/SCRIBBLE_C) );
			a = i;
			b = i + 7;
		}  
	}	
	if(i == b){
		msleep( (200 + (rand() % 200)) );
		for(j = 0; j < 8; j++){
			printf("%c", BS);
			msleep(((40 + (rand() % 40))/SCRIBBLE_C) );
		}
		i = a;
		b = 9999;
	}

	printf("%c", cmdline[i]);

	if(((i % 5) == 5) || (cmdline[i] == ',') || (cmdline[i] == ' ') ||
	    (cmdline[i] != cmdline[i+1])){
		msleep(( (50 + (rand() % 100))/SCRIBBLE_C) );
	}
	else{
		msleep( ((30 + (rand() % 50)))/SCRIBBLE_C );		
	}

	i++;
  }
}


