#undef NCURSES
#undef DEBUG
#define DEBUG2



#include <sys/wait.h>

#include <dirent.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>

#include <time.h>
#include <fcntl.h>



#include <sys/stat.h>
#include <dirent.h>
#include <sys/timeb.h>
#include <signal.h>
#include "../mbox.h"


#include "../s_global.h"
#include "../rip.h"
#include "../rip.error.h"


#ifdef VGA_GRAFIK

char old_cmd[STRING];
#define BADRIPCMD_LOG
struct rip_cmd_typ rip_cmd;
struct font_t font;
int RIP_TEST=0;
extern view_font();
#endif /*VGA_GRAFIK*/

void ripterm_init()
{
#ifdef VGA_GRAFIK
extern unsigned char WHATIS[];
  strcpy(old_cmd,"");
  strcpy(WHATIS,"menue");
#endif
}


/* herausloesen der RIP-CMD-Zeile */
void get_rip_cmd(cmd)
struct rip_cmd_typ *cmd;
{
  int  i = 0,j; 
#ifdef VGA_GRAFIK
  cmd->ansi=0;
  if (strpos("!|",cmd->zeile)==1)
  { 
   strcpy(cmd->cmd,"!|");
   strcpy(cmd->rest,"!");
  } else
  {
   strcpy(cmd->cmd,cmd->zeile);
   strcpy(cmd->rest,"");
  }
  
  while ((cmd->zeile[i]!=124 /*|*/)&&(cmd->zeile[i]!='\0')) i++;
  i++;  j=2;
  while ((cmd->zeile[i]!=124 /*|*/)&&(cmd->zeile[i]!='\0'))
  {
   if (cmd->zeile[i]!=124 /*|*/)
   {
    cmd->cmd[j]=(unsigned char *) cmd->zeile[i];
    j++;  i++;
   }
  }
  cmd->cmd[j]='\0';
  j=1; 
  while (cmd->zeile[i]!='\0')
  {
    cmd->rest[j]=(unsigned char *) cmd->zeile[i];
    j++;  i++;
  }
  if (j!=1)  cmd->rest[j]='\0'; else   cmd->rest[0]='\0';
#endif /* VGA_GRAFIK  */
}



void BadRipCmd(err,t,vt,cmd)
unsigned char *err[],*t[],*vt[];
struct rip_cmd_typ *cmd;
{ 
extern unsigned char WHATIS[];
 FILE *fd;
#ifdef VGA_GRAFIK 
#ifdef BADRIPCMD_LOG
#ifdef DEBUG 
 printf("\n%s: %s\n",err,t);
#endif 
 if ((fd=fopen(BAD_RIPTERM_CMD,"a"))!=NULL)
 {
   fprintf(fd,"%s - %s : %s\n",mytime(1),WHATIS,err);
   fprintf(fd,"cmd: %s\n%s\n\n",vt,cmd->zeile);
   fclose(fd);
 }
#endif
#endif /* VGA_GRAFIK*/
}




/* 'druckt' die Rip-Zeile auf SVGA-Bildschirm */
int print_rip(z)
unsigned char *z[];
{
unsigned char /*cmd[STRING],*/   h[STRING];
struct rip_cmd_typ rip_cmd;
int i,x,y;

#ifdef VGA_GRAFIK
strcpy(rip_cmd.zeile,z);
get_rip_cmd(&rip_cmd);
if (rip_cmd.cmd[0]=='\!')
{
   do
   { 
    if (rip_cmd.cmd[1]== '\|')    
    {
      strcpy(rip_cmd.cmd,s_copy(rip_cmd.cmd,3,strlen(rip_cmd.cmd)));
      RipLevel(&rip_cmd);
      if (RipBefehl(&rip_cmd)) rip_cmd.ansi=1;
    } else
    if (rip_cmd.cmd[1]== '\*')    
    {
	  /*RIP_RESET_WINDOWS Clear Graphics/Text Windows & reset to full screen */
     	  C_Log("RIP_RESET_WINDOWS()",rip_cmd.zeile,0,0,0,0,0,0,0);
	  GrClearScreen(GrBlack());         
    }
    else {
      BadRipCmd(NO_DEL,s_copy(rip_cmd.cmd,2,strlen(rip_cmd.cmd)),rip_cmd.cmd,&rip_cmd); /* no delimiter */
    }
    if ((rip_cmd.ansi)&&(strlen(rip_cmd.cmd))) {
     /* RAW-TEXT */
        BadRipCmd("print_ansi()",s_copy(rip_cmd.cmd,1,strlen(rip_cmd.cmd)),rip_cmd.cmd,&rip_cmd); 
    }
    strcpy(rip_cmd.zeile,rip_cmd.rest);
    get_rip_cmd(&rip_cmd);
   } while (rip_cmd.cmd[1]== '\|');
}
 else 
 {/* RAW-TEXT */
  if (strlen(rip_cmd.zeile))
   BadRipCmd(BAD_RIPCMD,s_copy(rip_cmd.cmd,1,strlen(rip_cmd.cmd)),rip_cmd.cmd,&rip_cmd); 
 }
#endif /* VGA_GRAFIK */
} /* end print_rip */







/*  
          !|L     RIPscrip Level-0 Command "L"
         !|1L     RIPscrip Level-1 Command "L"
        !|15L     RIPscrip Level-1, sub-level 5 Command "L"
*/
void RipLevel(cmd)
struct rip_cmd_typ *cmd;
{
int i;


#ifdef VGA_GRAFIK

i=(unsigned char*) cmd->cmd[0];
i=i-48;
if ((i<0)||(i>9)) cmd->lev=0;
    else cmd->lev=i;
if (cmd->lev)
{
i=(unsigned char*) cmd->cmd[1];
i=i-48;
if ((i<0)||(i>9)) cmd->sublev=0;
    else cmd->sublev=i;
} else cmd->sublev=0;
if (cmd->sublev!=0) strcpy(cmd->cmd,s_copy(cmd->cmd,3,strlen(cmd->cmd))); 
  else 
if (cmd->lev!=0) strcpy(cmd->cmd,s_copy(cmd->cmd,2,strlen(cmd->cmd))); 
  else 
  strcpy(cmd->cmd,s_copy(cmd->cmd,1,strlen(cmd->cmd))); 
#endif /* VGA_GRAFIK  */
}



int GetRipNum(cmd,anz)
struct rip_cmd_typ *cmd;
int anz;
{
int i,a,s=0;

#ifdef VGA_GRAFIK
 /*ripio_putchar("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"[value%36]);*/
if (strlen(cmd->cmd)<anz)  {
  cmd->ansi=1;
  return(-1);
 }
 for (i=0;i<anz;i++)
 {
       a=(unsigned char *) cmd->cmd[i];
#ifdef DEBUG       
       printf(" %c=%d ",cmd->cmd[i],a);
#endif       
       if ((a>47)&&(a<58)) a=a-48;
        else a=a-64+9;
#ifdef DEBUG        
      printf(" | %c=%d ",cmd->cmd[i],a);
#endif      
      s=(s*36)+a;
 }
 strcpy(cmd->cmd,s_copy(cmd->cmd,anz+1,strlen(cmd->cmd))); 
 return(s);
#endif /* VGA_GRAFIK */
}






void RipBefehl(cmd)
struct rip_cmd_typ *cmd;
{
int i;

#ifdef  VGA_GRAFIK
i=(unsigned char*) cmd->cmd[0];
if ((!((i<48)||(i>122))) || (i==42 /* "*" */)||(i==61 /* "=" */)
	||(i==64 /* "@" */)) {
   cmd->bef=(unsigned char *) cmd->cmd[0];
   strcpy(cmd->cmd,s_copy(cmd->cmd,2,strlen(cmd->cmd))); 
  }
  else cmd->ansi=1;
if (!cmd->ansi) RipBefehlLoop(cmd);
#endif
}




int RipBefehlLoop(cmd)
struct rip_cmd_typ *cmd;
{
int i;

#ifdef  VGA_GRAFIK
 switch (cmd->bef)
 {
 /* LEVEL 0 */
    case 'w': /* RIP_TEXT_WINDOW */
          RIP.twin[1]=GetRipNum(cmd,2);
          RIP.twin[2]=GetRipNum(cmd,2);
          RIP.twin[3]=GetRipNum(cmd,2);
          RIP.twin[4]=GetRipNum(cmd,2);
          RIP.wrap=GetRipNum(cmd,1);
	  RIP.fontsize=GetRipNum(cmd,1);
          break;
     case 'v': /* RIP_VIEWPORT - Define the size & location of the Graphics Window */
          RIP.gwin[1]=GetRipNum(cmd,2);
          RIP.gwin[2]=GetRipNum(cmd,2);
          RIP.gwin[3]=GetRipNum(cmd,2);
          RIP.gwin[4]=GetRipNum(cmd,2);
          GrSetClipBox(RIP.gwin[1],RIP.gwin[2],RIP.gwin[3],RIP.gwin[4]);
          C_Log("RIP_VIEWPORT()",cmd->zeile,RIP.gwin[1],RIP.gwin[2],RIP.gwin[3],RIP.gwin[4],0,0);
          break;
          
     case '*': /*RIP_RESET_WINDOWS Clear Graphics/Text Windows & reset to full screen */
     	  C_Log("RIP_RESET_WINDOWS()",cmd->zeile,0,0,0,0,0,0,0);
	  GrClearScreen(GrBlack());     
          break;
          
     case 'e': /* RIP_ERASE_WINDOW Clear Text Windows with Background Color */
          break;
     case 'E': /* RIP_ERASE_VIEW  - Clear Graphic-Windows with Background Color */
     	  C_Log("RIP_ERASE_VIEW()",cmd->zeile,RIP.bk_color->id,0,0,0,0,0,0);
     	  GrClearClipBox(RIP.bk_color->id);     
          break;
     case 'g': /* RIP_GOTOXY (TEXT) - Move text cursor to row & column in Text Window */
     	  cmd->i[1]=GetRipNum(cmd,2); /* x*/
          cmd->i[2]=GetRipNum(cmd,2); /* y */
          break;
     case 'H': /* RIP_HOME (TEXT) - Cursor to upper left corner*/
          break;
     case '>': /* RIP_ERASE_EOL (TEXT) - Erase current line from cursor to end of line*/
     	  /* vor Pos bis Ende der Zeile */
          break;
     case 'c': /* RIP_COLOR (GRAPH) - Set current Drawing Color for graphics*/
     	  RIP.gwin[5]=GetRipNum(cmd,2);
     	  SetColor(RIP.cur_color,RIP.gwin[5]);
     	  C_Log("RIP_SETCOLOR()",cmd->zeile,RIP.gwin[5],0,0,0,0,0,0);
          break; /* >OK< */
     case 'Q': /*RIP_SET_PALETTE-Set 16-color Palette from master 64-color palette*/
          for (i=1; i<=16;i++)
           RIP.c[1]=GetRipNum(cmd,2);
          break;
     case 'a': /*RIP_ONE_PALETTE-Set one 16-color Palette from master 64-color palette*/
          i=GetRipNum(cmd,2);
          if ((i<17)&&(i>0)) RIP.c[i]=GetRipNum(cmd,2);
          break;
     case 'W': /*RIP_WRITE_MODE- Set Drawing-Mode */
          i=GetRipNum(cmd,2);
          if ((i<2)&&(i>-1)) RIP.draw_mode=i;
          /*
          	00     Normal drawing mode (overwrite)
     		01     XOR (complimentary) mode
     	  */
          break;
     case '=': /*RIP_LINE_STYLE- Set LINE-SYLE */
          i=GetRipNum(cmd,2);
          if ((i>-1)&&(i<5)) RIP.line[1]=i;
           else cmd->ansi=1;
          i=GetRipNum(cmd,4);
          RIP.line[1]=i;
          i=GetRipNum(cmd,2);
          if ((i>0)&&(i<5)) RIP.line[1]=i;
           else cmd->ansi=1;
          RIP.line[1]=i;
          break;
     case 'm': /*RIP_MOVE- Set current drawing pos. to x,y*/
          cmd->i[1]=GetRipNum(cmd,2);
          cmd->i[2]=GetRipNum(cmd,2);
          break;
     case 'Y': /*RIP_FONT_STYLE - Set current FONT*/
          i=GetRipNum(cmd,2);
          font.font=i;
          i=GetRipNum(cmd,2);
          font.dir=i;
          i=GetRipNum(cmd,2);
          font.size=i;
          i=GetRipNum(cmd,2);
          font.res=i;
          break;
     case 'T': /* RIP-Text (TEXT) */
          /*!|Thello world*/
          break;
     case '@': /* RIP-Text-XY (TEXT)  - text on x,y*/
          /*!|@0021hello world*/
          cmd->i[1]=GetRipNum(cmd,2);
          cmd->i[2]=GetRipNum(cmd,2)*450/350;
          C_Log("RIP_TEXT()",cmd->rest,cmd->i[1],cmd->i[2],0,0,0,0,0);
          view_font(cmd->cmd,cmd->i[1],cmd->i[2]);
          break;
     case 'X': /* RIP-PIXEL (GRAPH)  - draw pixel */
          cmd->i[1]=GetRipNum(cmd,2);
          cmd->i[2]=GetRipNum(cmd,2)*450/350;
          C_Log("RIP_PIXEL()",cmd->zeile,cmd->i[1],cmd->i[2],RIP.cur_color->id,0,0,0,0);
          GrPlot(cmd->i[1],cmd->i[2],RIP.cur_color->id);
          break;/*<OK>*/
     case 'L': /* RIP-LINE (GRAPH)  - draw line */
          cmd->i[1]=GetRipNum(cmd,2);
          cmd->i[2]=GetRipNum(cmd,2)*450/350;
          cmd->i[3]=GetRipNum(cmd,2);
          cmd->i[4]=GetRipNum(cmd,2)*450/350;
          C_Log("RIP_LINE()",cmd->zeile,cmd->i[1],cmd->i[2],cmd->i[3],cmd->i[4],RIP.cur_color->id,0,0);
          GrLine(cmd->i[1],cmd->i[2],cmd->i[3],cmd->i[4],RIP.cur_color->id);
          /*GrPatternedLine(cmd->i[1],cmd->i[2],cmd->i[3],cmd->i[4],RIP.cur_color->id,
          	&RIP.line_opt);*/
          break; /*<OK>*/
     case 'R': /* RIP-RECTANGLE (GRAPH)  - draw rec */
          cmd->i[1]=GetRipNum(cmd,2);
          cmd->i[2]=GetRipNum(cmd,2)*450/350;
          cmd->i[3]=GetRipNum(cmd,2);
          cmd->i[4]=GetRipNum(cmd,2)*450/350;
          C_Log("RIP_RECTANGLE()",cmd->zeile,cmd->i[1],cmd->i[2],cmd->i[3],cmd->i[4],RIP.cur_color->id,0,0);
          GrBox(cmd->i[1],cmd->i[2],cmd->i[3],cmd->i[4],RIP.cur_color->id);
          break;/*<OK>*/
    case 'B': /* RIP-BAR (GRAPH)  - draw filled rec */
          cmd->i[1]=GetRipNum(cmd,2);
          cmd->i[2]=GetRipNum(cmd,2)*450/350;
          cmd->i[3]=GetRipNum(cmd,2);
          cmd->i[4]=GetRipNum(cmd,2)*450/350;
          C_Log("RIP_BAR()",cmd->zeile,cmd->i[1],cmd->i[2],cmd->i[3],cmd->i[4],RIP.cur_color->id,0,0);
          GrFilledBox(cmd->i[1],cmd->i[2],cmd->i[3],cmd->i[4],RIP.cur_color->id);
          break;	/*<OK>*/
    case 'C': /* RIP-CIRCLE (GRAPH)  - draw circle */
          cmd->i[1]=GetRipNum(cmd,2);   /* rx */
          cmd->i[2]=GetRipNum(cmd,2)*450/350;   /* ry */
          cmd->i[3]=GetRipNum(cmd,2);   /* r */
          C_Log("RIP_CIRCLE()",cmd->zeile,cmd->i[1],cmd->i[2],cmd->i[3],RIP.cur_color->id,0,0,0);
          GrCircle(cmd->i[1],cmd->i[2],cmd->i[3],RIP.cur_color->id);
          break;	/*<OK>*/
    case 'O': /* RIP-OVAL (GRAPH)  - draw elliptic arc */
          cmd->i[1]=GetRipNum(cmd,2);   /* rx */
          cmd->i[2]=GetRipNum(cmd,2)*450/350;   /* ry */
          cmd->i[3]=GetRipNum(cmd,2);   /* st_ang */
          cmd->i[4]=GetRipNum(cmd,2);   /* end_ang*/
          cmd->i[5]=GetRipNum(cmd,2);   /* x_rad */
          cmd->i[6]=GetRipNum(cmd,2)*450/350;   /* y_rad */
          C_Log("RIP_OVAL()",cmd->zeile,cmd->i[1],cmd->i[2],cmd->i[3],
          	cmd->i[4],cmd->i[5],cmd->i[6],
          	RIP.cur_color->id);
          GrEllipseArc(cmd->i[1],cmd->i[2],cmd->i[3],
          		cmd->i[4],cmd->i[5],cmd->i[6],
          		RIP.cur_color->id);
          break;	/* <OK>*/
    case 'o': /* RIP-FILLED_OVAL (GRAPH)  - draw elliptic arc (filled)*/
          cmd->i[1]=GetRipNum(cmd,2);   /* rx */
          cmd->i[2]=GetRipNum(cmd,2)*450/350;   /* ry */
          cmd->i[3]=GetRipNum(cmd,2);   /* st_ang */
          cmd->i[4]=GetRipNum(cmd,2);   /* end_ang*/
          cmd->i[5]=GetRipNum(cmd,2);   /* x_rad */
          cmd->i[6]=GetRipNum(cmd,2)*450/350;   /* y_rad */
          C_Log("RIP_FILLED_OVAL()",cmd->zeile,cmd->i[1],cmd->i[2],cmd->i[3],
          	cmd->i[4],cmd->i[5],cmd->i[6],
          	RIP.cur_color->id);
          GrFilledEllipseArc(cmd->i[1],cmd->i[2],cmd->i[3],
          		cmd->i[4],cmd->i[5],cmd->i[6],
          		RIP.cur_color->id);
          break;	/* <OK>*/
     case 'A': /* RIP-ARC (GRAPH)  - draw circ. arc */
          cmd->i[1]=GetRipNum(cmd,2);   /* rx */
          cmd->i[2]=GetRipNum(cmd,2)*450/350;   /* ry */
          cmd->i[3]=GetRipNum(cmd,2);   /* st_ang */
          cmd->i[4]=GetRipNum(cmd,2);   /* end_ang*/
          cmd->i[5]=GetRipNum(cmd,2)*450/350;   /* r */
          C_Log("RIP_ARC()",cmd->zeile,cmd->i[1],cmd->i[2],cmd->i[3],
          	cmd->i[4],cmd->i[5],
          	RIP.cur_color->id,0);
          GrCircleArc(cmd->i[1],cmd->i[2],cmd->i[3],
          		cmd->i[4],cmd->i[5],RIP.cur_color->id);
          break;	/* <OK>*/
     case 'V': /* RIP-OVAL-ARC (GRAPH)  - draw ellipt. arc */
          cmd->i[1]=GetRipNum(cmd,2);   /* rx */
          cmd->i[2]=GetRipNum(cmd,2)*450/350;   /* ry */
          cmd->i[3]=GetRipNum(cmd,2);   /* st_ang */
          cmd->i[4]=GetRipNum(cmd,2);   /* end_ang*/
          cmd->i[5]=GetRipNum(cmd,2);   /* radx */
          cmd->i[6]=GetRipNum(cmd,2)*450/350;   /* rady */
          C_Log("RIP_OVAL-ARC()",cmd->zeile,cmd->i[1],cmd->i[2],cmd->i[3],
          	cmd->i[4],cmd->i[5],cmd->i[6],
          	RIP.cur_color->id,0);
          GrEllipseArc(cmd->i[1],cmd->i[2],cmd->i[3],
          		cmd->i[4],cmd->i[5],cmd->i[6],RIP.cur_color->id);
          break;	
    case 'I': /* RIP-PIE_SLICE (GRAPH)  - draw circ. pie slice */
          cmd->i[1]=GetRipNum(cmd,2);   /* rx */
          cmd->i[2]=GetRipNum(cmd,2);   /* ry */
          cmd->i[3]=GetRipNum(cmd,2);   /* st_ang */
          cmd->i[4]=GetRipNum(cmd,2);   /* end_ang*/
          cmd->i[5]=GetRipNum(cmd,2);   /* r */
          break;
    case 'i': /* RIP-PIE_SLICE (GRAPH)  - draw circ. pie slice */
          cmd->i[1]=GetRipNum(cmd,2);   /* rx */
          cmd->i[2]=GetRipNum(cmd,2);   /* ry */
          cmd->i[3]=GetRipNum(cmd,2);   /* st_ang */
          cmd->i[4]=GetRipNum(cmd,2);   /* end_ang*/
          cmd->i[5]=GetRipNum(cmd,2);   /* r */
          break;
    case 'S': /* RIP_FILL_STYLE */
    	  cmd->i[1]=GetRipNum(cmd,2);   /* pattern  */
          cmd->i[2]=GetRipNum(cmd,2);   /* color */
    	  break;
     case 'p': /* RIP_FILL_POLYGON */
    	  cmd->i[1]=GetRipNum(cmd,2);   /* pattern  */
          cmd->i[2]=GetRipNum(cmd,2);   /* color */
    	  break;
    default:
          return(1);
          break;
  }
  return(0);
#endif /*  VGA_GRAFIK  */
}



void C_Log(t,t2,a1,a2,a3,a4,a5,a6,a7)
char *t[],*t2[];
int a1,a2,a3,a4,a5,a6,a7;
{
FILE *fd;
fd=fopen("/tmp/riptest.log","a");
fprintf(fd,"---\n%s\%s\n%d,%d,%d,%d,%d,%d,%d\n",t,t2,a1,a2,a3,a4,a5,a6,a7);
fclose(fd);
}