#define const

/* ripcal.c: RIP calendar
 *
 * Eric P. Scott, San Francisco State University, January 1994
 * Copyright 1994 by Eric P. Scott.  All rights reserved.
 *
 * This software is "freeware" but is not in the public domain.
 *
 * The author grants you a nonexclusive royalty-free license to copy,
 * redistribute, and use this software for any purpose provided that
 * source distributions retain this entire copyright and license.
 * You may not sublicense or distribute modified versions to anyone else
 * except as part of another product or program, and modified versions
 * must be so labeled.
 *
 * You are encouraged to give proper credit to the author in binary
 * distributions and associated documentation.
 *
 * This software is provided "as is" with no warranties of any kind,
 * including the warranties of merchantability and fitness for a
 * particular purpose.
 *
 * RIPscrip is a trademark of TeleGrafix Communications, Inc.
 *
 * This software is not supported or endorsed by TeleGrafix.
 *
 */

/* Revision History
 *
 * 1.0  2/24/94  EPS  Initial Release
 * 1.1  4/12/94  EPS  fixed #includes for Solaris, .tm_isdst for mktime()
 *
 */

#ifndef lint
/*static char sccsid[]="@(#)ripcal.c	1.1 (SFSU) 4/12/94";*/
#endif

#ifdef NX_COMPILER_RELEASE_3_0
#include <ansi/stdio.h>
#include <ansi/string.h>
#include <ansi/time.h>
#include <ansi/stdlib.h>
#else
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>
#include <unistd.h>
#endif
#include "ripwraps.h"

extern void SetRipLibClean();

const char * const months[]={
	"January", "February", "March", "April", "May", "June", "July",
	"August", "September", "October", "November", "December"
};



int rip_cal_main(int argc, char *argv[])
{
	register int i, x;
	int mdays;
	int cwday, cyday;
	int nwday, nyday;
	int pwday, pyday;
	int tmday;
	time_t now;
	struct tm tm;
	char buf[24];

	if (argc!=1&&argc!=3) {
	usage:
		(void)fprintf(stderr, "Usage: %s month year\n", *argv);
		exit(1);
	}
	(void)time(&now);
	tm= *localtime(&now);
	tmday=tm.tm_mday;
	if (argc>=3) {
		i=atoi(argv[1]);
		if (i<1||i>12) goto usage;
		tm.tm_mon=i-1;
		i=atoi(argv[2]);
		if (i<1970||i>2037) {
			(void)fprintf(stderr,
"%s: year must be between 1970 and 2037 inclusive\n",
				*argv);
			exit(1);
		}

		tm.tm_year=i-1900;
		tmday= -1;
	}
	tm.tm_mday=1;
	tm.tm_isdst= -1;	/* SysV */
	(void)mktime(&tm);
	cwday=tm.tm_wday;
	cyday=tm.tm_yday;
/*	printf("\n");*/
	/*SetRipLibClean();*/
	RipClean();
	rip_reset_windows();
	rip_text_window(0, 38, 79, 42, 1, 0);
	rip_fill_style(RIP_SOLID_FILL, RIP_BROWN);
	rip_bar(0, 0, 639, 104);
	rip_color(RIP_WHITE);
	rip_font_style(RIP_TRIPLEX_SCRIPT_FONT, RIP_HORIZ_DIR, 4, 0);
	rip_text_xy(192, 0, (char *) months[tm.tm_mon]);
	(void)sprintf(buf, "%d", tm.tm_year+1900);
	rip_text_xy(372, 34, buf);
	if (tm.tm_mon>=11) {
		tm.tm_mon=0;
		tm.tm_year++;
	}
	else tm.tm_mon++;
	tm.tm_isdst= -1;	/* SysV */
	(void)mktime(&tm);
	nwday=tm.tm_wday;
	nyday=tm.tm_yday;
	mdays=nyday-cyday;
	if (mdays<=0) mdays=31;
	rip_color(RIP_LIGHTRED);
	rip_font_style(RIP_TRIPLEX_FONT, RIP_HORIZ_DIR, 4, 0);
	rip_text_xy(17, 70, "Sun");
	rip_text_xy(107, 70, "Mon");
	rip_text_xy(201, 70, "Tue");
	rip_text_xy(291, 70, "Wed");
	rip_text_xy(381, 70, "Thu");
	rip_text_xy(480, 70, "Fri");
	rip_text_xy(569, 70, "Sat");
	rip_color(RIP_LIGHTBLUE);
	rip_line_style(RIP_SOLID_LINE, 0, RIP_THICK_WIDTH);
	rip_pixel(0, 105); rip_pixel(639, 105);
	rip_pixel(0, 299); rip_pixel(639, 299);
	rip_rectangle(1, 106, 638, 298);
	if (cwday>0) {
		rip_fill_style(RIP_SOLID_FILL, RIP_DARKGRAY);
		rip_bar(2, 107, 637-(7-cwday)*91, 137);
		rip_fill_style(RIP_SOLID_FILL, RIP_LIGHTGRAY);
		rip_bar(638-(7-cwday)*91, 107, 637, 137);
		i=138;
	}
	else {
		rip_fill_style(RIP_SOLID_FILL, RIP_LIGHTGRAY);
		i=107;
	}
	if (cwday+mdays>=35) {
		rip_bar(2, i, 637, 266);
		if (nwday>0) rip_bar(2, 267, 1+91*nwday, 297);
		rip_fill_style(RIP_SOLID_FILL, RIP_DARKGRAY);
		rip_bar(2+91*nwday, 267, 637, 297);
	}
	else if (nwday==0) {
		rip_bar(2, i, 637, 234);
		rip_fill_style(RIP_SOLID_FILL, RIP_DARKGRAY);
		rip_bar(2, 235, 637, 297);
	}
	else {
		rip_bar(2, i, 637, 234);
		if (nwday>0) rip_bar(2, 235, 1+91*nwday, 266);
		rip_fill_style(RIP_SOLID_FILL, RIP_DARKGRAY);
		rip_bar(2+91*nwday, 235, 637, 266);
		rip_bar(2, 267, 637, 297);
	}
	rip_line_style(RIP_SOLID_LINE, 0, RIP_NORM_WIDTH);
	i=4; do {
		x=266-i*32;
		rip_line(1, x, 638, x);
	} while (--i>=0);
	i=5; do {
		x=547-i*91;
		rip_line(x, 107, x, 297);
	} while (--i>=0);
	if (tmday>0) {
		rip_fill_style(RIP_SOLID_FILL, RIP_WHITE);
		tmday--;
		x=((cwday+tmday)%7)*91+2;
		i=((cwday+tmday)/7)*32+107;
		rip_bar(x, i, x+89, i+30);
	}
	rip_color(RIP_BLACK);
	rip_font_style(RIP_SMALL_FONT, RIP_HORIZ_DIR, 6, 0);
	for (i=0;i<mdays;i++) {
		x=((cwday+i)%7)*91+74;
		if (i<9) x+=10;
		(void)sprintf(buf, "%d", i+1);
		rip_text_xy(x, ((cwday+i)/7)*32+103, buf);
	}
	rip_fill_style(RIP_SOLID_FILL, RIP_LIGHTGRAY);
	rip_font_style(RIP_DEFAULT_FONT, RIP_HORIZ_DIR, 1, 0);
	tm.tm_mon-=2;
	if (tm.tm_mon<0) {
		tm.tm_mon+=12;
		tm.tm_year--;
	}
	if (tm.tm_year>=70) {
		tm.tm_isdst= -1;	/* SysV */
		(void)mktime(&tm);
		pwday=tm.tm_wday;
		pyday=tm.tm_yday;
		mdays=cyday-pyday;
		if (mdays<=0) mdays=31;
		rip_color(RIP_GREEN);
		rip_fill_polygon(4, 5, 6, 168, 6, 168, 72, 5, 72);
		(void)sprintf(buf, "%s %d", months[tm.tm_mon],
			tm.tm_year+1900);
		rip_color(RIP_DARKGRAY);
		rip_text_xy(32, 8, buf);
		rip_text_xy(16, 16, "S  M Tu  W Th  F  S");
		(void)strcpy(buf, "1  2  3  4  5  6  7");
		buf[(6-pwday)*3+1]='\0';
		rip_text_xy(pwday*24+16, 24, buf);
		for (i=7-pwday;i<mdays;i+=7) {
			(void)sprintf(buf, "%d %2d %2d %2d %2d %2d %2d",
				i+1, i+2, i+3, i+4, i+5, i+6, i+7);
			if (i+7>mdays) buf[(mdays-i)*3-1]='\0';
			rip_text_xy((i<9) ? 16 : 8, ((pwday+i)/7)*8+24, buf);
		}
	}
	tm.tm_mon+=3;
	if (tm.tm_mon>11) {
		tm.tm_mon-=12;
		tm.tm_year++;
	}
	if (tm.tm_year<=137||tm.tm_mon==0) {
		tm.tm_isdst= -1;	/* SysV */
		(void)mktime(&tm);
		mdays=tm.tm_yday-nyday;
		if (mdays<=0) mdays=31;
		tm.tm_mon--;
		if (tm.tm_mon<0) {
			tm.tm_mon+=12;
			tm.tm_year--;
		}
		rip_color(RIP_GREEN);
		rip_fill_polygon(4, 469, 6, 632, 6, 632, 72, 469, 72);
		(void)sprintf(buf, "%s %d", months[tm.tm_mon],
			tm.tm_year+1900);
		rip_color(RIP_DARKGRAY);
		rip_text_xy(496, 8, buf);
		rip_text_xy(480, 16, "S  M Tu  W Th  F  S");
		(void)strcpy(buf, "1  2  3  4  5  6  7");
		buf[(6-nwday)*3+1]='\0';
		rip_text_xy(nwday*24+480, 24, buf);
		for (i=7-nwday;i<mdays;i+=7) {
			(void)sprintf(buf, "%d %2d %2d %2d %2d %2d %2d",
				i+1, i+2, i+3, i+4, i+5, i+6, i+7);
			if (i+7>mdays) buf[(mdays-i)*3-1]='\0';
			rip_text_xy((i<9) ? 480 : 472, ((nwday+i)/7)*8+24,
				buf);
		}
	}
	rip_no_more();
	rip_no_more();
	rip_no_more();
	ripio_flush();
	(void)fflush(stdout);
	return(0);
}




void rip_cal()
{
char s[10];
  s[0]='\0';
  rip_cal_main(1 ,NULL);
}