  
#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include <time.h>
#include <unistd.h>
#include <strings.h>
#include <dirent.h>

#ifndef VU
#include "mbox.h"
#include "s_global.h"
#include "pm.c"
#else
#include "../mbox.h"
#include "../s_global.h"
#include "../pm.c"
#endif

#undef DEBUG





#define RET_NONE return (UNSIGNED char *) "Noe!"




/* archiviert ein tmp-verzeichnis, loescht (!) es /immer !!) und gibt 
   den Namen des tmp-Archives zurueck*/
UNSIGNED char *dir_archivieren( arg )
UNSIGNED char arg[];
{
  FILE *fp;
  int i, c;

  struct stat _fstat;

  UNSIGNED char s[4095];
static  UNSIGNED char t[STRING];
  UNSIGNED char packers[10][STRING];
  UNSIGNED char adds[10][STRING];
  UNSIGNED char tar[10][STRING];
  UNSIGNED char en[10][STRING];
  UNSIGNED char cd[LONGSTRING];

  int fpid;



if (strlen((char *) arg)<8)
{
 nerror("pd.c", 548, "dir_archiv", "name of tmp-dir to small (min 8char)", arg);
 exit(-6); /* kritischer Fehler !!!!!! */
}

if (chdir(arg)!=0)
{
 nerror("pd.c", 558, "dir_archiv", "Can't chdir :", arg);
 RET_NONE;
}

  headline( GetText("PD37_MSG") );
  printf("\n");

  sprintf(s, "%s/%s", ZOPT.OPT->HOME, PACKERS);
  fp = fopen(s, "r");
  if (fp == NULL) {
	nerror("pd.c", 495, "archivieren", "Can't read", s);
  }

  if(ZOPT.OPT->DOWN_PACK == 0) printf("  1 - Text/ASCII\n\n");
  strcpy(packers[1], (UNSIGNED char *) "cat");
  strcpy(adds[1], (UNSIGNED char *) "?");
  strcpy(tar[1], (UNSIGNED char *) "-");
  en[1][0] = 0;
 
  i = 1;
  while((fgets(s, 80, fp) != NULL) && (s[0] != '='));
  while((i < 10) && (fscanf(fp, "%s %s %s %s %s", s, packers[i], adds[i], tar[i], en[i]) > 0)){
	i++;
	if(ZOPT.OPT->DOWN_PACK == 0) printf("  %d - %s\n\n", i, s); 
  }
  fclose(fp);

  if(ZOPT.OPT->DOWN_PACK == 0){
	ansi2("md", 0, 0);
	printf("\n%s > ", GetText("PD38_MSG"));
	ansi2("me", 0, 0);

	c = getint();
	if(c > 32) printf("%c", c);
	c -= 49;

	if((c > i) || (c < 0)) RET_NONE;
	
	printf("\n\n");
  }
  else{
	c = ZOPT.OPT->DOWN_PACK - 1;
  }

  
  printf("%s .", GetText("PD39_MSG"));

  switch( (ZOPT.OPT->login_pid= fpid = fork()) ){
	case -1 :
		break;
	case  0 : 
		while(1){
			printf(".");
			sleep(1);
		}	
		break;
  }

  strcpy(cd, (UNSIGNED char *) arg);

   chdir(cd);
printf("\nMove to archive......\n%c",CR); 
    
    if(c != 0) /* also nicht cat ! */ 
    {

	if(tar[c][0] != '-'){
		sprintf(s, "%s.tar",  mytime(0));
		s[5] = '-';
		s[2] = '-';
		sprintf(t, "%s/tmp/%s",  ZOPT.OPT->HOME,s);
		if (chdir(arg)!=0)
		{
		  nerror("pd.c", 658, "news_archiv", "Can't find spool-dir", arg);
		  return;
		}
		sprintf(s, "%s %s * >>/dev/null", ZOPT.OPT->TAR, t);
		ssystem( s );
		
		
		strcpy(cd, (UNSIGNED char *) t);
	}    
	else{
		sprintf(s, "%s", mytime(0));
		s[5] = '-';
		s[2] = '-';
		sprintf(cd, "%s/tmp/%s",  ZOPT.OPT->HOME,s);
		strcpy(t,cd);
		
	}

		if (chdir(arg)!=0)
		{
		  nerror("pd.c", 658, "news_archiv", "Can't find spool-dir", arg);
		  return;
		}        
	if(adds[c][0] == '?')
		sprintf(s, "%s %s  >>/dev/null ", packers[c], cd);
	else
	  sprintf(s, "%s %s %s %s >>/dev/null ", 
	     packers[c], adds[c],cd, "*");

	ssystem( s );

	unlink( t );

	strcat(t, (UNSIGNED char *) en[c]);

  }
  else{		/* Text/ASCII */
	
	
	sprintf(s, "%s.tar",  mytime(0));
	s[5] = '-';
	s[2] = '-';
	sprintf(t, "%s/tmp/%s",  ZOPT.OPT->HOME,s);
	sprintf(s, "%s %s %s >>/dev/null", ZOPT.OPT->TAR, t, "*");
	ssystem( s );
		
		
	strcpy(cd, (UNSIGNED char *) t);
	
	
  }

  kill( fpid, SIGKILL );
  (void) wait( &fpid );
  ZOPT.OPT->login_pid=0;

  clearline();

  if(tar[c][0] != '-'){
	ansi2( "md", 0, 0 );
	printf( "%s",GetText("PD40_MSG") );
	ansi2( "me", 0, 0 );
	printf("%s\n", GetText("PD41_MSG"));
  }  

  stat(t, &_fstat);
  printf("%s \"%s\" %s %ld %s.", GetText("PD42_MSG"), GetLastPath(t), 
       GetText("PD43_MSG"), _fstat.st_size, GetText("PD44_MSG"));


  sprintf(s,"rm -rf %s >>/dev/null &",arg);
  ssystem(s);
  

  return (UNSIGNED char *) t;
}













/* #DL - Transfer one or a couple of article(s) [arg] to a user. */



void download_news( arg )    /* new */
UNSIGNED char arg[];
{
  long i, k, l, m;
  int von, bis;
  int protokoll=0, ok;
  int cps, bps, eff;
  FILE *fd;
  long ts, tn;
  long bytes_total = 0L;

  struct stat fst;

  UNSIGNED char s[STRING];
  UNSIGNED char cd[2048];
  UNSIGNED char t[(LONGSTRING+STRING)];
  UNSIGNED char tmp[STRING];
  UNSIGNED char ta[STRING];
  int a1,a2,a3,a4;
  UNSIGNED char files[MAX_DL_FILES][STRING];
  int mdlp = 1;
  int art=0;
  int artp = 0;
  int lastart;

  int havetokill = 0;
  struct nrc_ent *nc=NULL;


  FILE *fp;


  if (arg[0] == 0) {
	ansi2("md", 0, 0);
	printf(" %s\n", GetText("PD35_MSG"));
#ifndef VU	
	RipWait();
#endif	
	ansi2("me", 0, 0);
	intuition( 440 );
	return;
  }
printf("\n");
  if (!ZOPT.OPT->NNTP_ON) 
  {
   FMsgBox("nntp-server not responding - no news aviable!");
   return;
  }


  if ((!ZOPT.news.nntp_stat.article)||(GetFirstArticle()==0))  
  {
   FMsgBox(GetText("NNTP5")); 
   return;
  }
  
   if ((nc=(struct nrc_ent *) FindRcEntry(ZOPT.OPT->NG))==NULL)
   {
     nerror("pd.c", 264, "news_download()", "Can't find Handle to nntp-group", ZOPT.OPT->NG);
     return;
   }
                        
  
  
  if    (arg[0] == 0) {
	ansi( "md" );
	printf(" <- %s\n", GetText("PD35_MSG"));
	ansi( "me" );
	
	if (!ZOPT.OPT->RIP_ON) sleep(1);
	  else {
#ifndef VU	  
	   RipWait();
#endif	   
          }	   
	return;
  }


 
  tmp[0] = 0;

  i = 0;
  k = -1;
  l = -1;
  m = -1;

  while (arg[i] != 0) {
	if (arg[i] == '-') k = i;
	if (arg[i] == '*') l = i;
	if ((arg[i] > 48) && (arg[i] < 58) && (m == -1)) m = i;
	i++;
  }

  von = 1;
  bis = MAX_INT;

  if ((m == -1) && (l == -1) && (k == -1)) {
	ansi2( "md", 0, 0 );
	if(atoi(arg) != 0)
		printf(" %s\n", GetText("PD44aMSG"));
	else
		printf(" %s\n", GetText("PD44bMSG"));
	ansi2( "me", 0, 0 );
	return;
  }

  if ((m != -1) && (l == -1) && (k == -1)) {
	strcpy(s, (UNSIGNED char *) strcopy(arg, m, strlen(arg)));
	von = atoi(s);
	bis = von;
  }
  if (k != -1) {
	strcpy(s, (UNSIGNED char *) strcopy(arg, 0, (k - 1)));
	von = atoi(s);
	strcpy(s, (UNSIGNED char *) strcopy(arg, (k + 1), strlen(arg)));
	bis = atoi(s);

	if (von == 0) von = 1;
	if (bis == 0) bis = MAX_INT;
  }
  
  if(von > bis){
	i = bis;
	bis = von;
	von = i;
  }


  von=GetFirstArticle();
  
  if (von<ZOPT.news.nntp_stat.article_von) von=ZOPT.news.nntp_stat.article_von; 
  if (bis>ZOPT.news.nntp_stat.article_bis) bis=ZOPT.news.nntp_stat.article_bis;
  
  
  
                                  
  

  if(ZOPT.OPT->DOWN_PROT == 0)
  {

	ansi2("mr", 0, 0);
	printf("%c[%s] %c, %c, %c, %c ? > ", CR, 
	 GetText("PD07_MSG"), GetEChar("PD08_MSG"), GetEChar("PD09_MSG"), GetEChar("PD10_MSG"), GetEChar("PD11_MSG"));
	ansi2("me", 0, 0);


	do {
		protokoll = getint();
		if (protokoll >= 97) protokoll -= 32;
		if (protokoll == '?') {
			clearline();
			ansi2("mr", 0, 0);
			printf("%c%s > ", CR, GetText("PD12_MSG"));
			ansi2("me", 0, 0);
		}
		if ((protokoll != GetEChar("PD08_MSG")) && (protokoll != GetEChar("PD09_MSG")) &&
		    (protokoll != GetEChar("PD10_MSG")) && (protokoll != GetEChar("PD11_MSG")))
				protokoll = 0;
	} while (protokoll == 0);

	printf("%c", protokoll); 
  }
  else
  {
	switch( ZOPT.OPT->DOWN_PROT ){
		case 1: protokoll = GetEChar("PD09_MSG"); /* X Modem */
			break;
		case 2: protokoll = GetEChar("PD10_MSG"); /* Y Modem */
			break;
		case 3: protokoll = GetEChar("PD11_MSG"); /* Z Modem */
			break;
		case 4: protokoll = GetEChar("PD08_MSG"); /* ASCII */
			break;
	}
  }

        
	
	cd[0] = 0;
	
	printf("\n\n%s\n%s%c", GetText("PD36_MSG"),GetText("BLD23_MSG"),CR); /* artikel werden zusammengestellt */

  
  
  /* hole alle Artikel in tmp-dir ... */
  sprintf(s,"%s/tmp/%d/%s",ZOPT.OPT->HOME,ZOPT.OPT->USER.id,ZOPT.OPT->NG);
  mkdir(s,0777);

  if (chdir(s)!=0)
    nerror("pd.c", 868, "download_news", "Can't mkdir+chdir", s);



  i=von; art=1; /* dummy */

  
  if ((bis-von+1)<ZOPT.news.nntp_stat.article)
  {
    printf("\narticle:%d ... %d (about %d(!) articles)\n",von,bis,bis-von+1);
 } else
 {
   printf("\narticle:%d ... %d (probable %d(!) articles)\n",von,bis,ZOPT.news.nntp_stat.article);
 }
  
  NNTPSetArticle(i); /* fuer Speed ;-) */
    
  while ((i!=(bis+1)))
  {
      sprintf(cd,"%s/tmp/%d/%s/%d",ZOPT.OPT->HOME,ZOPT.OPT->USER.id,
      			ZOPT.OPT->NG,i);
      printf("."); 
      fd=fopen(cd,"w");
      art=0;
      if (fd!=NULL)
      {
        art=i;
   	art=NNTPGetArticle(art,fd);
      } else nerror("download.c", 878, "download()", "Can't write", cd);
      fclose(fd);
      if (art>(nc->hi-1)) nc->hi=art-1; /* letzer gelesener Artikel */
      i++;
      if (art==0) {
       printf("\nmissing: %d",i-1);
       unlink(cd);
      } else
      {
       if (art!=(i-1))
       {
        printf(" jump to: %d",art);
        i=art;
        sprintf(s,"%s/tmp/%d/%s/%d",ZOPT.OPT->HOME,ZOPT.OPT->USER.id,
                                ZOPT.OPT->NG,i);
        rename(cd,s);
       } else 
       {
         /* limiten */
         stat(cd,&fst);
	 bytes_total=fst.st_size;
         ZOPT.OPT->USER.downratio += ((long) fst.st_size / 1000);
       }
      }
      
      
  }
  
   sprintf(cd,"%s/tmp/%d/%s",ZOPT.OPT->HOME,ZOPT.OPT->USER.id,
      			ZOPT.OPT->NG);
      			
  if (protokoll != GetEChar("PD08_MSG"))
        {
	strcpy(s, (UNSIGNED char *) dir_archivieren( cd ));
	   stat(s,&fst);
	   bytes_total=fst.st_size;
	
	  if(strcomp("Noe!", s) != 0)
	  {
		strcpy(cd, (UNSIGNED char *) s);
		havetokill++;
	  }
        }
  
  printf("\n\n");
  ansi2("md", 0, 0);
  printf("%s\n\n", GetText("PD13_MSG"));
  ansi2("me", 0, 0);

  time(&ts);

      a1=(GetEChar("PD08_MSG"));
      a2=(GetEChar("PD09_MSG"));
      a3=(GetEChar("PD10_MSG"));
      a4=(GetEChar("PD11_MSG"));
  

  
  if(protokoll==a1) 
      {
		sprintf(t, "cat %s/*", cd);
      } else 
      {
       if (protokoll==a2) 
        {
		sprintf(t, "%s -b %s 2> /dev/null", SX, cd);
	} else
	{
	     if (protokoll==a3) 
	     {
		sprintf(t, "%s %s 2> /dev/null", SB, cd);
	     } else 
	     {
	     if (protokoll==a4) 
	     {
		sprintf(t, "%s %s 2> /dev/null", SZ, cd);
	     }
	     }
	}
     }
     
  
if (!ssystem( t ))
{


  time(&tn); tn = tn - ts; 

  chdir( ZOPT.OPT->HOME );

  ansi2( "md", 0, 0 );
 
  if(tn < 1) tn = 1;
  cps = bytes_total / tn;
  bps = cps * 11;

  ZOPT.OPT->BAUDRATE = bbs_baudrate( bps );

  eff = ((100000 / ZOPT.OPT->BAUDRATE) * bps) / 1000;

if (protokoll!=a1)
{
  if((bps > ZOPT.OPT->BAUDRATE) || (bps < 1)){
	printf("\n\n%s\n", GetText("PD14_MSG"));
	ok = -1;
  }
  else{	
	printf("\n\n%ld %s.\n", fst.st_size, GetText("PD15_MSG"));
	ok = 0;
  }

  ansi2( "me", 0, 0 );
  printf("%s %d cps (ca. %d bps).", GetText("PD16_MSG"), cps, bps);  
} /* not ascii */
  
  if(ok != -1){
	if ((!atoi(cd))&&(protokoll!=a1) ) GlobalPdLog(ok,protokoll,bps,cps,eff,cd /*files[i]*/); 
	i = 0;
  }
  else{
        /*
         if (!atoi(cd)) GlobalPdLog(0,protokoll,bps,cps,eff,cd ); 
       */         
  }


  if(lastart != (artp-1)){
    if (protokoll!=a1)
    {
        /*
	ansi2( "md", 0, 0 );
	printf("\n%s", GetText("PD40_MSG"));
	ansi2( "me", 0, 0 );
	
	printf("%s %d %s %d %s!", GetText("PD45_MSG"), art[0], GetText("PD46_MSG"), art[lastart], 
	GetText("PD47_MSG"));
	*/
     }
     
  }
 sprintf(s,"rm -rf %s >>/dev/null &",cd);
 ssystem(s);
  
} else{
   FMsgBox(GetText("PD17a_MSG"));    
   unlink( cd );
 }
 

 
 
chdir(ZOPT.OPT->HOME);
  printf("\n\n");
}



















/* ******************** NewsDownload() ********************************/
void NewsDownload( arg )    /* new for RIP  */
UNSIGNED char arg[];
{
  int i, k, l, m;
  int von, bis;
  int protokoll=0, ok;
  int cps, bps, eff;

  long ts, tn;
  long bytes_total = 0L;

  struct stat fst;

  UNSIGNED char s[STRING];
  UNSIGNED char cd[LONGSTRING];
  UNSIGNED char t[(LONGSTRING+STRING)];
  UNSIGNED char tmp[STRING];
  int a1,a2,a3,a4;
  UNSIGNED char files[MAX_DL_FILES][STRING];
  int mdlp = 1;

  int art[MAX_PER_NG];
  int artp = 0;
  int lastart;

  int havetokill = 0;


  FILE *fp;



  
  if    (arg[0] == 0) {
	ansi( "md" );
	if (!ZOPT.OPT->RIP_ON) printf(" <- %s\n", GetText("PD35_MSG"));
	 else printf(" (%s) <- %s\n", arg, GetText("PD35_MSG"));
	ansi( "me" );
	if (!ZOPT.OPT->RIP_ON) sleep(1); else 
	{  
#ifndef VU	
	  RipWait();
#endif	  
	}
	return;
  }


 
  brett(ZOPT.OPT->NG);  
chdir(ZOPT.OPT->HOME); 
 
  tmp[0] = 0;
  i = 0;
  k = -1;
  l = -1;
  m = -1;

  while (arg[i] != 0) {
	if (arg[i] == '-') k = i;
	if (arg[i] == '*') l = i;
	if ((arg[i] > 48) && (arg[i] < 58) && (m == -1)) m = i;
	i++;
  }

  von = 1;
  bis = 32000;

  if ((m == -1) && (l == -1) && (k == -1)) {
	ansi2( "md", 0, 0 );
	if(atoi(arg) != 0)
		printf(" %s\n", GetText("PD44aMSG"));
	else
		printf(" %s\n", GetText("PD44bMSG"));
	ansi2( "me", 0, 0 );
	return;
  }

  if ((m != -1) && (l == -1) && (k == -1)) {
	strcpy(s, (UNSIGNED char *) strcopy(arg, m, strlen(arg)));
	von = atoi(s);
	bis = von;
  }
  if (k != -1) {
	strcpy(s, (UNSIGNED char *) strcopy(arg, 0, (k - 1)));
	von = atoi(s);
	strcpy(s, (UNSIGNED char *) strcopy(arg, (k + 1), strlen(arg)));
	bis = atoi(s);

	if (von == 0) von = 1;
	if (bis == 0) bis = 32000;
  }
  
  if(von > bis){
	i = bis;
	bis = von;
	von = i;
  }

  maybe_locked(ZOPT.OPT->INHALT, "r");
  fp = fopen(ZOPT.OPT->INHALT, "r");
  if (fp == NULL) {
	nerror("pd.c", 504, "download", "Can't read", ZOPT.OPT->INHALT);
  }
  while (fgets(cd, LONGSTRING, fp) != NULL){
	i = atoi(cd);
	if((i >= von) && (i <= bis)){
		art[artp] = i;
		artp++;
		if(artp > MAX_PER_NG){
			printf("This is a known bug ;-)");
			exit(0);
		}		
	}
  }
  fclose(fp);


  printf("\n\n");

  if(ZOPT.OPT->DOWN_PROT == 0){

	ansi2("mr", 0, 0);
	printf("%c[%s] %c, %c, %c, %c ? > ", CR, 
	 GetText("PD07_MSG"), GetEChar("PD08_MSG"), GetEChar("PD09_MSG"), GetEChar("PD10_MSG"), GetEChar("PD11_MSG"));
	ansi2("me", 0, 0);


	do {
		protokoll = getint();
		if (protokoll >= 97) protokoll -= 32;
		if (protokoll == '?') {
			clearline();
			ansi2("mr", 0, 0);
			printf("%c%s > ", CR, GetText("PD12_MSG"));
			ansi2("me", 0, 0);
		}
		if ((protokoll != GetEChar("PD08_MSG")) && (protokoll != GetEChar("PD09_MSG")) &&
		    (protokoll != GetEChar("PD10_MSG")) && (protokoll != GetEChar("PD11_MSG")))
				protokoll = 0;
	} while (protokoll == 0);

	printf("%c", protokoll); 
  }
  else{
	switch( ZOPT.OPT->DOWN_PROT ){
		case 1: protokoll = GetEChar("PD09_MSG"); /* X Modem */
			break;
		case 2: protokoll = GetEChar("PD10_MSG"); /* Y Modem */
			break;
		case 3: protokoll = GetEChar("PD11_MSG"); /* Z Modem */
			break;
		case 4: protokoll = GetEChar("PD08_MSG"); /* ASCII */
			break;
	}
  }

  if (strcomp(CDROMNG, ZOPT.OPT->NG) != 0) {
#ifdef DEBUG  
       printf("\nkeine CDROM :-)\n"); sleep(1);
#endif       
	if (strcomp(ZOPT.OPT->BRETT, "PM") != 0) {
		       sprintf(s, "%s", ZOPT.OPT->BRETT); 
	}
	else {
		sprintf(s, "%s/usr/%c/%d", ZOPT.OPT->HOME, 
		         ZOPT.OPT->USER.name[0], ZOPT.OPT->USER.id);
	}
	chdir( s );
	
	cd[0] = 0;
	printf("\n\n%s .", GetText("PD36_MSG")); /* artikel werden zusammengestellt */
#ifdef DEBUG  
       printf("\ns: %s",s); sleep(3);
#endif       	

	lastart = artp;

	for( i = 0; i < artp; i++){  

		sprintf(s, "%d", art[i]); 
	
		fp = fopen(s, "r");
#ifdef DEBUG  
       printf("\nfopen: %s",s); sleep(1);
#endif       		
		if(fp != 0){
			printf(".");

			while ((fgets(t, LONGSTRING, fp) != NULL) && (t[0] > 32));
			while ((fgets(t, LONGSTRING, fp) != NULL) && (t[0] < 32));

			ok = 0;

			if (strcomp("BINFILE", t) == 0) {
				fgets(t, STRING, fp);
				strcpy(s, (UNSIGNED char *) stripped(t));
				ok++;
			}
			if(((2 + strlen(s) + strlen(cd)) < LONGSTRING) && (mdlp < MAX_DL_FILES)){
				stat(s, &fst);
				bytes_total += (long) fst.st_size;

				if(ok != 0){
					strcpy(files[mdlp], s);
					mdlp++;				
					ZOPT.OPT->USER.downratio += ((long) fst.st_size / 1000);
				}
	
				strcat(cd, s); 
				strcat(cd, " ");
				lastart = i;
			}
			fclose(fp);
		}
	}
  }
  else{			/* Download from CDROM */

        	
        chdir(NEWS_DUMMY);
	chdir( ZOPT.OPT->BRETT );
	
	cd[0] = 0;
	printf("\n\n%s .", GetText("PD36_MSG"));

	lastart = artp;

   	fp = fopen( ZOPT.OPT->INHALT, "r" );	  
	fgets(s, STRING, fp);
	fgets(s, STRING, fp);

	for( i = 0; i < artp; i++){  

		rewind( fp );	
		printf(".");

		while((fgets(s, STRING, fp) != 0) && (art[i] != atoi(s)));

		l = 6;
		while((s[l] != ' ') && (s[l] != 0)) l++;	
		strcpy(s, (UNSIGNED char *) strcopy(s, 6, (l - 1)));

		if(((2 + strlen(s) + strlen(cd)) < LONGSTRING) && (mdlp < MAX_DL_FILES)){
			stat(s, &fst);

			bytes_total += (long) fst.st_size;

			sprintf(files[mdlp], "%s/%s", ZOPT.OPT->BRETT, s);
			mdlp++;				
			ZOPT.OPT->USER.downratio += ((long) fst.st_size / 1000);
	
			strcat(cd, s); 
			strcat(cd, " ");
			lastart = i;
		}
	}
	fclose(fp);
  }	

  if(cd[0] == 0){
	ansi2("md", 0, 0);
	if (!ZOPT.OPT->RIP_ON) printf("\n%s", GetText("PD35_MSG"));
	 else printf("\n%s <- %s\n", arg, GetText("PD35_MSG"));
	ansi2("me", 0, 0);
#ifndef VU	
	RipWait();
#endif	
	chdir( ZOPT.OPT->HOME );
	return;
  }
  
  if((protokoll != GetEChar("PD08_MSG")) && (strcomp(PDNG, ZOPT.OPT->NG) != 0) 
  && (strcomp("cdrom", ZOPT.OPT->NG) != 0))
        {
        printf("\narchivieren: %s\n",cd);
	strcpy(s, (UNSIGNED char *) archivieren( cd ));
	printf("\narchivieren-s: %s\n",s);
	sleep(3);
	  if(strcomp("Noe!", s) != 0)
	  {
		strcpy(cd, (UNSIGNED char *) s);
		havetokill++;
	  }
        }
  
  printf("\n\n");
  ansi2("md", 0, 0);
  printf("%s\n\n", GetText("PD13_MSG"));
  ansi2("me", 0, 0);

  time(&ts);

      a1=(GetEChar("PD08_MSG"));
      a2=(GetEChar("PD09_MSG"));
      a3=(GetEChar("PD10_MSG"));
      a4=(GetEChar("PD11_MSG"));
  

  
  
  if(protokoll==a1) 
      {
		sprintf(t, "cat %s", cd);
      } else 
      {
       if (protokoll==a2) 
        {
		sprintf(t, "%s -b %s 2> /dev/null", SX, cd);
	} else
	{
	     if (protokoll==a3) 
	     {
		sprintf(t, "%s %s 2> /dev/null", SB, cd);
	     } else 
	     {
	     if (protokoll==a4) 
	     {
		sprintf(t, "%s %s 2> /dev/null", SZ, cd);
	     }
	     }
	}
     }
  

if (!ssystem( t ))
{
  if(havetokill != 0) unlink( cd );

  time(&tn); tn = tn - ts; 

  chdir( ZOPT.OPT->HOME );

  ansi2( "md", 0, 0 );
 
  if(tn < 1) tn = 1;
  cps = bytes_total / tn;
  bps = cps * 11;

  ZOPT.OPT->BAUDRATE = bbs_baudrate( bps );

  eff = ((100000 / ZOPT.OPT->BAUDRATE) * bps) / 1000;

/*
  if((bps > ZOPT.OPT->BAUDRATE) || (bps < 1)){
	printf("\n\n%s\n", GetText("PD14_MSG"));
	ok = -1;
  }
  else
 */
  	
	printf("\n\n%ld %s.\n", fst.st_size, GetText("PD15_MSG"));
	ok = 0;
  

  ansi2( "me", 0, 0 );
  printf("%s %d cps (ca. %d bps).", GetText("PD16_MSG"), cps, bps);  

  if(ok != -1){
     if (!atoi(cd)) GlobalPdLog(ok,protokoll,bps,cps,eff,cd ); 
	i = 0;
  }
  else{
/*      if (!atoi(cd)) GlobalPdLog(0,protokoll,bps,cps,eff,cd ); */
  }

  if(lastart != (artp-1)){
	ansi2( "md", 0, 0 );
	printf("\n%s", GetText("PD40_MSG"));
	ansi2( "me", 0, 0 );
	printf("%s %d %s %d %s!", GetText("PD45_MSG"), art[0], GetText("PD46_MSG"), art[lastart], 
	GetText("PD47_MSG"));
  }
} else{
   FMsgBox(GetText("PD17a_MSG"));    
 }
chdir(ZOPT.OPT->HOME);
  printf("\n\n");
}





void ViewCatDir(cd)
char *cd;
{
DIR *dp;
int i;
struct dirent *actdir;
char s[2*STRING];
                                
  dp=opendir(cd);
  if (dp==NULL){
      printf("\ndirectory (%s) not exist!\n",cd);
      return;
   }
  for (i=0;i<2;i++) readdir(dp);
  while ((actdir = readdir(dp)) != NULL)   
  {
    sprintf(s,"cat %s/%s",cd,actdir->d_name);
    ssystem(s);
  }
 closedir(dp);  

}
