#define __MBD
#define NOTERM  
#include <dirent.h>
#include <sys/types.h>
#include <signal.h>
#include <unistd.h>
#include <stdio.h>
#include <strings.h>                        
#include <time.h>                           
#include <sys/param.h>                      
#include <sys/socket.h>                     
#include <netinet/in.h>                     
#include <netdb.h>                          
#include <stdarg.h>                         

#include <fcntl.h>
#include <sys/stat.h>
#include <dirent.h>
#include <strings.h>
#include <string.h>
#include <ctype.h>
#include <arpa/inet.h>
                     


#include <sys/types.h>   
#include <linux/time.h>

#include "defs.h"
#include "nntp.h"


#undef EXTERN
#define ALLOCATE
#define NNTP_ABLE

char msg[1024*8],NG[STRING],INHALT[STRING],buf[4096],artikel[STRING];
FILE *nntp_rd_fp,*nntp_wr_fp;
char nntp_line[1024*8];
int article,article_von,article_bis,auth,posting,groups;
int NNTP_ON,GET_NNTP_CHECK_ON,NNTP_TIMEOUT;

#undef _ART_DEBUG
#undef VIEW


#include <stdio.h>
#include <sys/types.h>

#include <pwd.h>
#include <string.h>



void InitNews()
{
  printf("\ntbbs-project: nntp.post for lynx             (c) 1996 runge@boerde.de\n----------------------------------------------------------------------\n"); 
  NntpConnect();
  NNTPPostArticle();
}



void NntpConnect()
{
int i;

   time((time_t *) &NNTP_TIMEOUT);
   GET_NNTP_CHECK_ON=1;
#ifdef DEBUG   
   printf("\nnntp: connecting to %s ..... ", NNTP_HOST);
#endif   
   nntp_connect_port(NNTP_HOST,NNTP_DEFAULT_DUMMY);
   time((time_t *) &NNTP_TIMEOUT); GET_NNTP_CHECK_ON=0;
   i=get_nntp_code();
   if (!((i==OK_CANPOST)||(i==OK_NOPOST))) 
   {
    close_server();
#ifdef DEBUG2
      printf("\nnntp-status != ok\n");
#endif    
    exit(-7);
   }
}



void nntp_connect_port(char *server, int _port) 
{

    NNTP_ON=1;
    if (server_init (server, (char *) NNTP_PORT, _port)!=-1)   /*!PORT-BUG!*/
    {
     /* server ok .. */
    } else
    {
#ifdef DEBUG
	printf("\nkeine verbindung zum server\n");	
#endif    
        exit(-2);
    }

}





















/*
 * server_init  Get a connection to the remote server.
 *
 *	Parameters:	"machine" is the machine to connect to.
 *			"service" is the service to connect to on the machine.
 *			"port" is the servive port to connect to.
 *
 *	Returns:	-1 on error
 *			server's initial response code on success.
 *
 *	Side effects:	Connects to server.
 *			"nntp_rd_fp" and "nntp_wr_fp" are fp's
 *			for reading and writing to server.
 */

int server_init (machine, service, _port)
	char	*machine;
	char	*service;
	unsigned short _port;
{
	int	sockt_rd, sockt_wr;

	sockt_rd = get_tcp_socket (machine, service, _port); 

	if (sockt_rd < 0)
		return (-1);

	/*
	 * Now we'll make file pointers (i.e., buffered I/O) out of
	 * the socket file descriptor.  Note that we can't just
	 * open a fp for reading and writing -- we have to open
	 * up two separate fp's, one for reading, one for writing.
	 */

	if ((nntp_rd_fp = (FILE *) fdopen (sockt_rd, "r")) == NULL) {
#ifdef DEBUG2	
		printf ("\nserver_init: fdopen #1");
#endif		
		return (-1);
	}

	sockt_wr = dup (sockt_rd);

	if ((nntp_wr_fp = (FILE *) fdopen (sockt_wr, "w")) == NULL) {
#ifdef DEBUG2	
		printf ("\nserver_init: fdopen #2");
#endif		
		nntp_rd_fp = NULL;		/* from above */
		return (-1);
	}

	/*
	 * Now get the server's signon message
	 */
	/*(void) get_server (nntp_line, sizeof (nntp_line));*/
	return (atoi (nntp_line));
}




/*
 * put_server -- send a line of text to the server, terminating it
 * with CR and LF, as per ARPA standard.
 *
 *	Parameters:	"string" is the string to be sent to the
 *			server.
 *
 *	Returns:	Nothing.
 *
 *	Side effects:	Talks to the server.
 *			Closes connection if things are not right.
 *
 *	Note:	This routine flushes the buffer each time
 *			it is called.  For large transmissions
 *			(i.e., posting news) don't use it.  Instead,
 *			do the fprintf's yourself, and then a final
 *			fflush.
 */

void put_server (string)
	char *string;
{

	fprintf (nntp_wr_fp, "%s\r\n", string);
	(void) fflush (nntp_wr_fp);

}


void close_server ()
{
	if (nntp_wr_fp == NULL || nntp_rd_fp == NULL)
		return;
#ifdef DEBUG2
        printf("\nnntp: close server.");
#endif        
	put_server ("QUIT");

	(void) fclose (nntp_wr_fp);
	(void) fclose (nntp_rd_fp);
}






/*
 * get_tcp_socket -- get us a socket connected to the specified server.
 *
 *	Parameters:	"machine" is the machine the server is running on.
 *			"service" is the service to connect to on the server.
 *			"port" is the port to connect to on the server.
 *
 *	Returns:	Socket connected to the server if
 *			all is ok, else -1 on error.
 *
 *	Side effects:	Connects to server.
 *
 *	Errors:		Printed via perror.
 */

int get_tcp_socket (machine, service, _port)
	char	*machine;	/* remote host */
	char	*service;	/* nttp/smtp etc. */
	unsigned short _port;	/* tcp port number */
{
#ifdef NNTP_ABLE
	int	s = -1;
	struct	sockaddr_in _sin;


#ifndef EXCELAN
	struct	servent *getservbyname(), *sp;
	struct	hostent *gethostbyname(), *hp;
#ifdef h_addr
	int	x = 0;
	register char **cp;
	static char *alist[1];
#endif /* h_addr */
	unsigned long inet_addr();
	static struct hostent def;
	static struct in_addr defaddr;
	static char namebuf[256];

	if ((sp = (struct servent *) getservbyname (service, "tcp")) ==  NULL) {
#ifdef DEBUG	
		printf("%s/tcp: Unknown service.\n", service);
#endif		
		return (-1);
	}
	/* If not a raw ip address, try nameserver */
	if (!isdigit(*machine) || 
	    (long)(defaddr.s_addr = (long) inet_addr (machine)) == -1) {
		hp = gethostbyname (machine);
	} else {
		/* Raw ip address, fake  */
		(void) strcpy (namebuf, machine);
		def.h_name = (char *) namebuf;
#ifdef h_addr
		def.h_addr_list = alist;
#endif
		def.h_addr = (char *) &defaddr;
		def.h_length = sizeof (struct in_addr);
		def.h_addrtype = AF_INET;
		def.h_aliases = 0;
		hp = &def;
	}
	if (hp == NULL) {
#ifdef DEBUG	
		printf ("\n%s: Unknown host.\n", machine);
#endif		
		return (-1);
	}

	bzero((char *) &_sin, sizeof (_sin));
	_sin.sin_family = hp->h_addrtype;
	_sin.sin_port = sp->s_port;
#else /* EXCELAN */
	bzero((char *) &_sin, sizeof (_sin));
	_sin.sin_family = AF_INET;
#endif /* EXCELAN */

	/*
	 * The following is kinda gross.  The name server under 4.3
	 * returns a list of addresses, each of which should be tried
	 * in turn if the previous one fails.  However, 4.2 hostent
	 * structure doesn't have this list of addresses.
	 * Under 4.3, h_addr is a #define to h_addr_list[0].
	 * We use this to figure out whether to include the NS specific
	 * code...
	 */

#ifdef h_addr
	/*
	 * get a socket and initiate connection -- use multiple addresses
	 */

	for (cp = hp->h_addr_list; cp && *cp; cp++) {
		s = socket (hp->h_addrtype, SOCK_STREAM, 0);
		if (s < 0) {
#ifdef DEBUG		
			printf ("SOCK_STREAM: socket-error");
#endif			
			return (-1);
		}
		bcopy(*cp, (char *) &_sin.sin_addr, hp->h_length);
		
		if (x < 0) {
#ifdef DEBUG		
			fprintf (stderr, "Trying %s", (char *) inet_ntoa (_sin.sin_addr));
#endif			
		}
		x = connect (s, (struct sockaddr *) &_sin, sizeof (_sin));
		if (x == 0) {
			break;
		}
#ifdef 	DEBUG	
		fprintf (stderr, "\nConnection to %s: ", (char *) inet_ntoa (_sin.sin_addr));
#endif		
		(void) close (s);
	}
	if (x < 0) {
#ifdef DEBUG	
		fprintf (stderr, "Giving up...\n");
#endif		
		sprintf(buf,"nntp-host: %s  -> Giving up...",NNTP_HOST);
		exit (-1);
	}
#else	/* no name server */
#ifdef EXCELAN
	if ((s = socket (SOCK_STREAM,(struct sockproto *)NULL,&_sin,SO_KEEPALIVE)) < 0) {
		/* Get the socket */
#ifdef DEBUG2		
		printf ("socket");
#endif		
		return (-1);
	}
	bzero((char *) &_sin, sizeof (_sin));
	_sin.sin_family = AF_INET;
	_sin.sin_port = htons (IPPORT_NNTP);
	/* set up addr for the connect */

	if ((_sin.sin_addr.s_addr = rhost (&machine)) == -1) {
#ifdef DEBUG	
		fprintf (stderr, "\n%s: Unknown host.\n", machine);
#endif		
		return (-1);
	}
	/* And then connect */

	if (connect (s, (struct sockaddr *)&_sin) < 0) {
#ifdef DEBUG	
		printf ("connect");
#endif		
		(void) close (s);
		return (-1);
	}
#else /* not EXCELAN */
	if ((s = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
#ifdef DEBUG2	
		printf ("\nsocket-error ");
#endif		
		return (-1);
	}

	/* And then connect */

	bcopy (hp->h_addr, (char *) &_sin.sin_addr, hp->h_length);
	if (connect (s, (struct sockaddr *) &_sin, sizeof (_sin)) < 0) {
#ifdef DEBUG	
		printf("connect");
#endif		
		(void) close (s);
		return (-1);
	}

#endif /* !EXCELAN */
#endif /* !h_addr */
	return (s);
#else
	return (-1);
#endif /* NNTP_ABLE */
}




/*
 * get_server -- get a line of text from the server.  Strips
 * CR's and LF's.
 *
 *	Parameters:	"string" has the buffer space for the
 *			line received.
 *			"size" is the size of the buffer.
 *
 *	Returns:	-1 on error, 0 otherwise.
 *
 *	Side effects:	Talks to server, changes contents of "string".
 *			Reopens connection when necessary and requested.
 */


int get_server_line(string, size)
    char *string;
    int size;
{
    register char *cp, *nl;

time((time_t *) &NNTP_TIMEOUT); GET_NNTP_CHECK_ON=1;

    if (fgets(string, size, nntp_rd_fp) == NULL) {
	io_error();
	return -1;
    }
    for (cp = string, nl = NULL; *cp != NUL; cp++) {
	if (*cp == CR) {
	    nl = cp;
	    break;
	}
	if (nl == NULL && *cp == NL)
	    nl = cp;
    }
    if (nl != NULL) *nl = NUL;
time((time_t *) &NNTP_TIMEOUT); GET_NNTP_CHECK_ON=0;

#ifdef DEBUG2
   printf("\nget-line: (%s)",string);

#endif    
        
    return 0;
}



/*
 * get_server: get a response line from the server.
 *
 * 	Returns the numerical value of the reponse, or -1 in case of errors.
 */

int  get_server(string, size)
    char *string;
    int size;
{
    if (get_server_line(string, size) < 0)
	return (0);
     return((int ) strlen(string));
}



int io_error()
{
#ifdef DEBUG
      printf( "\nLost connection to nntp-server");
#endif      
      exit(-4);
}






/*
 *  get a response code from the server and return it to the caller
 */

int get_nntp_code ()
{
	char line[NNTP_STRLEN];

	if (get_server (line, NNTP_STRLEN) == -1) {
#ifdef DEBUG	
		printf("nntp-error: txt_connection_to_server_broken\n");
#endif		
		return(0);
	}
	return atoi (line);
}





/* Artikel ueber NNTP-senden */
int NNTPPostArticle()
{
char k[NNTP_STRLEN];
char ss[NNTP_STRLEN];
int i;
FILE *fd;



  if ((fd=fopen(artikel,"r"))==NULL)
  {
   printf("\nNntpPost: Can't open temporary file (%s)\n", artikel);
   return(0);
  }
  fclose(fd);
  
  sprintf(k,"POST");
  put_server(k);
          
  if ((i=get_nntp_code())!=CONT_POST)
   {
    printf("\n%s",nntp_respcode(i));
    return(0);
   }

  fd=fopen(artikel,"r");
  while (fgets(ss,NNTP_STRLEN,fd)!=NULL)
  {
    if (ss[0]=='.') ss[0]=SPACE;
    if (ss[strlen(ss)-1]=='\n') ss[strlen(ss)-1]=0;
    put_server(ss);
  }
  fclose(fd);
  sprintf(k,".");
  put_server(k);
  printf("\nwait for nntp-server responding .....");
  /*
  get_server(k,NNTP_STRLEN);
  printf("\nnntp: %s\n",k);
  */

  if ((i=get_nntp_code())!=OK_POSTED)
  {
   printf("\n%s",nntp_respcode(i));
   return(0);
  }      
  else 
  {
   printf("\n%s\n",nntp_respcode(i));
   return(1);
  }
}





 /* strings-funct */
 char *sstrings(s)
 char s[];
 {
   static char b[3*STRING];
   int j,k = 0 ;
   
 for (j=0;j<=(strlen(s));j++)
 {
  b[j]=s[j];
  if (  (b[j]>((char ) 127))||(b[j]<((char )32))     ) b[j]=32;
 }
  b[j]='\0';
   	     
   	     
   return ((char *) &b);
 }
 
 
 

char *nntp_respcode (respcode)
	int respcode;
{
	static char *text;

	/*
	 * If the last response line matches and has a description, return it
	 */
	if (atoi (nntp_line) == respcode && strlen (nntp_line) > 4) {
		return nntp_line;
	}

	switch (respcode) {
		case 0:
			text = "";
			break;
		case INF_HELP:
			text = "100  Help text on way";
			break;
		case INF_AUTH:
			text = "180  Authorization capabilities";
			break;
		case INF_DEBUG:
			text = "199  Debug output";
			break;
		case OK_CANPOST:
			text = "200  Hello; you can post";
			break;
		case OK_NOPOST:
			text = "201  Hello; you can't post";
			break;
		case OK_SLAVE:
			text = "202  Slave status noted";
			break;
		case OK_GOODBYE:
			text = "205  Closing connection";
			break;
		case OK_GROUP:
			text = "211  Group selected";
			break;
		case OK_GROUPS:
			text = "215  Newsgroups follow";
			break;
		case OK_XMOTD:
			text = "217  News motd file follows";
			break;
		case OK_XINDEX:
			text = "218  Group index file follows";
			break;
		case OK_ARTICLE:
			text = "220  Article (head & body) follows";
			break;
		case OK_HEAD:
			text = "221  Head follows";
			break;
		case OK_BODY:
			text = "222  Body follows";
			break;
		case OK_NOTEXT:
			text = "223  No text sent -- stat, next, last";
			break;
		case OK_NEWNEWS:
			text = "230  New articles by message-id follow";
			break;
		case OK_NEWGROUPS:
			text = "231  New newsgroups follow";
			break;
		case OK_XFERED:
			text = "235  Article transferred successfully";
			break;
		case OK_POSTED:
			text = "240  Article posted successfully";
			break;
		case OK_AUTHSYS:
			text = "280  Authorization system ok";
			break;
		case OK_AUTH:
			text = "281  Authorization (user/pass) ok";
			break;
		case OK_BIN:
			text = "282  binary data follows";
			break;
		case OK_SPLIST:
			text = "283  spooldir list follows";
			break;
		case OK_SPSWITCH:
			text = "284  Switching to a different spooldir";
			break;
		case OK_SPNOCHANGE:
			text = "285  Still using same spooldir";
			break;
		case OK_SPLDIRCUR:
			text = "286  Current spooldir";
			break;
		case OK_SPLDIRAVL:
			text = "287  Available spooldir";
			break;
		case OK_SPLDIRERR:
			text = "288  Unavailable spooldir or invalid entry";
			break;
		case CONT_XFER:
			text = "335  Continue to send article";
			break;
		case CONT_POST:
			text = "340  Continue to post article";
			break;
		case NEED_AUTHINFO:
			text = "380  authorization is required";
			break;
		case NEED_AUTHDATA:
			text = "381  <type> authorization data required";
			break;
		case ERR_GOODBYE:
			text = "400  Have to hang up for some reason";
			break;
		case ERR_NOGROUP:
			text = "411  No such newsgroup";
			break;
		case ERR_NCING:
			text = "412  Not currently in newsgroup";
			break;
		case ERR_XMOTD:
			text = "417  No news motd file";
			break;
		case ERR_XINDEX:
			text = "418  No index file for this group";
			break;
		case ERR_NOCRNT:
			text = "420  No current article selected";
			break;
		case ERR_NONEXT:
			text = "421  No next article in this group";
			break;
		case ERR_NOPREV:
			text = "422  No previous article in this group";
			break;
		case ERR_NOARTIG:
			text = "423  No such article in this group";
			break;
		case ERR_NOART:
			text = "430  No such article at all";
			break;
		case ERR_GOTIT:
			text = "435  Already got that article, don't send";
			break;
		case ERR_XFERFAIL:
			text = "436  Transfer failed";
			break;
		case ERR_XFERRJCT:
			text = "437  Article rejected, don't resend";
			break;
		case ERR_NOPOST:
			text = "440  Posting not allowed";
			break;
		case ERR_POSTFAIL:
			text = "441  Posting failed";
			break;
		case ERR_NOAUTH:
			text = "480  authorization required for command";
			break;
		case ERR_AUTHSYS:
			text = "481  Authorization system invalid";
			break;
		case ERR_AUTHREJ:
			text = "482  Authorization data rejected";
			break;
		case ERR_INVALIAS:
			text = "483  Invalid alias on spooldir cmd";
			break;
		case ERR_INVNOSPDIR:
			text = "484  No spooldir file found";
			break;
		case ERR_COMMAND:
			text = "500  Command not recognized";
			break;
		case ERR_CMDSYN:
			text = "501  Command syntax error";
			break;
		case ERR_ACCESS:
			text = "502  Access to server denied";
			break;
		case ERR_FAULT:
			text = "503  Program fault, command not performed";
			break;
		case ERR_AUTHBAD:
			text = "580  Authorization Failed";
			break;
		default:
			text = "Unknown NNTP response code";
			break;
	}
	return (text);
}
