
#include <stdio.h>
#include <setjmp.h>
#include <unistd.h>

#ifndef VU
#include "mbox.h"
#include "s_global.h"
#else 
#include "../mbox.h"
#include "../s_global.h"
#endif

#define DEBUG


/* #NR - Catching bugs and doing the reporting.

   [file] tells in which file the error occured,
   [line] specifies the code line,
   [function] names the C function,
   [descr] contains a description and
   [er] gives further information. */


void nerror(file, line, function, descr, er)
UNSIGNED char file[];
int line;
UNSIGNED char function[], descr[], er[];
{
  UNSIGNED char s[LONGSTRING];

  chdir( ZOPT.OPT->HOME );

  ansi2("md", 0, 0);
  printf("%c%s ", CR, NER01_MSG);
  ansi2("me", 0, 0);

  printf("%s (%s) - %s \"%s\"\n", function, file, descr, er);

  sprintf(s, "[%s] %s, %d\n***** %s, %s, %s ... %s !!!",
	NER02_MSG, file, line, function, descr, er, NER03_MSG);

  control(s, 99);
  control(s, 3);

  longjmp(ZOPT.OPT->jmpenv, 1);
}


void sys_error(cmd)
char *cmd;
{
 nerror(CONSOLE, 0,"NEWS-DBM",cmd,"");
}


void log_entry(cmd)
char *cmd;
{
/* dummy */
}

void logerror(file, line, function, descr, er)
UNSIGNED char *file;
int line;
UNSIGNED char *function, *descr, *er;
{
  UNSIGNED char s[LONGSTRING];

  chdir( ZOPT.OPT->HOME );

  ansi2("md", 0, 0);
  printf("%c%s ", CR, NER01_MSG);
  ansi2("me", 0, 0);

  printf("%s (%s) - %s \"%s\"\n", function, file, descr, er);

  sprintf(s, "[%s] %s, %d\n***** %s, %s, %s ... %s !!!",
	NER02_MSG, file, line, function, descr, er, NER03_MSG);
  
  control(s, 99);
  control(s, 3);

}




void RSLogErr(file,znummer,zeile,msg)
unsigned char *file,*zeile,*msg;
int 	znummer;
{
FILE *fd;

 Beep();
 if  ((fd=fopen(RIPERRFILE,"a"))!=NULL)
 {
 
 	fprintf(fd,"\n----------------------------------------"	);
 	fprintf(fd,"%s, %s, %s\n",mydate(0),mytime(0),ZOPT.OPT->USER.name);
 	fprintf(fd,"Error: %s\n",msg);
 	fprintf(fd,"File: %s, Zeile: %d\n",file,znummer);
 	fprintf(fd,"Zeile: %s\n",zeile);
 	
 
 }
 fclose(fd);

}


void DLog(file,zeile,msg)
unsigned char *file,*zeile,*msg;
{
FILE *fd;
unsigned char s[LONGSTRING];

#ifdef DEBUG
  sprintf(s,"%s/etc/errlog/t-bbs.RipScript.log",ZOPT.OPT->HOME);
 if  ((fd=fopen(s,"a"))!=NULL)
 {
 
 	fprintf(fd,"\n----------------------------------------"	);
 	fprintf(fd,"%s, %s, %s\n",mydate(0),mytime(0),ZOPT.OPT->USER.name);
 	fprintf(fd,"%s\n",file);
 	fprintf(fd,"%s\n%s\n",zeile,msg);
 	
 
 }
 fclose(fd);
#endif
}


void DCMDLog(file,zeile,msg)
unsigned char *file,*zeile,*msg;
{
FILE *fd;
unsigned char s[LONGSTRING];

#ifdef DEBUG
 sprintf(s,"%s/etc/errlog/t-bbs.RipScript.log",ZOPT.OPT->HOME);
 if  ((fd=fopen(s,"a"))!=NULL)
 {
 
 	fprintf(fd,"\n----------------------------------------"	);
 	fprintf(fd,"%s, %s, %s\n",mydate(0),mytime(0),ZOPT.OPT->USER.name);
 	fprintf(fd,"file: %s\n",file);
 	fprintf(fd,"cmd: %s\narg: %s\n",zeile,msg);
 	
 
 }
 fclose(fd);
#endif
}





void StrLog(str1)
unsigned char *str1;
{
FILE *fd;
unsigned char s[2*STRING];

 sprintf(s,"%s/etc/errlog/t-bbs.log",ZOPT.OPT->HOME);
 if  ((fd=fopen(s,"a"))!=NULL)
 fprintf(fd,"%s",str1);
 fclose(fd);
}





void zerror(file, line, function, descr, er)
UNSIGNED char file[];
int line;
UNSIGNED char function[], descr[], er[];
{
  UNSIGNED char s[LONGSTRING];

  chdir( ZOPT.OPT->HOME );

  ansi2("md", 0, 0);
  printf("%c%s ", CR, NER01_MSG);
  ansi2("me", 0, 0);

  printf("%s (%s) - %s \"%s\"\n", function, file, descr, er);

  sprintf(s, "[%s] %s, %d\n***** %s, %s, %s ... %s !!!",
	NER02_MSG, file, line, function, descr, er, NER03_MSG);

  zcontrol(s, 99);
  zcontrol(s, 3);

  longjmp(ZOPT.OPT->jmpenv, 1);
}
