
/* tbbs (links.c) by Sylvio Runge 7/96
*/



#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>
#include <fcntl.h>
#include <strings.h>
#include <dirent.h>

#ifdef _BSD
#undef _POSIX_SOURCE
#include <sys/stat.h>
#else
#include <sys/stat.h>
#endif




#define LOW_STRING 40

#undef LSTRING
extern char HOME[80];


#include "../mbox.h"
#include "../s_global.h"
#include "../proto.h"
#include "../language.h"


#define IF_DIR 		0x1
#define IF_FILE 	0x2
#define IF_LINK		0x3

int language;



int do_check(path)
char *path;
{
struct stat fst;
char s[2*STRING];

sprintf(s,"%s/etc/languages/%s",HOME,path);
stat(s,&fst);
if(fst.st_mode & S_IFDIR) return (IF_DIR);
/*if(fst.st_mode & S_IFLNK) return (IF_LINK);*/
if(fst.st_mode & S_IFREG) return (IF_FILE);
}






void TestFileTyp1(name,lang)
char *name;
int lang;
{
char s[2*STRING],h[2*STRING];
FILE *fd;
struct stat fst;

  sprintf(s,"%s/etc/languages/%s/%s",HOME,name,GetLangName(lang,0));
  if ((stat(s,&fst)!=0)||(fst.st_mode & S_IFREG) /*(fst.st_mode & S_IFDIR)*/)
  {
    
    printf("%s (",name);
    
    sprintf(s,"%s/etc/languages/%s/%s",HOME,name,GetLangName(lang,0));
    if ((fd=fopen(s,"r"))!=0) printf("%s=ok",name); else
    {
      fclose(fd);
      unlink(s);
      printf("%s=link",name);     
      sprintf(h,"%s/etc/languages/%s/%s",HOME,name,GetLangName(lang,0));
      /*sprintf(s,"../%s/english",name);*/
      sprintf(s,"english",name);
      symlink(s,h);
    }
    fclose(fd);  
  } 
  printf(") ");

}




void TestFileTyp2(name,name2,lang)
char *name,*name2;
int lang;
{
char s[2*STRING],h[2*STRING];
FILE *fd;
struct stat fst;

  sprintf(s,"%s/etc/languages/%s/%s.%s",HOME,name,GetLangName(lang,0),name2);
  if ((stat(s,&fst)!=0)||(fst.st_mode & S_IFREG) /*(fst.st_mode & S_IFDIR)*/)
  {
    
    printf("%s (",name);
    
    sprintf(s,"%s/etc/languages/%s/%s.%s",HOME,name,GetLangName(lang,0),name2);
    if ((fd=fopen(s,"r"))!=0) printf("%s=ok",name); else
    {
      fclose(fd);
      unlink(s);
      printf("%s=link",name);     
      sprintf(h,"%s/etc/languages/%s/%s.%s",HOME,name,GetLangName(lang,0),name2);
      /*sprintf(s,"../%s/english",name);*/
      sprintf(s,"english.%s",name2,name);
      symlink(s,h);
    }
    fclose(fd);  
  } 
  printf(") ");

}













void do_link_check(lang)
int lang;
{
char s[2*STRING],h[2*STRING];
FILE *fd;
struct stat fst;

  language=lang;
  
  /* !!!!!!!!!!!!! LISA !!!!!!!!!!!!! */
  printf("\n\nlanguage=%s: [ ",GetLangName(lang,0));
  sprintf(s,"lisa/%s",GetLangName(lang,0));
  if (do_check(s)==IF_DIR)
  {
    
    printf("lisa (");
    
    /* lisa/known */
    sprintf(s,"lisa/%s/known",GetLangName(lang,0));
    if (do_check(s)==IF_FILE) printf("known=ok "); else
    {
      printf("lisa.known=new ");     
      sprintf(s,"%s/etc/languages/lisa/%s/known",HOME,GetLangName(lang,0));
      fd=fopen(s,"a"); fclose(fd);
    }
    
    /* lisa/msg */
    sprintf(s,"lisa/%s/msg",GetLangName(lang,0));
    if (do_check(s)==IF_FILE) printf("msg=ok"); else
    {
      printf("lisa.msg=new");     
      sprintf(s,"%s/etc/languages/lisa/%s/msg",HOME,GetLangName(lang,0));
      fd=fopen(s,"a"); fclose(fd);
    }
  
  } else 
  {
   sprintf(s,"lisa/%s",GetLangName(lang,0));
   sprintf(h,"%s/etc/languages/%s",HOME,s);
   printf("->?->");
   unlink(h);
   strcpy(s,"english");
   if (!symlink(s,h)) printf("link-ok)"); else printf("\n  Can't link (%s)->(%s)!\n   ",s,h);
  }
  printf(") ");
  

  /* !!!!!!!!! info-base !!!!!!!!!!!!!!! */  
LOP2:  
  sprintf(s,"%s/etc/languages/%s.info",HOME,GetLangName(lang,0));
  stat(s,&fst);
  if (/*(fst.st_mode & S_IFREG)&&*/(fst.st_mode & S_IFDIR))
  {
    
    printf(" info (");
    
    
    sprintf(s,"%s/etc/languages/%s.info/info.1",HOME,GetLangName(lang,0));
    if ((fd=fopen(s,"r"))!=0) printf("info.1=ok"); else
    {
      fclose(fd);
      printf("info.1=new");     
      fd=fopen(s,"a"); 
      fprintf(fd,"sysop: please edit my \"%s\"-infobase :-)\n\n",GetLangName(lang,0));
      fprintf(fd,"Info-base with this languages is empty. Please tell your sysop now\n");
      fprintf(fd,"(directory: \"%s/etc/languages/%s.info/\")!\n",HOME,GetLangName(lang,0));
    }
    sprintf(s,"%s/etc/languages/%s.info/info.2",HOME,GetLangName(lang,0));
    if ((fd=fopen(s,"r"))!=0) printf("info.2=ok"); else
    {
      fclose(fd);
      printf("info.2=new");     
      fd=fopen(s,"a"); 
      fprintf(fd,"sysop: please edit my \"%s\"-infobase :-)\n\n",GetLangName(lang,0));
      fprintf(fd,"Info-base with this languages is empty. Please tell your sysop now\n");
      fprintf(fd,"(directory: \"%s/etc/languages/%s.info/\")!\n",HOME,GetLangName(lang,0));
    }
    fclose(fd);  
  } else 
  {
   sprintf(h,"%s/etc/languages/%s.info",HOME,GetLangName(lang,0));
   printf("\n   mkdir(%s) ",h);
   mkdir(h,0755);
   goto LOP2;
  }
  
  printf(") ");


/* !!!!!!!!! guest-intro !!!!!!!!!!!!!!! */  
  sprintf(s,"%s/etc/languages/guest.intro/%s",HOME,GetLangName(lang,0));
  if ((stat(s,&fst)!=0)||(fst.st_mode & S_IFREG) /*(fst.st_mode & S_IFDIR)*/)
  {
    
    printf(" intro (");
    
    sprintf(s,"%s/etc/languages/guest.intro/%s",HOME,GetLangName(lang,0));
    if ((fd=fopen(s,"r"))!=0) printf("guest.intro=ok"); else
    {
      fclose(fd);
      unlink(s);
      printf(" guest.intro=new");     
      fd=fopen(s,"a"); 
      fprintf(fd,"Enjoy this brand new version of the ix/MBox BBS package. It'll impress you\n");
      fprintf(fd,"with lots of new features and \"special effects\".\n");
    }
    fclose(fd);  
  } 
  printf(") ");

 /* type 1 */
 TestFileTyp1("hlp",lang) ;
 TestFileTyp1("newaccount",lang) ;
 TestFileTyp1("qwk.hlp",lang) ;
 TestFileTyp1("sfile.hlp",lang) ;
 TestFileTyp1("shh",lang) ;
 TestFileTyp1("adt",lang) ;
 TestFileTyp1("asc",lang) ;
 TestFileTyp1("bled",lang) ;

 TestFileTyp1("wendy",lang) ;

 TestFileTyp1("logout",lang) ;
 TestFileTyp1("ansi/fido.board",lang) ;
 TestFileTyp1("ansi/fido.email",lang) ;
 TestFileTyp1("ansi/fido.info",lang) ;
 TestFileTyp1("ansi/fido.m_user",lang) ;
 TestFileTyp1("ansi/fido.main",lang) ;
 TestFileTyp1("ansi/fmain",lang) ;
 TestFileTyp1("assist",lang) ;
 TestFileTyp1("mail.welcome.user",lang) ;
 TestFileTyp1("cmd",lang) ;
 
 /* type 2 */
 TestFileTyp2("sysinfo","sysinfo",lang) ;
 TestFileTyp2("logout","ans",lang) ; /*ANSI-Screens fuer engl, franc. etc */
 TestFileTyp2("wmenu","ans",lang) ; /*WMenu-ANSI-Screens fuer engl, franc. etc */
 TestFileTyp2("wmenu","guest.ans",lang) ; /*WMenu-ANSI-Screens fuer engl, franc. etc */


/* !!!!!!!!! RIP !!!!!!!!!!!!!!! */  
  sprintf(s,"%s/etc/Rip/%s",HOME,GetLangName(lang,0));
  stat(s,&fst);
  printf(" RIP1.54");
  if (!(fst.st_mode & S_IFDIR))
  {
    
    printf(" info (");
    unlink(s);
    printf("=link");
    symlink("deutsch",s);
  } else 
   printf("=ok");
  
  printf(") ");
  
  
printf(" ]");  




}







