

#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <pwd.h>

#include <stdio.h>
/*#include <stdlib.h>*/
#include <unistd.h>
#include <strings.h>



#ifndef UNSIGNED
#if !defined(_MINIX) || defined(_ESTDIO)
#define UNSIGNED unsigned
#else
#define UNSIGNED
#endif
#endif



#include "mbox.h"
#include "s_global.h"
#include "compile.h"
#include "uqwk/uqwk.h"
#include "alias.update/defs.h"




#ifdef LONGSTRING
#undef LONGSTRING
#endif
#undef STRING
#define STRING 81
#define LONGSTRING 256

UNSIGNED char headinfo[STRING];





/* #SP - Delete all leading and tailing blanks in string [st].

   This function returns the string without blanks. */

UNSIGNED char *stripped(st)
UNSIGNED char st[];
{
  UNSIGNED char *s = st;

  int i = 0;

#ifdef _PROFILE
  profile( "stripped()" );
#endif

  if (st[0] == 0) 
	return ((UNSIGNED char *) s);

  if ((st[0] == 10) || (st[0] == 13)) 
	return (UNSIGNED char *) " ";

  while((s[0] < 33) && (s[0] != 0)) s++;
  i = strlen(s);
  while(s[i] < 33) i--;
  s[(i+1)] = 0;

  return (UNSIGNED char *) s;
}

/* #MR - Rename file [alt] to file [neu].

   This function returns 0 if everything went ok, or -1 if there are
   any problems. */

int mbrename(alt, neu)
UNSIGNED char alt[], neu[];
{
  FILE *fp;
  FILE *ff;

  UNSIGNED char s[LONGSTRING];

  if(rename(alt, neu) == NULL) return 0;


  fp = fopen(neu, "w");
  if (fp == NULL) {
	return -1;
  }
  ff = fopen(alt, "r");
  if (ff == NULL) {
	return -2;
  }
  
  while(fgets(s, LONGSTRING, ff) != NULL)
	fputs(s, fp);

  fclose(fp);
  fclose(ff);

  unlink(alt);

  return 0;
  
}


/* #SC - Cut a part out of a string [st].

   [v] describes the first position in [st], [b] stands for the last
   position. 

   This function returns the part between [v] and [b] as a string. */

UNSIGNED char *strcopy(st, v, b)
UNSIGNED char st[];
int v, b;
{
  static UNSIGNED char s[STRING];

  int i = 0, j;

#ifdef _PROFILE
  profile( "strcopy()" );
#endif
 
  if(b > STRING) b = STRING;

  for (j = v; j <= b; j++) {
	s[i] = st[j];
	i++;
  }
  s[i] = 0;

  return (UNSIGNED char *) s;
}



/* #WH - Find the name of your shell account.

   This function returns the name of a shell account. */

UNSIGNED char *whoami()
{
  struct passwd *pw_entry;

  pw_entry = getpwuid(getuid());

/*  if (pw_entry->pw_uid < (uid_t) 0) return (UNSIGNED char *) "OOPS";*/

  return (UNSIGNED char *) (pw_entry->pw_name);
}






/* #ST - Compare two strings [s, t] case insensitive.

  This function returns the number of different characters. */

int strcomp(s, t)
char *s, *t;
{
  int i = 0, a = 0;
  UNSIGNED char s1, t1;

 
#ifdef _PROFILE
  profile( "strcomp()" );
#endif

  while (s[i] != 0) {
	s1 = s[i];
	t1 = t[i];
	if (t1 > 96) 
		if (t1 < 123) t1 -= 32;
	if (s1 > 96)
		if (s1 < 123) s1 -= 32;
	if (t1 != s1) a++;
	i++;
  }

  return (int) a;
}




/* #MT - Get the time.

   [mode]  ->  0 = hh:mm:ss
               1 = hh:mm

   This function returns a time string. */

UNSIGNED char *mytime(mode)
int mode;
{
  struct tm *tp;
  time_t tt;

  static UNSIGNED char s[STRING];


#ifdef _PROFILE
  profile( "mytime()" );
#endif

  time(&tt);
  tp = localtime(&tt);
  sprintf(s, "%02.2d:%02.2d:%02.2d", tp->tm_hour, tp->tm_min, tp->tm_sec);

  if (mode == 1) s[5] = 0;

  return (UNSIGNED char *) s;
}



/* #MD - Get the date.

   [mode]  ->  0 = tt.mm.yyyy
               1 = tt.nn.yy
               2 = ttt
	       3 = Sunday | Saturday ??? (Returns 0 if not !)

   This function returns a date string. */


#ifndef TZS
#define TZS	1
#endif

UNSIGNED char *mydate(mode)
int mode;
{
  struct tm *tp;
  time_t tt;
  UNSIGNED char wt[8][11];

  static UNSIGNED char s[STRING];


  if (((!ZOPT.OPT->USER.language!=0))&&(L_INIT))
  {
    strcpy(wt[0], (UNSIGNED char*) GetText("MTOOL01"));
    strcpy(wt[1], (UNSIGNED char*)GetText("MTOOL02"));
    strcpy(wt[2], (UNSIGNED char*)GetText("MTOOL03"));
    strcpy(wt[3], (UNSIGNED char*) GetText("MTOOL04"));
    strcpy(wt[4], (UNSIGNED char*) GetText("MTOOL05"));
    strcpy(wt[5], (UNSIGNED char*) GetText("MTOOL06"));
    strcpy(wt[6], (UNSIGNED char*) GetText("MTOOL07"));   

  } else
  {
    strcpy(wt[0], "Sonntag");
    strcpy(wt[1], "Montag");
    strcpy(wt[2], "Dienstag");
    strcpy(wt[3], "Mittwoch");
    strcpy(wt[4], "Donnerstag");
    strcpy(wt[5], "Freitag");
    strcpy(wt[6], "Samstag");
  }
    if (mode>1000) mode=mode-1000;  
  time(&tt);
  tzset();
  tp = localtime(&tt);
  if (mode == 0) {
	sprintf(s, "%02.2d.%02.2d.%04.4d", tp->tm_mday, tp->tm_mon + TZS, 1900 + tp->tm_year);
  }
  if (mode == 1) {
	sprintf(s, "%02.2d.%02.2d.%02.2d", tp->tm_mday, tp->tm_mon + TZS, tp->tm_year);
  }
  if (mode == 2) {
	sprintf(s, "%s", wt[tp->tm_wday]);
  }
  if (mode == 3) {
	if((tp->tm_wday == 0) || (tp->tm_wday == 6))
		strcpy(s, (UNSIGNED char *) wt[tp->tm_wday]);

	else
		s[0] = 0;
  }
  return (UNSIGNED char *) s;
}



/* #TC - Convert a time string [t] into a (long).

   This function returns the time as a (long). */   

int timeconv(t)
UNSIGNED char t[];
{
  UNSIGNED char s[STRING];
  int i = 0;


  strcpy(s, (UNSIGNED char *) strcopy(t, 0, 1));
  i = 100 * atoi(s);
  strcpy(s, (UNSIGNED char *) strcopy(t, 3, 4));
  i += atoi(s);

  return i;
}





/* #MU - Unlock a file [path]. */

void mbunlock( path )
UNSIGNED char path[];
{
  UNSIGNED char s[STRING];
  
  sprintf(s, "%s.LCK", path); 

#ifndef _LONGNAMES
  strcpy(s, (UNSIGNED char *) shortname(s));
#endif

  unlink(s);
}





 
int maybe_locked(name, mode)
UNSIGNED char name[], mode[];
{
  FILE *fp;
  int i = 0;
  static UNSIGNED char s[STRING];


  sprintf(s, "%s.LCK", name);


  TRY_TWICE:

  fp = NULL;

  do {
	if(fp != NULL) fclose(fp);
	fp = fopen(s, "r");
	i++;
	if (fp != NULL) {
		if(i == 1) printf("%c%s (%s)", CR, TOL08_MSG,s);
		printf(".");
		sleep(3);
	}
  } while ((i < 8) && (fp != 0));

  if(fp != 0){
	fclose(fp);
	mbunlock(name);  /* <--- DAS IST NATUERLICH NICHT KORREKT !!! */
	goto TRY_TWICE;  /* <--- DAS AUCH NICHT !!! ABER ES FUNXT ;-) */
	nerror("tools.c", 566, "maybe_locked", "File locked", name);	
	exit( -1 );
  }

  i = 0;

  do {
	fp = fopen(name, "r");	/* "r" => "mode", aber VORSICHT ! */
	i++;
	if (fp == NULL) {
		if(i == 1) printf("%c%s (%s)", CR, TOL08_MSG,name);	
		printf(".");
		sync();
		sleep(3);
	}
  } while ((i < 5) && (fp == NULL));

  if (fp == NULL) return -1;

  fclose(fp);
  return 0;
}





/* #ML - Check whether a file [name] is locked or simply doesn't exist.

   [mode] shouldn't be used!

   This function returns 0 if a file is locked and -1 if file doesn't
   exist. */
 
int maybe_locked2(name, mode)
UNSIGNED char name[], mode[];
{
  FILE *fp;
  int i = 0;
  UNSIGNED char s[STRING];

#ifdef _PROFILE
  profile( "mytime()" );
#endif

  sprintf(s, "%s.LCK", name);

#ifndef _LONGNAMES
  strcpy(s, (UNSIGNED char *) shortname(s));
#endif

  TRY_TWICE:

  fp = NULL;

  do {
	if(fp != NULL) fclose(fp);
	fp = fopen(s, "r");
	fclose(fp);
	i++;
	if (fp != NULL) {
		if(i == 1) printf("%c%s ", CR, TOL08_MSG);
		printf(".");
		sleep(1);
	}
  } while ((i < 15) && (fp != 0));

  if(fp != 0){
	fclose(fp);
#ifdef _MBOX
	mbunlock(name);  /* <--- DAS IST NATUERLICH NICHT KORREKT !!! */
	goto TRY_TWICE;  /* <--- DAS AUCH NICHT !!! ABER ES FUNXT ;-) */
	nerror("tools.c", 566, "maybe_locked", "File locked", name);	
#else
	printf("\n\nDatei >>%s<< gesperrt !!!\n\n", name);
#endif
	exit( -1 );
  }

  i = 0;

  do {
	fp = fopen(name, "r");	/* "r" => "mode", aber VORSICHT ! */
	fclose(fp);
	i++;
	if (fp == NULL) {
		if(i == 1) printf("%c%s ", CR, TOL08_MSG);	
		printf(".");
		sleep(1);
	}
  } while ((i < 15) && (fp == NULL));

  if (fp == NULL) return -1;

  fclose(fp);
  return 0;
}







/* #SN - Converting a long filename [longname] into a 14-char name.

       comp.protocols.tcp-ip.sources.wanted
   ==> comp0ces.wanted

   This function returns the shortened name. */

UNSIGNED char *shortname( longname )
UNSIGNED char longname[];
{
static  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];

  int i = 0, j = 0;

  strcpy(s, longname);

  strcpy(t, longname);

  while(s[i] != 0){
	if(s[i] == '/') j = i + 1;
	i++;
  }

  i = strlen(t);
  
  if((i - j) < 15) return (UNSIGNED char *) s;
  
  sprintf(s, "%s%d", (UNSIGNED char *) strcopy(s, j, j + 1), (i - 14));
  strcat(s, (UNSIGNED char *) strcopy(t, (i-12), i));
  s[14] = 0;

  return (UNSIGNED char *) s;
}





/* #MO - Lock a file [path]. */

void mblock( path )
UNSIGNED char path[];
{
  FILE *fp;
  UNSIGNED char s[STRING];

  sprintf(s, "%s.LCK", path); 

#ifndef _LONGNAMES
  strcpy(s, (UNSIGNED char *) shortname(s));
#endif

  fp = fopen( s, "w" );
  if(fp != NULL){
	fputs(VERSION, fp);
	fclose(fp);
  }
}






/* #DC - Convert a date string [d] into a (long).

   This function returns the date as a (long). */   

long dateconv(d)
UNSIGNED char d[];
{
  UNSIGNED char s[STRING];
  int a, b, i;

  strcpy(s, (UNSIGNED char *) strcopy(d, 0, 1));
  a = atoi(s);
  strcpy(s, (UNSIGNED char *) strcopy(d, 3, 4));
  b = atoi(s);
  strcpy(s, (UNSIGNED char *) strcopy(d, 6, 9));
  i = atoi(s);
  if (i < 1900) i += 1900;

  sprintf(s, "%4.4d%02.2d%02.2d", i, b, a);

  return atol(s);
}



/* sicherheit-strings-funct: loescht alle kritischen Zeichen aus arg eines bef*/
unsigned char *si_strings(s)
unsigned char s[];
{
  static unsigned char b[STRING];
  int j;
  
for (j=0;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if ((b[j]>127)||(b[j]<40)) b[j]=32;
 if ((b[j]==124)||(b[j]==126)||(b[j]==60)||(b[j]==62)||(b[j]==33)||(b[j]==96)) b[j]=64; /* :-) */
}
 b[j]=0;
  	     
  	     
  return (UNSIGNED char *) (b);
}





/* loescht alle Leer-Zeichen aus arg eines bef, eigentlich nur fuer LOOSER notwendig*/
unsigned char *leer2clear(s)
unsigned char s[];
{
  static unsigned char b[STRING],c[STRING];
  int j,k;

/* unmoegliche Zeichen auf SPACE setzen */  
for (j=0;j<=(strlen(s));j++)
{
 b[j]=s[j];
 if ((b[j]>127)||(b[j]<40)) b[j]=32;
}
 b[j]=0;
 
/* Leer-Zeichen entfernen */  
k=0;
for (j=0;j<=(strlen(b));j++)
{
 if (b[j]!=SPACE)
 {
  c[k]=b[j];
  k++;
 }
}
 c[k]=0;
  	     
  	     
  return (UNSIGNED char *) (c);
}

