#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>
#include <fcntl.h>
#include <sys/stat.h>
/*#include <stdlib.h>*/
#include <strings.h>

#ifndef VU
#include "mbox.h"
#include "proto.h"
#include "s_global.h"
#include "language.h"
#else
#include "../mbox.h"
#include "../proto.h"
#include "../s_global.h"
#include "../language.h"
#endif



/* #HE - Give help.

   [cmd]   ->  '*'        = Display the entire helpfile
               '='        = Show the short version of the helpfile

               '#Command' = find the entry for 'Command' and show
                            the belonging helptext

   This functions returns 0 on any errors or the number of found entries
   otherwise. */

int help(cmd)
UNSIGNED char cmd[];
{
  FILE *fp;
  UNSIGNED char s[LONGSTRING];
  int ok = 0, found = 0, toggle = 0, lines = 0, new = 0;

  show(ZOPT.OPT->KURZHILFE, 99, 99); /* RESET */
  
  if(cmd[0] == '='){
	if(ZOPT.OPT->USER.schluessel[3] != 128){
		headline( GetText("HLP01_MSG") );
		show(ZOPT.OPT->KURZHILFE, 9999, ZOPT.OPT->USER.more);
	}
	else{
	        chdir((char *) ZOPT.OPT->HOME);
		show_raw( ANSI_HELP, 10 );
		show(ZOPT.OPT->KURZHILFE, 9999, ZOPT.OPT->USER.more + 1000);
	}

	return 9999;
  }

  maybe_locked(ZOPT.OPT->HILFE, "r");
  fp = fopen(ZOPT.OPT->HILFE, "r");
  if (fp == NULL) {
	nerror("help.c", 14, "help", "Can't read", ZOPT.OPT->HILFE);
  }
  if (cmd[0] != '#') {
	ok = 2;
	found++;
  }
  headline( GetText("HLP01_MSG") );
  lines = 0;

  while(fgets(s, STRING, fp) != NULL){

	if(ZOPT.OPT->UMLAUT_MODUS != 4) 
		strcpy(s, (UNSIGNED char *) iso_line(s));
	
	strcpy(s, (UNSIGNED char *) richtext(s));

	if (ZOPT.OPT->USER.more > 0) {
		if (lines >= ZOPT.OPT->MAX_SCR_LINES) {
			lines = 0;
			if (more() != 0) return 1;
		}
	}
	if (ok == 2) {
		if (s[0] != '#') {
			printf("%s", s);
			lines++;
			if (toggle > 0) {
				ansi2("me", 0, 0);
				toggle = 0;
			}
		}
		else {
			printf("\n");
			lines++;
			ansi2("md", 0, 0);
			toggle++;
		}
	}
	else {
		if ((ok == 1) && (s[0] == '#')) {
			if(new != 0){
				ok = 0;
				/*
				printf("\n");
				*/
				lines++;
				new = 0;
			}
		}
		if ((ok == 1) && (s[0] != '#')) {
			printf("%s", s);
			new++;
			lines++;
			if (toggle > 0) {
				ansi2("me", 0, 0);
				toggle = 0;
			}
		}
		if ((ok == 0) && (s[0] == '#')) {
			if (strcomp(cmd, s) == 0) {
				ok = 1;
				found++;
				ansi2("md", 0, 0);
				toggle++;
			}
		}
	}
  }
  fclose(fp);

  return found;
}






/* #IT - Help quickly. */

int intuition( be )
int be;
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char ex[LONGSTRING];
  UNSIGNED char xx[LONGSTRING];

  FILE *fp;

  int i, ok = 0;

  s[0] = 0; i = 0;
  while((s[0] == 0) && (ZOPT.OPT->BEF[i].id != -1)){
	if(ZOPT.OPT->BEF[i].id == be) strcpy(s, ZOPT.OPT->BEF[i].befehl);
	i++;
  }
  
  sprintf(t, "%s/etc/languages/shh/%s", ZOPT.OPT->HOME, GetLanguage());
  fp = fopen(t, "r");
  if(fp == NULL){
	nerror("help.c", 155, "intuition", "Can't read", t);
	return(0);
  }

  ansi2( "us", 0, 0 );
  printf("\n-------------------------------------------------------------------------------\n");
  ansi2( "me", 0, 0 );

  while(fgets(ex, LONGSTRING, fp) != 0){
	if(strlen(ex) < 40) ok = 0;
	strcpy(t, (UNSIGNED char *) strcopy(ex, 0, 40));
	if((sgrep(t, s) != 0) || (ok > 0)){
		strcpy(xx, (UNSIGNED char *) richtext( ex ));
		strcpy(ex, (UNSIGNED char *) iso_line( xx ));
		printf("%s", ex );
		ok++;
	}
  } 
 
  fclose(fp); 

  ansi2( "us", 0, 0 );
  printf("-------------------------------------------------------------------------------\n");
  ansi2( "me", 0, 0 );
  return(0);
}




/* #LC - Lowcaseing all characters in string [st].

   This function returns the "lowcased" string. */

UNSIGNED char *lowcased(st)
unsigned char st[];		/* !!! unsigned, NOT UNSIGNED !!! */
{
  static UNSIGNED char s[STRING];

  int i = 0;

#ifdef _PROFILE
  profile( "lowcased()" );
#endif

  strcpy(s, (UNSIGNED char *) strcopy(st, 0, STRING));

  while (s[i] != 0) {
	if (s[i] > 127) {
		if (s[i] == 142) s[i] = 132; /* IBM/DOS, ATARI ST */
		if (s[i] == 153) s[i] = 148;
		if (s[i] == 154) s[i] = 122;
		if (s[i] == 196) s[i] = 228; /* ISO-8859-1, AMIGA */
		if (s[i] == 214) s[i] = 246;
		if (s[i] == 220) s[i] = 252;
	}
	else{
		if ((s[i] > 64) && (s[i] < 97)) s[i] += 32;
	}
	i++;
  }

  return (UNSIGNED char *) s;
}





/* #FF - Addresses ... [mode == 0] -> add a new on, [mode == 1] -> search */

UNSIGNED char *filofax( address, mode )
UNSIGNED char address[];
int mode;
{
static  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char v[STRING];
  UNSIGNED char a[STRING];

  FILE *fp;
 
  int ok = 0, x, y, i, c;

  strcpy(a, (UNSIGNED char *) stripped(address));
  sprintf(t, "%s/usr/%c/%d/.address",  ZOPT.OPT->HOME, 
  	 ZOPT.OPT->USER.name[0],  ZOPT.OPT->USER.id);


s[0]=0;
if (strlen(address)<1) return((UNSIGNED char *) s);

  if(mode == 0){
        if (!ZOPT.OPT->adr_on) 
         {
           s[0]=0;
           return((UNSIGNED char *) s);
         }
	sprintf(t, "%s/usr/%c/%d/.address",  ZOPT.OPT->HOME, 
		 ZOPT.OPT->USER.name[0],  ZOPT.OPT->USER.id);

	fp = fopen( t, "r" );
	if(fp != NULL){
		while(fgets(s, STRING, fp) != 0){
			if(strcomp(a, s) == 0){
				ok++;
			}
		}
		fclose(fp);
	}
	if(ok == 0){
		fp = fopen(t, "a" );
		fprintf(fp, "%s, NICKNAME\n", (UNSIGNED char *) a);
		fclose(fp);
	}

	strcpy(s, (UNSIGNED char *) "OK" );
  }
	
  if(mode == 1){
  
	strcpy(s, (UNSIGNED char *) a);
        if (!ZOPT.OPT->adr_auto)
        {
          return((UNSIGNED char *) s);
       }
	                                                

	fp = fopen( t, "r" );
	if(fp != NULL){
		while((fgets(v, STRING, fp) != 0) && (ok == 0)){
			x = strpos(",",v);
			if(x != 0){
			        
				strcpy(s, (UNSIGNED char *) stripped(strcopy(v, x, strlen(v))));
				if(strcomp(a, s) == 0){
					ok++;
					strcpy(a, (UNSIGNED char *) stripped(strcopy(v, 0, x-2)));
					i = 0; x = -1; y = -1; c = 0;
					while(a[i] != 0){
						if(a[i] == '('){
							x = i+1; c = 1;
						}
						if((a[i] == ')') && (y == -1)){
							y = i-1;
						}
						if(a[i] == '<'){
							x = i+1; c = 2;
						}
						if((a[i] == '>') && (y == -1)){
							y = i-1;
						}
						i++;
					}
					if(c == 0) strcpy(s, (UNSIGNED char *) a);
					if(c == 1){
						strcpy(s, (UNSIGNED char *) stripped(strcopy(a, 0, x-2)));
					}
					if(c == 2){
						strcpy(s, (UNSIGNED char *) stripped(strcopy(a, x, y)));
					}
				   ansi("us");
				   printf("\n%s: \"%s\" -> \"%s\"\n",GetText("HLP06_MSG"),address,s);
				   ansi("me");
				}
			}
		}
		fclose(fp);
		if(ok == 0) strcpy(s, (UNSIGNED char *) a);
	}
  }

  return (UNSIGNED char *) s;
}
