/**
 ** FONTTEST.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/


#include <string.h>
#include <dirent.h>
#include "../grafik.h"

#define VOLLBILD	

int cx;
int cy;
int c1;
int c2;
int c3;
int c4;

char test_text[] = {
    "QUICK BROWN FOX JUMPS OVER THE LAZY DOG, "
    "quick brown fox jumps over the lazy dog !@#$%^&*()1234567890"
};

void displayfont(GrFont *font,char *text,int len,int mode)
{
	GrTextOption opt;
	int ww,hh;
	int bx,by;
	int bw,bh;
	int pw,ph;
	int ii;

	pw = ph = 0;
	memset(&opt,0,sizeof(opt));
	if ((opt.txo_font = GrLoadFont(font))==NULL) opt.txo_font=NULL;
	opt.txo_xalign = GR_ALIGN_LEFT;
	opt.txo_yalign = GR_ALIGN_TOP;
	GrFilledBox(0,0,GrSizeX(),GrSizeY(),GrBlack());
	for(ii = 1; ; ii++) {
	    opt.txo_xmag = ii;
	    opt.txo_ymag = ii;
	    opt.txo_direct  = GR_TEXT_RIGHT;
	    opt.txo_fgcolor.v = GrBlack();
	    opt.txo_bgcolor.v = c1;
	    ww = GrStringWidth(text,len,&opt);
	    hh = GrStringHeight(text,len,&opt);
	    bw = ww+2*hh;
	    bh = ww;
	    if(bw < pw+2*hh+2) bw = pw+2*hh+2;
	    if(bh < ph+2*hh+2) bh = ph+2*hh+2;
	    pw = bw;
	    ph = bh;
	    if(bw > (2*GrSizeX())) break;
	    bx = cx - bw/2;
	    by = cy - bh/2;
	    GrDrawString(text,len,bx+hh,by,&opt);
	    opt.txo_direct  = GR_TEXT_DOWN;
	    opt.txo_bgcolor.v = c2;
	    GrDrawString(text,len,bx+bw-hh,by,&opt);
	    opt.txo_direct  = GR_TEXT_LEFT;
	    opt.txo_bgcolor.v = c3;
	    GrDrawString(text,len,bx+bw-ww-hh,by+bh-hh,&opt);
	    opt.txo_direct  = GR_TEXT_UP;
	    opt.txo_bgcolor.v = c4;
	    GrDrawString(text,len,bx,by+bh-ww,&opt);
	}
	getkey();
	GrClearClipBox(GrBlack());
if (mode)	
{
	opt.txo_xmag = 1;
	opt.txo_ymag = 1;
	opt.txo_direct  = GR_TEXT_RIGHT;
	opt.txo_fgcolor.v = c1;
	opt.txo_bgcolor.v = GrBlack();
	hh = GrFontHeight(&opt);
#ifndef VOLLBILD		
	bx = GrSizeX() / 16;
	by = GrSizeY() / 16;
#else
	bx=by=0;
#endif	
	bx = (bx + 7) & ~7;
	
	while(by < GrSizeY()) {
	    GrDrawString(test_text,strlen(test_text),bx,by,&opt);
	    opt.txo_fgcolor.v ^= GR_UNDERLINE_TEXT;
	    by += hh;
	}
     getch();
     
}
GrUnloadFont(opt.txo_font);	
/*free(opt.txo_font);opt.txo_font=NULL;*/
}


void SGrFontInit()
{	
	cx = GrSizeX() / 2;
	cy = GrSizeY() / 2;
	c1 = GrAllocColor(100,200,100);
	c2 = GrAllocColor(150,150,100);
	c3 = GrAllocColor(100,100,200);
	c4 = GrAllocColor(100,180,180);
#ifndef VOLLBILD	
	GrBox(GrSizeX()/16 - 2,
	    GrSizeY()/16 - 2,
	    GrSizeX() - GrSizeX()/16 + 1,
	    GrSizeY() - GrSizeY()/16 + 1,
	    GrAllocColor(250,100,100)
	);
	GrSetClipBox(GrSizeX()/16,
	    GrSizeY()/16,
	    GrSizeX() - GrSizeX()/16 - 1,
	    GrSizeY() - GrSizeY()/16 - 1
        );
#endif       
}

font_test_run()
{
	char buff[100],buff2[50];
	DIR *dp;
	int c;
  	struct dirent *actdir;	
  	 char  font[80];
	
	F2Init();
	sprintf(buff,"%s/etc/bitmaps/fonts",HOME);

	if(getenv("GRXFONT") == NULL) GrSetFontPath(buff);
        SGrFontInit();
	strcpy(buff, "Default font");  /* pc8x14 */
	displayfont(NULL,buff,strlen(buff),1);
	sprintf(buff,"%s/etc/bitmaps/fonts",HOME);
	dp=opendir(buff);
        for (c=0;c<2;c++) readdir(dp);
        FLog(actdir->d_name);
        while(((actdir = readdir(dp)) != NULL)    )	
        {
        FLog(actdir->d_name);
        
         if (strpos("fnt",actdir->d_name))
          {
         
 	    printf("\nZeichensatz: %s",actdir->d_name);
 	    sprintf(buff,"%s/etc/bitmaps/fonts",HOME);
 	    actdir->d_name[strpos("fnt",actdir->d_name)-2]='\0';
 	    if(getenv("GRXFONT") == NULL) GrSetFontPath(buff);
/* 	    SGrFontInit();*/
 	    strcpy(buff2,actdir->d_name);
	    sprintf(buff,"This is %s",actdir->d_name);
	    strcpy(font,actdir->d_name);
	     displayfont(&font,&buff,strlen(buff),0);

	}
	}
	if (!dp) closedir(dp);

}

F2Init()
{
	int x;
	int y;
	int c;


	x=640;
	y=450 /*350*/;
	c=16 ;
	if(c >= 2)
	    GrSetMode(GR_width_height_color_graphics,x,y,c);
	else if((x >= 320) && (y >= 200))
	    GrSetMode(GR_width_height_graphics,x,y);
	else GrSetMode(GR_default_graphics);
}

void font_test()
{
	F2Init();
	font_test_run();
	GrSetMode(GR_default_text);
}


void FLog(t)
char *t[];
{
/*
FILE *fd;
fd=fopen("/tmp/fonttest.log","a");
fprintf(fd,"%s\n",t);
fclose(fd);
*/
}