

#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>
#include <fcntl.h>
#include <sys/stat.h>
/*#include <stdlib.h>*/
#include <strings.h>

#ifndef VU
#include "mbox.h"
#include "proto.h"
#include "s_global.h"
#include "language.h"
#else
#include "../mbox.h"
#include "../proto.h"
#include "../s_global.h"
#include "../language.h"
#endif




#ifndef STRING
#define STRING 85
#endif


#undef ALWAY_8BIT  /* immer 8Bit-code nutzen */

/* GL - Read a line.

   [len]      ->  How many characters
   [mode]     ->     <0  =  7 Bit
                      0  =  Don't echo input (i.e. nothing is shown)
                      1  =  Echo input 
                      2  =  Show '*' instead of receiver characters
                      3  =  Show ':' as third and sixth character (time input)
                      4  =  Show '.' as third and sixth character (date input)
                      5  =  Only accept alphanumerical input
                     10  =  Show [bsc] [len] times before accepting any input
                    100  =  Only numeric input, '.' and ':' allowed
                   1000  =  Show [deftext] and [bsc] first
                  10000  =  If a number is the first input, return immediately
   [bsc]      ->  Print this to delete
   [deftext]  ->  To be displayed if [mode] >= 1000 */

static int endless;

UNSIGNED char *getline(len, mode, bsc, deftext)
int len, mode;
int bsc;
UNSIGNED char deftext[];
{
  static UNSIGNED char gls[STRING];
  int c;
  int gli, gll;
  int delim = 0;
  int matrix = 0;
  int echo = 1, numerics = 0, defmode = 0, letters = 0;
  int escape = 0;
  int lenmem = len;
  int lastwasblank = 0;
  int siebenbit = 0;
  
#ifndef ALWAY_8BIT   
  if (mode < 0) {
	siebenbit++;
	mode *= -1;
  }
#endif
  
  if (mode > 10000) {
	escape++;
	mode -= 10000;
  }
  if (mode > 1000) {
	mode -= 1000;
	defmode++;
  }
  if (mode > 100) {
	mode -= 100;
	numerics++;
  }
  if (mode > 10) {
	mode -= 10;
	matrix++;
  }
  if (mode > 2) {
	switch(mode){
		case 3	: delim = ':';
			  break;
		case 4  : delim = '.';		
			  break;
	 	case 5  : letters++;
			  break;
	}
	mode = 1;
  }
  echo = mode;

  if (defmode != 0) {
	if((deftext[0] < 32) || (deftext[0] > 126)) deftext[0] = 0;
	gll = strlen(deftext);
	lenmem = len - gll;
	if(deftext[0] != 0){
		sprintf(gls, "%s", deftext);
		printf("%s", deftext);
	}
	else gls[0] = 0;
  }
  else {
	gll = 0;
	strcpy(gls, (UNSIGNED char *) "OOPS");
  }

  if (matrix != 0) {
	for (gli = 0; gli < lenmem; gli++) {
		if (((gli == 2) || (gli == 5)) && (delim != 0) && (gli != len)) {
			printf("%c", delim);
		}
		else {
			printf("%c", bsc);
		}
	}
	for (gli = 0; gli < lenmem; gli++) printf("%c", BS);
  }

  do {

	if (delim != 0) {
		if (((gll == 2) || (gll == 5)) && (gll < len)){
			c = delim;
		}
		else {
			c = getint();  
		}
	}
	else {
		c = getint();  
	}        

	if(siebenbit != 0){
		if(c > 127) c = 0;
	}

	/*  LINUX' very strange keymaps ;-(                      */
	/*  DEL (= 127) will NOT work any longer! Never mind ... */

 	if (c == 127) c = BS;



	if (c == ESC) {
		c = getint();  
		if(c == 'A'){		/* G90 CODE */
			g94();
		}
		else{			/* CURSOR MOVE */
			c = getint();  
			if ((c == 'A') || (c == 'B')) {
				if (c == 'A') endless++;
				if (c == 'B') endless--;
				if (endless < 1) endless = 9;
				if (endless > 9) endless = 1;
				sprintf(gls, "%d", endless);
				return (UNSIGNED char *) gls;
			}
			if (c == 'D') c = BS;
			if (c == 'C') c = ENTER;
		}
	}
	if ((c == CTRL_X) || (c == CTRL_D) || (c == DEL)) {
		return (UNSIGNED char *) "<BREAK>";
	}
	if (c == FF) {
		printf("\\\n");
		c = 0;
	}
	if (c != ENTER) { 
		if ((c == BS) && (gll > 0)) {
			if (((gll == 3) || (gll == 6)) && (delim != 0)) {
				gll -= 2;
				printf("%c%c%c%c", BS, BS, bsc, BS);
			} else {
				gll--;
				printf("%c%c%c", BS, bsc, BS);
			}
		}
		if (numerics == 0) {
			if (c >= 32) {
				if(letters != 0){
					if((c < 'A') && (c != ' ')) c = 0;
					if(c > 'z') c = 0;
					if((c > 'Z') && (c < 'a')) c = 0;

					if(c == ' '){
						if(lastwasblank != 0) c = 0;
						lastwasblank++;
					}
					else{
						if(c != 0) lastwasblank = 0;
					}				

					if(c == 0)
						printf("%c", BELL);
				}
				if(c != 0){
					gls[gll] = c;
					gll++;
				}
			}
			else {
				c = 0;
			}
		}
		else {
			if ((c == '.') || (c == ':') || ((c >= '0') && (c <= '9'))) {
				if (((delim != 0) && ((c == '.') || (c == ':'))) &&
				    ((gll != 2) && (gll != 5))) {
					printf("%c", BELL);
					c = 0;
				}
				else {
					gls[gll] = c;
					gll++;
					gls[gll] = 0;
				}
			}
			else {
				if (c != BS) printf("%c", BELL);
				c = 0; 
			}
		}
		if (c != 0) {
			if (echo == 1) printf("%c", c);
			if (echo == 2) printf("*");
		}
	}
	if (gll == 1) {
		if (escape != 0) {
			if (((c > 47) && (c < 58)) ||
			     (c == '-') || (c == '+') ||  (c == '/') ||  (c == '*')) {
					gls[gll] = 0;
					return (UNSIGNED char *) gls;
			}
		}
	}

  } while ((c != ENTER) && (gll < len));

  gls[gll] = 0;

  return (UNSIGNED char *) gls;
}







/* #GI - Read an integer. */

int getint_old()
{
  int c;


  if(ZOPT.OPT->UMLAUT != 0){
	c = ZOPT.OPT->UMLAUT;
	ZOPT.OPT->UMLAUT = 0;
	return (int) c;
  }

  do{
	c = (int) bgetch();

#ifndef _UMLAUT

	if(c > 127){

		ZOPT.OPT->UMLAUT = 'e';

		switch(c){
			case 142 : c = 'A'; /* IBM 'Ae' */
				   break;
			case 153 : c = 'O'; /* IBM 'Oe' */
				   break;
			case 154 : c = 'U'; /* IBM 'Ue' */
				   break;
			case 132 : c = 'a'; /* IBM 'ae' */
				   break;
			case 148 : c = 'o'; /* IBM 'oe' */
				   break;
			case 129 : c = 'u'; /* IBM 'ue' */
				   break;
			case 225 : c = 's'; /* IBM 'ss' */
				   ZOPT.OPT->UMLAUT = 's';
				   break;

			case 196 : c = 'A'; /* AMIGA 'Ae' */
				   break;
			case 214 : c = 'O'; /* AMIGA 'Oe' */
				   break;
			case 220 : c = 'U'; /* AMIGA 'Ue' */
				   break;
			case 228 : c = 'a'; /* AMIGA 'ae' */
				   break;
			case 246 : c = 'o'; /* AMIGA 'oe' */
				   break;
			case 252 : c = 'u'; /* AMIGA 'ue' */
				   break;
			case 223 : c = 's'; /* AMIGA 'ss' */
				   ZOPT.OPT->UMLAUT = 's';
				   break;

#ifdef I_LIKE_CONFUSIONS
		        case 128 : c = 'A'; /* APPLE 'Ae' */
				   break;
			case 133 : c = 'O'; /* APPLE 'Oe' */
				   break;
			case 134 : c = 'U'; /* APPLE 'Ue' */
				   break;
			case 138 : c = 'a'; /* APPLE 'ae' */
				   break;
			case 154 : c = 'o'; /* APPLE 'oe' */
				   break;
			case 159 : c = 'u'; /* APPLE 'ue' */
				   break;
			case 167 : c = 's'; /* APPLE 'ss' */
				   ZOPT.OPT->UMLAUT = 's';
				   break;
#endif /* _CONFUSION */
			default  : ZOPT.OPT->UMLAUT = 0;
		}		
        }

  }while((c == 0) || (c > 127));

#else /* _UMLAUT */

  }while(c == 0);

#endif /* _UMLAUT */


  return (int) c;
}





/* #YN - Get a char, but only accept GBL06_MSG (Yes, Ja, Qui) and
   GBL07_MSG (No, Nein, Non). */

int yesno()
{
  int c;

  do {
	c = getint();
	if (c >= 97) c -= 32;
	if ((c != GetEChar("GBL06_MSG")) && (c != GetEChar("GBL07_MSG"))) c = 0;
  } while (c == 0);

  printf("%c", c);

  return (int) c;
}

 


/* #YN - Get a char, but only accept GBL06_MSG (Yes, Ja, Qui) and
   GBL07_MSG (No, Nein, Non). */

int sysop_yesno()
{
  int c;

  printf("[%c,%c]?",GetEChar("GBL06_MSG"),GetEChar("GBL07_MSG"));
  
  do {
	c = getint();
	if (c >= 97) c -= 32;
	if ((c != GetEChar("GBL06_MSG")) && (c != GetEChar("GBL07_MSG"))) c = 0;
  } while (c == 0);

  printf("%c\n", c);
  if (c==GetEChar("GBL06_MSG")) c=1; else c=0; 

  return (int) c;
}

 



/* #GI - Read an integer. */

int getint()
{
  int c, runs;


  if(ZOPT.OPT->UMLAUT != 0){
	c = ZOPT.OPT->UMLAUT;
	ZOPT.OPT->UMLAUT = 0;
	return (int) c;
  }

  runs = 0;

  do{
	c = (int) getch();

	runs++;
	if(runs > 10){ 
#ifdef _MBOX		
		control( "[GETINT] Terminal attachment lost!", 3 );
		logout();
#endif	
		exit(-1);
	}

#ifndef _UMLAUT

	if(c > 127){

		ZOPT.OPT->UMLAUT = 'e';

		switch(c){
			case 142 : c = 'A'; /* IBM 'Ae' */
				   break;
			case 153 : c = 'O'; /* IBM 'Oe' */
				   break;
			case 154 : c = 'U'; /* IBM 'Ue' */
				   break;
			case 132 : c = 'a'; /* IBM 'ae' */
				   break;
			case 148 : c = 'o'; /* IBM 'oe' */
				   break;
			case 129 : c = 'u'; /* IBM 'ue' */
				   break;
			case 225 : c = 's'; /* IBM 'ss' */
				   ZOPT.OPT->UMLAUT = 's';
				   break;

			case 196 : c = 'A'; /* AMIGA 'Ae' */
				   break;
			case 214 : c = 'O'; /* AMIGA 'Oe' */
				   break;
			case 220 : c = 'U'; /* AMIGA 'Ue' */
				   break;
			case 228 : c = 'a'; /* AMIGA 'ae' */
				   break;
			case 246 : c = 'o'; /* AMIGA 'oe' */
				   break;
			case 252 : c = 'u'; /* AMIGA 'ue' */
				   break;
			case 223 : c = 's'; /* AMIGA 'ss' */
				   ZOPT.OPT->UMLAUT = 's';
				   break;

#ifdef I_LIKE_CONFUSIONS
		        case 128 : c = 'A'; /* APPLE 'Ae' */
				   break;
			case 133 : c = 'O'; /* APPLE 'Oe' */
				   break;
			case 134 : c = 'U'; /* APPLE 'Ue' */
				   break;
			case 138 : c = 'a'; /* APPLE 'ae' */
				   break;
			case 154 : c = 'o'; /* APPLE 'oe' */
				   break;
			case 159 : c = 'u'; /* APPLE 'ue' */
				   break;
			case 167 : c = 's'; /* APPLE 'ss' */
				   ZOPT.OPT->UMLAUT = 's';
				   break;
#endif /* _CONFUSION */
			default  : ZOPT.OPT->UMLAUT = 0;
		}		
        }

  }while((c <= 0) || (c > 127));

#else /* _UMLAUT */

  }while(c <= 0);

#endif /* _UMLAUT */


  return (int) c;
}


