/*##########################################################################*/
/*    checkt /etc/passwd + /etc/group   	   			    */
/*##########################################################################*/


#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <pwd.h>
       
       

#include "../mbox.h"
#include "../mbox.msg"
#include "../s_global.h"
#include "defs.h"

char s[3*STRING],tmp[2*STRING];

void check_passwd()
{
  printf("\ncheck \"/etc/passwd\".....");
  check_entry("bbs","","BBS_USER",GUEST_GID,GUEST_GID);
  check_entry("bbsd","*","bbs_daemon",GUEST_GID+1,GUEST_GID);
  check_entry("bbsusr","*","bbs_tmp_user",GUEST_UID2,GUEST_GID);  

  printf("\ncheck  \"etc/group\".....");  
  check_group("bbs",GUEST_GID);
  check_group("bbsuser",GUEST_GID+1);

  
}

void check_entry(name,passwd,rem,uid,gid)
char *name,*passwd,*rem;
int uid,gid;

{
 struct passwd *pwd;
 FILE *fd,*fp;
 int make=0;
 

   
   strcpy(s,name);   
   pwd=getpwnam(s);
   if (pwd==NULL) 
   {
     printf("\n User \"%s\" not found in \"/etc/passwd\"",s);
     if (do_change)
     {
       printf(" -> change\n");

       pwd=(struct passwd *) malloc(sizeof(struct passwd));
       
           /* user name */
              pwd->pw_name=(char *) malloc(strlen(s)+1);
              strcpy(pwd->pw_name,s);           
           
           /* user password */
              strcpy(tmp,passwd);
              pwd->pw_passwd=(char *) malloc(strlen(tmp)+1);
              strcpy(pwd->pw_passwd,tmp);           
           
           pwd->pw_uid=uid;         /* user id */
           pwd->pw_gid=gid;         /* group id */
           
           
           /* real name */
           strcpy(tmp,rem);
           pwd->pw_gecos=(char *) malloc(strlen(tmp)+1);
           strcpy(pwd->pw_gecos,tmp);
           
           /* home directory */
           if (uid==GUEST_GID)
           strcpy(tmp,"/usr/local/home/guest");
           else
           strcpy(tmp,"/dev/null");
           pwd->pw_dir=(char *) malloc(strlen(tmp)+1);
           strcpy(pwd->pw_dir,tmp);           
           
           /* shell program */
           if (uid==GUEST_GID)
            sprintf(tmp,"%s/bin/bbs",HOME);
           else
            strcpy(tmp,"/dev/null");

           pwd->pw_shell=(char *) malloc(strlen(tmp)+1);
           strcpy(pwd->pw_shell,tmp);           
                                                                                                                                                                                             
       fd=fopen(PWD_FILE,"a");
       putpwent(pwd,fd);
       fclose(fd);
       
     } else
     {
       do_error++;
       printf(" Error %d (ignored)\n",do_error);
     }
   
   
   } else  
   {
    printf(" %s",s);
    
     if 
        (
          ((!(
           (strpos(pwd->pw_passwd,passwd)==1) 
            &&
           (strpos(passwd,pwd->pw_passwd)==1)
          )) && (uid!=GUEST_GID))
           
          ||
          (
           (uid==GUEST_GID)&&(strlen(pwd->pw_passwd)>0)
          )
        )
     {
      do_error++; make++;
      printf("\n password for \"%s\" is not \"%s\", Error %d",s, passwd,do_error);
      if (do_change)
         {
              printf(" -> change  ");
              strcpy(tmp,passwd);
              pwd->pw_passwd=(char *) malloc(strlen(tmp)+1);
              strcpy(pwd->pw_passwd,tmp);
         } else
         {
              printf(" (ignored)");
         }
     }
     
     
     if (pwd->pw_uid!=uid)  /* uid=1000? */
     {
      do_error++; make++;
      printf("\n uid is \"%d\" and not \"%d\", Error %d",pwd->pw_uid,uid,do_error);
      if (do_change)
         {
              printf(" -> change  ");
              pwd->pw_uid=uid;
         } else
              printf(" (ignored)");         
     }     
     
     if (pwd->pw_gid!=gid)  /* gid=1000? */
     {
      do_error++; make++;
      printf("\n gid is \"%d\" and not \"%d\", Error %d",pwd->pw_gid,gid,do_error);
      if (do_change)
         {
              printf(" -> change  ");
              pwd->pw_gid=gid;
         } else
              printf(" (ignored)");
     }          
    
   
   if ((chdir(pwd->pw_dir)!=0)&&(uid==GUEST_GID))
   {
      do_error++; make++;
      printf("\n guest-home-dir \"%s\" is invalid, Error %d",pwd->pw_dir,do_error);     
      if (do_change)
         {
              printf(" -> make dir  ");
              mkdir("/usr/local/home",0777);
              mkdir("/usr/local/home/guest",0777);
              chown("/usr/local/home/guest", GUEST_GID+1, GUEST_GID);
              strcpy(tmp,"/usr/local/home/guest");
              pwd->pw_dir=(char *) malloc(strlen(tmp)+1);              
              strcpy(pwd->pw_dir,tmp);
         } else
              printf(" (ignored)");   
              
   }


   if ((do_change)&&(make!=0))
   {
     fd=fopen(PWD_FILE,"r");   fp=fopen(PWD_OUTFILE,"w");
     sprintf(tmp,"%s:",name);
     while ((fgets(s,2*STRING,fd)!=NULL)&&(strpos(tmp,s)!=1)) 
      fprintf(fp,"%s",s);
     putpwent(pwd,fp);
     while (fgets(s,2*STRING,fd)!=NULL) 
      fprintf(fp,"%s",s);     
     fclose(fd);fclose(fp);
     update(PWD_OUTFILE,PWD_FILE,"update all changes ");
   }           
   if (make==0) printf("=ok ");
   
   }
   chdir(HOME);


}









void check_group(name,gid)
char *name;
int gid;
{
FILE *fd,*fp;
int make=0;

     printf(" %s",name);
     fd=fopen(TGRP_FILE,"r");  fp=fopen(TGRP_OUTFILE,"w");
     sprintf(tmp,"%s:",name);
          
     while ((fgets(s,2*STRING,fd)!=NULL)&&(strpos(tmp,s)!=1)) 
      fprintf(fp,"%s",s);
     if (strpos(tmp,s)==1)
     { 
      unlink(TGRP_OUTFILE);
     } else 
     {
      if ((strpos("bbs",name)==1)&&(strpos(name,"bbs")==1))
        fprintf(fp,"bbs::%d:bbs,adm\n",gid);
      else
        fprintf(fp,"%s::%d:\n",name,gid);
      make=1;
     }
     while (fgets(s,2*STRING,fd)!=NULL) 
      fprintf(fp,"%s",s);     
     fclose(fd);fclose(fp);
     if(make)
     {
        do_error++;
       printf(" no entry! Error %d",do_error);     
      if (!do_change)
       printf(" (ignored)");
      else
      {
       update(TGRP_OUTFILE,TGRP_FILE,"update all changes ");
      }
      printf("\n");
      
     }
     else printf("=ok");
}