/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 + T-BBS-Daemon 		 					+
 + (c) S.Runge 10/94							+
 +     bbsd.c   							+
 ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#include <stdio.h>
#include <sys/types.h>
#include <time.h>
#include <setjmp.h>
#include <sys/stat.h>

#include <unistd.h>
#include <dirent.h>
#include <fcntl.h>
#include <stdio.h>
#include "mbox.h"
#include "s_global.h"
#include "bbsd.h"

#undef DEBUG 
void *TOP;
FILE *fd;
int RUN=0;
int NoClean=0;
unsigned char h[STRING];
#ifdef TTTTTT
unsigned char HOME[STRING],BIN[STRING];
#endif
#define MAXDIFF_TIME (3600*24)	/* max. Zeit zwischen den Timer-Takten in sek.*/

void init()
{
TOP=NULL;
TestLck();
SetStruct();
sprintf(h,"%s/etc/list.bbsd",HOME);
fd=fopen(h,"r");
if (!fd)  {
           printf("\nbbsd-error: file is missing (%s)\n",h);
           exit();
          }
while (fgets(h,STRING,fd)!=NULL)
{
  if (strpos("QWK_TASK",h))
  {
    bbsd.qwkd_task=atoi(&h[9]);
  } else 
  if (strpos("BBSD_AKT",h))
  {
     strcpy(bbsd.akt_z,strings(&h[9]));
  } else 
  if (strpos("SCR_KILLDAY",h))
  {
     bbsd.scratch->kill_day=atoi(&h[12]);
  } else 
  if (strpos("SCR_DL_KILLDAY",h))
  {
     bbsd.scratch->kill_dl_day=atoi(&h[15]);
  } else 
  if (strpos("SCR_BACKUP_PATH",h))
  {
     strcpy(bbsd.scratch->path,cut_bef(strings(&h[16])));
  } else 
  if (strpos("SCR_EMAIL",h))
  {
     bbsd.scratch->email=atoi(&h[10]);
  } else 
  if (strpos("BBS_LST_HOUR",h))
  {
     bbsd.bbslst->list_hour=atoi(&h[13]);
  } else 
  if (strpos("BBS_LST_ALL",h))
  {
     bbsd.bbslst->list_all=atoi(&h[12]);
  } else 
  if (strpos("BBS_IDX_HOUR",h))
  {
     bbsd.bbslst->idx_hour=atoi(&h[13]);
  } else 
  if (strpos("BBS_IDX_ALL",h))
  {
     bbsd.bbslst->idx_all=atoi(&h[12]);
  } else 
  if (strpos("MBD_OPT",h))
  {
     strcpy(bbsd.mbd->option,cut_bef(strings(&h[8])));
  } else 
  if (strpos("MBD_AKT",h)==1)
  {
     bbsd.mbd->akt=1;
  } else   
  if (strpos("MBD_OUT",h))
  {
     strcpy(bbsd.mbd->out,cut_bef(strings(&h[8])));
  } else 
  if (strpos("KILL_UNUSED_ACCOUNT",h))
  {
    bbsd.update->kill_day=atoi(&h[20]);
  } else 
  if (strpos("KILL_USR_TMP",h))
  {
     bbsd.update->kill_tmp=atoi(&h[13]);
  }
} /* while(gets()) */

}














void Hidden()
{
int temp;

  while ((temp = fork()) < 0) sleep(1);
  if (temp) exit(0);	
}




void ClearLck()
{
 sprintf(h,"%s/etc/bbsd.LCK",HOME);
 unlink(h) ;
}







void sigcatch(sig)
int sig;
{


  signal(sig, SIG_IGN);

  chdir( HOME );

  switch (sig) {

	case SIGQUIT:
	        Clean();
		break;
	case SIGABRT:
		Clean();
		break;
	case SIGINT:
		Clean();
		break;
	case SIGHUP:
		Clean();
		break; 
	case SIGTERM:
		Clean();
		break;
	case SIGALRM:
	        Run(1);
	        break;
  }
}


void Clean()
{
if (!NoClean)
{
#ifdef DEBUG
  printf("\n...clean\n");
#endif  
  ClearLck();
}
  exit(0);
}




void SigInit()
{
	signal(SIGINT,  sigcatch);
	signal(SIGQUIT, sigcatch);
	signal(SIGHUP,  sigcatch);
	signal(SIGABRT, sigcatch);
	signal(SIGTERM, sigcatch);
}





main(argc,argv)
 int argc;
 unsigned char *argv[];
{
SetMain();
  if (strpos("ver",argv[1]))  {
   Ver();
   ClearLck();
   exit();
  }
  if (strpos("help",argv[1]))  {
   Help();
   ClearLck();
   exit();
  }
  SigInit();
  init();
  Log(3);
  if (strpos("-print",argv[1]))  {
      PrintStruct(1);
      
    }
  CheckRange();
  PrintStruct(0);
  if (!strpos("-direct",argv[1]))  Hidden();
  
  printf("\nbbsd: init..ok  -> run...\n");
  CalcAkt();
  do
  {
     if (strpos("-run",argv[1])) Run(0);
      else  SetTimer();
     sleep(999999);  
  } while (1);
  ClearLck();
}



void CalcAkt()
{
int a,b;
struct akt_typ *akt,*t;
unsigned char s[STRING/3];
   
do
{
 strcpy(s,cut_bef(bbsd.akt_z));
 strcpy(bbsd.akt_z,cut_arg(bbsd.akt_z));
 sscanf(s,"%d:%d",&a,&b);
 t=malloc(sizeof(struct akt_typ)); t->n=NULL;
 t->h=a; t->m=b;
 if (bbsd.akt==NULL) bbsd.akt=t;
  else {
    akt=bbsd.akt;
    while (akt->n!=NULL) akt=akt->n;
    akt->n=t;
  }
#ifdef DEBUG  
 printf("\nakt-time: (%s)     a:%d     b:%d",s,a,b);
#endif 
} while (strlen(bbsd.akt_z));
#ifdef DEBUG  
 printf("\n");
#endif    
}





void SetStruct()
{
bbsd.akt=NULL;
bbsd.bbslst=malloc(sizeof(struct BBSLIST_T));
bbsd.qwkd_task=0;
bbsd.mbd=malloc(sizeof(struct MBD_T));
bbsd.update=malloc(sizeof(struct UPDATE_T));
bbsd.scratch=malloc(sizeof(struct SCRATCH_T));

     bbsd.qwkd_task=0;
     strcpy(bbsd.akt_z,"");
     bbsd.akt=NULL;
     bbsd.bbslst->list_hour=0;
     bbsd.bbslst->list_all=0;
     bbsd.bbslst->idx_hour=0;
     bbsd.bbslst->idx_all=0;
     
     strcpy(bbsd.mbd->option,"");
     strcpy(bbsd.mbd->out,"");
     bbsd.mbd->akt=0;
     
     bbsd.update->kill_day=0;
     bbsd.update->kill_tmp=0;
     
     bbsd.scratch->kill_day=0;
     bbsd.scratch->kill_dl_day=0;
     bbsd.scratch->email=0;
     strcpy(bbsd.scratch->path,"");
bbsd.bbslst->time=0;     
bbsd.bbslst->idx_time=0;     
}


void PrintStruct(mode)
int mode;
{
if (!mode) 
{
#ifdef DEBUG
printf("\nbbsd.qwk_task: %d",bbsd.qwkd_task);
printf("\nbbsd.akt_z: (%s)",bbsd.akt_z);
printf("\nbbsd.akt(ptr): %d",bbsd.akt);

printf("\nbbsd.bbslst->list_hour: %d",bbsd.bbslst->list_hour);
printf("\nbbsd.bbslst->list_all: %d",bbsd.bbslst->list_all);
printf("\nbbsd.bbslst->idx_hour %d",bbsd.bbslst->idx_hour);
printf("\nbbsd.bbslst->idx_all: %d",bbsd.bbslst->idx_all);

printf("\nbbsd.mbd->option: (%s)",bbsd.mbd->option);     
printf("\nbbsd.mbd->out: (%s)",bbsd.mbd->out);

printf("\nbbsd.update->kill_day: %d",bbsd.update->kill_day);     
printf("\nbbsd.update->kill_tmp: %d",bbsd.update->kill_tmp);     
     
printf("\nbbsd.scratch->kill_day: %d",bbsd.scratch->kill_day);          
printf("\nbbsd.scratch->kill_dl_day: %d",bbsd.scratch->kill_dl_day);     
printf("\nbbsd.scratch->email: %d",bbsd.scratch->email);     
printf("\nbbsd.scratch->path: (%s)\n",bbsd.scratch->path);     
#endif
} 
else
{
printf("\nQWK_TASK: 			%d",bbsd.qwkd_task);
printf("\nBBSD_AKT:			(%s)",bbsd.akt_z);
printf("\nBBS_LST_HOUR:			%d",bbsd.bbslst->list_hour);
printf("\nBBS_LST_ALL: 			%d",bbsd.bbslst->list_all);
printf("\nBBS_IDX_HOUR:			%d",bbsd.bbslst->idx_hour);
printf("\nBBS_IDX_ALL: 			%d",bbsd.bbslst->idx_all);
printf("\nMBD_OPT: 			(%s)",bbsd.mbd->option);     
printf("\nMBD_OUT: 			(%s)",bbsd.mbd->out);

printf("\nKILL_UNUSED_ACCOUNT:		%d",bbsd.update->kill_day);     
printf("\nKILL_USR_TMP:			%d",bbsd.update->kill_tmp);     
     
printf("\nSCR_KILLDAY: 			%d",bbsd.scratch->kill_day);          
printf("\nSCR_DL_KILLDAY: 		%d",bbsd.scratch->kill_dl_day);     
printf("\nSCR_EMAIL: 			%d",bbsd.scratch->email);     
printf("\nSCR_BACKUP_PATH: 		(%s)\n",bbsd.scratch->path);     
ClearLck();
exit(0);
}
}



void Run(mode)
int mode;
{
#ifdef DEBUG
printf("\n----------- RUN ---------------\n");
#endif
if (!RUN)
{
RUN=1;
Log(mode);
sprintf(h,"%s/qwkd >>/dev/null",BIN);
system(h);
if (bbsd.mbd->akt)
{
 sprintf(h,"%s/mb-daemon %s >>%s",BIN,bbsd.mbd->option,bbsd.mbd->out);
 system(h);
}
if (((time(0)-bbsd.bbslst->time-3000)/3600)>bbsd.bbslst->list_hour)
{
if (bbsd.bbslst->list_all)
  sprintf(h,"%s/sfileman.index all -listen >>/dev/null",BIN);
else sprintf(h,"%s/sfileman.index -listen >>/dev/null",BIN);
system(h);
bbsd.bbslst->time=time(0);
}

if (((time(0)-bbsd.bbslst->idx_time-3000)/3600)>bbsd.bbslst->idx_hour)
{
if (bbsd.bbslst->idx_all)
  sprintf(h,"%s/sfileman.index all -index >>/dev/null",BIN);
else sprintf(h,"%s/sfileman.index -index >>/dev/null",BIN);
system(h);
bbsd.bbslst->idx_time=time(0);
}

 SetTimer();
 RUN=0;
} /* if (!RUN) */

}

long GetTime(a,b)
int a,b;
{
 time_t d,l;
 struct tm *t;
 l=time(0);
 t=gmtime(&l);
 t->tm_hour=a;
 t->tm_min=b;
 t->tm_sec=0;
 d=mktime(t);
 if (difftime(d,time(0))<0)
 {
  if (t->tm_mday<30) t->tm_mday++;
  d=mktime(t);
  if (difftime(d,time(0))<0) d=0;
 }
#ifdef DEBUG 
 printf("\nGetTime: %d\n",d);
#endif 
 return(d);
}

void SetTimer()
{
long min,ist,t;
struct akt_typ *akt;

ist=time(0);
akt=bbsd.akt; min=9999999999;
if (akt==NULL) exit(0);
while (akt!=NULL)
{
 t=GetTime(akt->h,akt->m);
#ifdef DEBUG 
 printf("\nakt:%d",t);
#endif 
 if ((t<min)/*&&(t!=0)*/) {
   if (t!=NULL) min=t;
  }
 akt=akt->n;
}
 signal(SIGALRM, sigcatch);
 t=difftime(min,time(0));
 if (t>MAXDIFF_TIME) t= MAXDIFF_TIME;
#ifdef DEBUG 
 printf("\n\nist:%d\nmin:%d\nTimer-Diff: %d\n",ist,min,t);
#endif 
 alarm(t);
}

void Log(mode)
int mode;
{
FILE *fd;

sprintf(h,"%s/etc/log.bbsd",HOME);
if ((fd=fopen(h,"a"))!=NULL)
{
  if (!mode)
   fprintf(fd,"\n%s  %s -> mode==0\n",sr_time(time(0)),sr_the_time(time(0)));
  else
   if (mode==3)
   fprintf(fd,"%s  %s -> start\n",sr_time(time(0)),sr_the_time(time(0)));
   else fprintf(fd,"%s  %s\n",sr_time(time(0)),sr_the_time(time(0)));
  fclose(fd);
} else
{
  printf("\npermission: Can't write to (%s)\n",h);
  exit(-2);
}
}














void CheckRange()
{
#ifdef DEBUG
    printf("\CheckRange()\n");
#endif
if (!bbsd.qwkd_task) PError("no qwkd-task is active!");
else

if (!bbsd.bbslst->list_hour) PError("bbsd.bbslst->list_hour == NULL");
else
if (!bbsd.bbslst->idx_hour) PError("bbsd.bbslst->idx_hour == NULL");
else

if (!strlen(bbsd.mbd->option)) PError("bbsd.mbd->option == NULL");
else
if (!strlen(bbsd.mbd->out)) PError("bbsd.mbd->out == NULL");
else

if (!bbsd.update->kill_day) PError("bbsd.update->kill_day == NULL");
else
if (!bbsd.update->kill_tmp) PError("bbsd.update->kill_tmp == NULL");
else

if (!bbsd.scratch->kill_day) PError("bbsd.scratch->kill_day == NULL");
else
if (!bbsd.scratch->kill_dl_day) PError("bbsd.scratch->kill_dl_day == NULL");
else
if (!strlen(bbsd.scratch->path)) PError("bbsd.scratch->path == NULL");

}


void PError(t)
unsigned char *t[];
{
 printf("\n\7Out of Range: %s\n",t);
 exit(0);
}

void Help()
{
 Ver();
 printf("\nUsage: bbsd [Option]\n\nOption:\n--help		this help\n-print		view cfg-state\
\n-direct		no hidden-mode\n-run			with start daemon, execute the first run()\
\n-ver		view version-info\n\n");
}

void Ver()
{
 printf("\n\nbbsd v1.0pl1 	(t-bbs-tool)	\n(c) 10/94 by Sylvio.Runge@wupper.uunet.DE\n");
}





#ifdef TTTTTT
char *GRead(entry)
char *entry;
{
FILE *fd;
static char s[2*STRING];

sprintf(s,"../etc/config/%s",entry);
if ((fd=fopen(s,"r"))!=NULL)
 {
   if (fgets(s,STRING,fd)==NULL)
/*nerror("derror.c", 363, "GRead()", "Bad entry in config-base (check the adjustments in \"tbbs.setup\")", entry);*/
      
   fclose(fd);      
   return((char *) s);   
      
 }/* else nerror("derror.c", 367, "GRead()", "Can't read (check the adjustments in \"tbbs.setup\")", s);*/
 return(NULL);  
}

/* ++++++++++++++++++++++  Globale CFG lesen ++++++++++++++++++ */
void SetMain()
{
FILE *fd;
unsigned char t[STRING];
char s[STRING],*env;
int i,j;

strcpy(HOME,GRead("HOME")); 
strcpy(BIN,GRead("BIN")); 

}



#endif