
#undef DEBUG

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <utmp.h>
#include <unistd.h>
#include <errno.h>
#include <pwd.h>
/*#include <stdlib.h>*/

#include <fcntl.h>


#define TRUE 1
#define FALSE 0
#define ZOMBIE "<zombie>"


#ifndef VU
#include "mbox.h"
#include "s_global.h"
#include "procs/whattime.h"
#else
#include "../mbox.h"
#include "../s_global.h"
#include "../procs/whattime.h"
#endif

extern unsigned char HOME[STRING],BIN[STRING];
struct usrproc_typ *usrproc_top=NULL;

/* Position eines Strings in einem anderen -> strpos alias PAS */
int strpos(s, t)
UNSIGNED char s[], t[];
{
  int j=0, i = 0, a = 0;


  while (t[i] != 0) {
	j=0;
	if (t[i] == s[0]){
	    a=i+1;
	    while ((s[j]==t[i])&&(s[j]!=0)) {
	       j++; i++;
	     }
	    if (s[j]==0) return (int) a ; else a='0';
	 }
	i++;
  }

  return (int) NULL;
}



SetFett()
{
/*printf("\E[40;31m");  fett*/
printf("\E[1;37;42m");
}

SetBld()
{
printf("\E[7m");  /* revers*/
}

SetBld0()
{
printf("\E[44;37m");  /*rev. blau*/
}

SetNorm()
{
printf("\E[0m"); /* reverse off */
}

char *idletime(tty)

char *tty;

{
    struct stat terminfo;
    long idle;
    char ttytmp[40];
    static char give[20];
    time_t curtime;

    curtime = time(NULL);
    sprintf(ttytmp, "/dev/%s", tty);
    stat(ttytmp, &terminfo);
    idle = (curtime - terminfo.st_atime);

    if (idle >= (60 * 60))		/* more than an hour */
    {
	if (idle >= (60 * 60 * 48))	/* more than two days */
	    sprintf(give, "%2ddays", idle / (60 * 60 * 24));
	else
	    sprintf(give, " %2d:%s%d", idle / (60 * 60), 
		(idle / 60) % 60 < 10 ? "0" : "", (idle / 60) % 60);
    }
    else
    {
	if (idle / 60)
	    sprintf(give, "%6d", idle / 60);
	else
	    give[0]=0;
    }

    return give;
}



/*
 * logintime()
 *
 * Returns the time given in a suitable format
 *
 * This routine was lifted from the original w program
 * by Larry Greenfield  (greenfie@gauss.rutgers.edu)
 * Copyright (c) 1993 Larry Greenfield
 *
 */
char *logintime(ut_time)

time_t ut_time;

{
    time_t curtime;
    struct tm *logintime, *curtm;
    int hour, am, curday, logday;
    static char give[20];
    static char *weekday[] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
    static char *month[] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
				"Aug", "Sep", "Oct", "Nov", "Dec" };

    curtime = time(NULL);
    curtm = localtime(&curtime);
    curday = curtm->tm_yday;
    logintime = localtime(&ut_time);
    hour = logintime->tm_hour;
    logday = logintime->tm_yday;
    am = (hour < 12);

    if (!am)
	hour -= 12;

    if (hour == 0)
	hour = 12;

/*
 * This is a newer behavior: it waits 12 hours and the next day, and then
 * goes to the 2nd time format. This should reduce confusion.
 * It then waits only 6 days (not till the last moment) to go the last
 * time format.
 */
    if ((curtime > (ut_time + (60 * 60 * 12))) && (logday != curday))
    {
	if (curtime > (ut_time + (60 * 60 * 24 * 6)))
	    sprintf(give, "%2d%3s%2d", logintime->tm_mday,
		month[logintime->tm_mon], (logintime->tm_year % 100));
	else
	    sprintf(give, "%*s%2d%s", 3, weekday[logintime->tm_wday],
		hour, am ? "am" : "pm");
    }
    else
	sprintf(give, "%2d:%02d%s", hour, logintime->tm_min, am ? "am" : "pm");

    return give;
}



int TestPID(pid)
int pid;
{
char s[STRING];
struct stat fst;
int i;

sprintf(s,"/proc/%d",pid);
i=stat(s, &fst);
if (((fst.st_mode & S_IFMT)==S_IFDIR) && (i==0))
{
 return(1);
}
else return(0);

}






/* welcher (aktueller) Prozess gehoert zu diesem tty ? */
char *GetWhatIsTTY(tty)
char *tty;
{
static char s[2*STRING];
char str[STRING];
FILE *fd;

sprintf(s,"%s/tmp/proc.w~", HOME);


if ((fd=fopen(s,"r"))!=NULL)
{
sprintf(str,"%s ",tty); 
while (fgets(s,100,fd)!=NULL)
{
/*  printf("\nstr:(%s), s:(%s)",str,s); sleep(1);*/
  if (strpos(str,s)==10)
  {
    
   fclose(fd);
   strcpy(s,(char * ) sstrings(s));
   s[80]=0;
   strcpy(s,(char *) &s[27 /*43*/]);
/*     printf("\nOK!!!: str:(%s), s:(%s)",str,s);*/
   return((char *) &s);
  }
}
/*printf("NULL");*/
fclose(fd);
} else nerror("portinfo.c", 1158, "GetWhatIs", "Can't read", s);
strcpy(s,"-");
return((char *) &s);
}








/*-----------------------------------------------------------------------*/


void SetBBSPortInfo(d)
struct usrproc_typ *d;
{
char f[STRING],h[STRING],s[STRING];
FILE *fd;
int i;

  sprintf(f,"%s/etc/spool/whatdoes.%s",HOME,d->tty);
  
  if ((fd=fopen(f,"r"))!=NULL)
  {

   if (fgets(h,STRING,fd)!=NULL)
   {
    h[75]=0;
    fgets(s,STRING,fd);
    i=atoi((char *) s);
/*    printf("\ns=(%s);i=(%d)\n",s,i);*/

    if (TestPID(i))   /* wenn dieser BBS-Prozess  noch aktiv ist */
    {
     h[STRING-1]=0;
     d->bbs=1;
     strcpy(d->what,(char *) sstrings(&h[52]));
     h[35]=0;
     strcpy(d->user, h);
    }
    fclose(fd);
   }

  }
 }



void  SRungeGetProc(mode)
int mode;  
/* mode: 	== 0 	Normal-Mode
 *		== 1	Test-Mode (Ausgabe)
 */		
{
unsigned char s[STRING];

int header=TRUE, long_format=TRUE, ignore_user=FALSE;
int i, j, k;
struct utmp *utmp_rec;
struct stat stat_rec;
struct passwd *passwd_entry;
uid_t uid=0;
char username[9], tty[13], rhost[17], login_time[27];
char idle_time[7], what[256], pid[10];
char out_line[256], file_name[256];
char search_name[9];
int jcpu, pcpu, tpgid, curr_pid, utime, stime, cutime, cstime;
char state, comm[256];
FILE *fp;
                                                    


void CleanProc()
{
struct usrproc_typ *_d,*d2;
 
 _d=(struct usrproc_typ  *) usrproc_top;
 while (_d!=NULL)
 {
  d2=_d;
  _d=_d->n;
  free(d2);
 }
 usrproc_top=NULL;
}









void SetLoop()
{
struct usrproc_typ *d2,*d;

search_name[0] = 0;

/*
 * Process user information.
 *
 * getutent() opens the utmp file for us,
 * and reads off the first record.
 * If the file was already opened, it reads the
 * subsequent record for us. See man page for more info.
*/

usrproc_top=NULL;
setutent();          
    while (utmp_rec = getutent())
    {

/*
 * Check we actually want to see this record.
 * It must be a valid active user process,
 * and match a specified search name.
 */
	if ( (utmp_rec->ut_type == USER_PROCESS)
	  && (strcmp(utmp_rec->ut_user, ""))
	  && ( (search_name[0] == 0)
	    || ( (search_name[0] != 0)
	    && !strncmp(search_name, utmp_rec->ut_user, 8) ) ) )
	{
	

/*
 * Important note:
 *
 * Strings in the utmp struct are *NOT*
 * necessarily null terminated :-(
 * This only occurs if the string fills
 * up its allocated space exactly.
 * If it is shorter, it is terminated by a null.
 * Because of this, strcpy breaks, and strncpy
 * won't necessarily add a terminator, so we have to
 * do it ourselves. The non-null-terminated string
 * can also cause problems for printf type calls,
 * otherwise I'd just read it direct !
 */

/* Get the username */
	    for (i = 0; i < 8; i++)
	    {
		username[i] = 0;

		if (utmp_rec->ut_user[i] != 0)
		    username[i] = utmp_rec->ut_user[i];
		else
		    i = 8;
	    }

           username[7]= 0;
           

/* If necessary, find out the uid of that user (from their passwd entry) */
/*
	    if (ignore_user == FALSE)
	    {
		passwd_entry = getpwnam(username);
		uid = passwd_entry->pw_uid;
	    }
*/

/* Get the tty line */
	    for (i = 0; i < 6; i++)
	    {
		tty[i] = 0;

		if (utmp_rec->ut_line[i] != 0)
		    tty[i] = utmp_rec->ut_line[i];
		else
		    i = 6;
	    }


/* Don't other getting info if it's not asked for */
            
/* Get the remote hostname */
		for (i = 0; i < 15; i++)
		{
		    rhost[i] = 0;

		    if (utmp_rec->ut_host[i] != 0)
			rhost[i] = utmp_rec->ut_host[i];
		    else
			i = 15;
		}


/*
 * Get the login time
 * (Calculated by LG's routine, below)
 */
		strcpy(login_time, logintime(utmp_rec->ut_time));



/*
 * Get the idle time.
 * (Calculated by LG's routine, below)
 */
	    strcpy(idle_time, idletime(tty));



/*
 * That's all the info out of /etc/utmp.
 * The rest is more difficult.
 * We use the pid from utmp_rec->ut_pid to look in /proc for the info.
 * NOTE: This is not necessarily the active pid, so we chase
 * down the path of parent -> child pids until we find it,
 * according to the information given in /proc/<pid>/stat.
 */


	    what[0] = 0;
	    
/*	    
printf("\nuser: (%s), uid: %d, tty: (%s)",username,uid,tty);
printf("\n  host: (%s), login-time: (%s), idle (%s)\n",rhost,login_time,idle_time);	    
printf("\n  what: (%s)\n",GetWhatIs(utmp_rec->ut_pid));
*/
 d=usrproc_top; d2=NULL;
 while (d!=NULL)
 {
    d2=d;
    d=d->n;
 }
 d=(struct usrproc_typ *) malloc(sizeof(struct usrproc_typ));
 d->n=NULL; d->bbs=0;
 
 strcpy(d->user,username);
 strcpy(d->login,d->user); 
 if (username[0]!='S')
   strcat(d->user,"<Shell Account>");
  else
   strcat(d->user,"<SLIP Process>");
 strcpy(d->tty,tty);
 /*sprintf(d->what,"%-50.50s",GetWhatIs(utmp_rec->ut_pid));*/
 strcpy(d->what,GetWhatIsTTY(d->tty));
 strcpy(d->rhost,rhost);
 sprintf(d->time,"%s %s",login_time,idle_time);
 
         
 SetBBSPortInfo(d);
 if (d2==NULL)  usrproc_top=d;
  else d2->n=d;
    
          
/* !!!!!!!!!!!!!!!!!!!!         */


   } /* while ->  usr-proc */
 }  /*  while -> utmp */
}




unsigned char f[2*STRING];
FILE *fd;

search_name[0] = 0;
if (usrproc_top!=NULL) CleanProc();
usrproc_top=NULL;

if (chdir("/proc"))
{
   nerror("portinfo.c", 1245, "RungeGetProc()", "t-bbs: fatal error: cannot access /proc", "/proc-filesystem-failure");
}
chdir(HOME);
/*                                    
sprintf(f,"ps -xa >%s/tmp/proc.~", HOME);
system(f);
*/

sprintf(f,"w -s >%s/tmp/proc.w~", HOME);
system(f);

  SetLoop();


 sprintf(f,"%s/tmp/proc.~",HOME);
 unlink(f);
 sprintf(f,"%s/tmp/proc.w~", HOME);
 unlink(f); 
 
}


/*-----------------------------------------------------------------------*/





void port()
{
char ex[STRING];
struct usrproc_typ *dat=NULL;
int i;

  chdir(HOME);
   printf("++++++++++++  %s: tools  ++++++++++++\n",VERSION);
  SetBld0();
   printf("%-9.9s: %-68.68s","Portinfo (extern/intern) ",sprint_uptime());
  SetNorm();printf("\n");SetBld();
   printf("%-79.79s","User                 sh-name  tty    login     idle  Prozess" );
  SetNorm();
  printf("\n%s ...%c", "wait", CR);
  fflush(stdout);


  SRungeGetProc(0);


  if (usrproc_top!=NULL)  /* wenn UsrProc-Info da ist */
  {
   
    dat=usrproc_top;
    while ( (dat!=NULL) )
	{
		if (!(((strpos("<Shell Acc",dat->user))||(strpos("<SLIP",dat->user))))) SetFett();
  		 printf("%-20.20s %-8.8s %-06.06s %-16.16s%-25.25s",
		  dat->user,dat->login,dat->tty,dat->time,dat->what);
		  SetNorm();
		  printf("\n");
	   	  
		dat=dat->n;
	}
   }
                                                             
  printf("\n");

}



main()
{
 SetMain();
 setuid(GUEST_GID );
 port();
}