
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>
#include <fcntl.h>
#include <sys/stat.h>


#include <strings.h>

#include <sys/times.h>

/* The largest number rand will return (same as INT_MAX).  */





#ifndef VU
#include "mbox.h"
#include "proto.h"
#include "s_global.h"
#include "language.h"
#else
#include "../mbox.h"
#include "../proto.h"
#include "../s_global.h"
#include "../language.h"
#endif

#ifndef _BSD
#include  <termio.h>
#endif
#include <sys/ioctl.h>



#define BYTE	0377	/* Don't ask me, ask Andy !! */


/* #BA - Find out which baudrate is used. Start with 'try' BPS. */

int bbs_baudrate( try )
int try;
{

  return(bps());
  if(ZOPT.OPT->BAUDRATE != 0) return ZOPT.OPT->BAUDRATE;
}



/* #PF - Display the system and line performance to a user. */

void perf()
{
  struct tms tmsbuf, tmnbuf;
  struct tms whsbuf, whnbuf;
  int i, j;
  int a, b;
  int _bps;
  char s[STRING];

  int fpid;
  int pos = strlen((char *) GetText("BAU01_MSG")) + 1;

  int _pause = 0;

  long ts, tn;


  if(ZOPT.OPT->USER.terminal == 4){
	printf(" <- %s\n", GetText("BAU04_MSG") );
	return;
  }


                sprintf(s,"%s (connect: %dbps)", GetText("BAU02_MSG" ),bps());
		headline( s);

		ansi2( "cm", 1, 5 );
		ansi2( "us", 0, 0 );
		printf("-+-------+------+---------+--------------------------+------------------+----");
		ansi2( "cm", 1, 7 );
		printf("-+-------+------+---------+--------------------------+------------------+----");
		ansi2( "cm", 1, 8 );
		printf("300     4800   9600     14400                      38400              45000    ");

		ansi2( "cm", 1, 12 );
		printf("-----------+-----------+-----------+-----------+-----------+-----------+-------");
		ansi2( "cm", 1, 14 );
		printf("-----------+-----------+-----------+-----------+-----------+-----------+-------");
		ansi2( "cm", 1, 15 );
		printf("          1.5k        3.0k        3.5k        4.0k        4.5k        5.0k     ");
		ansi2( "cm", 1, 16 );
		printf("           15k         30k         35k         40k         45k         50k     ");
		ansi2( "cm", 1, 12 );
		printf("-----------+-----------+-----------+-----------+-----------+-----------+-------");

		ansi2( "me", 0, 0 );
		ansi2( "md", 0, 0 );
		ansi2( "mb", 0, 0 );
		ansi2( "cm", 1, 6 );
		printf("%s", GetText("BAU03_MSG") );

		ansi2( "me", 0, 0 );
		ansi2( "cm", 1, 20 );
		ansi2( "mr", 0, 0 );


			/* BAUDRATE */
	

			i = 0;
			time(&ts);
			ts += 4;
			do{
			      for (j=0; j<=10; j++) printf("%c%c",97+((j%2)*(j%3)), BS);
              		      time(&tn);
				i++;
			}while(tn < ts);
                        
			i /= 50;
			printf(" %c", BS);

			_bps = (i * 990)/2;

			ansi2( "cm", 1, 6 );
			ansi2( "mr", 0, 0 );

			j = _bps / (260 - (60000/_bps));	

			if(j > 79) j = 79;

			for(i = 1; i <= j; i++) 
			printf(" ");
	
			ansi2( "me", 0, 0 );

			for(i = 79; i > j; i--)
				printf(" ");

			ansi2( "cm", 1, 4 );
			ansi2( "md", 0, 0 );
			printf("BAUDRATE: %d BPS, %d CPS (effektiv)              ", 24*_bps/10, (24*_bps / 110));
			ansi2( "cm", pos, 20 );

			/* BAUDRATE */


			/* FLOPS */

			times(&tmsbuf);
			tmsbuf.tms_stime += (CLOCKS_PER_SEC / 3);
			j = 0;
			do{
				a = fix( (100 / 95) );
				b = flt( (100 / 95) );		
				j++;
				times(&tmnbuf);
			}while(tmnbuf.tms_stime < tmsbuf.tms_stime);

			ansi2( "cm", 1, 13 );
			ansi2( "mr", 0,  0 );
	
			j *= 10;
			a = (j * 100) / 10000;
			a = (a * 80)  / 100;
			if(a > 79) a /= 100;

			for(i = 1; i <= a; i++) 
				printf(" ");

			ansi2( "me", 0, 0 );
		
			for(i = 79; i > a; i--)
				printf(" ");


			ansi2( "cm", 1, 11 );
			ansi2( "md", 0,  0 );
			printf("TEST-FLOPS: %d                 ", j/10);
			ansi2( "cm", pos, 20 );

			/* FLOPS */
				
			sleep( _pause );

			/* USAGE */

			times(&whnbuf);

			a = whnbuf.tms_stime - whsbuf.tms_stime;
			b = whnbuf.tms_utime - whsbuf.tms_utime;


			ansi2( "me", 0, 0 );


                        printf("\n%s\n",GetText("BAU05_MSG"));
			/* USGAGE */
			
			

}
