
/*##########################################################################*/
/*    erstellt Statisitik - QWK-Log-Mail fuer Admin   			    */
/*##########################################################################*/

#undef CONVERT

#include <sys/types.h>
#include <dirent.h>

#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>
#include <dirent.h>
#include "prototypes.h"

#include "../mbox.h"
#include "../mbox.msg"
#include "../s_global.h"
#include "../usr.list/defs.h"



FILE *fd;


long QwkMailSize=0;

#undef DEBUG

struct qwk_usr_t
{
 int uid;
 char name[STRING];
 long size;
 int mark;
 struct qwk_usr_t *n;
};

void *top=NULL;

void do_qwk_log()
{
DIR *dp;
char s[2*STRING];
struct dirent *actdir;
int i;


SetZMain(); SetMain2();
chdir(HOME);
LoadQwkStat();
make_qwkmail_stat();
PrintQwkUsr();
fclose(fd);
sprintf(s,"%s/tmp/rmail.stat",HOME);
QwkMailTo(s,ZPOSTMASTER);
unlink(s);
sprintf(s,"%s/etc/spool/add.qwk_stat",HOME);
unlink(s);
exit(0);

}





void make_qwkmail_stat()
{
unsigned char s[STRING];
  time_t timer,k;
  

sprintf(s,"%s/tmp/rmail.stat",HOME);
if ((fd=fopen(s,"w"))!=NULL)
{
        
        fprintf(fd, "From: TBBS_LOG-DAEMON@%s (TBBS_LOG-DAEMON)\n",UUCPID2,UUCPID2);	
        fprintf(fd, "Subject: %s\n",BBSMD01x_MSG);
	fprintf(fd, "Organization: ");
	fputs(ORGANIZATION,fd); fputs("\n",fd);


        fprintf(fd, "X-Mailer: %s (log.qwk)\n",  VERSION);	
    if (!gethostname(&s[0],STRING))
    {
     k=time(0);
     fprintf(fd,"Received: by \"%s\"  %s \nMessage-ID: <%d.%d@%s>\n\n",
     	s,BBSMD_VERSION,
       getpid(),(int ) k,UUCPID2);
    }
	
	fputs("\n", fd);
 fprintf(fd,"+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
 fprintf(fd,"+ OFFLINE-STATISTIC (NEWS+MAIL for QWK+SOUP-Support)                  +\n");
 fprintf(fd,"+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
 fprintf(fd,"from: %s   until: %s %s \n",GetRQwkMailDate(),mydate(0),mytime(0));
 fprintf(fd,"total: %d kBytes (all qwk+soup-jobs)\n",(int ) QwkMailSize); 
 fprintf(fd,"+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n\n");
 fprintf(fd,"\n\n--------------------   detailed offline-statistic  --------------------\n");
 fprintf(fd,"\n%04s %-20.20s %-7.7s %-40s  %c","uid","name"," KBytes","",'%'); 
 
} else
{
 printf("\nCan't write to (%s)",s);
 exit(-7);
}


}



long GetTotalQwkMailSize()
{
return (QwkMailSize);
}



char *GetRQwkMailDate() 
{
FILE *fd;
int i;
static unsigned char s[STRING],t[STRING];

sprintf(s,"%s/etc/spool/qwk.stat.run",HOME);
if ((fd=fopen(s,"r"))!=NULL)
{
  i= (int) fgets(s,STRING,fd);
  strcpy(s,sstrings(s)); 
  sprintf(t,"%s/etc/spool/qwk.stat.run",HOME);
  fclose(fd);
  fd=fopen(t,"w");
  fprintf(fd,"%s %s",mydate(0),mytime(0));
  fclose(fd);   

} else
{
  fd=fopen(s,"w");
  fprintf(fd,"%s %s",mydate(0),mytime(0));
  fclose(fd);   
  strcpy(s,"<start>");
}

return ((char *) s);
}


/* sucht den User-namen in der User-base */
char *GetUsrName(id)
int id;
{
static char s[STRING];
int fd,uid;
char t[STRING];
struct userdaten DUMMY;
long ll = -1L;
size_t dummy = sizeof(DUMMY);
    
chdir(HOME);
strcpy(s,"<expired, unknown>");
  
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	printf("\nlog_qwk.c 139  - user-search, Can't read (%s)\n", UDBASE);
	exit(-1);
  }
  while (read(fd, (UNSIGNED char *) &DUMMY, dummy) == dummy) {
		if (DUMMY.id == id) {
			ll = lseek(fd, 0L, SEEK_CUR) - dummy;
			strcpy(s,DUMMY.name);
		}
  }
close(fd);
return((char *) &s);
}


/* laden der QWK-Statistic aus dem File */
void LoadQwkStat()
{
char s[STRING*2];
FILE *fd;
int uid,size;
struct qwk_usr_t *qusr,*qusr2;
int new=0,tops;

sprintf(s,"%s/etc/spool/add.qwk_stat",HOME);
if ((fd=fopen(s,"r"))==NULL)
{
  return; /* keine QWK-Nutzung!!! */
}
while (fgets(s,STRING,fd)!=NULL)
{
#ifdef DEBUG
 printf("\n%s",s); fflush(stdout);

#endif
  uid=atoi(s); 
  size=atoi((char *) cut_arg(s));
  QwkMailSize+=size;  
  qusr=top; tops=0;
  while ((qusr!=NULL)&&(qusr->uid!=uid)) qusr= qusr->n;
  new=0;
  if (qusr==NULL)
  {
   qusr2=(struct qwk_usr_t *) malloc(sizeof(struct qwk_usr_t ));
   if (top==NULL) {
    top= qusr2;
    tops++;
   }
   qusr2->n=NULL;
   qusr2->mark=0;
   qusr2->uid=uid;
   strcpy(qusr2->name,GetUsrName(uid));
   qusr2->size=size; new++;
#ifdef DEBUG
   printf("\nuser (%s), uid=%d\n",qusr2->name,uid);
   printf("size1 (%d),\n",qusr2->size); fflush(stdout);
#endif   
  } else
  {
   qusr2=qusr;
   qusr2->size+=size;
  }

  qusr=top;
  if ((new!=0)&&(!tops))
  {
    
     while (qusr->n!=NULL) qusr=qusr->n;
     qusr->n=qusr2;
  }
}
fclose(fd);


}







struct qwk_usr_t *FindNextQwkUser()
{
static struct qwk_usr_t *qusr,*qusr2;
int max=0,mark=0;
#ifdef DEBUG
int anz=0;
#endif

qusr2=NULL;
qusr=top;

while (qusr!=NULL)
{
  if ((max<qusr->size)&&(qusr->mark==0))
  {
   max=qusr->size; mark++;
   qusr2=qusr;
  }
#ifdef DEBUG  
  if (qusr!=NULL)
  printf("\nUser in Struct: %s=%d, mark=%d\n",qusr->name,qusr->size,qusr->mark);
  anz++;
#endif  
  qusr=qusr->n;
}
#ifdef DEBUG
  printf("\nUserSumme in Struct: %d\n",anz);
#endif

if (!mark) qusr2=NULL;
if (qusr2!=NULL) qusr2->mark=1;
return ((struct qwk_usr_t *) qusr2);
}











void PrintQwkUsr()
{
struct qwk_usr_t *qusr;
int i,k;
float f;

while (qusr=(struct qwk_usr_t *)FindNextQwkUser())
{
  fprintf(fd,"\n%04d %-20.20s %07d ",qusr->uid,qusr->name, qusr->size);
  i=(40*qusr->size/QwkMailSize);

  for (k=0; k<i; k++) fprintf(fd,"o");
  while (k<40)
  {
    fprintf(fd,"-"); k++;
  }
  f=100*qusr->size/QwkMailSize*1.03;
  fprintf(fd," %2.2f", f);
                   
 
}

}






