(* ........................................................................ *)
(*                                                                          *)
(* MODULE       :   USER.PP                                                 *)
(*                                                                          *)
(* DESCRIPTION  :   USER UNIT                                               *)
(*                                                                          *)
(* COPYRIGHT    :   SIMON HORTON 2008                                       *)
(*                                                                          *)
(*..........................................................................*)

Unit user;

Interface

Uses Dos, Crt, Data, Dates,Colours, ErrorLog, baseunix,sqldb,strings,lib;

function UserSignUpCount: integer;
function GuestUserCount: integer;
function UserCount: integer;
procedure UserDisplay;
function UpdateUserReg : boolean;
function UpdateUserLevel(LevelNo, UserUID : integer) : boolean;
function UpdateUserBulletin(BulletinNo, UserUID : integer) : boolean;
function UpdateUserLocation(Location : string[30]; UserUID : integer) : boolean;
function UpdateUserCallNumber(CallNumber, UserUID : integer) : boolean;
function UpdateUserLastCall(LastCall : string; UserUID : integer) : boolean;
function UpdateUserCalls(Calls,  UserUID : integer) : boolean;
function UpdateUserCallsToday(CallsToday, UserUID : integer) : boolean;
function UpdateUserTimeOnLine(TimeOnLine, UserUID : integer) : boolean;
function UpdateUserLogonTime(LogonTime : time_t; UserUID : integer) : boolean;
function UpdateUserTimeStamp(TimeStamp : time_t; UserUID : integer) : boolean;
function UpdateUserFullName(FullName : string[30]; UserUID : integer) : boolean;
function UpdateUserEmail(Email : string[40]; UserUID : integer) : boolean;
function UpdateUserInfo(Info : string[30]; InfoRecord, UserUID : integer) : boolean;

implementation

(*..........................................................................*)
{ Returns the number of accounts waiting creation }
function UserSignUpCount: integer;
var
  results : recbuf;
begin
   query := 'select * from user_signup';
   if sql_query(query) then
     begin
       results := sql_store_results;
       if results <> NIL then UserSignUpCount :=  sql_num_rows(results)
         else UserSignUpCount := 0;
     end
   else
     begin
       UserSignUpCount := 0;
     end;
end;
(*..........................................................................*)
{ Returns the number of guest user accounts }
function GuestUserCount: integer;
var
  results : recbuf;
begin
   query := 'select * from user_data where guest<>''no''';
   if sql_query(query) then
     begin
       results := sql_store_results;
       if results <> NIL then GuestUserCount :=  sql_num_rows(results)
         else GuestUserCount := 0;
     end
   else
     begin
       GuestUserCount := 0;
     end;
end;
(*..........................................................................*)
{ Returns the number of user accounts }
function UserCount: integer;
var
  results : recbuf;
begin
   query := 'select * from user_data where guest=''no''';
   if sql_query(query) then
     begin
       results := sql_store_results;
       if results <> NIL then UserCount :=  sql_num_rows(results)
         else UserCount := 0;
     end
   else
     begin
       UserCount := 0;
     end;
end;
(*..........................................................................*)
{ Displays users  }
procedure UserDisplay;
var
 results   : recbuf;
 rows      : rowbuf;
 ValTime   : time_t;
 ValCode,
 XPos,
 LineCount : integer;
 Strgs     : string;
begin
  XPos := whereX;
  LineCount := 0;
  str(GuestUID, strgs);
  querystr := 'select name,town,logon,calls from user_data where uid <> ' + strgs + ' order by name';
  query := pchar(querystr);
  if sql_query(query) then
   begin
     { get query results }
     results := sql_store_results;
     if results <> nil then
      begin
        rows := sql_fetch_row(results);
        LineFeed;
        Colour(FBlue);
        Str(XPos, Strgs);
        SetX(Strgs);
        Print(' Username          Location                  Last Called             Calls');
        LineFeed;
        Colour(FCyan);
        SetX(Strgs);
        Print('--------------------------------------------------------------------------');
        LineFeed;
        while rows <> nil do
         begin
           inc(LineCount);
           Str((XPos + 1), Strgs);
           Setx(Strgs);
           Colour(FYellow);
           Print(strpas(rows[0]));
           Colour(FCyan);
           Str((XPos + 19), Strgs);
           Setx(Strgs);
           Print(strpas(rows[1]));
           Str((XPos + 45), Strgs);
           Setx(Strgs);
           val(strpas(rows[2]), valtime, valcode);
           Print(EpochtoDateString(valtime));
           Str((XPos + 70), Strgs);
           Setx(Strgs);
           Print(strpas(rows[3]));
           LineFeed;
           if LineCount = (UserInfo.UserLines  - 7) then
            begin
              Str(XPos, Strgs);
              Setx(Strgs);
              HoldPage;
              LineCount := 0;
            end;
           rows := sql_fetch_row(results);
         end;
        { clear memory }
        sql_free_results(results);
      end;
   end
  else
   begin
     LogSQLError('Error retriving User SQL Data - ' + sqlerror + ' - ' + querystr);
   end;
end;
(*..........................................................................*)
{ Updates the users Membership registration key  }
function UpdateUserReg : boolean;
begin
  querystr := 'update user_data set reg=1 where guestip=''' + remotehost + '''';
  { setup query }
  query := pchar(querystr);
  if sql_query(query) then
    begin
      if sql_affected_rows = 0 then
       begin
         LogError('Error Updating User Reg Key - ' + querystr);
         UpdateUserReg := false;
       end
      else
       begin
         UpdateUserReg := true;
       end;
    end
  else
    begin
      LogSQLError('Error Upating User Reg Key - ' + sqlerror);
      UpdateUserReg := false;
    end;
    logerror(querystr);
end;
(*..........................................................................*)

{ Updates the users Membership Level  }
function UpdateUserLevel(LevelNo, UserUID : integer) : boolean;
var
  Level,
  UID     : string;
begin
  str(LevelNo, Level);
  str(UserUID, UID);
  { is this a guest user }
  if UserUID = GuestUID then
   begin
     querystr := 'update user_data set level=' + level + ' where guestip=''' + remotehost + ''' and uid=' + UID;
   end
  else
   begin
     querystr := 'update user_data set level=' + level + ' where uid=' + UID;
   end;
  { setup query }
  query := pchar(querystr);
  if sql_query(query) then
    begin
      if sql_affected_rows = 0 then
       begin
         LogError('Error Updating User Level - ' + querystr);
         UpdateUserLevel := false;
       end
      else
       begin
         UpdateUserLevel := true;
       end;
    end
  else
    begin
      LogSQLError('Error Upating User Level - ' + sqlerror);
      UpdateUserLevel := false;
    end;
end;
(*..........................................................................*)
{ Updates the users bulletin number  }
function UpdateUserBulletin(BulletinNo, UserUID : integer) : boolean;
var
  BullNo,
  UID     : string;
begin
  str(BulletinNo, BullNo);
  str(UserUID, UID);
  { is this a guest user }
  if UserUID = GuestUID then
   begin
     querystr := 'update user_data set bulletin=' + BullNo + ' where guestip=''' + remotehost + ''' and uid=' + UID;
   end
  else
   begin
     querystr := 'update user_data set bulletin=' + BullNo + ' where uid=' + UID;
   end;
  { setup query }
  query := pchar(querystr);
  if sql_query(query) then
    begin
      if sql_affected_rows = 0 then
       begin
         LogError('Error Updating User Bulletin');
         UpdateUserBulletin := false;
       end
      else
       begin
         UpdateUserBulletin := true;
       end;
    end
  else
    begin
      LogSQLError('Error Upating User Bulletin - ' + sqlerror);
      UpdateUserBulletin := false;
    end;
end;
(*..........................................................................*)
function UpdateUserColour : boolean;
begin
end;
(*..........................................................................*)
function UpdateUserScreenClear : boolean;
begin
end;
(*..........................................................................*)
function UpdateUserLocation(Location : string[30]; UserUID : integer) : boolean;
var
  UID  : string;
begin
  str(UserUID, UID);
  { is this a guest user }
  if UserUID = GuestUID then
   begin
     querystr := 'update user_data set town=''' + Location + ''' where guestip=''' + remotehost + ''' and uid=' + UID;
   end
  else
   begin
     querystr := 'update user_data set town=''' + Location + ''' where uid=' + UID;
   end;
  { setup query }
  query := pchar(querystr);
  if sql_query(query) then
    begin
      if sql_affected_rows = 0 then
       begin
         LogError('Error Updating User Location - ' + querystr);
         UpdateUserLocation := false;
       end
      else
       begin
         UpdateUserLocation := true;
       end;
    end
  else
    begin
      LogSQLError('Error Upating User Location - ' + sqlerror);
      UpdateUserLocation := false;
    end;

end;
(*..........................................................................*)
function UpdateUserCallNumber(CallNumber, UserUID : integer) : boolean;
var
  UID,
  CallNo  : string;
begin
  str(UserUID, UID);
  str(CallNumber, CallNo);
  { is this a guest user }
  if UserUID = GuestUID then
   begin
     querystr := 'update user_data set callnumber=' + CallNo + ' where guestip=''' + remotehost + ''' and uid=' + UID;
   end
  else
   begin
     querystr := 'update user_data set CallNumber=' + CallNo + ' where uid=' + UID;
   end;
  { setup query }
  query := pchar(querystr);
  if sql_query(query) then
    begin
      if sql_affected_rows = 0 then
       begin
         LogError('Error Updating User Call Number');
         UpdateUserCallNumber := false;
       end
      else
       begin
         UpdateUserCallNumber := true;
       end;
    end
  else
    begin
      LogSQLError('Error Upating User Call Number - ' + sqlerror);
      UpdateUserCallNumber := false;
    end;

end;
(*..........................................................................*)
function UpdateUserLastCall(LastCall : string; UserUID : integer) : boolean;
var
  UID,
  CallNo  : string;
begin
  str(UserUID, UID);
  { is this a guest user }
  if UserUID = GuestUID then
   begin
     querystr := 'update user_data set lastcall=''' + LastCall + ''' where guestip=''' + remotehost + ''' and uid=' + UID;
   end
  else
   begin
     querystr := 'update user_data set lastcall=''' + LastCall + ''' where uid=' + UID;
   end;
  { setup query }
  query := pchar(querystr);
  if sql_query(query) then
    begin
      if sql_affected_rows = 0 then
       begin
         LogError('Error Updating User Last Call');
         UpdateUserLastCall := false;
       end
      else
       begin
         UpdateUserLastCall := true;
       end;
    end
  else
    begin
      LogSQLError('Error Upating User Last Call - ' + sqlerror);
      UpdateUserLastCall := false;
    end;
end;
(*..........................................................................*)
function UpdateUserCalls(Calls,  UserUID : integer) : boolean;
var
  UID,
  uCalls  : string;
begin
  str(UserUID, UID);
  str(Calls, uCalls);
  { is this a guest user }
  if UserUID = GuestUID then
   begin
     querystr := 'update user_data set calls=' + uCalls + ' where guestip=''' + remotehost + ''' and uid=' + UID;
   end
  else
   begin
     querystr := 'update user_data set calls=' + uCalls + ' where uid=' + UID;
   end;
  { setup query }
  query := pchar(querystr);
  if sql_query(query) then
    begin
      if sql_affected_rows = 0 then
       begin
         LogError('Error Updating User Calls - ' + sqlerror);
         UpdateUserCalls := false;
       end
      else
       begin
         UpdateUserCalls := true;
       end;
    end
  else
    begin
      LogSQLError('Error Upating User Calls - ' + sqlerror);
      UpdateUserCalls := false;
    end;
end;
(*..........................................................................*)
function UpdateUserCallsToday(CallsToday, UserUID : integer) : boolean;
var
  UID,
  Calls  : string;
begin
  str(UserUID, UID);
  str(CallsToday, Calls);
  { is this a guest user }
  if UserUID = GuestUID then
   begin
     querystr := 'update user_data set callstoday=' + Calls + ' where guestip=''' + remotehost + ''' and uid=' + UID;
   end
  else
   begin
     querystr := 'update user_data set callstoday=' + Calls + ' where uid=' + UID;
   end;
  { setup query }
  query := pchar(querystr);
  if sql_query(query) then
    begin
      if sql_affected_rows = 0 then
       begin
         LogError('Error Updating User Calls Today - ' + querystr);
         UpdateUserCallsToday := false;
       end
      else
       begin
         UpdateUserCallsToday := true;
       end;
    end
  else
    begin
      LogSQLError('Error Upating User Calls Today - ' + sqlerror);
      UpdateUserCallsToday := false;
    end;
end;
(*..........................................................................*)
function UpdateUserTimeOnLine(TimeOnLine, UserUID : integer) : boolean;
var
  UID,
  uTime  : string;
begin
  //writeln('UID=',UserUID);
  //writeln('TIME=', TimeOnline);
  str(UserUID, UID);
  str(TimeOnline, uTime);
  { is this a guest user }
  if UserUID = GuestUID then
   begin
     querystr := 'update user_data set timeonline=' + uTime + ' where guestip=''' + remotehost + ''' and uid=' + UID;
   end
  else
   begin
     querystr := 'update user_data set timeonline=' + uTime + ' where uid=' + UID;
   end;
  { setup query }
  query := pchar(querystr);
  if sql_query(query) then
    begin
      if sql_affected_rows = 0 then
       begin
         LogError('Error Updating User Online Time - ' + querystr);
         UpdateUserTimeOnLine := false;
       end
      else
       begin
         UpdateUserTimeOnLine := true;
       end;
    end
  else
    begin
      LogSQLError('Error Upating User Time OnLine - ' + sqlerror);
      UpdateUserTimeOnline := false;
    end;
end;
(*..........................................................................*)
function UpdateUserLogonTime(LogonTime : time_t; UserUID : integer) : boolean;
var
  UID,
  Time  : string;
begin
  str(UserUID, UID);
  str(LogonTime, Time);
  { is this a guest user }
  if UserUID = GuestUID then
   begin
     querystr := 'update user_data set logon=' + Time + ' where guestip=''' + remotehost + ''' and uid=' + UID;
   end
  else
   begin
     querystr := 'update user_data set logon=' + Time + ' where uid=' + UID;
   end;
  { setup query }
  query := pchar(querystr);
  if sql_query(query) then
    begin
      if sql_affected_rows = 0 then
       begin
         LogError('Error Updating User Logon Time - ' + querystr);
         UpdateUserLogonTime := false;
       end
      else
       begin
         UpdateUserLogonTime := true;
       end;
    end
  else
    begin
      LogSQLError('Error Upating User Logon Time - ' + sqlerror);
      UpdateUserLogonTime := false;
    end;
end;
(*..........................................................................*)
function UpdateUserTimeStamp(TimeStamp : time_t; UserUID : integer) : boolean;
var
  UID,
  Time  : string;
begin
  str(UserUID, UID);
  str(TimeStamp, Time);
  { is this a guest user }
  if UserUID = GuestUID then
   begin
     querystr := 'update user_data set timestamp=' + Time + ' where guestip=''' + remotehost + ''' and uid=' + UID;
   end
  else
   begin
     querystr := 'update user_data set timestamp=' + Time + ' where uid=' + UID;
   end;
  { setup query }
  query := pchar(querystr);
  if sql_query(query) then
    begin
      if sql_affected_rows = 0 then
       begin
         LogError('Error Updating User Time Stamp - ' + querystr);
         UpdateUserTimeStamp := false;
       end
      else
       begin
         UpdateUserTimeStamp := true;
       end;
    end
  else
    begin
      LogSQLError('Error Upating User Time Stamp - ' + sqlerror);
      UpdateUserTimeStamp := false;
    end;
end;
(*..........................................................................*)
function UpdateUserFullName(FullName : string[30]; UserUID : integer) : boolean;
var
  UID : string;
begin
  str(UserUID, UID);
  { is this a guest user }
  if UserUID = GuestUID then
   begin
     querystr := 'update user_data set namefull=''' + FullName + ''' where guestip=''' + remotehost + ''' and uid=' + UID;
   end
  else
   begin
     querystr := 'update user_data set namefull=''' + FullName + ''' where uid=' + UID;
   end;
  { setup query }
  query := pchar(querystr);
  if sql_query(query) then
    begin
      if sql_affected_rows = 0 then
       begin
         LogError('Error Updating User Full Name - ' + querystr);
         UpdateUserFullName := false;
       end
      else
       begin
         UpdateUserFullName := true;
       end;
    end
  else
    begin
      LogSQLError('Error Upating User Full Name - ' + sqlerror);
      UpdateUserFullName := false;
    end;
end;
(*..........................................................................*)
function UpdateUserEmail(Email : string[40]; UserUID : integer) : boolean;
var
  UID : string;
begin
  str(UserUID, UID);
  { is this a guest user }
  if UserUID = GuestUID then
   begin
     querystr := 'update user_data set email=''' + Email + ''' where guestip=''' + remotehost + ''' and uid=' + UID;
   end
  else
   begin
     querystr := 'update user_data set email=''' + Email + ''' where uid=' + UID;
   end;
  { setup query }
  query := pchar(querystr);
  if sql_query(query) then
    begin
      if sql_affected_rows = 0 then
       begin
         LogError('Error Updating User Email - ' + querystr);
         UpdateUserEmail := false;
       end
      else
       begin
         UpdateUserEmail := true;
       end;
    end
  else
    begin
      LogSQLError('Error Upating User Email - ' + sqlerror);
      UpdateUserEmail := false;
    end;
end;
(*..........................................................................*)
function UpdateUserInfo(Info : string[30]; InfoRecord, UserUID : integer) : boolean;
var
  UID,
  InfoNo : string;
begin
  str(UserUID, UID);
  str(InfoRecord, InfoNo);
  { is this a guest user }
  if UserUID = GuestUID then
   begin
     querystr := 'update user_data set info' + InfoNo + '=''' + Info + ''' where guestip=''' + remotehost + ''' and uid=' + UID;
   end
  else
   begin
     querystr := 'update user_data set info' + InfoNo  + '=''' + Info + ''' where uid=' + UID;
   end;
  { setup query }
  query := pchar(querystr);
  if sql_query(query) then
    begin
      if sql_affected_rows = 0 then
       begin
         LogError('Error Updating User Info' + InfoNo + ' - ' + querystr);
         UpdateUserInfo := false;
       end
      else
       begin
         UpdateUserInfo := true;
       end;
    end
  else
    begin
      LogSQLError('Error Upating User Info' + InfoNo + ' - ' + sqlerror);
      UpdateUserInfo := false;
    end;
end;
(*..........................................................................*)


end.

