program upgrade;

uses dos, crt, BaseUnix, sqldb;

{ User Information  USERINFO.DATA}
type
  User = record
    UserUID    : integer;       { Linux Account UID }
    UserAcc    : String[3];     { Account Number }
    UserAnsi   : byte;          { Ansi or Avatar }
    UserColour : byte;          { Colour ON or OFF }
    Userlevel  : byte;
    UserTime   : time_t;       { Date user account Created }
    UserTimestamp : time_t;    { epochtime of user login, used to reset daily call/time allowance }
    //UserLogon  : time_t;       { epochtime of user login }
    UserReg    : boolean;      { Has the user filled in a signup form }
    UserName   : string[30];
    UserNameFull : string[30];
    UserPass   : string[30];
    UserTown   : string[30];
    UserEmail  : string[30];
    UserInfo1  : string[30];
    UserInfo2  : string[30];
    UserInfo3  : string[30];
    Userinfo4  : string[30];
    Userinfo5  : string[30];
    Userinfo6  : string[30];
    Userinfo7  : string[30];
    Userinfo8  : string[30];
    UserCls    : Boolean;      { Screen clear code to be sent }
    UserLines  : byte;         { Lines of user terminal }
    Bulletin   : word;         { Current Bulletin Number Read }
    MailCount  : integer;      { User Mail }
    LastMsgNum : integer;
    Calls      : integer;      { Calls to system }
    CallsToday : integer;      { Calls today }
    LCallDate  : String[10];   { Last call date }
    LastCall   : string[30];
    CallNumber : integer;
    TimeOnLine : word;
    FileArea   : integer;      { Last file area visited - Will return user to this file area on next logon }
    DownLoads  : integer;      { Number of downloads }
    Uploads    : integer;      { Number of uploads }
    BytesDL    : LongInt;      { Bytes downloaded }
    BytesUL    : LongInt;      { Bytes uploaded }
end;

const
   title     = 'Sauron Linux BBS Upgrade Utility';
   version   = '0.1.0.0';
   copyright = '(C) Simon Horton 2008';
   license   = 'GPL version 2.0';

   //sqlserver = '172.16.10.169';
   sqlserver = '127.0.0.1';
   sqluser   = 'root';
   sqlpw     = '';
   sqlbbsdb  = 'bbs';

var
  userinfo : user;
  userfile : file of user;       { UserFile & User Temp File}

  valcode  : integer;


(*..........................................................................*)
{ convert userdata.info to SQL }
function user2sql(filename : string) : boolean;
var
  FileError : integer;
  uid,
  ansi,
  colour,
  level,
  time,
  timestamp,
  logon,
  reg,
  cls,
  lines,
  bulletin,
  mailcount,
  lastmsgnum,
  calls,
  callstoday,
  callnumber,
  timeonline,
  downloads,
  uploads,
  bytesdl,
  bytesul    : string;
  q1, q2, q3,
  q4, q5, q6, q7 : ansistring;
begin
  write('Opening user data file [',filename,'].. ');
  {$I-}
  Assign(userfile, filename);
  Reset(userfile);
  FileError := IOResult;
  if FileError = 0 then
    begin
      writeln('OK');
      write('Reading User Data File.. ');
      seek(userfile, 0);
      if IOREsult <> 0 then writeln('SEEKERR',IORESULT);
      Read(userfile, userinfo);
      if IOREsult <> 0 then writeln('REEDEROROROR',IORESULT);
      {$I+}
      { convert ints to str }
      str(userinfo.useruid,uid);
      str(userinfo.useransi,ansi);
      str(userinfo.usercolour,colour);
      str(userinfo.userlevel,level);
      str(userinfo.usertime,time);
      str(userinfo.usertimestamp,timestamp);

      // version 0.31.x.x
      //str(userinfo.userlogon,logon);
      str(userinfo.usertimestamp,logon);

      if  userinfo.userreg then reg := '1'
       else reg := '0';
      if userinfo.usercls then cls := '1'
       else cls := '0';
      str(userinfo.userlines,lines);
      str(userinfo.bulletin,bulletin);
      str(userinfo.mailcount,mailcount);
      str(userinfo.lastmsgnum,lastmsgnum);
      str(userinfo.calls,calls);
      str(userinfo.callstoday,callstoday);
      str(userinfo.callnumber,callnumber);
      str(userinfo.timeonline,timeonline);
      str(userinfo.downloads,downloads);
      str(userinfo.uploads,uploads);
      str(userinfo.bytesdl,bytesdl);
      str(userinfo.bytesul,bytesul);
      writeln('OK');
    end
  else
    begin
      writeln('error opening file');
      exit;
    end;
  close(userfile);
  writeln('Adding user [',userinfo.username,']');
  write('Inserting user data into the SQL database.. ');
  q1 := 'insert into user_data values('+uid+','''+userinfo.useracc+''','+ansi+','+colour+','+level+','+time+','+timestamp;
  q2 := ','+logon+','+reg+','''+userinfo.username+''','''+userinfo.usernamefull+''','''+userinfo.userpass+''','''+userinfo.usertown+''',';
  q3 := ''''+userinfo.useremail+''','''+userinfo.userinfo1+''','''+userinfo.userinfo2+''','''+userinfo.userinfo3+''',';
  q4 := ''''+userinfo.userinfo4+''','''+userinfo.userinfo5+''','''+userinfo.userinfo6+''','''+userinfo.userinfo7+''','''+userinfo.userinfo8+''',';
  q5 := ''+cls+','+lines+','+bulletin+','+mailcount+','+lastmsgnum+','+calls+','+callstoday+','''+userinfo.lcalldate+''',';
  q6 := ''''+userinfo.lastcall+''','+callnumber+','+timeonline+','+downloads+','+uploads+','+bytesdl;
  q7 := ','+bytesul+',''no'',''0.0.0.0'')';
  querystr := q1 + q2 + q3 + q4 + q5 + q6 + q7;
  query := pchar(querystr);
  if not sql_query(query) then
    begin
      writeln('SQL error..');
      writeln(sqlerror);
      writeln;
      writeln(query);

      exit;
    end
   else
    begin
      writeln('OK');
    end;
end;
(*..........................................................................*)
(*..........................................................................*)
(*..........................................................................*)
{ Main Program }
begin
 clrscr;
 if (Paramcount = 0) or (Paramstr(1) = '--help')  then
    begin
      writeln(Title,' Version ', Version, ' ', Copyright);
      writeln(License);
      writeln;
      writeln('Usage : upgrade <options> [data file]');
      writeln;
      writeln('Options - ');
      writeln;
      writeln;
      writeln('Please read the UPGRADE.DOC for information on using this utility.');
      writeln('Email: simon@sauron.org.uk with questions or bug reports.');
      writeln;
      writeln;
      Halt(0);
    end
   else
    begin
      writeln(Title,' Version ', Version, ' ', Copyright);
      if fpgetuid <> 0 then
       begin
         writeln('It is recommanded to run this program as root..');
         writeln;
         halt(1);
       end;
     { Connect to SQL Server }
     writeln;
     write('Connecting to SQL server.. ');
     if not sql_connect(sqlserver,sqluser,sqlpw) then
      begin
       writeln('Oops, mysql connection error...[',sqlerror,']');
       halt(1);
      end
     else
      begin
        { Connect database }
        if not sql_select_db(sqlbbsdb) then
         begin
           writeln('Opps, mysql db error...[',sqlerror,']');
           // Need to add dispose(pchar) for BBSCfg.SQLxx
           halt(1);
         end;
      end;
     writeln('OK');
     user2sql(paramstr(1));
     sql_close;
    end;
end.
