UNIT TpzAsync;

INTERFACE
USES Dos, PibAsync, PibTimer, GlobType;

FUNCTION Z_CharAvail: BOOLEAN;
PROCEDURE Z_ClearInbound;
PROCEDURE Z_FlushOutbound;
PROCEDURE Z_ClearOutbound;
PROCEDURE Z_SendBreak;
FUNCTION Z_ReceiveByte: INTEGER;
PROCEDURE Z_SendByte(b: BYTE);
FUNCTION Z_Carrier: BOOLEAN;

IMPLEMENTATION

{$DEFINE FOSSIL}

FUNCTION Z_CharAvail: BOOLEAN;
(* See if there is a character coming in *)
BEGIN
  Z_CharAvail := Async_Buffer_Check
END;

PROCEDURE Z_ClearInbound;
(* Throw away any pending input to clear the line *)
VAR
   n: INTEGER;
BEGIN
    WHILE (Async_Carrier_Detect) AND (Async_Buffer_Check) DO
       Async_Receive_With_Timeout(1,n)
END;

PROCEDURE Z_ClearOutbound;
(* Throw away any pending output in the buffer *)
BEGIN
  Async_Flush_Output_Buffer
END;

PROCEDURE Z_FlushOutbound;
BEGIN
     REPEAT UNTIL (NOT Async_Carrier_Detect) OR
                  (Async_OBuffer_Head = Async_OBuffer_Tail)
END;

PROCEDURE Z_SendBreak;
(* Send a break signal *)
BEGIN
     Async_Send_Break
END;

PROCEDURE Z_SendByte(b: BYTE);
(* Output one byte *)
BEGIN
     Async_Send(Chr(b))
END;

FUNCTION Z_ReceiveByte: INTEGER;
(* Input one byte (N.B.: RETURNS AN INTEGER!) *)
VAR
   n: INTEGER;
BEGIN
     Async_Receive_With_Timeout(0,n);
     Z_ReceiveByte := (n AND $00FF)
END;

FUNCTION Z_Carrier: BOOLEAN;
(* Checks for the presence of a carrier *)
BEGIN
  Z_Carrier := (Async_Carrier_Detect)
END;

END.
