(*..........................................................................*)
(*        								    *)
(* MODULE	:   STOREDIR.PP      			                    *)
(*									    *)
(* DESCRIPTION	:   STORES FILE DIRECTORY STRUCTURE                         *)
(*									    *)
(* ENVIRONMENTS :   PPC386 PASCAL Ver 0.99.0+ LINUX KERNEL 2.2.30+          *)               
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1998 - 2008                                *)
(*									    *)
(* VERSION      :   Linux Version 0.0.1                                     *)
(*..........................................................................*)
(* History                                                                  *)
(*									    *)
(* 23 May 1998 - First Version            				    *)
(*..........................................................................*)
(* Todo                                                                     *)
(*       - Tidy Up Code                                                     *)
(*..........................................................................*) 
uses linux, crt, dos;

{ Maxx BBS File Areas  AREAS.DAT }
type
  Area = record
    AreaNumber  : String[3];
    Description : String[30];
    OpenClosed  : Boolean;
    FileNumber  : LongInt;
    CatNumber   : LongInt;
end;

{ Maxx BBS File Areas  AREA.* }
type
  FileAreas = record
    DirNo   : Integer;     { Number Of File Directorys }
    Dir     : String[255];  { Directory path       }
    DirDes  : String[30];  { Directory Area Name  }
    FileLst : String[255];  { Files List & Path    }
    Uploads : Integer;     { Uploads Allowed      }
    DnLoads : Integer;     { DownLoads Allowed    }
    Access  : integer;     { Minimum Level Access }
end;

var
  Areas      : FileAreas;     { Data, as the main file was somehow being corrupt }
  SAreas     : Area;
  FileArea   : File of FileAreas;  { File Directorys }
  CatArea    : File of Area;
  infile,
  outfile : text;
  DirNumber,
  number,
  step  :  integer;
  Size, 
  areasize : LongInt;
  line : string;
  Flag : boolean;
  Info : Byte;
  temp,
  I1,
  I2,
  I3,
  PC   : string;

procedure open_data_areas;
begin
  Assign(CatArea,'areas.dat');
  {$I-} Reset(CatArea); {$I+}
  if IOResult = 0 then
    begin
      if FileSize(CatArea) <> 0 then
       begin
         Seek(CatArea, 0);
         Read(CatArea, SAreas);
       end;
    end
  else
    begin
      {$I-} rewrite(CatArea); {$I+}
      if IOResult <> 0 then
        begin
{          TextBackground(Red); }
{          Textcolor(White); }
          Write(' ERROR : ');
          writeln(' areas.dat');
          Halt(1);
       end;   
    end;
(*
  Assign(FileArea,'area.1');   { Open Default File Area }
  {$I-} Reset(FileArea); {$I+}
  if IOResult = 0 then
    begin
      if FileSize(FileArea) = 0 then
       begin
         Seek(FileArea, 0);
         Read(FileArea, Areas);
       end;
    end
  else
    begin
      TextBackground(Red);
      Textcolor(White);
      Write(' ERROR : ');
      Writeln(' AREA.1');
      Halt(1);
    end;
*)
end;

begin
  DirNumber := 1;
  Info := 1;
  If paramcount = 0 then
    begin
      clrscr;
      textbackground(7);
      textcolor(0);
      writeln(' StoreDir Version 0.0.1 Linux Maxx BBS                (C) Maxx Develpments 1998 ');
      textbackground(0);
      textcolor(7);
      writeln;
      writeln('Usage : STOREDIR < STRUCTURE FILE > ');
      writeln;
      Halt(1);
    end;
  assign(infile, Paramstr(1));
  {$I-} reset(infile); {$I-}
  if IOResult <> 0 then
   begin
     clrscr;
     textbackground(7);
     textcolor(0);
     writeln(' StoreDir Version 0.0.1 Linux Maxx BBS                (C) Maxx Develpments 1998 ');
     textbackground(0);
     textcolor(7);
     writeln;
     writeln('Error Opening File ', Paramstr(1));
     writeln;
     halt(1);
   end;
  open_data_areas; 
  while not eof(infile) do
   begin
     Temp := '';
     Flag := False;
     Number := 1;
     readln(InFile, Line);
     if (Line[1] <> chr(59)) and (Line[1] <> chr(37)) then
       begin
         Temp := '';
         Areas.DirNo := DirNumber;
         Str(DirNumber, Temp);
         Areas.FileLst := I3 + Temp + '.lst';
         Temp := '';
         repeat
           if Line[Number] <> ' ' then
             begin
               Temp := Temp + Line[Number];
             end;
           inc(Number);
         until Line[Number] = ' ';
         writeln(Temp);
         Areas.Dir := Temp;
         repeat
           inc(Number);
         until Line[Number] <> ' ';
         dec(Number);
         Temp := '';
         repeat
           inc(Number);
           if Line[Number] <> ' ' then
             begin
               if Line[Number] = '_' then Temp := Temp + ' '
                 Else Temp := Temp + Line[Number];
             end;
         until Line[Number] = ' ';
         for step := 0 to length(Temp) do
            begin
              Temp[Step] := Upcase(Temp[Step]);
            end;
         write(' ', Temp);
         writeln;
         Areas.DirDes := Temp;
         repeat
          inc(Number);
         until Line[Number] <> ' ';
         dec(Number);
         Temp := '';
         repeat
           inc(Number);
           If Line[Number] <> ' ' then
             begin
               Temp := Line[Number];
             end;
         until Line[Number]  = ' ';
         If UpCase(Temp[Number]) = 'Y' then
           begin
             Areas.UpLoads := 1;
           end
         Else
           begin
             Areas.UpLoads := 0;
           end;
         repeat
           inc(Number);
         until Line[Number] <> ' ';
         dec(Number);
         Temp := '';
         repeat
           inc(Number);
           If Line[Number] <> ' ' then
             begin
              Temp := Line[Number];
             end;
         until Line[Number]  = ' ';
         If UpCase(Temp[1]) = 'Y' then
           begin
             Areas.DnLoads := 1;
           end
         Else
           begin
             Areas.DnLoads := 0;
           end;
         repeat
           inc(Number);
         until Line[Number] <> ' ';
         dec(Number);
         Temp := '';
         repeat
           inc(Number);
           If Line[Number] <> ' ' then
             begin
               Temp := Line[Number];
             end;
         until Number = Length(Line);
         Val(Temp, Step, Number);
         Areas.Access := Step;
         Write(FileArea, Areas);
         inc(dirNumber);
      end
  else
    begin
      If Line[Number] = '%' then
        begin
          Temp := '';
          repeat
            inc(number);
          until Line[Number] = ' ';
          repeat
           inc(Number);
           if Line[Number] <> ' ' then
             begin
               if Line[Number] = '_' then Line[Number] := ' ';
               Temp := Temp + Line[Number];
             end;
         until number >= Length(Line);
         Case Info of
            1: begin
                 PC := 'area.' + Temp;
                 Assign(FileArea, PC);
                 Rewrite(FileArea);
               end;
            2: begin
                 SAreas.Description := Temp;
                 SAreas.OpenClosed  := True;
               end;
            3: I3 := Temp;
         end; { Case End }
         inc(Info);
        end
      else
      begin
         { ignore }
       end;
    end;
  end;
  write(areas.dirdes);
  areasize := filesize(Catarea) + 1;
  Str(AreaSize, Temp);
  SAreas.AreaNumber := Temp;
  SAreas.FileNumber := 6305;
  SAreas.CatNumber  := DirNumber;
  Val(SAreas.AreaNumber, Number, Step);
  Seek(CatArea, FileSize(CatArea));
  Write(CatArea, SAreas);
  Close(infile);
  Close(FileArea);
  Close(CatArea);
end.



