(* $Id: start.pp,v 1.5 2008-02-19 21:58:09 simon Exp $                       *)
(* ........................................................................ *)
(*        								    *)
(* MODULE	:   START.PAS       			                    *)
(*									    *)
(* DESCRIPTION	:   MODEM CONTROL AND ANSWEAR ROUTINES                      *)
(*									    *)
(* ENVIRONMENTS :   TURBO PASCAL Ver 7,  MSDOS 3.3 +                        *)
(*              :   PPC386 PASCAL Ver 0.99.0 LINUX KERNEL 2.2.30+           *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1995 - 2007 & ALEX HENRIKSEN 1997 - 1998   *)
(*									    *)
(* VERSION      :   DOS version 1.06A  Linux Version 0.0.1                  *)
(*..........................................................................*)
(*
   $Log: start.pp,v $
   Revision 1.5  2008-02-19 21:58:09  simon
   see todo.txt

   Revision 1.3  2008/02/11 22:40:36  simon
   Removed old units

*)
Unit Start;

Interface

{$IFDEF _LINUX_}
  Uses dos, linux, Lib, Crt, Display, Data, Colours, Errorlog, Dates, BaseUnix, Unix,user;

{$ELSE}
  Uses dos,  Lib, Crt, Display, Data, PIBAsync, Wins, Stats,
       Colours, Errorlog, Dates, WaitTix;
{$ENDIF}

Procedure StartBBS;

Implementation
(*..........................................................................*)
Var
  Hangup : Boolean;
(*..........................................................................*)
{$IFDEF _LINUX_}
{$ELSE}
procedure ViewLog(Filename : String);
var
  F    : Text;
  Step : Integer;
  Line : String;
begin
  Assign(F, FileName);
  {$I-} Reset(F); {$I+}
  Error := IOResult;
  If Error <> 0 then
    begin
      Case Error of
        2 : begin
            end;
        Else
           begin
           end;
      end; { End Case }
    end
  Else
    begin
      Step := 0;
      OnCursor;
      Box(1,1,80,25,58,2, False);
      OffCursor;
      while not eof(f) do
        begin
          Readln(F, Line);
          If Step < 23 then
            begin
              Writeln(Line);
              Inc(Step);
            end
           Else
             begin
               Step := 0;
               Writeln;
               Write('Press Any Key To Continue');
               Repeat Until Keypressed;
               Line := ReadKey; { Clear Buffer }
               ClrScr;
             end;
        end;
      Writeln;
      Write('Press Any Key To Continue');
      Repeat Until Keypressed;
      Line := ReadKey; { Clear Buffer }
      CloseBox;
    end;
end;
(*..........................................................................*)
procedure Help;
begin
  OnCursor;
  Box(10, 7, 70, 18, 58, 3, True);
  OffCursor;
  BCol(Cyan);
  TCol(White);
  ClrScr;
  Writeln(' F2  Logon To Sauron Localy');
  Writeln(' F3  Logon On To Sauron Localy, Bypassing the LOGON.SFI');
  Writeln('     Automatically As Sysop');
  Writeln(' F4  Alter Any Users Account Details & Preferances');
  Writeln(' F5  View USER.LOG');
  Writeln(' F6  View ERROR.LOG');
  Repeat Until Keypressed;
  CloseBox;
end;
(*..........................................................................*)
Procedure SetUpScreen;
begin
  BCol(Blue);
  TCol(White);
  GotoXY(75,2);
  Write(BBSCfg.Node);
  TCol(Yellow);
  GotoXY(18,20);
  Write(BBSInfo.Line);
  GotoXY(18,21);
  Write(BBSInfo.Date);
  GotoXY(59,22);
  Write(BBSCfg.Calls);
end;
(*..........................................................................*)
Procedure CopyRight;
Var
  Strgs : String;
begin
  Window(1,1,80,25);
  BCol(Black);
  ClrScr;
  If AnsiDetect then
    begin
      UserInfo.UserAnsi   := 1;
      UserInfo.UserColour := 1;
    end
  Else
    begin
      UserInfo.UserColour := 0;
    end;
   ClearDisplay(False);
   Colour(FYellow);
   Print('SAURON HOST');
   Colour(FCyan);
   Print(' Ver' + Version + ' Copyright (C) Simon Horton 1995');
   Print('Licenced To : ');
   Colour(FYellow);
   Print(Regto);
   Colour(FCyan);
   Print(' Licence Number : ');
   Colour(FYellow);
   Print(RegNo);
   LineFeed;
   LineFeed;
   Colour(FMagenta);
   Print('   BBS  : ');
   Colour(FYellow);
   Print(BBScfg.BBSName);
   LineFeed;
   Colour(FMagenta);
   Print('   Line : ');
   Colour(FYellow);
   Print(BBSCfg.BBSTele);
   LineFeed;
   If BBSCfg.Node > 0 then
     begin
       Colour(FMagenta);
       Print('   Node : ');
       Colour(FYellow);
       Str(BBSCfg.Node, Strgs);
       Print(Strgs);
       LineFeed;
     end;
   Colour(FMagenta);
   Print('Connect : ');
   Colour(FYellow);
   if Local then
     begin
       Print('LOCAL');
     end
   Else
     begin
       if (carrier <> 0) and (Carrier < LineBaud) then
         begin
            str(Carrier, Strgs);
            Print(Strgs);
        end
       else
         begin
           Print(copy(ConnectString, 9, Length(ConnectString)));
         end;
     end;
   Colour(FWhite);
   LineFeed;
   LineFeed;
   Wait(10);
   TextColor(7);
end;
{$ENDIF}
(*..........................................................................*)
{$IFDEF _LINUX_}
{$ELSE}
procedure HangUpModem;
begin
  Center(22,'HANGING UP MODEM');
  Async_Send_String('ATH1' + Char(13));
  Wait(5);
end;
(*..........................................................................*)
procedure ResetModem;
begin
  { ResetCom(ComPort); }
  Wait(2);
(*  Repeat
    DropFCarrier;
    Wait(2);
     if not FCarrier then
       begin
         SendFChar(Ord('A'));
         SendFChar(Ord('T'));
         SendFChar(Ord('Z'));
         SendFChar(13);
         Wait(2);
       end;
     If Not FCarrier then
       begin
         SendFChar(Ord('A'));
         SendFChar(Ord('T'));
         SendFChar(Ord('H'));
         SendFChar(Ord('0'));
         SendFChar(13);
         Wait(2);
       end;
    If FCarrier then
       begin
         SendFChar(Ord('+'));
         SendFChar(Ord('+'));
         SendFChar(Ord('+'));
         SendFChar(13);
         SendFChar(13);
         Wait(2);
       end;
  Until Not FCarrier;
  DTR; *)
end;
(*..........................................................................*)
procedure ModemIntro;
  Label Reset;  { A Jump Label :-( }
var
  StringLen    : Integer;
  Ins          : Integer;
  Count        : Integer;
  IntroString1 : String;
  IntroString2 : String;
  IntroString3 : String;
  ModemString  : String;
  Connect,
  Ring         : Boolean;
  Key          : Char;
  A,B          : Integer;
  TimeOut,
  GetTimeOut   : longint;
begin
  OnCursor;
  Window(4,7,49,16);
  OffCursor;
  TCol(Yellow);
  BCol(Blue);
  ClrScr;
  Async_Fossil := FALSE;
  Async_Do_CTS := FALSE;
  Async_Do_DSR := FALSE;
  Async_Do_XonXoff := FALSE;
  Async_Hard_Wired_On := FALSE;
  Async_Break_Length := 500;
  Async_Init(2048,2048,0,0,0);
  PortStatus := Async_Open(ComPort, BaudRate, Parity, DataBits, StopBits);
  if not PortStatus then
    begin
      ClrScr;
      Writeln('             UNABLE TO OPEN COM PORT');
      Writeln('     USE -  SAURON /C:<config file> /LOCAL');
      Writeln('          To Start Sauron In Local Mode');
      Wait(150);
      Halt(1);
    end;
  Reset:
  Carrier := 0;
  LineBaud := 0;
  Connect := False;
  Ring    := False;
  If HangUp then ResetModem;
  HangUp := False;
  if Async_Carrier_Detect then
    begin
      Writeln;
      Writeln('CARRIER DETECTED..ATEMPTING TO LOWER CARRIER');
      ResetModem;
    end;
  Count        := 1;
  Stringlen    := 0;
  IntroString1 := BBSCfg.InitString1;
  Introstring2 := BBSCfg.InitString2;
  IntroString3 := BBSCfg.InitString3;
  Repeat
    Case Count of
       1 :begin
            StringLen   := Length(IntroString1);
            ModemString := IntroString1;
          end;
       2 :begin
            Stringlen   := Length(IntroString2);
            ModemString := IntroString2;
          end;
       3 :begin
            Stringlen   := Length(IntroString3);
            ModemString := IntroString3;
          end;
   end;   { Case End }
   For Loop := 1 to Stringlen do
      begin
        Async_Send(ModemString[Loop]); { Introlisation String To Modem }
        Wait(5);
        GetTimeOut := 0;
        TimeOut := 0;
        GetTimeOut := GetTix;
        Repeat
          TimeOut := GetTix;
        Until (Async_Buffer_Check) or (TimeOut >= GetTimeOut + ModemTimeOut);
        if TimeOut >= (GetTimeOut + ModemTimeOut) then
          begin
            Writeln('TIMEOUT');
          end
        else
          begin
            PortStatus := Async_Receive(ModemChar);
            Write(ModemChar);
          end;
      end;
  Async_Send(#13);
  GetTimeOut := 0;
  GetTimeOut := GetTix;
  TimeOut := 0;
  Repeat
    TimeOut := GetTix;
  Until (Async_Buffer_Check) or (TimeOut >= GetTimeOut + ModemTimeOut);
  if TimeOut >= (GetTimeOut + ModemTimeOut) then
    begin
      writeln('TIMEOUT');
    end
  else
    begin
      PortStatus := Async_Receive(ModemChar);
      Write(ModemChar);
    end;
  GetTimeOut := 0;
  GetTimeOut := GetTix;
  TimeOut := 0;
  Repeat
    TimeOut := GetTix;
  Until (Async_Buffer_Check) or (TimeOut >= GetTimeOut + ModemTimeOut);
  GetTimeOut := 0;
  TimeOut := 0;
  GetTimeOut := GetTix;
  Repeat
    Wait(10);
    PortStatus := Async_Receive(ModemChar);;
    if PortStatus then Write(ModemChar);
    TimeOut := GetTix;
    if TimeOut >= (GetTimeOut + ModemTimeOut) then PortStatus := False;
  until PortStatus = False;
  if TimeOut >= (GetTimeOut + ModemTimeOut) then writeln('TIMEOUT');
  ModemString :='';
  LineCount := 0;
  Error     := 0;
  Ins := 0;
  Count := Count + 1;
  ModemString := '';
  Stringlen   := 0;
  Until (Count = 4);
  Writeln('Waiting For Caller');
  LineCount := MinutesPast;
  repeat
  Error := MinutesPast;
 (* if not CarrierDetect(ComPort) then
    begin
      Writeln;
      Writeln('CARRIER DETECTED');
    end; *)
(*  If Not CarrierDetect(ComPort) then
      Center(24, '              '); *)
  If Keypressed then
    begin
      Case ReadKey of
        #0 : begin
               Case Readkey of
                   #59 : begin { F1 }
                           Local := True;
                           HangUpModem;
                         end;
                   #60 : begin  { F2 }
                           Writeln;
                           Writeln('EXITING SAURON BBS');
                           ResetModem;
                           Finish := true;
                           Wait(50);
                            ClrScr;
                           CurSw(True); { Exit BBS F9 }
                           Exit;
                         end;
                   #62 : begin  { F4 }
                           Error := LineCount + 2; { Reset Modem  F7 }
                         end;
                   #63 : begin   { F5 }
                           ViewLog(BBSCfg.LogFile);
                           Viewlog(BBSCfg.ErrFile);
                         end;
                   #64 : begin   { F6 }
                           HangUpModem;
                           CurSw(True);
                           Halt(3); { Return To Sauron And Shell to Dos F8 }
                           ResetModem;
                         end;
                   #65 : begin   { F7 }
                         end;
                   #66 : begin   { F8 }
                         end;
                   #67 : begin
                         end;
                   #68 : begin
                         end;
                   #69 : begin
                         end;
               end; { Case End }
          end;
      end; { Case End }
    end;
  { PeakFChar <> 0 }
     if Async_Buffer_Check then
          begin
            ModemString := '';
            Repeat
              PortStatus := Async_Receive(ModemChar);;
              If ModemChar > #31 then ModemString := ModemString + ModemChar;
            Until ModemChar = #13;
            { Get Line Connection Speed }
            If Pos('RING', ModemString) > 0 then
              Begin
                if not Ring then
                  begin
                    Ring := True;
                    (*Center(22,'                                  ');
                    Center(22,'RING');
                    *)
                    Sound(620);
                    Wait(1);
                    Sound(660);
                    Wait(1);
                    NoSound;
                    Wait(1);
                    Stringlen   := Length(BBSCfg.InitAnswear);
                    ModemString := BBSCfg.InitAnswear;;
                    For Loop := 1 to Stringlen do
                    begin
                      { Intialisation String To Modem }
                      Async_Send(ModemString[Loop]);
                      { SendFChar(Ord(ModemString[Loop])); }
                      Wait(2);
                    end;
                    LogError('Modem Output = ' + ModemString);
                    Async_Send(#13);
                    { SendFChar(13); }
                    Wait(2);
                 end;
                Writeln;
                Writeln('WAITING CONNECTION');
                { Make Sure System Resets If Connection Takes Longer than 2 Minutes }
                LineCount := MinutesPast;
              End;
            If Pos('NO CARRIER', ModemString) > 0 then
              Begin
                LogError('Modem Output = ' + ModemString);
                Wait(2);
                Goto Reset;
              End;
            If Pos('FAX', ModemString) > 0 then
              begin
                Writeln;
                Writeln('INCOMING FAX');
                Wait(5);
                BBSInfo.Fax     := BBSInfo.Fax + 1;
                BBSInfo.FaxTime := Today;
                Seek(BBSini, 0);
                Write(BBSini, BBSInfo);
                LogError('Modem Output = ' + ModemString);
                Halt(4); { Exit SBBS Reset Software }
              end;
            If Pos('CARRIER', ModemString) > 0 then
              begin
                Ins := 9;
                IntroString1 := '';
                Repeat
                  If (ModemString[Ins] <> ' ') or (ModemString[Ins] <> '/') then
                    begin
                      If (Ord(ModemString[Ins]) > 47) and
                         (Ord(ModemString[Ins]) < 58) then
                        IntroString1 := IntroString1 + ModemString[Ins];
                    end;
                  Inc(Ins);
                Until (ModemString[Ins] = '/') or (Ins = Length(ModemString) + 1)
                   or (ModemString[Ins] = ' ');
                Count := 0;
                Val(IntroString1, Count, Ins);
                Carrier  := Count;
              end;
            If Pos('CONNECT', ModemString) > 0 then
              begin
                Ins := 9;
                IntroString1 := '';
                Repeat
                  If (ModemString[Ins] <> ' ') or (ModemString[Ins] <> '/') then
                    begin
                      If (Ord(ModemString[Ins]) > 47) and
                        (Ord(ModemString[Ins]) < 58) then
                        IntroString1 := IntroString1 + ModemString[Ins];
                    end;
                  Inc(Ins);
                Until (ModemString[Ins] = '/') or (Ins = Length(ModemString) + 1)
                   or (ModemString[Ins] = ' ');
                ConnectString := ModemString;
                If length(ModemString) <= 9 then
                  begin
                    LineBaud := 300;
                    Connect := True;
                    LogError('CONNECT 300');
                  end
                 else
                  begin
                    Count := 0;
                    Val(IntroString1, Count, Ins);
                    LineBaud := Count;
                    Connect := True;
                    LogError('Modem Output = ' + ModemString);
                  end;
              if Ring then
                 begin
                   Writeln;
                   Writeln('WAITING CONNECTION');
                 end;
              if not BBSCfg.LocKBaud then
                 begin
                   Case LineBaud of
                      14400..19200 : Async_Reset_port(ComPort, 19200, Parity, DataBits, StopBits);
                      28800..38400 : Async_Reset_port(ComPort, 38400, Parity, DataBits, StopBits);
                          300..599 : Async_Reset_port(ComPort, 300, Parity, DataBits, StopBits);
                         600..1199 : Async_Reset_port(ComPort, 600, Parity, DataBits, StopBits);
                        1200..2399 : Async_Reset_port(ComPort, 1200, Parity, DataBits, StopBits);
                        2400..4799 : Async_Reset_port(ComPort, 2400, Parity, DataBits, StopBits);
                        4800..9799 : Async_Reset_port(ComPort, 4800, Parity, DataBits, StopBits);
                       9600..14399 : Async_Reset_port(ComPort, 9600, Parity, DataBits, StopBits);
                    end; {Case End}
                    ModemString := '';
                    Str(LineBaud, ModemString);
                    ActualBaud := ModemString;
                  end;
                { SetFlowControl(9); }
              end
             Else
              begin
               { If Pos('RING', ModemString) > 0 then }
                 begin
                   Writeln;
                   Writeln(ModemString);
                 {  Center(22,'                                ');
                   Center(22, ModemString); }
                   LogError('Modem Output = ' + ModemString);
                   Wait(2);
                 end;
              end;
          end;
  { Resets Modem Every 2 Minutes - Should prevent Modem From Locking Up }
  If (Error = LineCount + 2) and (Connect = False) and (Ring = False) then
    begin
      Writeln;
      Writeln('RESETING MODEM');
      Wait(5);
      Goto Reset;
    end;
  UNTIL (Connect = True) or (Local = True);
  LineCount := 0;
  If Local Then
    begin
      Writeln;
      Writeln('LOCAL LOGON');
      HangUp     := True;
      AnsiDetect := True;
      Wait(10);
    end;
end;
{$ENDIF}
(*..........................................................................*)
procedure AnsiDetec;
Var
  AnsiChar   : Char;
  TTY_Output : text;
  Epoch      : time_t;
begin
  AnsiDetect := false;
  Epoch := fptime + 3;
  writeln('Sensing Terminal ... ');
  write(chr(27) + '[6n' + chr(13));;
  delay(800);
  repeat
    if keypressed then
     begin
       ansichar := readkey;
       If (AnsiChar in [#27,'0'..'9','[',';','R']) then
         begin
          AnsiDetect := True;
          exit;
         end; 
     end;
  until fptime >= Epoch;
  (*
   { Old routinue, works, but if terminal does not send ANSI codes }
   { then the user has to press a key, because read sits and waits }
   Epoch := fptime + 5;
   writeln('Sensing Terminal ... ');
   writeln('If you can see this message for longer than 5 secs, press a key.!');
   assign(TTY_Output,'');
   {$I-}
     reset(TTY_Output);
   {$I+}
   if IOResult <> 0 then
    begin
      { Unable To Open TTY }
      AnsiDetect := false;
    end
   else
    begin
      write(chr(27) + '[6n' + chr(13));;
      delay(500);
      while not eof(TTY_Output) and (ansichar <> '') do
       begin
         read(tty_output,ansichar);
         If (AnsiChar in [#27,'0'..'9','[',';','R']) then
           begin
             AnsiDetect := True;
             close(TTY_Output);
             exit;
           end;
         if fptime >= Epoch then 
           begin
             AnsiDetect := False;
             close(TTY_Output);
             exit;
           end;
          write(fptime,'-');
       end;
       close(TTY_Output);
    end;
*)
end;
(*..........................................................................*)
procedure StartBBS;
begin
  OpenDataFiles;  { Open Data Files }

//  UserInfo.CallNumber := BBSCfg.Calls;
//  UpdateUserCallNumber(UserInfo.CallNumber, UserInfo.UserUID);

  Errored := False; { Reset Error Log Switch }
  If not Local then
      begin
	{$IFDEF _LINUX_}
          //AnsiDetec;
          AnsiDetect := True;
        {$ELSE}
          OffCursor;
          if Paramstr(1) <> '/D' then { Door Way Mode / MailDoor }
            begin
              SetUpScreen;
              OnLine := True;
              ModemIntro;
            end
          else
            begin
              OnLine    := True;
              LineCount := 0;
              Val(Paramstr(2), Linebaud, Code);
              if not BBSCfg.LocKBaud then
                 begin
                   Case LineBaud of
                       14400..19200 : Async_Reset_port(ComPort, 19200, Parity, DataBits, StopBits);
                       28800..38400 : Async_Reset_port(ComPort, 38400, Parity, DataBits, StopBits);
                           300..599 : Async_Reset_port(ComPort, 300, Parity, DataBits, StopBits);
                          600..1199 : Async_Reset_port(ComPort, 600, Parity, DataBits, StopBits);
                         1200..2399 : Async_Reset_port(ComPort, 1200, Parity, DataBits, StopBits);
                         2400..4799 : Async_Reset_port(ComPort, 2400, Parity, DataBits, StopBits);
                         4800..9799 : Async_Reset_port(ComPort, 4800, Parity, DataBits, StopBits);
                        9600..14399 : Async_Reset_port(ComPort, 9600, Parity, DataBits, StopBits);
                   end; {Case End}
                end;
              ConnectString := 'CONNECT ' + Paramstr(2) + Paramstr(3);
	    end;
          If Not Finish then
            begin
              GotoXY(1,1);
              if not Local then AnsiDetec;
              CopyRight;
	    end;
         {$ENDIF}
      end
   Else
     begin
       BaudRate := 38400;
       //AnsiDetec;
       AnsiDetect := True;
     end;
end;
end.
