unit user;

interface

{$linklib c}

uses Linux, Dos, Strings, Crt, nCrt, cWin, DataLib, lib, BaseUnix, SysUtils;

procedure DisplayUser;
function GetUsers : integer;
function DeleteNewUser : boolean;

implementation

var
   DataStr   : string;
   User_Win  : pWin;
   tUser     : tUserInfo;
   UserInfo  : uInfo;
   UserDB    : file of UserRec;
   UserData  : UserRec;
   Uid,
   Code,
   fSuccess  : integer;
   fSave     : boolean;

   { ----------------------------------
      Setup external library functions
     ---------------------------------- }
   function getpwuid(UserID : Longint) : tUserInfo; cdecl; external;

{ ---------------------------------------------------------------------------
                      Displays users waiting creation
  ---------------------------------------------------------------------------}
function ListNewUsers : integer;
var
  NewDB : string;
  Loop,
  No    : integer;
begin
  No := 1;
  if BBSCfg.NewDir[Length(BBSCfg.NewDir)] = '/' then NewDB := BBSCfg.NewDir + NewUserDatabase
   else NewDB := BBSCfg.NewDir + '/' + NewUserDatabase;
   { ------------------------------
     Check if there is a newuser DB
     ------------------------------ }
   if not FileExists(NewDB) then
    begin
       cErrorBox('There are no users waiting creation..!');
       ListNewUsers := 0;
       exit;
    end
   else
    begin
      assign(UserDB, NewDB);
      {$I-}
      reset(UserDB);
      if IOResult <> 0 then
       begin
         cErrorBox('Reading - ' + NewDB);
         ListNewUsers := 0;
       end
      else
       begin
         if FileSize(UserDB) <> 0 then
          begin
            for Loop := 0 to (FileSize(UserDB) - 1) do
              begin
                seek(UserDB, Loop);
                read(UserDB, UserData);
                d1List[No] := UserData.UserName;
                d2List[No] := UserData.UserNameFull;
                d3List[No] := UserData.UserTown;
                inc(No);
              end;
           ListNewUsers := dListBox(No,'NEW USERS','[ESC] Exit [ENTER] Delete');
        end
       else       
        begin
          cErrorBox('There are no users waiting creation..!');
          ListNewUsers := 0;
        end
      end;
    end;
   close(UserDB);
  {$I+}
end;
{ ---------------------------------------------------------------------------
                      Delete a user waiting creation
  ---------------------------------------------------------------------------}
function DeleteNewUser : boolean;
var
 nUser,
 Loop  : integer;
 NewDB : string;
begin
   nUser := ListNewUsers;
   if nUser = 0 then exit;
   if not cAlertBox('ALERT','Are you sure want to remove the new user') then exit;
   if BBSCfg.NewDir[Length(BBSCfg.NewDir)] = '/' then NewDB := BBSCfg.NewDir + NewUserDatabase
     else NewDB := BBSCfg.NewDir + '/' + NewUserDatabase;
   assign(UserDB, NewDB);
   {$I-}
   reset(UserDB);
   if IOResult <> 0 then
    begin
       cErrorBox('Reading - ' + NewDB);
       DeleteNewUser := false;
       exit;
    end
   else
     begin
       { ---------------
         Remove the user
         --------------- }
        if FileSize(UserDB) > 1 then
         begin
            for Loop := nUser to (FileSize(UserDB) - 1) do
             begin
               seek(UserDB, Loop);
               read(UserDB, UserData);
               seek(UserDB, (Loop - 1));
               write(UserDB, UserData);
             end;
         end;
        { -------------------------------
            Delete User Record
          ------------------------------- }
        seek(UserDB,(FileSize(UserDB) - 1));
        truncate(UserDB);
        if IOResult = 0 then
         begin
           cSuccessBox('User Deleted');
           DeleteNewUser := true;
         end
        else
         begin
           cErrorBox('Removing user');
           DeleteNewUser := false;
         end;
     end;
     close(userDB);
     {$I+}
end;
{ ---------------------------------------------------------------------------
                Returns number of users on the Linux system &
                  stores their infomation into a database
  ---------------------------------------------------------------------------}
function GetUsers : integer;
begin
  Uid := BBsUserID; { Set to BBS user ID}
  repeat
    inc(Uid);
  until getpwuid(Uid) = NIL;
  GetUsers := Uid - (BBsUserID);
end;
{ ---------------------------------------------------------------------------

  ---------------------------------------------------------------------------}
function SaveUserData : boolean;
var
 Directory,
 hDirectory : string;
 UserSize   : integer;
begin
  tUser := getpwuid(UserData.UserUID);
  { -----------------------------
     Open the users bbs database
   ----------------------------- }
  hDirectory := BBSCfg.HomeDir;
  if hDirectory[Length(hDirectory)] = '/' then Directory := hDirectory + StrPas(tUser^.pw_name) + '/' + UserDatabase
   else Directory := hDirectory + '/' + StrPas(tUser^.pw_name) + '/' + UserDatabase;
  Assign(UserDB, Directory);
  {$I-}
  Reset(UserDB);
  fSuccess := IOResult;
  if fSuccess = 0 then
   begin
     Seek(UserDB, 0);
     Write(UserDB, UserData);
     {$I+}
     if IOResult = 0 then
      begin
        {-------------------
           Display Error Box
         -------------------}
        cSuccessBox('User Update');
        SaveUserData := FALSE;
        fSave := false;
      end
     else
      begin
        {-------------------
           Display Error Box
         -------------------}
        cErrorBox('Updating User Info');
        SaveUserData := FALSE;
      end;
   end
  else
   begin
     {-------------------
        Display Error Box
      -------------------}
     cErrorBox('Unable to open user database');
     SaveUserData := FALSE;
   end;
end;
{ ---------------------------------------------------------------------------
--------------------------------------------------------------------------}
function RetriveUserData(ID : integer) : boolean;
var
 Directory,
 hDirectory : string;
 UserSize   : integer;
begin
  { --------------------------------------
    Get user information from getpwuid ()
  --------------------------------------- }
  if getpwuid(BBsUserID + ID) = NIL then
   begin
     RetriveUserData := FALSE; { returns False if an error occurs }
   end
  else
   begin
    tUser := getpwuid(BBsUserID + ID);
    { -----------------------------
       Read the users bbs database
      ----------------------------- }
    hDirectory := BBSCfg.HomeDir;
    if hDirectory[Length(hDirectory)] = '/' then Directory := hDirectory + StrPas(tUser^.pw_name) + '/' + UserDatabase
     else Directory := hDirectory + '/' + StrPas(tUser^.pw_name) + '/' + UserDatabase;
    Assign(UserDB, Directory);
    {$I-}
    Reset(UserDB);
    fSuccess := IOResult;
    if fSuccess = 0 then
       begin
          UserSize := FileSize(UserDB);
           If UserSize <> 0 then
             begin
               Seek(UserDB, 0);
               Read(UserDB, UserData);
               close(UserDB);
               {$I+}
               RetriveUserData := TRUE;
             end
           else
             begin
               {-------------------
                 Display Error Box
                -------------------}
                cErrorBox('Reading user database');
                RetriveUserData := FALSE;
             end;
          end
      else
         begin
           {-------------------
             Display Error Box
            -------------------}
            cErrorBox('Unable to open user database ' + directory);
            RetriveUserData := FALSE;
         end;
    end;
end;
{ ---------------------------------------------------------------------------
  ---------------------------------------------------------------------------}
function RetriveUsers : integer;
var
  Loop,
  No    : integer;
begin
  No := 1;
  for Loop := BbsUserID + 1 to  BbsUserID + GetUsers do
   begin
     if getpwuid(Loop) <> NIL then
      begin
        tUser := getpwuid(Loop);
        cList[No] := StrPas(tUser^.pw_name);
        inc(No);
      end;
   end;
   RetriveUsers := cListBox(No,'Select User');
end;
{ ---------------------------------------------------------------------------

  ---------------------------------------------------------------------------}
procedure EditUserInfo;
begin
  nNewWindow(User_Win,1,2,80,24);
  nWinColor(User_Win,79);
  nWriteScr(User_Win,3,2,78,'Account Name   : ');
  DataStr := StrPas(tUser^.pw_name);
  nWriteScr(User_Win,20,2,79,DataStr);
  nWriteScr(User_Win,34,2,78,'UID  : ');
  str(UserData.UserUID, DataStr);
  nWriteScr(User_Win,41,2,79,DataStr);
  nWriteScr(User_Win,47,2,78,'Created    : ');
  nWriteScr(User_Win,60,2,79,EpochToString(UserData.UserTime));
  nWriteScr(User_Win,3,3,78,'[F]ull Name    : ');
  nWriteScr(User_Win,20,3,79,UserData.UserNameFull);
  nWriteScr(User_Win,47,3,78,'[B]ulletin : ');
  str(UserData.Bulletin, DataStr);
  nWriteScr(User_Win,60,3,79,DataStr);
  nWriteScr(User_Win,3,4,78,'[E]mail        : ');
  nWriteScr(User_Win,20,4,79,UserData.UserEmail);
  nWriteScr(User_Win,3,5,78,'[L]ocation     : ');
  nWriteScr(User_Win,20,5,79,UserData.UserTown);
  nWriteScr(User_Win,54,5,78,'Calls 24hrs : ');
  str(UserData.CallsToday, DataStr);
  nWriteScr(User_Win,69,5,79,DataStr);
  nWriteScr(User_Win,3,6,78,'Last Called    : ');
  nWriteScr(User_Win,20,6,79,UserData.LastCall);
  nWriteScr(User_Win,54,6,78,'Total Calls : ');
  str(UserData.Calls, DataStr);
  nWriteScr(User_Win,69,6,79,DataStr);
  nWriteScr(User_Win,3,8,78,'[U]ser Level    : ');
  str(UserData.UserLevel, DataStr);
  nWriteScr(User_Win,22,8,79,DataStr);
  nWriteScr(User_Win,3,10,78,'[1] User Info 1 : ');
  nWriteScr(User_Win,22,10,79,UserData.UserInfo1);
  nWriteScr(User_Win,3,11,78,'[2] User Info 2 : ');
  nWriteScr(User_Win,22,11,79,UserData.UserInfo2);
  nWriteScr(User_Win,3,12,78,'[3] User Info 3 : ');
  nWriteScr(User_Win,22,12,79,UserData.UserInfo3);
  nWriteScr(User_Win,3,13,78,'[4] User Info 4 : ');
  nWriteScr(User_Win,22,13,79,UserData.UserInfo4);
  nWriteScr(User_Win,3,14,78,'[5] User Info 5 : ');
  nWriteScr(User_Win,22,14,79,UserData.UserInfo5);
  nWriteScr(User_Win,3,15,78,'[6] User Info 6 : ');
  nWriteScr(User_Win,22,15,79,UserData.UserInfo6);
  nWriteScr(User_Win,3,16,78,'[7] User Info 7 : ');
  nWriteScr(User_Win,22,16,79,UserData.UserInfo7);
  nWriteScr(User_Win,3,17,78,'[8] User Info 8 : ');
  nWriteScr(User_Win,22,17,79,UserData.UserInfo8);
  nWriteScr(User_Win,3,19,78,'Downloads : ');
  str(UserData.Downloads, DataStr);
  nWriteScr(User_Win,15,19,79,DataStr);
  nWriteScr(User_Win,3,20,78,'Bytes     : ');
  str(UserData.BytesDL, DataStr);
  nWriteScr(User_Win,15,20,79,DataStr);
  nWriteScr(User_Win,45,19,78,'Uploads : ');
  str(UserData.Uploads, DataStr);
  nWriteScr(User_Win,55,19,79,DataStr);
  nWriteScr(User_Win,45,20,78,'Bytes   : ');
  str(UserData.BytesUL, DataStr);
  nWriteScr(User_Win,55,20,79,DataStr);
  nWriteScr(User_Win,3,22,79,'Press entry number to edit  [Q] To return to main menu ');
  if fSave then nWrite(User_Win,'[S]ave');
  nFrame(User_Win);
  nRefresh(User_Win);
end;
{ ---------------------------------------------------------------------------}
procedure DisplayUser;
var
  SelectUser : integer;
  Response : integer;
  ValNo,
  CodeData  : integer;
  updateOK  : boolean;
begin
  updateOK := false;
  SelectUser := RetriveUsers;
  if not RetriveUserData(SelectUser) then
   begin
   end
  else
   begin
     fSave := false;
     repeat
       EditUserInfo;
       response := ord(readkey);
       case upcase(chr(response)) of
          'F' : begin
                  UserData.UserNameFull := cEditBox(30,UserData.UserNameFull,'Full Name');
                  fSave := true;
                end;
          'E' : begin
                  UserData.UserEmail := cEditBox(30,UserData.UserEmail,'Email');
                  fSave := true;
                end;
          'L' : begin
                  UserData.UserTown := cEditBox(30,UserData.UserTown,'Location');
                  fSave := true;
                end;
          'U' : begin
                  DataStr := cEditBox(30,'','Access Level');
                  val(DataStr, ValNo, CodeData);
                  if (ValNo < 1) or (ValNo > 9) then
                   begin
                     cErrorBox('Level 1 - 9');
                   end
                  else
                   begin
                     UserData.UserLevel := ValNo;
                     fSave := true;
                   end;
                end;
          'B' : begin
                  UserData.UserTown := cEditBox(30,UserData.UserTown,'');
                  fSave := true;
                end;
          '1' : begin
                  UserData.UserInfo1 := cEditBox(30,UserData.UserInfo1,'Info 1');
                  fSave := true;
                end;
          '2' : begin
                  UserData.UserInfo2 := cEditBox(30,UserData.UserInfo2,'Info 2');
                  fSave := true;
                end;
          '3' : begin
                  UserData.UserInfo3 := cEditBox(30,UserData.UserInfo3,'Info 3');
                  fSave := true;
                end;
          '4' : begin
                  UserData.UserInfo4 := cEditBox(30,UserData.UserInfo4,'Info 4');
                  fSave := true;
                end;
          '5' : begin
                  UserData.UserInfo5 := cEditBox(30,UserData.UserInfo5,'Info 5');
                  fSave := true;
                end;
          '6' : begin
                  UserData.UserInfo6 := cEditBox(30,UserData.UserInfo6,'Info 6');
                  fSave := true;
                end;
          '7' : begin
                  UserData.UserInfo7 := cEditBox(30,UserData.UserInfo7,'Info 7');
                  fSave := true;
                end;
          '8' : begin
                  UserData.UserInfo8 := cEditBox(30,UserData.UserInfo8,'Info 8');
                  fSave := true;
                end;
          'S' : if fSave then SaveUserData;
          'Q' : begin
                  if fSave then
                    begin
                      if cAlertBox('Alert','Save Updates') then
                       begin
                         if SaveUserData then UpdateOK := true
                          else updateOK := false;
                       end
                      else
                       begin
                         updateOK := true;
                       end;
                    end
                  else
                   begin
                     updateOK := true;
                   end;
                end;
       end;
       nDelWindow(User_Win);
     until updateOK;
  end;
end;

end.
