program smt;


uses Linux, Strings, nCrt, User, Files,Forum, DataLib, cWin, BaseUnix;

const
  App =  'Sauron Linux BBS Management Tool [SMT]';
  Version = '0.1.0.1';
  Copyright = '(C) Simon Horton 2008';

var
  w1, w2, w3, w4,
  w5, w6, w7, w8,
  Main_Win          : pwin;

  key               : char;

  test, u  : integer;
  strg : string;

procedure Initialise;
begin
  writeln(App,' version ',Version,' ',Copyright);

  if not ReadINIFiles then
   begin
     writeln('>> Program End.....');
     writeln;
     Halt(2);
   end;
  { -----------------------------------
            Check for NCURSES
    ----------------------------------- }
  if not StartCurses(Main_Win) then
   begin
     writeln;
     writeln('NCURSES Failed To Initialise... [STOP]..');
     halt;
   end;
end;
  { -------------------------
        Setup Main Screen
    ------------------------- }
procedure DisplayMain;
begin
(*
  nClrScr(Main_Win,7);
  nDrawBox(btSingle,16,9,57,16,31);
  FWrite(24,10,30,0,App);
  FWrite(34,11,30,0,'For');
  FWrite(24,12,30,0,'Sauron Linux BBS v0.0.2-2+');
  FWrite(26,13,30,0,Copyright);
  FWrite(28,14,30,0,'smt@sauron.org.uk');
  FWrite(20,15,30,0,'Press Any Key To Continue');
  readkey;
*)
  nClrScr(Main_Win, BLACK);
  nNewWindow(w1,1,1,80,25);
  nWinColor(w1,31);
  nWriteScr(w1,1,1,63,' ' + App);
  nWriteScr(w1,67,1,63,'[Q]uit');
  nWriteScr(w1,1,25,63,' ' + Copyright);
  nWriteScr(w1,58,25,63,'www.sauron.uklinux.net');

  nWriteScr(w1,2,3,31,'Main File Area');
  nWriteScr(w1,4,5,30,'1. Edit Area ');
  nWriteScr(w1,4,6,30,'2. Delete Area ');
  nWriteScr(w1,4,7,30,'3. Add Area ');

  nWriteScr(w1,2,9,31,'Sub File Area');
  nWriteScr(w1,4,11,30,'4. Edit Area ');
  nWriteScr(w1,4,12,30,'5. Delete Area ');
  nWriteScr(w1,4,13,30,'6. Add Area ');

  nWriteScr(w1,2,15,31,'User Files');
  nWriteScr(w1,4,17,30,'7. Edit Users');
  nWriteScr(w1,4,18,30,'8. New Users');
  nWriteScr(w1,4,19,30,'');


  nWriteScr(w1,21,3,31,'Forum Message Area');
  nWriteScr(w1,23,5,30,'A. Edit Forum ');
  nWriteScr(w1,23,6,30,'B. Add Forum ');
  nWriteScr(w1,23,7,30,'C. Delete Forum ');

  nWriteScr(w1,3,21,31,'No. of BBS users       : ');
  nWriteScr(w1,40,21,31,'BBS   : ' + BBSCfg.BBSName);
  nWriteScr(w1,3,22,31,'No. of logged in users : xxxx');
  nWriteScr(w1,40,22,31,'Sysop : ' + BBSCfg.SysopFirst + ' ' + BBSCfg.SysopSec);
  nWriteScr(w1,40,23,31,'Nodes : ');
  nWriteScr(w1,3,23,31,'Current system time    : 00:00:00');

  test := GetUsers;
  Str(test, Strg);
  nWriteScr(w1,28,21,30,Strg);
  Str(BBSCfg.BBSNodes, Strg);
  nWriteScr(w1,48,23,30,Strg);
  nRefresh(w1);

end;
var
 GoodBye,
 notRoot  : boolean;
 response : integer;
begin
  { ------------------------
         Start Program
    ------------------------ }
  Initialise;
  Goodbye := false;
  repeat
    DisplayMain;
    if not notRoot then
      begin
        if fpgetuid <> 0 then
         begin
           cErrorBox('It is recommanded to run this program as root..');
           nRefresh(w1);
           notRoot := true;
         end
        else notRoot := true;
      end;
    response := ord(readkey);
    case upcase(chr(response)) of
      '1' : EditAreas;
      '2' : DeleteFileArea;
      '3' : AddFileArea;
      '4' : EditSubArea;
      '5' : DeleteSubFileArea;
      '6' : AddSubFileArea;
      '7' : DisplayUser;
      '8' : DeleteNewUser;
      'A' : EditForum;
      'B' : AddForum;
      'C' : DeleteForum;
      'Y' : ListDeleteFiles;
      'Z' : DeleteAllFiles;
      'Q' : begin
              if cAlertBox('EXIT SMT', 'Are you sure you want to exit ?') then GoodBye := true;
            end;
    end;
   nRefresh(w1);
   nDelWindow(w1);
  until GoodBye;
  EndCurses;
end.
