(* ........................................................................ *)
(*        								    *)
(* PROGRAM	:   SADDUSER.PP (Sauron Add User)	                    *)
(*									    *)
(* DESCRIPTION	:   Adds New Users to Linux System                          *)
(*									    *)
(* ENVIRONMENT  :   PPC386 PASCAL Ver 0.99.5 LINUX KERNEL 2.2.30+           *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1999 - 2000                                *)
(*									    *)
(* LICENSE	:   GPL (See COPYING.DOC for more information)              *)
(*                                                                          *)
(* VERSION      :   0.0.32                                                  *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* History.Linux                                                            *)
(*..........................................................................*)
Program SaddUser;

uses Dos, Crt, Strings, Linux, Data, INI, Errorlog, Dates, Directory, Creation,
     FileCopy;

(*..........................................................................*)
procedure Stop_Program(Buffer : string);
begin
  if Output_Verbose then
   begin
     writeln('>> ', Buffer);
     writeln('>> Program End..');
     writeln;
   end;  
  Halt(1);
end;
(*..........................................................................*)
procedure Start_System(Config_File : string);
var
  Code_Data   : integer;
begin
  Success := 0;
  { Check for CONFIG file }
  if Output_Verbose then writeln('> Checking for ini configuration file..');
  if not FileExist(Config_file + '.ini') then
   begin
    {$IFDEF _DEBUG_}
      writeln(' [DEBUG] Check for INI file : [',Config_File, '.ini] Errors = [', ErrorString(DosError), ']'); 
    {$ENDIF}  
    if not Display_Users then Stop_Program('Configuration file missing.. ' + Config_File + '.ini');
   end;
  {$IFDEF _DEBUG_}
    writeln(' [DEBUG] Check for INI file : [',Config_File, '.ini] Errors = [', ErrorString(DosError), ']'); 
  {$ENDIF}  
  { Read CONFIG FILE }
  if Output_Verbose then writeln('> Reading configuration file..');  
  Success := GetProfile(Config_File, 'CONFIG' , 'BBS_FILES', Config.bbs_files, '/usr/local/sauron/');
  Success := GetProfile(Config_File, 'CONFIG' , 'NEW_USER_FILES', Config.new_user_files, '/usr/local/sauron/newuser');
  Success := GetProfile(Config_File, 'CONFIG' , 'LOG_FILE_LOCATION', Config.log_file_location, '/usr/local/sauron/');
  Success := GetProfile(Config_File, 'CONFIG' , 'LOG_FILE_NAME', Config.log_file_name, 'user.log');
    
  Success := GetProfile(Config_File, 'CONFIG' , 'SHADOW_TOKEN', Shadowtoken, '*');
  Success := GetProfile(Config_File, 'CONFIG' , 'PASSWD_FILE', PasswdFile, '/etc/passwd');
  Success := GetProfile(Config_File, 'CONFIG' , 'SHADOW_FILE', ShadowFile, '/etc/shadow');
  Success := GetProfile(Config_File, 'CONFIG' , 'SKEL_DIR', SkelDir, '/etc/skel');
  Success := GetProfile(Config_File, 'CONFIG' , 'MAIL_DIR', MailDir, '/var/spool/mail');
  Success := GetProfile(Config_File, 'CONFIG' , 'SHELL', DefaultShell, '/usr/local/sauron/sauron.sh');
  Success := GetProfile(Config_File, 'CONFIG' , 'HOME_DIR', HomeDir, '/local/home');
  Success := GetProfile(Config_File, 'CONFIG' , 'HOME_DIR_PERMS', Data_String, '0775');
  val(Data_String, HomeDirPerms, Code_Data);
  Success := GetProfile(Config_File, 'CONFIG' , 'USERGRP', Data_String, '500');
  val(Data_String, UserGrp, Code_Data);
  Success := GetProfile(Config_File, 'CONFIG' , 'USER', Data_String, '1000');
  val(Data_String, UserNo, Code_Data);
   Success := GetProfile(Config_File, 'CONFIG' , 'MAIL_GRP', Data_String, '12');
  val(Data_String, MailGrp, Code_Data);
  DisposeINICollection;
  {$IFDEF _DEBUG_}
     writeln(' [DEBUG] bbs_files         = [', Config.bbs_files,']');
     writeln(' [DEBUG] new_user_files    = [', Config.new_user_files,']');
     writeln(' [DEBUG] log_file_location = [', Config.log_file_location,']');
     writeln(' [DEBUG] log_file_name     = [', Config.log_file_name,']');  
     
     writeln(' [DEBUG] ShadowToken       = [', ShadowToken,']');  
     writeln(' [DEBUG] PasswdFile        = [', PasswdFile,']');       
     writeln(' [DEBUG] ShadowFile        = [', ShadowFile,']');  
     writeln(' [DEBUG] DefaultShell      = [', DefaultShell,']');  
     writeln(' [DEBUG] HomeDir		 = [', HomeDir,']');
     writeln(' [DEBUG] SkelDir		 = [', SkelDir,']');
     writeln(' [DEBUG] MailDir		 = [', MailDir,']');
     writeln(' [DEBUG] HomePerms         = [', HomeDirPerms,']');
     writeln(' [DEBUG] UserGrp           = [', UserGrp,']');
     writeln(' [DEBUG] User ID           = [', User,']');
     writeln(' [DEBUG] MailGrp           = [', MailGrp,']');  
  {$ENDIF}
  if Success <= 0 then
   begin
     writeln('>> Error reading ini configuration file..(',Success,')');
     writeln('>> Program End..');
     Halt(1);
   end;
  { Check directories }
  if Output_Verbose then writeln('> Checking file paths..');  
  if not Display_Users then
   begin
    Check_Directory(Config.bbs_files);
    Check_Directory(Config.new_user_files);
    Check_Directory(Config.log_file_location);
    Check_Directory(HomeDir);
    Check_Directory(SkelDir);
    Check_Directory(MailDir);
   end;
  { Check for Log File }
  if not Check_For_Log then LogError('LOG FILE CREATED ');
  LogError('*************************************************************'); 
  { Check for required files }
  if Output_Verbose then writeln('> Checking for required files...');  
  {$IFDEF _DEBUG_}
    writeln(' [DEBUG] Checking for passwd file [', PasswdFile,']'); 
  {$ENDIF}  
  if not FileExist(PasswdFile) then
   begin
    LogError('Password file missing ' + PasswdFile + ' - Program Stopped'); 
    Stop_Program('Password file missing.. ' + PasswdFile );
   end;
  {$IFDEF _DEBUG_}
    writeln(' [DEBUG] Checking for shadow file [', ShadowFile,']'); 
  {$ENDIF}  
  if not FileExist(ShadowFile) then
   begin
    LogError('Shadow file missing ' + ShadowFile);
    LogError('Adding encrypted password in ' + PasswdFile);
    NoShadowFile := TRUE;
   end; 
  {$IFDEF _DEBUG_}
     writeln(' [DEBUG] Checking for Default Shell [', DefaultShell,']'); 
  {$ENDIF}  
  if not FileExist(DefaultShell) then
   begin
     LogError('Shell file missing ' + DefaultShell + ' - Program Stopped'); 
     if not Display_Users then Stop_Program('Shell file missing.. ' + DefaultShell );
   end; 
  Data_String := Config.new_user_files;
  if Data_String[Length(Data_String)] = '/' then
    Data_String := Data_String + 'adduser.dat'
  else Data_String := Data_String + '/' + 'adduser.dat';  
  {$IFDEF _DEBUG_}
    writeln(' [DEBUG] Checking for user creation database [', Data_String, ']'); 
  {$ENDIF}  
  if not FileExist(Data_String) then
   begin
     LogError('No users to create... User creation database not found [' + Data_String + ']');
     Stop_Program('No users to create..');
   end; 
end;
(*..........................................................................*)
{ Main Program}
var
  Creation_No,
  Creation_Count : integer;
  New_User,
  Paramms	 : PChar;
  Params	 : Param;
  DelFile        : text;
begin
   if (Paramcount = 0) or (Paramstr(1) = '--help')  then
    begin
      ClrScr;
      writeln(Title,' Version ', Version, ' ', Copyright);
      writeln(License);
      writeln(WebSite);
      writeln;
      writeln('Usage : sadduser <options> [ini file]');
      writeln;
      writeln('Options - ');
      writeln;
      writeln('  --users                Display list of users waiting creation');
      writeln('  --verbose              Explain whats being done');
      writeln('  --nolog                Do not write to log file *disabled*');
      writeln('  --help                 This screen');
      writeln;
      writeln('INI file - ');
      writeln;
      writeln('Name of configuration file needed by sadduser, the configuration file needs the');
      writeln('extension of <.ini> but is not need on the command line. ');
      writeln;
      writeln('Example: sadduser -verbose sadduser');
      writeln;
      writeln('Please read the MANUAL.DOC for information on using sadduser.');
      writeln('Email: simon.horton@earthling.net with questions or bug reports.');
      writeln;
      Halt(0);    
    end
   else
    begin
      NoShadowFile := FALSE;
      Output_Verbose := FALSE;
      Display_Users := FALSE;
      { Get command line params }
      for Loop := 1 to paramcount do
       begin
         if paramstr(Loop) = '--verbose' then Output_Verbose := TRUE
          else if paramstr(Loop) = '--nolog' then S1 := ''
           else if paramstr(Loop) = '--help' then S1 := ''
            else if paramstr(Loop) = '--users' then Display_Users := TRUE
             else Params.inifile := paramstr(Loop);
       end;  
      {$IFDEF _DEBUG_}
        clrscr;
        writeln(Title,' Version ', Version, ' ', Copyright);
        writeln('DEBUG MODE   = ON');
        writeln('VERBOSE MODE = ON');
        writeln;
        Output_Verbose := TRUE;
      {$ELSE} 
        if Output_Verbose then 
         begin 
          writeln(Title, ' Version ', Version,' ', Copyright);
          writeln;
         end; 
      {$ENDIF} 
      { Ensure user is root }
      if getuid <> 0 then 
        begin
          Stop_Program('You must be root to run this program..');
        end;	
      { Intaililise software }
      Start_System(params.inifile);  
      { Get number of users to create }
      Creation_No := Get_User_Size;
      case Creation_No of
            -1:  begin
                 Stop_Program('Error whilst reading user creation database (' + AddUserdb + ')');
                 LogError('Error whilst reading user creation database (' + AddUserdb + ').. Stopping');
                 end;
             0:  begin
                 Stop_Program('No users to create..');
                 LogError('No users to create.. Stoppping');
                 end;         
      end; { Case end }
      {$IFDEF _DEBUG_}
        writeln(' [DEBUG] Number of users to create = [', Creation_No,']');
      {$ENDIF}  
      for Loop := 0 to Creation_No - 1 do
       begin 
         if not Get_User_Info(Loop) then
          begin
          end
         else
          begin
            if not Display_Users then
             begin
              New_User := StrAlloc(Length(User_Data.User_Name) + 1);
              StrPCopy(New_User, User_Data.User_Name);
              if Check_For_Existing_User(New_User) then
               begin
                Create_User;
                inc(Creation_Count);
               end;
             end
            else
             begin
               { Displaying users waiting for creation }
               writeln('Username : ', User_Data.User_Name);
             end;
          end;  
       end;  
    end;
   if not Display_Users then
    begin
      Success := Copy_File(Config.new_user_files, Config.new_user_files, AddUserdb, TRUE);
      LogError('Backed up database to adduser.' + MyTime);
      {$IFDEF _DEBUG_}
         writeln(' [DEBUG] Backed up database to adduser.', MyTime,' [', Success,']');
      {$ENDIF}
      { Add data deletion }
      {$I-}
        assign(DelFile,Data_String);
        close(DelFile);
        erase(DelFile);
      {$I+}
    end;
   Str(Creation_No, S1);
   Str(Creation_Count, S2);
   LogError('Number of Users to create (' + S1 + '), Actual users created (' + S2 + ')');
   if Output_Verbose then writeln('> Number of Users to create (', S1,'), Actual users created (', S2,')');
   if Output_Verbose then writeln; 
end.
