unit forum;

interface

uses Linux, Dos, Strings, nCrt, cWin, DataLib, lib, baseunix, SysUtils, Unix;

procedure EditForum;
function AddForum : boolean;
function DeleteForum : boolean;

implementation

var
   DataStr,
   ForDB       : string;
   Forum_Win   : pWin;
   Code,
   fSuccess,
   AreaSize,
   Loop,
   ListNo      : integer;
   fSave       : boolean;

function SelectForum : integer;
begin
  ListNo := 1;
  { -------------------------------
     Read the Forum  database
   -------------------------------- }
  if BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then ForDB := BBSCfg.DataDir + ForumDatabase
    else ForDB := BBSCfg.DataDir + '/' + ForumDatabase;
  Assign(ForumDB, ForDB);
  {$I-}
  Reset(ForumDB);
  fSuccess := IOResult;
  if fSuccess = 0 then
   begin
     AreaSize := FileSize(ForumDB);
     if AreaSize <> 0 then
      begin
        for Loop := 0 to (AreaSize -1) do
         begin
           seek(ForumDB, Loop);
           read(ForumDB, ForumData);
           if IOResult = 0 then
            begin
              cList[ListNo] := ForumData.AreaName;
              inc(ListNo);
            end;
         end;
        SelectForum := cListBox(ListNo,'Select Forum To Edit');
        seek(ForumDB, (SelectForum - 1));
        read(ForumDB, ForumData);
        if IOResult <> 0 then
         begin
           cErrorBox('Reading Forum Info');
           SelectForum := 0;
         end;
      end
     else
      begin
        cErrorBox('There are No Forums');
        SelectForum := 0;
      end;
   end
  else
   begin
     cErrorBox('Reading Forum DB');
     SelectForum := 0;
   end;
   Close(ForumDB);
   {$I+}
end;
{ ---------------------------------------------------------------------------
--------------------------------------------------------------------------}
function DeleteForum : boolean;
var
 ForumDel : integer;
 ForumDir : string;
begin
  ForumDel := SelectForum;
  if ForumDel <> 0 then
   begin
     if BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then ForDB := BBSCfg.DataDir + ForumDatabase
      else ForDB := BBSCfg.DataDir + '/' + ForumDatabase;
     Assign(ForumDB, ForDB);
     {$I-}
     Reset(ForumDB);
     fSuccess := IOResult;
     if fSuccess = 0 then
      begin
        if FileSize(ForumDB) = 1 then
         begin
           if not cAlertBox('WARNING','Are you sure you want to delete the last forum?') then
            begin
              close(ForumDB);
              DeleteForum := false;
              {$I+}
              exit;
            end;
         end;
        if not cAlertBox('WARNING','Deleting the Forum will remove all the  posts - continue') then
         begin
           close(ForumDB);
           DeleteForum := false;
           {$I+}
           exit
         end;
        { ------------------------
          Read the forum to delete
          ------------------------ }
        seek(ForumDB, (ForumDel - 1));
        read(ForumDB, ForumData);
        AreaSize := FileSize(ForumDB);
        if AreaSize > 1 then
         begin
           { -------------------------------
            Move all records down 1 place
           ------------------------------- }
           for Loop := ForumDel to (AreaSize - 1) do
            begin
              seek(ForumDB, Loop);
              read(ForumDB, ForumData);
              seek(ForumDB, (Loop - 1));
              write(ForumDB, ForumData);
            end;
         end;
        { -------------------------------
            Delete Last Record
          ------------------------------- }
        seek(ForumDB,(AreaSize - 1));
        truncate(ForumDB);
        if IOResult = 0 then
         begin
           {  -----------------------------------------
              Remove all the posts and the forum folder
              ----------------------------------------- }
           str(ForumDel, DataStr);
           if BBSCfg.MsgDir[Length(BBSCfg.MsgDir)] = '/' then ForumDir := BBSCfg.MsgDir + DataStr
             else ForumDir := BBSCfg.MsgDir + '/' + DataStr;
           if shell('rm -Rf ' + ForumDir) <> 0 then
            begin
              cErrorBox('Removing Forum Folder ' + ForumDir);
              DeleteForum := false;
            end
           else
            begin
              { -----------------------------------
                if last forum remove all data files
                ----------------------------------- }
              if AreaSize = 1 then
                begin
                  if BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then ForumDir := BBSCfg.DataDir
                    else ForumDir := BBSCfg.DataDir + '/';
                  if shell('rm -f ' + ForumDir + ForumDatabase)  <> 0 then cErrorBox('Deleting - ' + ForumDatabase);
                  if shell('rm -f ' + ForumDir + MsgIndex) <> 0 then cErrorBox('Deleting - ' + MsgIndex);
                end;
              cSuccessBox('Forum Deleted');
              DeleteForum := true;
            end;
         end
        else
         begin
           cErrorBox('Deleting Forum');
           DeleteForum := false;
         end;
      end
     else
      begin
        cErrorBox('Delete: Reading - ' + ForDB);
        DeleteForum := false;
      end;
   end;
   close(ForumDB);
   {$I+}
end;
{ ---------------------------------------------------------------------------
--------------------------------------------------------------------------}
function SaveForum(ForumNo : integer) : boolean;
begin
  { -------------------------------
    Read the Forum  database
  -------------------------------- }
  if BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then ForDB := BBSCfg.DataDir + ForumDatabase
    else ForDB := BBSCfg.DataDir + '/' + ForumDatabase;
   Assign(ForumDB, ForDB);
  {$I-}
  Reset(ForumDB);
  fSuccess := IOResult;
  if fSuccess = 0 then
   begin
    seek(ForumDB, (ForumNo - 1));
    write(ForumDB, ForumData);
    if IOResult = 0 then
     begin
       cSuccessBox('Forum Data Saved');
       SaveForum := true;
     end
    else
     begin
       cErrorBox('Saving Data');
       SaveForum := false;
     end;
   end
  else
   begin
     cErrorBox('Saving Data');
     SaveForum := false;
     exit;
   end;
  Close(ForumDB);
 {$I+}
end;
{ ---------------------------------------------------------------------------
--------------------------------------------------------------------------}
function AddForum : boolean;
var
  ForumDir,
  MsIdx   : string;
begin
  ForumData.AreaName := cEditBox(30,'','Forum Description');
  if not cAlertBox('Confirm','Add Forum') then exit;
  { -------------------------------
    Read the Forum  database
   -------------------------------- }
  if BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then ForDB := BBSCfg.DataDir + ForumDatabase
    else ForDB := BBSCfg.DataDir + '/' + ForumDatabase;
   Assign(ForumDB, ForDB);
  {$I-}
   { -----------------
     Does the DB Exist
   ------------------- }
   if not FileExists(ForDB) then
    begin
      { -------------------------------------
        No Forum DB, So lets create a new one
        ------------------------------------- }
     rewrite(ForumDB);
     if IOResult <> 0 then
      begin
        cErrorBox('Creating ' + ForDB);
        AddForum := false;
        exit;
      end
     else
      begin
       if fpChmod (ForDB,&666) <> 0 then cErrorBox('chmod 666 ' +  ForDB);
       if fpChown (ForDB,BBSCfg.SysopUID,Config.UserGrp)  <> 0 then cErrorBox('chown SYSOP:BBS ' +  ForDB);
       { --------------------------------
         if Forum DB needs to be created
         then MSINDEX.DAT will need to be
         created also
         -------------------------------- }
       if BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then MsIdx := BBSCfg.DataDir + MsgIndex
        else MsIdx := BBSCfg.DataDir + '/' + MsgIndex;
       if not FileExists(MsIdx) then
        begin
          assign(MsgIdxDB, MsIdx);
          {$I-}
           rewrite(MsgIdxDB);
           if IOResult <> 0 then
            begin
              cErrorBox('Creating ' + MsIdx);
              AddForum := False;
              exit;
            end
           else
            begin
              if fpChmod (MsIdx,&666) <> 0 then cErrorBox('chmod 666 ' +  MsIdx);
              if fpChown (MsIdx,BBSCfg.SysopUID,Config.UserGrp)  <> 0 then cErrorBox('chown SYSOP:BBS ' +  MsIdx);
              close(MsgIdxDB);
              {$I+}
            end;
        end;
      end;
    end;
  reset(ForumDB);
  fSuccess := IOResult;
  if fSuccess = 0 then
   begin
     AreaSize := FileSize(ForumDB);
     Str((AreaSize + 1), ForumData.MsgNumber);
     seek(ForumDB, AreaSize);
     write(ForumDB, ForumData);
     if IOResult = 0 then
      begin
        close(ForumDB);
        AddForum := True;
       { ----------------------
         Create the Posr Folder
         ---------------------- }
       if BBSCfg.MsgDir[Length(BBSCfg.DataDir)] = '/' then ForumDir := BBSCfg.MsgDir + ForumData.MsgNumber
         else ForumDir := BBSCfg.MsgDir + '/' + ForumData.MsgNumber;
       if FpMkdir(ForumDir,&777) <> 0 then
        begin
          cErrorBox('Creating Forum Post Folder ' + ForumDir);
        end
       else
        begin
          if fpChmod (ForumDir,&777) <> 0 then cErrorBox('chmod 666 ' +  ForumDir);
          if fpChown (ForumDir,BBSCfg.SysopUID,Config.UserGrp)  <> 0 then cErrorBox('chown SYSOP:BBS ' +  ForumDir);
        end;
       cSuccessBox('Forum Created');
      end
     else
      begin
        cErrorBox('Saving ' + ForDB);
        AddForum := False;
      end;
   end
  else
   begin
     cErrorBox('Opening ' + ForDB);
     AddForum := False;
   end;
  {$I+}
end;
{ ---------------------------------------------------------------------------
--------------------------------------------------------------------------}
procedure DisplayForum;
begin
  nNewWindow(Forum_Win,1,8,80,14);
  nWinColor(Forum_Win,30);
  nWriteScr(Forum_Win,3,2,31,'Forum [N]umber : ');
  nWriteScr(Forum_Win,20,2,30,ForumData.MsgNumber);
  nWriteScr(Forum_Win,3,4,31,'[F]orum : ');
  nWriteScr(Forum_Win,13,4,30,ForumData.AreaName);
  nWriteScr(Forum_Win,55,4,31,'Posts : ');
  nWriteScr(Forum_Win,3,6,31,'Press entry number to edit  [Q] To return to main menu ');
  if fSave then nWrite(Forum_Win,'[S]ave');
  nFrame(Forum_Win);
  nRefresh(Forum_Win);
end;

procedure EditForum;
var
 response,
 fArea    : integer;
 updateOK : boolean;
begin
  updateOK := false;
  fArea := SelectForum;
  if fArea <> 0 then
   begin
     fsave := false;
     repeat
       DisplayForum;
       response := ord(readkey);
       case upcase(chr(response)) of
        'N' : begin
                if cAlertBox('CAUTION','Changing this number is not a good idea, Continue') then
                 begin
                   ForumData.MsgNumber := cEditBox(30,ForumData.MsgNumber,'Forum Number');
                   fsave := true;
                 end;
              end;

       'F' : begin
               ForumData.AreaName := cEditBox(30,ForumData.AreaName,'Forum Description');
               fSave := true;
             end;
       'S' : if SaveForum(fArea) then fSave := false;
       'Q' : begin
                if fSave then
                  begin
                    if cAlertBox('Alert','Save Updates') then
                     begin
                       if SaveForum(fArea) then UpdateOK := true
                          else updateOK := false;
                     end
                    else
                     begin
                       updateOK := true;
                     end;
                  end
                else
                 begin
                   updateOK := true;
                 end;
              end;

       end;
       nDelWindow(Forum_Win);
     until UpdateOK;
   end;
end;

end.
