unit files;

interface

uses Linux, Dos, Strings, Crt, nCrt, cWin, DataLib, lib, BaseUnix, SysUtils, unix;

function deleteallfiles : boolean;
function listdeletefiles : integer;
procedure EditAreas;
procedure EditSubArea;
procedure DeleteFileArea;
procedure DeleteSubFileArea;
function AddFileArea: boolean;
function AddSubFileArea: boolean;

implementation

var
   DataStr   : string;
   File_Win  : pWin;
   Code,
   fSuccess  : integer;
   fSave     : boolean;

{ ---------------------------------------------------------------------------
             Removes all files tagged for deletion
  ------------------------------------------------------------------------}
function listdeletefiles : integer;
var
  FileDeleteDB : string;
  Loop, No     : integer;
begin
  { -----------------------
    Open File Deletaion DB
    ----------------------- }
  if BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then FileDeleteDB := BBSCfg.DataDir + FileDeletion
    else FileDeleteDB := BBSCfg.DataDir + '/' + FileDeletion;
  if not FileExists(FileDeleteDB) then
   begin
     cErrorBox('There are no files waiting removal');
     ListDeleteFiles := 0;
     exit;
   end
  else
   begin
     assign(FileRDB, FileDeleteDB);
     {$I-}
     reset(FileRDB);
     fSuccess := IOResult;
     if fSuccess <> 0 then
      begin
        cErrorBox('Reading - ' + FileDeleteDB);
      end
     else
      begin
        No := 1;
        for Loop := 0 to (FileSize(FileRDB) - 1) do
         begin
           seek(FileRDB, Loop);
           read(FileRDB, FileRData);
           d1list[No] := FileRData.FilePath;
           d2list[No] := '';
           d3list[No] := '';
           inc(No);
         end;
         close(FileRDB);
         ListDeleteFiles := dListBox(No,'Files to be removed','[ENTER] Exit');
         {$I+}
      end;
   end;
end;
{ ---------------------------------------------------------------------------
             Removes all files tagged for deletion
--------------------------------------------------------------------------}
function deleteallfiles : boolean;
var
 FileDeleteDB,
 FileList     : string;
 NoFiles,
 Loop, Floop  : integer;
begin
  { -----------------------
    Open File Deletaion DB
    ----------------------- }
  if BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then FileDeleteDB := BBSCfg.DataDir + FileDeletion
    else FileDeleteDB := BBSCfg.DataDir + '/' + FileDeletion;
  { ----------------------------------------------
     Lets see if we have a file deletion database
    ---------------------------------------------- }
  if FileExists(FileDeleteDB) then
   begin
     if not cAlertBox('CONFIRM','Delete all tagged files') then exit;
     assign(FileRDB, FileDeleteDB);
     {$I-}
     reset(FileRDB);
     fSuccess := IOResult;
     if fSuccess = 0 then
      begin
        NoFiles := filesize(FileRDB);
        { ------------------
           Remove all files
          ------------------ }
        for Loop := 0 to (NoFiles - 1) do
         begin
           seek(FileRDB, Loop);
           read(FileRDB, FileRData);
           { -------------------
              Open the file list
             ------------------- }
           assign(FileIDB, FileRData.FileLst);
           reset(FileIDB);
           if IOResult = 0 then
            begin
              if filesize(FileIDB) <> 1 then
               begin
                 { -------------------------------
                   Move all records down 1 place
                  ------------------------------- }
                  for FLoop := FileRData.FileID to (FileSize(FileIDB) - 1) do
                    begin
                      seek(FileIDB, Loop);
                      read(FileIDB, FileIData);
                      seek(FileIDB, (Loop - 1));
                      write(FileIDB, FileIData);
                    end;
               end;
              { -------------------------------
                Delete Last Record
               ------------------------------- }
              seek(FileIDB,(FileSize(FileIDB) - 1));
              truncate(FileIDB);
              { -----------------------
                 Remove file from REPO
                ----------------------- }
              if shell('rm -f ' + FileRData.FilePath)  <> 0 then cErrorBox('Deleting - ' + FileRData.FilePath);
            end
           else
            begin
              cErrorBox('Opening File List DB - ' + FileRData.FileLst);
              close(FileRDB);
              {$I+}
              exit;
            end;
           close(FileIDB);
         end;
        close(FileRDB);
        {$I+}
        cSuccessBox('Files Removed');
      end
     else
      begin
        cErrorBox('Error opening - ' + FileDeleteDB);
      end;
   end
  else
   begin
     cErrorBox('There are no files to remove');
   end;
end;
{ ---------------------------------------------------------------------------
--------------------------------------------------------------------------}
function SelectSubFileArea : integer;
var
 FileDB : string;
 AreaSize,
 Loop,
 No     : integer;
begin
  No := 1;
  { -------------------------------
     Read the File Areas  database
   -------------------------------- }
  if BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then FileDB := BBSCfg.DataDir + SubFileArea + '.' + AreaData.AreaNumber
    else FileDB := BBSCfg.DataDir + '/' + SubFileArea + '.' + AreaData.AreaNumber;
  Assign(SubDB, FileDB);
  {$I-}
  Reset(SubDB);
  fSuccess := IOResult;
  if fSuccess = 0 then
   begin
     AreaSize := FileSize(SubDB);
     if AreaSize <> 0 then
      begin
        for Loop := 0 to (AreaSize - 1) do
         begin
           seek(SubDB, Loop);
           read(SubDB, SubData);
           cList[No] := SubData.DirDes;
           inc(No);
         end;
        SelectSubFileArea := cListBox(No,'Select Sub Area');
        seek(SubDB, (SelectSubFileArea - 1));
        read(SubDB, SubData);
        if IOResult <> 0 then
         begin
           cErrorBox('Reading Sub Area Info');
           SelectSubFileArea := 0;
         end;
      end
     else
      begin
        Close(SubDB);
        {$I+}
        SelectSubFileArea := 0;
        exit;
      end;
   end
 else
   begin
     SelectSubFileArea := 0;
     exit;
   end;
 Close(SubDB);
 {$I+}
end;
{ ---------------------------------------------------------------------------
--------------------------------------------------------------------------}
function SelectFileArea : integer;
var
 FileDB : string;
 AreaSize,
 Loop,
 No     : integer;
begin
  No := 1;
  { -------------------------------
     Read the File Areas  database
   -------------------------------- }
  if BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then FileDB := BBSCfg.DataDir + FileAreas
    else FileDB := BBSCfg.DataDir + '/' + FileAreas;
  Assign(AreaDB, FileDB);
  {$I-}
  Reset(AreaDB);
  fSuccess := IOResult;
  if fSuccess = 0 then
   begin
     AreaSize := FileSize(AreaDB);
     if AreaSize <> 0 then
      begin
        for Loop := 0 to (AreaSize - 1) do
         begin
           seek(AreaDB, Loop);
           read(AreaDB, AreaData);
           cList[No] := AreaData.Description;
           inc(No);
         end;
        SelectFileArea := cListBox(No,'Select File Area');
        seek(AreaDB, (SelectFileArea - 1));
        read(AreaDB, AreaData);
        if IOResult <> 0 then
         begin
           cErrorBox('Reading Area Info');
           SelectFileArea := 0;
         end;
      end
     else
      begin
        Close(AreaDB);
        {$I+}
        SelectFileArea := 0;
        exit;
      end;
   end
 else
   begin
     SelectFileArea := 0;
     exit;
   end;
 Close(AreaDB);
 {$I+}
end;
{ ---------------------------------------------------------------------------
--------------------------------------------------------------------------}
procedure DeleteSubFileArea;
var
 SubDel : SubAreas;
 FileDB : string;
 sArea,
 AreaSize,
 Loop   : integer;
begin
  if SelectFileArea = 0 then exit;
  sArea := SelectSubFileArea;
  if sArea = 0 then
    begin
      cErrorBox('No Sub Areas');
      exit;
    end;
  if not cAlertBox('Confirm','Erase File Area') then exit;
  { -------------------------------
     Read the File Areas  database
   -------------------------------- }
  if BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then FileDB := BBSCfg.DataDir + SubFileArea + '.' + AreaData.AreaNumber
    else FileDB := BBSCfg.DataDir + '/' + SubFileArea + '.' + AreaData.AreaNumber;
  Assign(SubDB, FileDB);
  {$I-}
  Reset(SubDB);
  fSuccess := IOResult;
  if fSuccess = 0 then
   begin
     AreaSize := FileSize(SubDB);
        { -------------------------------
           Read the Sub Area to Erase
          ------------------------------- }
        seek(SubDB, (sArea - 1));
        read(SubDB, SubDel);
        if AreaSize > 1 then
         begin
           { -------------------------------
            Move all records down 1 place
           ------------------------------- }
           for Loop := sArea to (AreaSize - 1) do
            begin
              seek(SubDB, Loop);
              read(SubDB, SubData);
              seek(SubDB, (Loop - 1));
              write(SubDB, SubData);
            end;
         end;
         { -------------------------------
            Delete Last Record
           ------------------------------- }
         seek(SubDB,(AreaSize - 1));
         truncate(SubDB);
         if IOResult = 0 then
           begin
             Close(SubDB);
             { -------------------------------
                Delete List File for Sub Area
              ------------------------------- }
             if FileExists(SubDel.FileLst) then
              begin
                assign(SubDB, SubDel.FileLst);
                erase(SubDB);
                if IOResult <> 0 then cErrorBox('Unable to remove ' + FileDB);
              end;
             cSuccessBox('Sub Area Deleted');
           end
          else
       begin
        cErrorBox('Erasing Sub Area');
        Close(SubDB);
      end;
   end
 else
   begin
     cErrorBox('Opening ' + FileDB);
     exit;
   end;
 {$I+}
end;
{ ---------------------------------------------------------------------------
--------------------------------------------------------------------------}
procedure DeleteFileArea;
var
 AreaDel : Area;
 SubDel  : file of SubAreas;
 FileDB,
 DelDB   : string;
 sArea,
 AreaSize,
 Loop    : integer;
begin
  sArea := SelectFileArea;
  if sArea = 0 then exit;
  if not cAlertBox('Confirm','Erase File Area') then exit;
  { -------------------------------
     Read the File Areas  database
   -------------------------------- }
  if BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then FileDB := BBSCfg.DataDir + FileAreas
    else FileDB := BBSCfg.DataDir + '/' + FileAreas;
  Assign(AreaDB, FileDB);
  {$I-}
  Reset(AreaDB);
  fSuccess := IOResult;
  if fSuccess = 0 then
   begin
     AreaSize := FileSize(AreaDB);
     { -------------------------------
        If there is only One Area exit
       ------------------------------- }
     if AreaSize = 1 then
      begin
        cErrorBox('Only 1 File Area');
      end
     else
      begin
        { -------------------------------
           Read the  Area to Erase
        ------------------------------- }
        seek(AreaDB, (sArea - 1));
        read(AreaDB, AreaDel);
        if BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then DelDB:= BBSCfg.DataDir + SubFileArea + '.' + AreaDel.AreaNumber
          else DelDB := BBSCfg.DataDir + '/' + SubFileArea + '.' + AreaDel.AreaNumber;
        assign(SubDel, DelDB);
        reset(SubDel);
        if FileSize(SubDel) <> 0 then
          begin
            cErrorBox('Area Still Contains Sub File Areas');
            close(SubDB);
            close(AreaDB);
            exit;
          end;
        close(SubDel);
        { -------------------------------
           Move all records down 1 place
          ------------------------------- }
        for Loop := sArea to (AreaSize - 1) do
         begin
           seek(AreaDB, Loop);
           read(AreaDB, AreaData);
           seek(AreaDB, (Loop - 1));
           write(AreaDB, AreaData);
         end;
         { -------------------------------
            Delete Last Record
           ------------------------------- }
         seek(AreaDB,(AreaSize - 1));
         truncate(AreaDB);
         if IOResult = 0 then
           begin
             Close(AreaDB);
             { ------------------------------
                Remove Area.<no>
              ------------------------------ }
             assign(SubDel, DelDB);
             erase(SubDel);
             if IOResult <> 0 then cErrorBox('Unable to remove ' + FileDB);
             cSuccessBox('Area Deleted');
             Close(AreaDB);
           end
          else
           begin
            cSuccessBox('Area Deleted');
            Close(AreaDB);
           end;
      end;
   end
 else
   begin
     cErrorBox('Opening AREAS.DAT');
     exit;
   end;
 {$I+}
end;
{ ---------------------------------------------------------------------------
--------------------------------------------------------------------------}
function AddFileArea: boolean;
var
 FileDB,
 StrData  : string;
 AreaSize : integer;
begin
  AreaData.Description := cEditBox(30,'','Area Description');
  if not cAlertBox('Confirm','Add File Area') then exit;
  AreaData.OpenClosed := true;
  AreaData.FileNumber := 0;
  AreaData.CatNumber  := 0;
  { -------------------------------
     Read the File Areas  database
   -------------------------------- }
  if BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then FileDB := BBSCfg.DataDir + FileAreas
    else FileDB := BBSCfg.DataDir + '/' + FileAreas;
  { ------------------------
    Check if the file exists
   ------------------------- }
  Assign(AreaDB, FileDB);
  if not FileExists(FileDB) then
   begin
     { -----------------
        Lets create it
      ----------------- }
     rewrite(AreaDB);
     if IOResult <> 0 then
      begin
        cErrorBox('Creating ' + FileDB);
        exit;
      end
     else
      begin
       if fpChmod (FileDB,&666) <> 0 then cErrorBox('chmod 666 ' +  FileDB);
       if fpChown (FileDB,BBSCfg.SysopUID,Config.UserGrp)  <> 0 then cErrorBox('chown SYSOP:BBS ' +  FileDB);
      end;
   end;
  {$I-}
  Reset(AreaDB);
  fSuccess := IOResult;
  if fSuccess = 0 then
   begin
    AreaSize := FileSize(AreaDB);
    Str((AreaSize + 1), AreaData.AreaNumber);
    seek(AreaDB, AreaSize);
    write(AreaDB, AreaData);
    if IOResult = 0 then
     begin
       Close(AreaDB);
       { ------------------
          Create Area file
         ------------------ }
       if BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then FileDB := BBSCfg.DataDir + SubFileArea + '.' + AreaData.AreaNumber
        else FileDB := BBSCfg.DataDir + '/' + SubFileArea + '.' + AreaData.AreaNumber;
       Assign(SubDB, FileDB);
       rewrite(SubDB);
       if IOResult <> 0 then
        begin
          cErrorBox('Creating ' + FileDB);
          AddFileArea := false;
        end
       else
        begin
         fpchmod(FileDB, &0666);
         if fpChmod (FileDB,&666) <> 0 then cErrorBox('chmod 666 ' +  FileDB);
         if fpChown (FileDB,BBSCfg.SysopUID,Config.UserGrp)  <> 0 then cErrorBox('chown SYSOP:BBS ' +  FileDB);
         cSuccessBox('Area Created');
         AddFileArea := true;
         close(SubDB);
        end;
     end
    else
     begin
       cErrorBox('Creating Area');
       AddFileArea := false;
     end;
   end
 else
   begin
     cErrorBox('Opening AREAS.DAT');
     AddFileArea := false;
     exit;
   end;
 Close(AreaDB);
 {$I+}
end;
{ ---------------------------------------------------------------------------
--------------------------------------------------------------------------}
function AddSubFileArea: boolean;
var
 FileDB,
 StrData  : string;
 AreaSize,
 CodeData,
 ValNo    : integer;
begin
  if SelectFileArea = 0 then exit;
  SubData.DirDes := cEditBox(30,'','Sub Title');
  SubData.Dir := cEditBox(65,'','Files Path');
  SubData.FileLst := cEditBox(65,BBSCfg.FileLstDir + AreaData.AreaNumber + '/','List Path (Default)');
  StrData := cEditBox(18,'','Min Level Access');
  val(DataStr, SubData.Access, CodeData);
  SubData.UpLoads := 0;
  SubData.DnLoads := 1;
  if not cAlertBox('Confirm','Add Sub File Area') then exit;
  { -------------------------------
     Read the File Areas  database
   ------------------------------- }
  if BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then FileDB := BBSCfg.DataDir + SubFileArea + '.' + AreaData.AreaNumber
    else FileDB := BBSCfg.DataDir + '/' + SubFileArea + '.' + AreaData.AreaNumber;
  Assign(SubDB, FileDB);
  {$I-}
  Reset(SubDB);
  fSuccess := IOResult;
  if fSuccess = 0 then
   begin
   { ----------------------------------------
      Create Files Dir if not done so already
     ---------------------------------------- }
   if not DirectoryExists(SubData.Filelst) then
     begin
       if not CreateDir(SubData.Filelst) then
        begin
          cErrorBox('Creating ' + SubData.Filelst);
        end
       else
        begin
          if fpChmod (SubData.Filelst,&777) <> 0 then cErrorBox('777 on ' +  SubData.Filelst);
          if fpChown (SubData.Filelst,BBSCfg.SysopUID,Config.UserGrp)  <> 0 then cErrorBox('Owner on ' +  SubData.Filelst);
        end;
     end;
    AreaSize := FileSize(SubDB);
    SubData.DirNo := (AreaSize + 1);
    str(SubData.DirNo, StrData);
    SubData.FileLst := SubData.Filelst + StrData + '.lst';
    seek(SubDB, AreaSize);
    write(SubDB, SubData);
    if IOResult = 0 then
     begin
       cSuccessBox('Sub Area Created');
       AddSubFileArea := true;
     end
    else
     begin
       cErrorBox('Creating Sub Area');
       AddSubFileArea := false;
     end;
   end
 else
   begin
     cErrorBox('Opening AREAS.' + AreaData.AreaNumber);
     AddSubFileArea := false;
     exit;
   end;
 Close(SubDB);
 {$I+}
end;
{ ---------------------------------------------------------------------------
--------------------------------------------------------------------------}
function SaveSubFileArea(FileNo : integer) : boolean;
var
 FileDB : string;
begin
  { -------------------------------
     Read the File Areas  database
   -------------------------------- }
  if BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then FileDB := BBSCfg.DataDir + SubFileArea + '.' + AreaData.AreaNumber
    else FileDB := BBSCfg.DataDir + '/' + SubFileArea + '.' + AreaData.AreaNumber;
  Assign(SubDB, FileDB);
  {$I-}
  Reset(SubDB);
  fSuccess := IOResult;
  if fSuccess = 0 then
   begin
    seek(SubDB, (FileNo - 1));
    write(SubDB, SubData);
    if IOResult = 0 then
     begin
       cSuccessBox('Data Saved');
       SaveSubFileArea := true;
     end
    else
     begin
       cErrorBox('Saving Data');
       SaveSubFileArea := false;
     end;
   end
 else
   begin
     cErrorBox('Saving Data');
     SaveSubFileArea := false;
     exit;
   end;
 Close(SubDB);
 {$I+}
end;
{ ---------------------------------------------------------------------------
--------------------------------------------------------------------------}
function SaveFileArea(FileNo : integer) : boolean;
var
 FileDB : string;
begin
  { -------------------------------
     Read the File Areas  database
   -------------------------------- }
  if BBSCfg.DataDir[Length(BBSCfg.DataDir)] = '/' then FileDB := BBSCfg.DataDir + FileAreas
    else FileDB := BBSCfg.DataDir + '/' + FileAreas;
  Assign(AreaDB, FileDB);
  {$I-}
  Reset(AreaDB);
  fSuccess := IOResult;
  if fSuccess = 0 then
   begin
    seek(AreaDB, (FileNo - 1));
    write(AreaDB, AreaData);
    if IOResult = 0 then
     begin
       cSuccessBox('Data Saved');
       SaveFileArea := true;
     end
    else
     begin
       cErrorBox('Saving Data');
       SaveFileArea := false;
     end;
   end
 else
   begin
     cErrorBox('Saving Data');
     SaveFileArea := false;
     exit;
   end;
 Close(AreaDB);
 {$I+}
end;
{ ---------------------------------------------------------------------------
--------------------------------------------------------------------------}
procedure DisplayFileArea;
begin
  nNewWindow(File_Win,1,8,80,14);
  nWinColor(File_Win,30);
  nWriteScr(File_Win,3,2,31,'[A]rea Number : ');
  nWriteScr(File_Win,19,2,30,AreaData.AreaNumber);
  nWriteScr(File_Win,3,4,31,'[F]ile Area : ');
  nWriteScr(File_Win,17,4,30,AreaData.Description);
  nWriteScr(File_Win,55,4,31,'S[t]atus : ');
  if AreaData.OpenClosed then nWriteScr(File_Win,66,4,30,'OPEN')
   else nWriteScr(File_Win,66,4,30,'CLOSED');
  nWriteScr(File_Win,3,6,31,'Press entry number to edit  [Q] To return to main menu ');
  if fSave then nWrite(File_Win,'[S]ave');
  nFrame(File_Win);
  nRefresh(File_Win);
end;
{ ---------------------------------------------------------------------------
--------------------------------------------------------------------------}
procedure DisplaySubFileArea;
begin
  nNewWindow(File_Win,1,5,80,21);
  nWinColor(File_Win,30);
  nWriteScr(File_Win,3,2,31,'Area : ');
  nWriteScr(File_Win,10,2,30,AreaData.Description);
  nWriteScr(File_Win,60,2,31,'Sub No : ');
  Str(SubData.DirNo, DataStr);
  nWriteScr(File_Win,69,2,30,DataStr);
  nWriteScr(File_Win,3,4,31,'Sub [T]itle : ');
  nWriteScr(File_Win,17,4,30,SubData.DirDes);
  nWriteScr(File_Win,3,6,31,'[F]ile Path : ');
  nWriteScr(File_Win,17,6,30,SubData.Dir);
  nWriteScr(File_Win,3,8,31,'[L]ist      : ');
  nWriteScr(File_Win,17,8,30,SubData.Filelst);
  nWriteScr(File_Win,3,10,31,'[U]ploads   : ');
  if SubData.Uploads = 1 then nWriteScr(File_Win,17,10,30,'Y')
   else nWriteScr(File_Win,17,10,30,'N');
  nWriteScr(File_Win,3,12,31,'[D]ownloads : ');
  if SubData.Dnloads = 1 then nWriteScr(File_Win,17,12,30,'Y')
   else nWriteScr(File_Win,17,12,30,'N');
  nWriteScr(File_Win,3,14,31,'[M]in Access Level : ');
  str(SubData.Access, DataStr);
  nWriteScr(File_Win,24,14,30,DataStr);
  nWriteScr(File_Win,3,16,31,'Press entry number to edit  [Q] To return to main menu ');
  if fSave then nWrite(File_Win,'[S]ave');
  nFrame(File_Win);
  nRefresh(File_Win);
end;
{ ---------------------------------------------------------------------------
--------------------------------------------------------------------------}
procedure EditAreas;
var
 response,
 sArea    : integer;
 updateOK : boolean;
begin
  updateOK := false;
  sArea := SelectFileArea;
  if sArea <> 0 then
   begin
     fsave := false;
     repeat
       DisplayFileArea;
       response := ord(readkey);
       case upcase(chr(response)) of
        'A' : begin
                if cAlertBox('CAUTION','Changing this number is not a good idea, Continue') then
                 begin
                   AreaData.AreaNumber := cEditBox(30,AreaData.AreaNumber,'Area Number');
                   fsave := true;
                 end;
              end;
        'F' : begin
                AreaData.Description := cEditBox(30,AreaData.Description,'Description');
                fSave := true;
              end;
        'T' : begin
                if sArea > 1 then
                 begin
                   if AreaData.OpenClosed then AreaData.OpenClosed := false
                     else AreaData.OpenClosed := true;
                   fsave := true;
                 end
                else
                 begin
                   if cAlertBox('CAUTION','Changine Area 1 is not recommanded, Continue') then
                    begin
                      if AreaData.OpenClosed then AreaData.OpenClosed := false
                        else AreaData.OpenClosed := true;
                      fsave := true;
                    end;
                 end;
              end;
        'S' : if SaveFileArea(sArea) then fSave := false;
        'Q' : begin
                if fSave then
                  begin
                    if cAlertBox('Alert','Save Updates') then
                     begin
                        if SaveFileArea(sArea) then UpdateOK := true
                          else updateOK := false;
                     end
                    else
                     begin
                       updateOK := true;
                     end;
                  end
                else
                 begin
                   updateOK := true;
                 end;
              end;

       end;
       nDelWindow(File_Win);
     until updateOK;
   end
  else
   begin
     cErrorBox('OPPS AREAS.DAT');
   end;
end;
{ ---------------------------------------------------------------------------
--------------------------------------------------------------------------}
procedure EditSubArea;
var
 response,
 sArea,
 CodeData,
 ValNo    : integer;
 updateOK : boolean;
begin
  updateOK := false;
  if SelectFileArea <> 0 then sArea := SelectSubFileArea;
  if sArea <> 0 then
   begin
     fSave := false;
     repeat
      DisplaySubFileArea;
      response := ord(readkey);
      case upcase(chr(response)) of
        'T' : begin
                SubData.DirDes := cEditBox(30,SubData.DirDes,'Sub Title');
                fsave := true;
              end;
        'F' : begin
                SubData.Dir := cEditBox(65,SubData.Dir,'File Path');
                fSave := true;
              end;
        'L' : begin
                SubData.FileLst := cEditBox(65,SubData.FileLst,'File List');
                fSave := true;
              end;
        'U' : begin
                if SubData.Uploads = 1 then SubData.Uploads := 0
                 else SubData.Uploads := 1;
                fSave := true;
              end;
        'D' : begin
                if SubData.Dnloads = 1 then SubData.Dnloads := 0
                 else SubData.Dnloads := 1;
                fSave := true;
              end;
        'M' : begin
                DataStr := cEditBox(14,'','Access Level');
                val(DataStr, ValNo, CodeData);
                if (ValNo < 1) or (ValNo > 9) then
                  begin
                    cErrorBox('Level 1 - 9');
                  end
                 else
                  begin
                    SubData.Access := ValNo;
                    fSave := true;
                  end;
              end;
        'S' : begin
                if fSave then
                  begin
                    if SaveSubFileArea(sArea) then fSave := false;
                  end;
              end;
        'Q' : begin
                if fSave then
                  begin
                    if cAlertBox('Alert','Save Updates') then
                     begin
                        if SaveSubFileArea(sArea) then UpdateOK := true
                          else updateOK := false;
                     end
                    else
                     begin
                       updateOK := true;
                     end;
                  end
                else
                 begin
                   updateOK := true;
                 end;
              end;
      end;
      nDelWindow(FIle_Win);
     until updateOK;
   end;
end;

end.
