(* ........................................................................ *)
(*        								    *)
(* MODULE	:   DIRECTORY.PP      			                    *)
(*									    *)
(* DESCRIPTION	:   Checks directory paths and creates if they do not exist *)
(*									    *)
(* ENVIRONMENT  :   PPC386 PASCAL Ver 0.99.5 LINUX KERNEL 2.2.30+           *)
(*									    *)
(* COPYRIGHT	:   SIMON C HORTON  1999 - 2000                             *)
(*									    *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* History.Linux                                                            *)
(*..........................................................................*)
Unit Directory;

interface

uses Dos, Linux, Strings, Errorlog, Data;

procedure Check_Directory(Path : string);

implementation

(*..........................................................................*)
procedure Check_Directory(Path : string);
var
  Sub_Dir     : integer;
  Directory   : string;
  Directories : array[1..100] of string[25]; { Allow upto 100 sub directories }
  PChar       : array[1..100] of integer; { Stores / location in directory string }
begin
  { Check for directory separator at end of file path }
  if Path[Length(Path)] <> '/' then Path := Path + '/';
  {$IFDEF _DEBUG_}
    writeln(' [DEBUG] Checking for directory path : [', Path,']');
  {$ENDIF} 
  { Count number of sub-directories }
  for Loop := 1 to Length(Path) do
   begin
     if Path[Loop] = '/' then 
      begin     
        inc(Sub_Dir);  
        { Store / locations }
        PChar[Sub_Dir] := Loop;
      end;
   end; 
  {$IFDEF _DEBUG_}
     writeln(' [DEBUG] Number of file separators = [',Sub_Dir,']'); 
  {$ENDIF}
  { Check for directories and create if needed }
  for Loop := 1 to Sub_Dir - 1 do
    begin
    Directories[Loop] := copy(Path, PChar[1], PChar[Loop + 1] - 1);
    {$IFDEF _DEBUG_}
      writeln(' [DEBUG] ',Loop,' Checking directory : [', Directories[Loop],'] ');
    {$ENDIF} 
    {$I-} ChDir(Directories[Loop]); {$I+}
    Success := IOResult;
    if Success <> 0 then 
    begin
     {$IFDEF _DEBUG_}
       writeln(' [DEBUG] Check directory result : Error = [', ErrorString(Success),']');
     {$ENDIF} 
     { Create Directory }
     if Output_Verbose then writeln('> Creating Directory.. (',Directories[Loop],')');
     {$I+} MkDir(Directories[Loop]); {$I+}
     Success := IOResult;
     if Success <> 0 then
      begin
        writeln('>> Error creating (', Directories[Loop],') Error = (', ErrorString(DosError),')');
	writeln('>> Program End..');
	Halt(1);
      end; 
    end;   
  end;
end;

end.
