unit DataLib;

interface

uses Linux, Ini, BaseUnix;

function ReadINIfiles : boolean;
(*..........................................................................*)
{ Sauron Message Index File - msgno = 0 tagged for deletion }
type
  Index = Record
     MsgNumber : Integer;
end;
(*..........................................................................*)
{ Sauron Message Areas Data Files }
type
  MsgArea = Record
    MsgNumber : String;         {MSG AREA NUMBER}
    AreaName  : String[30];     {MSG AREA DESCRIPTION}
end;
(*..........................................................................*)
{ Sauron Message Number }
{ NOT SURE WHAT THIS DOES AGAIN...! 23/10/07 }
type
  MS = record
    MsgNumber : integer;
end;

{ ----------------------------------
    Data structure for getpwuid ()
  ---------------------------------- }
type
  UserPasswd = record
    pw_name,
    pw_passwd : pchar;
    pw_uid,
    pw_gid    : word;
    pw_gecos,
    pw_dir,
    pw_shell  : pchar;
end;
  tUserInfo = ^UserPasswd;

{ ----------------------------
   File Area  Data Structures
  ----------------------------- }
{ Sauron BBS File Areas  AREAS.DAT }
type
  Area = record
    AreaNumber  : String[3];
    Description : String[30];
    OpenClosed  : Boolean;
    FileNumber  : LongInt;
    CatNumber   : LongInt;
end;

{ Sauron BBS File Areas  AREA.* }
type
  SubAreas = record
    DirNo   : Integer;     { Number Of File Directorys }
    Dir     : String[255];  { Directory path       }
    DirDes  : String[30];  { Directory Area Name  }
    FileLst : String[255];  { Files List & Path    }
    Uploads : Integer;     { Uploads Allowed      }
    DnLoads : Integer;     { DownLoads Allowed    }
    Access  : integer;     { Minimum Level Access }
end;

{ File Deletion - Stores files to be removed using SMT }
type
  FileRemove = record
    FilePath  : string[255]; { Path and FileName to be removed }
    FileLst   : string[255]; { File List DB path and name }
    FileID    : integer;     { File List DB record Number }
    FileDes   : string[60];  { First Line of Description }
end;

(*..........................................................................*)
{ Sauron BBS File Information }
type
  FileInfo = Record
    FileName  : String[60];
    Size      : LongInt;      { FileSize }
    FDate     : String[10];    { FileDate }
    Des1,
    Des2,
    Des3,
    Des4,
    Des5,
    Des6,
    Des7,
    Des8,
    Des9,
    Des10,
    Des11,
    Des12,
    Des13,
    Des14,
    Des15     : String[60];   { File Description }
    DLTimes   : Integer;      { Number Of Times File Has Been Downloaded }
    ULUser    : String[30];   { User Who Uploaded File }
    DLAllowed : boolean;      { Download enabled }
    Delete    : boolean;      { Deletion tag }
end;


{ ----------------------
   User Data Structures
  ---------------------- }
{ User Information  USERDAT.DAT}
type
  UserRec = record
    UserUID    : integer;       { Linux Account UID }
    UserAcc    : String[3];     { Account Number }
    UserAnsi   : byte;          { Ansi or Avatar }
    UserColour : byte;          { Colour ON or OFF }
    Userlevel  : byte;
    UserTime   : time_t;       { Date user account Created }
    UserTimestamp : time_t;    { epochtime of user login, used to reset daily call/time allowance }
    UserReg    : boolean;      { Has the user filled in a signup form }
    UserName   : string[30];
    UserNameFull : string[30];
    UserPass   : string[30];
    UserTown   : string[30];
    UserEmail  : string[30];
    UserInfo1  : string[30];
    UserInfo2  : string[30];
    UserInfo3  : string[30];
    Userinfo4  : string[30];
    Userinfo5  : string[30];
    Userinfo6  : string[30];
    Userinfo7  : string[30];
    Userinfo8  : string[30];
    UserCls    : Boolean;      { Screen clear code to be sent }
    UserLines  : byte;         { Lines of user terminal }
    Bulletin   : word;         { Current Bulletin Number Read }
    MailCount  : integer;      { User Mail }
    LastMsgNum : integer;
    Calls      : integer;      { Calls to system }
    CallsToday : integer;      { Calls today }
    LCallDate  : String[10];   { Last call date }
    LastCall   : string[30];
    CallNumber : integer;
    TimeOnLine : word;
    FileArea   : integer;      { Last file area visited - Will return user to this file area on next logon }
    DownLoads  : integer;      { Number of downloads }
    Uploads    : integer;      { Number of uploads }
    BytesDL    : LongInt;      { Bytes downloaded }
    BytesUL    : LongInt;      { Bytes uploaded }
end;

{ BBS configuration structure }
type
  Cfg = record
    ComPort     : Integer;
     BaudRate    : Byte;
     InitString1 : String[50];
     InitString2 : String[50];
     InitString3 : String[50];
     InitAnswear : String[20];
     //LockBaud    : Boolean;
     BBSNodes    : smallint;
     Node        : byte;
     MultiNode   : Boolean;
     GuestsAllowed : smallint;
     L1T,
     L2T,
     L3T,
     L4T,
     L5T,
     L6T,
     L7T,
     L8T,
     L9T        : Word;   { Level Time }
     L1C,
     L2C,
     L3C,
     L4C,
     L5C,
     L6C,
     L7C,
     L8C,
     L9C       : Word;   { Level Calls Per Day }
     SysDir,    { System Directories }
     ScriptDir,
     MenuDir,
     BBSMailDir,
     MsgDir,
     TempDir,
     BinDir,
     NewDir,
     DataDir,
     FileLstDir,
     LogDir,
     HomeDir,
     MailDir,
     upload,
     NodeDir    : String[80];  { Node Directory Is Where All nodes Share Info }
     SysopFirst : String[15];
     SysopSec   : String[15];
     BBSName    : String[30];
     BBSTele    : String[20];
     SysopUID,
     SysopNew,
     Calls      : integer;
     NuLevel    : integer;
     IdleTime,
     MaxUsers,
     MaxMsg,
     MaxTags    : Word;
     LogFile,
     ErrFile    : String[12];
     Bulletin   : word;
end;

{ Sadduser.ini Structure }
type
 System_Config = record
   bbs_files,
   new_user_files,
   log_file_location,
   log_file_name,
   message_location,
   admin_email	: string;
   use_log_file,
   mail_user,
   mail_admin		: boolean;
   ShadowToken,
   PasswdFile,
   ShadowFile,
   DefaultShell,
   HomeDir,
   SkelDir,
   MailDir       : string;
   HomedirPerms,
   UserGrp,
   UserNo        : longint;
   MailGrp       : integer;
end;

type
  Info = record
   u_name,
   u_dir   : pchar;
end;
  uInfo = ^Info;

const
   UserDatabase    = 'userinfo.data';
   NewUserDatabase = 'adduser.dat';
   BBSConfFile     = 'linux';
   SUConfFile      = 'sadduser';
   FileAreas       = 'areas.dat';
   SubFileArea     = 'area';
   FileDeletion    = 'filedelete.dat';
   ForumDatabase   = 'message.dat';
   MsgIndex        = 'msindex.dat';
   PostIndex       = 'message.idx';

var
  ready      : boolean;
  BBSCfg     : Cfg;  { BBS Configuration structure }
  Config     : System_Config; { Sadduser INI }
  BBSUserID,
  loop       : integer;
  { ----------------
    Main File Areas
   ---------------- }
  AreaDB     : file of Area;
  AreaData   : Area;

  SubDB	     : file of SubAreas;
  SubData    : SubAreas;

  FileIDB    : file of FileInfo;
  FileIData  : FileInfo;

  FileRDB    : file of FileRemove;
  FileRData  : FileRemove;

  {------------
    Forum Areas
   ------------ }
  ForumDB    : file of MsgArea;
  ForumData  : MsgArea;

  MsgIdxDB   : file of MS;
  MsgIdxData : MS;


implementation
{ ---------------------------------------------------------------------------
  ---------------------------------------------------------------------------}
function ReadINIfiles : boolean;
var
 DataString : string;
 CodeData   : integer;
begin
  { Check for linux.ini }
  if not FileExist(BBSConfFile + '.ini') then
   begin
     writeln('Error accessing [',BBSConfFile,'.ini]');
     ReadINIfiles := FALSE;
   end
 else
  begin
    DataString := '';
    { [CONFIG] }
    GetProfileString(BBSConfFile, 'CONFIG' , 'BINDIR', BBSCfg.BinDir, '/sauron/bin/');
    GetProfileString(BBSConfFile, 'CONFIG' , 'DATADIR', BBSCfg.DataDir, '/sauron/data/');
    GetProfileString(BBSConfFile, 'CONFIG' , 'SYSDIR', BBSCfg.SysDir, '/sauron/sys/');
    GetProfileString(BBSConfFile, 'CONFIG' , 'SCRIPTDIR', BBSCfg.ScriptDir, '/sauron/script/');
    GetProfileString(BBSConfFile, 'CONFIG' , 'MENUDIR', BBSCfg.MenuDir, '/sauron/menu/');
    GetProfileString(BBSConfFile, 'CONFIG' , 'FILESDIR', BBSCfg.FileLstDir, '/sauron/files/');
    GetProfileString(BBSConfFile, 'CONFIG' , 'NODEDIR', BBSCfg.NodeDir, '/sauron/node/');
    GetProfileString(BBSConfFile, 'CONFIG' , 'MSGDIR', BBSCfg.MsgDir, '/sauron/message/');
    GetProfileString(BBSConfFile, 'CONFIG' , 'TEMPDIR', BBSCfg.TempDir, '/sauron/temp/');
    GetProfileString(BBSConfFile, 'CONFIG' , 'LOGDIR', BBSCfg.LogDir, '/sauron/log/');
    GetProfileString(BBSConfFile, 'CONFIG' , 'ADDUSER', BBSCfg.NewDir, '/sauron/newuser/');
    GetProfileString(BBSConfFile, 'CONFIG' , 'HOMEDIR', BBSCfg.HomeDir, '/home/');
    GetProfileString(BBSConfFile, 'CONFIG' , 'MAILDIR', BBSCfg.BBSMailDir, '/var/spool/mail/');
    GetProfileString(BBSConfFile, 'CONFIG' , 'UPLOAD', BBSCfg.Upload, '/var/spool/mail/');
    GetProfileString(BBSConfFile, 'CONFIG' , 'SYSOPFIRST', BBSCfg.SysopFirst, 'System');
    GetProfileString(BBSConfFile, 'CONFIG' , 'SYSOPSEC', BBSCfg.SysopSec, 'Operator');
    GetProfileString(BBSConfFile, 'CONFIG' , 'BBSNAME', BBSCfg.BBSName, 'Sauron BBS');
    GetProfileString(BBSConfFile, 'CONFIG' , 'BBSTEL', BBSCfg.BBSTele, '555-8989');
    GetProfileString(BBSConfFile, 'CONFIG' , 'SYSOP', DataString, '2000');
    val(DataString, BBSCfg.SysopUID, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'SYSOPNEW', DataString, '1');
    val(DataString, BBSCfg.SysopNew, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'BBSNODES', DataString, '10');
    val(DataString, BBSCfg.BBSNodes, CodeData);
    //GetProfileString(BBSConfFile, 'CONFIG' , 'GUESTUID', DataString, '2000');
    //val(DataString, GuestUID, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'GUESTSALLOED', DataString, '5');
    val(DataString, BBSCfg.GuestsAllowed, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'CALLS', DataString, '0');
    val(DataString, BBSCfg.Calls, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'NEWLEVEL', DataString, '1');
    val(DataString, BBSCfg.NuLevel, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'IDLETIME', DataString, '5');
    val(DataString, BBSCfg.IdleTime, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'MAXUSERS', DataString, '100');
    val(DataString, BBSCfg.MaxUsers, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'MAXMSG', DataString, '100');
    val(DataString, BBSCfg.MaxMsg, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'MAXTAGS', DataString, '5');
    val(DataString, BBSCfg.MaxTags, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'BULLETIN', DataString, '1');
    val(DataString, BBSCfg.Bulletin, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'USERLOG', BBSCfg.LogFile, 'user.log');
    GetProfileString(BBSConfFile, 'CONFIG' , 'ERRORLOG', BBSCfg.ErrFile, 'error.log');
    GetProfileString(BBSConfFile, 'CONFIG' , 'L1TIME', DataString, '999');
    val(DataString, BBSCfg.L1T, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'L2TIME', DataString, '999');
    val(DataString, BBSCfg.L2T, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'L3TIME', DataString, '999');
    val(DataString, BBSCfg.L3T, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'L4TIME', DataString, '999');
    GetProfileString(BBSConfFile, 'CONFIG' , 'L5TIME', DataString, '999');
    val(DataString, BBSCfg.L5T, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'L6TIME', DataString, '999');
    val(DataString, BBSCfg.L6T, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'L7TIME', DataString, '999');
    val(DataString, BBSCfg.L7T, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'L8TIME', DataString, '999');
    val(DataString, BBSCfg.L8T, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'L9TIME', DataString, '999');
    val(DataString, BBSCfg.L9T, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'L1CALLS', DataString, '1');
    val(DataString, BBSCfg.L1C, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'L2CALLS', DataString, '1');
    val(DataString, BBSCfg.L2C, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'L3CALLS', DataString, '1');
    val(DataString, BBSCfg.L3C, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'L4CALLS', DataString, '1');
    val(DataString, BBSCfg.L4C, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'L5CALLS', DataString, '1');
    val(DataString, BBSCfg.L5C, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'L6CALLS', DataString, '1');
    val(DataString, BBSCfg.L6C, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'L7CALLS', DataString, '1');
    val(DataString, BBSCfg.L7C, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'L8CALLS', DataString, '1');
    val(DataString, BBSCfg.L8C, CodeData);
    GetProfileString(BBSConfFile, 'CONFIG' , 'L9CALLS', DataString, '1');
    val(DataString, BBSCfg.L9C, CodeData);
    DisposeINICollection;
    { Check for Sadduser.ini }
    if not FileExist(SUConfFile + '.ini') then
     begin
       writeln('Error accessing [',SUConfFile,'.ini]');
       ReadINIfiles := FALSE;
     end
    else
     begin
       GetProfileString(SUConfFile, 'CONFIG' , 'BBS_FILES', Config.bbs_files, '/usr/local/sauron/');
       GetProfileString(SUConfFile, 'CONFIG' , 'NEW_USER_FILES', Config.new_user_files, '/usr/local/sauron/newuser');
       GetProfileString(SUConfFile, 'CONFIG' , 'LOG_FILE_LOCATION', Config.log_file_location, '/usr/local/sauron/');
       GetProfileString(SUConfFile, 'CONFIG' , 'LOG_FILE_NAME', Config.log_file_name, 'user.log');
       GetProfileString(SUConfFile, 'CONFIG' , 'SHADOW_TOKEN', Config.Shadowtoken, '*');
       GetProfileString(SUConfFile, 'CONFIG' , 'PASSWD_FILE', Config.PasswdFile, '/etc/passwd');
       GetProfileString(SUConfFile, 'CONFIG' , 'SHADOW_FILE', Config.ShadowFile, '/etc/shadow');
       GetProfileString(SUConfFile, 'CONFIG' , 'SKEL_DIR', Config.SkelDir, '/etc/skel');
       GetProfileString(SUConfFile, 'CONFIG' , 'MAIL_DIR', Config.MailDir, '/var/spool/mail');
       GetProfileString(SUConfFile, 'CONFIG' , 'SHELL', Config.DefaultShell, '/usr/local/sauron/sauron.sh');
       GetProfileString(SUConfFile, 'CONFIG' , 'HOME_DIR', Config.HomeDir, '/local/home');
       GetProfileString(SUConfFile, 'CONFIG' , 'HOME_DIR_PERMS', DataString, '0775');
       val(DataString, Config.HomeDirPerms, CodeData);
       GetProfileString(SUConfFile, 'CONFIG' , 'USERGRP', DataString, '500');
       val(DataString, Config.UserGrp, CodeData);
       GetProfileString(SUConfFile, 'CONFIG' , 'USER', DataString, '1000');
       val(DataString, Config.UserNo, CodeData);
       GetProfileString(SUConfFile, 'CONFIG' , 'MAIL_GRP', DataString, '12');
       val(DataString, Config.MailGrp, CodeData);
       DisposeINICollection;
       BBSUserID := Config.UserNo;
       ReadINIFiles := true;
     end;
  end;
end;

end.


