(* ........................................................................ *)
(*        								    *)
(* MODULE	:   DATA.PAS        			                    *)
(*									    *)
(* DESCRIPTION	:   SMT DATA UNIT                                           *)
(*									    *)
(* ENVIRONMENTS :   PPC386 PASCAL Ver 0.99.14 LINUX KERNEL 2.2.30+          *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 2000                                       *)
(*									    *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* History.Linux                                                            *)
(*..........................................................................*)
Unit Data;

Interface

Uses Dos, nCrt, Strings;

procedure OpenDataFiles;
procedure CloseDataFiles;
procedure OpenUserTemp;
procedure CloseUserTemp;
procedure ReadINIFile;
(*..........................................................................*)

{ User Information  USERDAT.DAT}
type
  AddUser_Data = record
    Full_Name, 
    User_Name,
    User_Pass,
    User_Address1,
    User_Address2,
    User_Address3,
    User_Address4,
    User_Telephone,
    User_Email     : string[30];
end; 


type
  UserPasswd = record
    pw_name,
    pw_passwd : pchar;
    pw_uid,
    pw_gid    : word;
    pw_gecos,
    pw_dir,
    pw_shell  : pchar;
end;
  TUserPasswd = ^UserPasswd;

{ Modem data }
type
  Cfg = record
     ComPort     : Integer;
     BaudRate    : Byte;
     InitString1 : String[50];
     InitString2 : String[50];
     InitString3 : String[50];
     InitAnswear : String[20];
     LockBaud    : Boolean;
     Node        : Byte;
     MultiNode   : Boolean;
     L1T,
     L2T,
     L3T,
     L4T,
     L5T,
     L6T,
     L7T,
     L8T,
     L9T        : Word;   { Level Time }
     L1C,
     L2C,
     L3C,
     L4C,
     L5C,
     L6C,
     L7C,
     L8C,
     L9C       : Word;   { Level Calls Per Day }
     SysDir,    { System Directories }
     ScriptDir,
     MenuDir,
     BBSMailDir,
     MsgDir,
     TempDir,
     BinDir,
     NewDir,
     DataDir,
     LogDir,
     HomeDir,
     MailDir,
     NodeDir    : String[30];  { Node Directory Is Where All nodes Share Info }
     SysopFirst : String[15];
     SysopSec   : String[15];
     BBSName    : String[30];
     BBSTele    : String[20];
     Calls      : integer;
     NuLevel    : integer;
     IdleTime,
     MaxUsers,
     MaxMsg     : Word;
     LogFile,
     ErrFile    : String[12];
     Bulletin   : word;
end;
(*..........................................................................*)
{ Sauron BBS File Areas  AREAS.DAT }
type
  Area = record
    AreaNumber  : String[3];
    Description : String[30];
    OpenClosed  : Boolean;
    FileNumber  : LongInt;
    CatNumber   : LongInt;
end;
(*..........................................................................*)
{ Sauron BBS File Areas  AREA.* }
type
  FileAreas = record
    DirNo   : Integer;     { Number Of File Directorys }
    Dir     : String[30];  { Directory path       }
    DirDes  : String[30];  { Directory Area Name  }
    FileLst : String[30];  { Files List & Path    }
    Uploads : Integer;     { Uploads Allowed      }
    DnLoads : Integer;     { DownLoads Allowed    }
    Access  : integer;     { Minimum Level Access }
end;
(*..........................................................................*)
{ Tag File }
type
  FileTags = record
    FileName  : String[12];
    Dir       : String[80];
    DirLst    : String[80];
    Des       : String[40];
    Tagged    : Byte;
    Size      : LongInt;
    DLTimes   : Integer;
    ULUser    : String[30];
    Date      : String[8];
    RecNumber : integer;
end;
(*..........................................................................*)
{ Sauron BBS File Information }
type
  FileInfo = Record
    FileName  : String[12];
    Size      : LongInt;      { FileSize }
    FDate     : String[8];    { FileDate }
    Des1,
    Des2,
    Des3,
    Des4,
    Des5,
    Des6,
    Des7,
    Des8,
    Des9,
    Des10,
    Des11,
    Des12,
    Des13,
    Des14,
    Des15     : String[60];   { File Description }
    DLTimes   : Integer;      { Number Of Times File Has Been Downloaded }
    ULUser    : String[30];   { User Who Uploaded File }
end;
(*..........................................................................*)
{ Sauron BBS Data Information  SIMPBBS.DAT }
type
  bbs = record
    NextUser   : integer;
    Line       : string;
    From       : string;
    Date       : string;
    Time       : Word;
    Fax        : integer;
    FaxTime    : string;
end;
(*..........................................................................*)
{ Sauron Message Index File }
type
  Index = Record
     MsgNumber : Integer;
end;
(*..........................................................................*)
{ Sauron Message Areas Data Files }
type
  MsgArea = Record
    MsgNumber : String;
    AreaName  : String[30];
end;
(*..........................................................................*)
{ Sauron Message Number }
type
  MS = record
    MsgNumber : integer;
end;
(*..........................................................................*)
{ User Information  USERDAT.DAT}
type
  User = record
    UserAcc    : String[3];     { Account Number }
    UserAnsi   : byte;          { Ansi or Avatar }
    UserColour : byte;          { Colour ON or OFF }
    Userlevel  : byte;
    UserName   : string[30];
    UserPass   : string[10];
    UserTown   : string[30];
    UserInfo1  : string[30];
    UserInfo2  : string[30];
    UserInfo3  : string[30];
    Userinfo4  : string[30];
    Userinfo5  : string[30];
    Userinfo6  : string[30];
    Userinfo7  : string[30];
    Userinfo8  : string[30];
    UserCls    : Boolean;      { Screen clear code to be sent }
    UserLines  : byte;         { Lines of user terminal }
    Bulletin   : word;         { Current Bulletin Number Read }
    MailCount  : integer;      { User Mail }
    LastMsgNum : integer;
    Calls      : integer;      { Calls to system }
    CallsToday : integer;      { Calls today }
    LCallDate  : String[10];   { Last call date }
    LastCall   : string[30];   
    CallNumber : integer;
    TimeOnLine : word;
    FileArea   : integer;      { Last file area visited - Will return user to this file area on next logon }
    DownLoads  : integer;      { Number of downloads }
    Uploads    : integer;      { Number of uploads }
    BytesDL    : LongInt;      { Bytes downloaded }
    BytesUL    : LongInt;      { Bytes uploaded }
end;
(*..........................................................................*)

var
  Home_Directory : string;
  NewUserName    : pchar;
  { File Structure for adduser.dat }
  AddUser	  : AddUser_Data;
  UserDatabase : file of Adduser_Data;
  LockFile	  : boolean;
 { BBS Variables } { These Can Be Set In The Script Files }
  UserNumber : Integer;      { Holds Current UserNumber }
  bbsinfo    : bbs;
  Userinfo,
  UserTemp   : user;          { UserTemp is a tempory file to write and retrive  }
  Areas      : FileAreas;     { Data, as the main file was somehow being corrupt }
  SAreas     : Area;
  BBSCfg     : Cfg;
  FInfo      : FileInfo;
  Idx        : Index;
  Msg        : MsgArea;
  MsIndex    : Ms;
  Tags       : FileTags;
  UserSize   : LongInt;
  AreaSize   : LongInt;
  TagSize    : LongInt;
  InFile     : Text;
  DataFile,
  DataTemp   : File of user;       { UserFile & User Temp File}
  BBSini     : File of bbs;        { BBS Data File }
  FileArea   : File of FileAreas;  { File Directorys }
  CatArea    : File of Area;
  SBBSCfg    : File of Cfg;
  Files      : File of FileInfo;
  TagInfo    : File of FileTags;
  IdxFile    : File of Index;
  MsgFile    : File of MsgArea;
  MsgNum     : File of MS;
  Temp       : String;
  Loop       : Integer;
  FileNumber : byte;     { Record Number Of File DownLoaded }
  StatsBox   : Byte;     { Holds Whats To Displayed In Stats Box }
  SOnOff     : Boolean;  { Status Bar On / Off Flag              }
  Tagged,                { True if files are tagged }
  Local,                 { True if local logon }
  OnLine,
  PromptQuote : Boolean;

  LastCall,
  CallAway    : Integer;
  LastCalls,
  LastCaller,
  LastCallerTown : String;
  SessionTime,
  SessionLength,
  StartTimes,
  Minutes,
  Times,
  Time,
  LastOnTime     : Word;  { Reset Time Procedure }

  Carrier,                 { Line Speed }
  LineBaud       : Word;
  ActualBaud     : String;
  ConnectString  : String;
  ColourSelect   : Byte;
  ColourCode     : String;


  ModemTimeOut : integer;
  PortStatus   : Boolean; { Current Port Status - True = OK }
  ModemChar    : char;    { Char Return From Modem }
  ModemIntChar : integer;
  { PORT.INI VALUES NOT NEEDED BY LINUX VERSION }
  { [COMPORT] }
  ComPort,
  Irq,
  DataBits,
  StopBits    : byte;
  PortAddress : word;
  Baudrate    : longint;
  Parity      : char;
  { Sauron.ini & Linux.ini Data Values }
  { [MISC] }
  PausePage,
  SysopMenu,
  CommandNotFound,
  ShowTime1,
  ShowTime2,
  ShowTime3,
  InvalidPassword : string;
   { [SENDMAIL] }
   MailAbort,
   MailSave,
   MailEdit,
   MailView,
   MailAbortYes,
   MailAbortNo,
   MailPrompt1,
   MailPrompt2,
   MailHead1,
   MailHead2,
   MailSaved,
   MailAborted,
   MailError,
   MailUserError : string;
   { [READMAIL] }
   MailContinue,
   MailRead,
   MailDelete,
   MailReply,
   RMailPrompt1,
   RMailPrompt2,
   MailDeleted   : string;
   { [DIRECTORYLIST] }
   DNext,
   DUp,
   DDown,
   DAction,
   DStop,
   DDownload,
   DFileView,
   DContinue,
   DLFilePrompt1,
   DLFilePrompt2,
   ActionPrompt1,
   ActionPrompt2, 
   DFileHead1,
   DFileHead2,
   DFileHead3   : string;  
   { [LISTFILES] }
   TagFile,
   FileView,
   FileRelist,
   FileListStop,
   LFilePrompt1,
   LFilePrompt2,
   ViewFile,
   FileHead1,
   FileHead2,
   FileHead3   : string;
   { [FILEVIEW] }
   VTagFile,
   VFilePrompt1,
   VFilePrompt2,
   UpLoadBy,
   DownTime,
   DownMinutes   : string;
   { [MAINFILEAREA] }
   MQuit,
   MFilePrompt,
   MFileHead1,
   MFileHead2,
   MFileHead3,
   MOpen,
   MClosed,
   MCurrentArea  : string;
   { [SUBFILEAREA] }
   SArea,
   SFilePrompt,
   SFileHead1,
   SFileHead2,
   SFileHead3,
   NoAccess,
   InvalidArea   : string;
Implementation

function CheckINIKeys(Key : String) : String;
begin
  CheckINIKeys := '';
  if Pos('#ENTER', key) > 0 then
   begin
     CheckINIKeys := '';
   end
  else
   if Pos('#SPACE', key) > 0 then
    begin
     CheckINIKeys := ' ';
    end
   else
    begin    
      CheckINIKeys := Key;
   end;
end;

{ Retrive Profile Settings From Sauron.ini and Linux.ini}
procedure ReadINIFile;
begin
  DataString := '';
  { LINUX.INI }
  { [CONFIG] }
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'BINDIR', BBSCfg.BinDir, '/sauron/bin/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'DATADIR', BBSCfg.DataDir, '/sauron/data/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'SYSDIR', BBSCfg.SysDir, '/sauron/sys/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'SCRIPTDIR', BBSCfg.ScriptDir, '/sauron/script/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'MENUDIR', BBSCfg.MenuDir, '/sauron/menu/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'MSGDIR', BBSCfg.MsgDir, '/sauron/message/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'TEMPDIR', BBSCfg.TempDir, '/sauron/temp/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'LOGDIR', BBSCfg.LogDir, '/sauron/log/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'ADDUSER', BBSCfg.NewDir, '/sauron/newuser/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'HOMEDIR', BBSCfg.HomeDir, '/home/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'MAILDIR', BBSCfg.MailDir, '/var/spool/mail/');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'SYSOPFIRST', BBSCfg.SysopFirst, 'System');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'SYSOPSEC', BBSCfg.SysopSec, 'Operator');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'BBSNAME', BBSCfg.BBSName, 'Sauron BBS');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'BBSTEL', BBSCfg.BBSTele, '555-8989');
      
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'CALLS', DataString, '0');
      val(DataString, BBSCfg.Calls, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'NEWLEVEL', DataString, '1');
      val(DataString, BBSCfg.NuLevel, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'IDLETIME', DataString, '5');
      val(DataString, BBSCfg.IdleTime, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'MAXUSERS', DataString, '100');
      val(DataString, BBSCfg.MaxUsers, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'MAXMSG', DataString, '100');
      val(DataString, BBSCfg.MaxMsg, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'BULLETIN', DataString, '1');
      val(DataString, BBSCfg.Bulletin, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'USERLOG', BBSCfg.LogFile, 'user.log');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'ERRORLOG', BBSCfg.ErrFile, 'error.log');
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L1TIME', DataString, '999');
      val(DataString, BBSCfg.L1T, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L2TIME', DataString, '999');
      val(DataString, BBSCfg.L2T, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L3TIME', DataString, '999');
      val(DataString, BBSCfg.L3T, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L4TIME', DataString, '999');
      val(DataString, BBSCfg.L4T, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L5TIME', DataString, '999');
      val(DataString, BBSCfg.L5T, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L6TIME', DataString, '999');
      val(DataString, BBSCfg.L6T, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L7TIME', DataString, '999');
      val(DataString, BBSCfg.L7T, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L8TIME', DataString, '999');
      val(DataString, BBSCfg.L8T, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L9TIME', DataString, '999');
      val(DataString, BBSCfg.L9T, CodeData);
      
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L1CALLS', DataString, '1');
      val(DataString, BBSCfg.L1C, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L2CALLS', DataString, '1');
      val(DataString, BBSCfg.L2C, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L3CALLS', DataString, '1');
      val(DataString, BBSCfg.L3C, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L4CALLS', DataString, '1');
      val(DataString, BBSCfg.L4C, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L5CALLS', DataString, '1');
      val(DataString, BBSCfg.L5C, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L6CALLS', DataString, '1');
      val(DataString, BBSCfg.L6C, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L7CALLS', DataString, '1');
      val(DataString, BBSCfg.L7C, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L8CALLS', DataString, '1');
      val(DataString, BBSCfg.L8C, CodeData);
      ProfileStatus := GetProfileString('linux', 'CONFIG' , 'L9CALLS', DataString, '1');
      val(DataString, BBSCfg.L9C, CodeData);
      { [MISC] }
       ProfileStatus := GetProfileString('linux', 'MISC' , 'PAUSEPAGE', PausePage, '[PAUSED]');
       ProfileStatus := GetProfileString('linux', 'MISC' , 'SYSOPMENU', SysopMenu, '[!] Sysop Menu');
       ProfileStatus := GetProfileString('linux', 'MISC' , 'COMMANDNOTFOUND', CommandNotFound, 'Command Not Found');
       ProfileStatus := GetProfileString('linux', 'MISC' , 'SHOWTIME1', ShowTime1, 'Online Time ');
       ProfileStatus := GetProfileString('linux', 'MISC' , 'SHOWTIME2', ShowTime2, ' Minutes, With ');
       ProfileStatus := GetProfileString('linux', 'MISC' , 'SHOWTIME3', ShowTime3, ' Left');
       { [DIRECTORYLIST] }
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'NEXT', DataString, 'N');
       DNext := CheckINIKeys(DataString);
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'UP', DataString, '8');
       DUp := CheckINIKeys(DataString);
       ProfileStatus := GetProfileString('linux', 'FIRECTORYLIST' , 'DOWN', DataString, '2');
       DDown := CheckINIKeys(DataString);
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'ACTION', DataString, 'A');
       DAction := CheckINIKeys(DataString);
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'STOP', DataString, 'S');
       DStop := CheckINIKeys(DataString);
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'DOWNLOAD', DataString, 'D');
       DDownload := CheckINIKeys(DataString);
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'VIEW', DataString, 'V');
       DFileView := CheckINIKeys(DataString);
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'DContinue', DataString, '');
       DContinue := CheckINIKeys(DataString);
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'LFILEPROMPT1', DLFilePrompt1, '[N] Next [8] Up [2] Down [A] Action [S] Stop');
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'ACTIONPROMPT1', ActionPrompt1, '[D] Downloaf [V]View File [ENTER] Continue');
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'LFILEPROMPT2', DLFilePrompt2, 'Select :');
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'ACTIONPROMPT2', ActionPrompt2, 'Select :');
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'FILEHEAD1', DFileHead1, ' ');
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'FILEHEAD2', DFileHead2, 'File List..');
       ProfileStatus := GetProfileString('linux', 'DIRECTORYLIST' , 'FILEHEAD3', DFileHead3, ' ');
       { [SENDMAIL] }
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILABORT', MailAbort, 'A');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILSAVE', MailSave, 'S');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILEDIT', MailEdit, 'E');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILVIEW', MailView, 'V');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILABORTYES', MailAbortYes, 'Y');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILABORTNO', MailAbortNo, 'N');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILPROMPT1', MailPrompt1, 'A - S - E - V');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILPROMPT2', MailPrompt2, 'Select : ');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILHEAD1', MailHead1, 'Press Enter On A Empty Line Finish');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILHEAD2', MailHead2, 'Max 25 Lines 65 Chars Per Line');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILSAVED', MailSaved, 'Mail Saved');
       ProfileStatus := GetProfileString('linux', 'SENDMAIL' , 'MAILABORTED', MailAborted, 'Abort Mail (Y / N) : ');
  DisposeINICollection;
end;
(*..........................................................................*)
{ Open All Data Files needed To Run Sauron BBS }
procedure OpenUserTemp;
begin
  Assign(DataTemp,'USERLOG.TMP');
  {$I-} Reset(DataTemp); {$I+}
  FileError := IOResult;
  if FileError <> 0 then
      begin
        Writeln('Unable To Open USERLOG.TMP');
        ErrorString(FileError);
        Halt(1);
      end;
end;
(*..........................................................................*)
procedure CloseUserTemp;
begin
  Close(DataTemp);
end;
(*..........................................................................*)
procedure OpenDataFiles;
var
  Data_File : string;
begin
  Download_Script := '';
  File_Viewer	    := '';
  LastOnTime  := 0;
  StatsBox    := 1;
  FileNumber  := 0;
  LineCount   := 0;
  BBSLines    := 0;
  CurrentLine := 24;
  Carrier     := 0;
  LineBaud    := 0;
  LastCall    := 0;
  CallAway    := 0;
  Echo        := True;
  Tagged      := True;
  PassEcho    := False;
  NoUpper     := False;
  FileError   := 0;
  ColourSelect := 1;
  AvatarChar  := 0;
  AvatarCode  := 0;
  AvatarCol   := 0;
  AnsiCode    := 0;
  AnsiDetect  := False;
  PromptQuote := True;
  ModemTimeOut := 5;
  Back := 0;
  Fore := White;
  Flash := 0;
  High := 0;
  UserNumber := 0;
  UserInfo.UserAnsi := 1; { Default User To ANSI }
  ConnectString := 'LOCAL';
  FileMode := fmReadWrite + fmDenyNone;
  Home_Directory := Home_Directory + '/userinfo.data';
  Assign(DataFile, Home_Directory);
    {$I-}
    Reset(DataFile);
    FileError := IOResult;
    if FileError = 0 then
        begin
           UserSize := FileSize(DataFile);
            If UserSize <> 0 then
             begin
               Seek(DataFile, 0);
               Read(DataFile, UserInfo);
               {$I+}
             end;
           end
        else
           begin
             Write('ERROR : ');
             ErrorString(FileError);
             Writeln('Accessing ', Home_Directory);
             Writeln;
             {$I+}
             Halt(1);
           end;
   If BBSCfg.DataDir[Length(BBSCfg.DataDir)] = directory_Seperator then
       Data_File := BBSCfg.DataDir + 'simpbbs.dat'
   Else Data_File := BBSCfg.DataDir + directory_Seperator + 'simpbbs.dat';
  Assign(BBSini, Data_File);
  {$I-} Reset(BBSini);
  FileError := IOResult;
  if FileError = 0 then
    begin
      Seek(BBSINI, 0);
      Read(BBSINI, BBSInfo);
      {$I+}
    end
  else
    begin
      ClrScr;
      Write('   ERROR ACCESSING [',Data_File,'] : ');
      ErrorString(FileError);
      Writeln('                     SIMPBBS.DAT');
      Writeln('               PRESS ANY KEY TO EXIT');
      {$I+}
      Repeat Until Keypressed;
      Halt(1);
    end;

  If BBSCfg.DataDir[Length(BBSCfg.DataDir)] = directory_Seperator then
       Data_File := BBSCfg.DataDir + 'areas.dat'
   Else Data_File := BBSCfg.DataDir + directory_Seperator + 'areas.dat';
  Assign(CatArea, Data_File);
  {$I-} Reset(CatArea);
  FileError := IOResult;
  if FileError = 0 then
    begin
      if FileSize(CatArea) <> 0 then
       begin
         Seek(CatArea, 0);
         Read(CatArea, SAreas);
         {$I+}
       end;
    end
  else
    begin
      Write('   ERROR ACCESSING [',Data_File,'] : ');
      ErrorString(FileError);
      Writeln('                     AREAS.DAT');
      Writeln('               PRESS ANY KEY TO EXIT');
      {$I+}
      Repeat Until Keypressed;
      Halt(1);
    end;

  If BBSCfg.DataDir[Length(BBSCfg.DataDir)] = directory_Seperator then
       Data_File := BBSCfg.DataDir + 'area.1'
   Else Data_File := BBSCfg.DataDir + directory_Seperator + 'area.1';
  Assign(FileArea, Data_File);   { Open Default File Area }
  {$I-} Reset(FileArea);
  FileError := IOResult;
  if FileError = 0 then
    begin
      AreaSize := FileSize(FileArea);
      if AreaSize <> 0 then
       begin
         Seek(FileArea, 0);
         Read(FileArea, Areas);
         {$I+}
       end;
    end
  else
    begin
      Write('   ERROR ACCESSING [',Data_File,'] : ');
      ErrorString(FileError);
      Writeln;
      Writeln('                       AREA.1');
      Writeln('               PRESS ANY KEY TO EXIT');
      {$I+}
      Repeat Until Keypressed;
      Halt(1);
    end;

  If BBSCfg.DataDir[Length(BBSCfg.DataDir)] = directory_Seperator then
       Data_File := BBSCfg.DataDir + 'message.dat'
   Else Data_File := BBSCfg.DataDir + directory_Seperator + 'message.dat';
  Assign(MsgFile, Data_File);
  {$I-} Reset(MsgFile);
  FileError := IOResult;
  if FileError = 0 then
    begin
      If FileSize(MsgFile) <> 0 then
        begin
          Seek(MsgFile, 0);
          Read(MsgFile, Msg);
          {$I+}
        end;
    end
  else
    begin
      Write('   ERROR ACCESSING [',Data_File,'] : ');
      ErrorString(FileError);
      Writeln('                    MESSAGE.DAT');
      Writeln('               PRESS ANY KEY TO EXIT');
      {$I+}
      Repeat Until Keypressed;
      Halt(1);
    end;

  If BBSCfg.DataDir[Length(BBSCfg.DataDir)] = directory_Seperator then
       Data_File := BBSCfg.DataDir + 'msindex.dat'
   Else Data_File := BBSCfg.DataDir + directory_Seperator + 'msindex.dat';
  Assign(MsgNum, Data_File);
  {$I-} Reset(MsgNum);
  FileError := IOResult;
  if IOResult = 0 then
    begin
      If FileSize(MsgNum) <> 0 then
        begin
          Seek(MsgNum, 0);
          Read(MsgNum, MsIndex);
          {$I+}
        end;
    end
  else
    begin
      Write('   ERROR ACCESSING [', Data_File,'] : ');
      ErrorString(FileError);
      Writeln('                    MSINDEX.DAT');
      Writeln('               PRESS ANY KEY TO EXIT');
      {$I+}
      Repeat Until Keypressed;
      Halt(1);
    end;
  end;
(*..........................................................................*)
function MinutesPast: word;
Var
  H,M,S,Hund,
  Mins  : Word;
begin
  { GetTime(H,M,S,Hund); }
  If M <> StartTimes then
    begin
      Inc(Minutes);
      StartTimes := M;
    end;
  MinutesPast := Minutes;
end;
(*..........................................................................*)
procedure CloseDataFiles;
var
  Rec, Code : Integer;
begin

    BBSInfo.Time := Code;
    BBSInfo.Line := UserInfo.UserName;
    BBSInfo.From := UserInfo.UserTown;
    BBSInfo.Date := Today;
    UserInfo.Lastcall := today;
    Code := MinutesPast;
    UserInfo.LastMsgNum := MsIndex.MsgNumber;
    UserInfo.FileArea   := Areas.DirNo - 1;
    UserInfo.TimeOnline := LastOnTime + Code;
    {$I-}
      Seek(BBSini, 0);
      Write(BBSINI, BBSInfo);
      Seek(DataFile, 0);
      Write(DataFile, UserInfo);
    {$I+}  
    Close(BBSINI);
    Close(FileArea);
    Close(CatArea);
    Close(MsgNum);
    Close(MsgFile);
   { Close(SBBSCfg); }
    Close(DataFile);
end;
end.

