(*..........................................................................*)
(*        								    *)
(* MODULE	:   CWIN.PAS        			                    *)
(*									    *)
(* DESCRIPTION	:   WINDOW ROUTINES THAT USES NCRT AND NCURSES              *)
(*									    *)
(* ENVIRONMENTS :   PPC386 PASCAL Ver 0.99.14+ LINUX KERNEL 2.2.30+         *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 2000                                       *)
(*									    *)
(*..........................................................................*)
(* History                                                                  *)
(*									    *)
(* version |   date   |  who  |  description                                *)
(*..........................................................................*)
(*  0.0.1  | 10/04/00 |  SCH  |  first version                              *)
(*..........................................................................*)
unit cwin;

interface

uses Linux, nCrt, Strings, DataLib;

function cAlertBox(Title, Strg : string) : boolean;
procedure cErrorBox(ErrStr : string);
procedure cSuccessBox(SuccStr : string);
function cListBox(ListSize : integer; Title : string): integer;
function dListBox(ListSize : integer; Title,Footer : string): integer;
function cEditBox(TextSize : integer; EditStr, Title : string) : string;

var
 uw1,eWin,
 aWin     : pWin;
 cList    : array[1..1000] of string;  { Holds the entries for the list box }
 d1List   : array[1..1000] of string;  { Holds the entries for the list box }
 d2List   : array[1..1000] of string;  { Holds the entries for the list box }
 d3List   : array[1..1000] of string;  { Holds the entries for the list box }

implementation

{ ---------------------------------------------------------------------------
                                  ALERT BOX
                        Returns TRUE = yes FALSE = no
  ---------------------------------------------------------------------------}
function cAlertBox(Title, Strg : string) : boolean;
var
 xPos, StrLen : byte;
 key          : char;
begin
  StrLen := length(Strg);
  xPos := ((80 - Strlen) DIV 2) - 3;
  nNewWindow(aWin,xPos,9,(xPos + Strlen) + 3 ,13);
  nWinColor(aWin,79);
  nClrScr(aWin,79);
  nWriteScr(aWin,((Strlen - length(Title)) DIV 2 + 3),2,78,Title);
  nWriteScr(aWin,3,3,79,Strg);
  nWriteScr(aWin,((Strlen - 12) DIV 2 + 3),4,78,'[Y]es / [N]o');
  nFrame(aWin);
  nRefresh(aWin);
  ready := FALSE;
  repeat
   key := readkey;
    case (key) of
     'y' : begin
            cAlertBox := TRUE;
            ready := TRUE;
           end;
     'Y' : begin
            cAlertBox := TRUE;
            ready := TRUE;
           end;
     'n' : begin
            cAlertBox := FALSE;
            ready := TRUE;
           end;
     'N' : begin
            cAlertBox := FALSE;
            ready := TRUE;
           end;
    end; {case end}
  until ready = TRUE;
  nDelWindow(aWin);
end;
{ ---------------------------------------------------------------------------
                                  ERROR BOX
  ---------------------------------------------------------------------------}
procedure cErrorBox(ErrStr : string);
var
 xPos, StrLen : byte;
begin
  StrLen := length(ErrStr);
  xPos := ((80 - Strlen) DIV 2) - 3;
  nNewWindow(eWin,xPos,9,(xPos + Strlen) + 3 ,12);
  nWinColor(eWin,79);
  nClrScr(eWin,79);
  nWriteScr(eWin,((Strlen - 5) DIV 2 + 3),2,78,'ERROR');
  nWriteScr(eWin,3,3,79,ErrStr);
  nFrame(eWin);
  nRefresh(eWin);
  readkey;
  nDelWindow(eWin);
end;
{ ---------------------------------------------------------------------------
                                  SUCCESS BOX
  ---------------------------------------------------------------------------}
procedure cSuccessBox(SuccStr : string);
var
 xPos, StrLen : byte;
begin
  StrLen := length(SuccStr);
  xPos := ((80 - Strlen) DIV 2) - 3;
  nNewWindow(eWin,xPos,9,(xPos + Strlen) + 3 ,12);
  nWinColor(eWin,31);
  nClrScr(eWin,31);
  nWriteScr(eWin,((Strlen - 7) DIV 2 + 3),2,30,'SUCCESS');
  nWriteScr(eWin,3,3,31,SuccStr);
  nFrame(eWin);
  nRefresh(eWin);
  readkey;
  nDelWindow(eWin);
end;
{ ---------------------------------------------------------------------------
                             3 COL LIST BOX
                           returns entry number
           requires the information to be put into d{123}List first
  ---------------------------------------------------------------------------}
function dListBox(ListSize : integer; Title, Footer : string) : integer;
var
 Line,
 CurrentLine,
 ListNo,
 X, Y        : integer;
 Kyb         : char;
begin
  Line := 1;
  ListNo := 1;
  CurrentLine := 1;
  nNewWindow(eWin,1,5,80,5);
  nWinColor(eWin,48);
  nWriteScr(eWin,((78 - length(Title)) DIV 2),1,63,Title);
  nRefresh(eWin);
  nNewWindow(aWin,1,22,80,22);
  nWinColor(aWin,48);
  nWriteScr(aWin,((78 - length(Footer)) DIV 2),1,63,Footer);
  nRefresh(aWin);
  nNewWindow(uw1,1,6,80,21);
  nWinColor(uw1,48);
  nClrScr(uw1,48);
  repeat
   if Line <= 14 then
    begin
     nWriteScr(uw1,2,Line + 1,48,d1List[Line]);
     nWriteScr(uw1,12,Line + 1,48,d2List[Line]);
     nWriteScr(uw1,44,Line + 1,48,d3List[Line]);
    end;
   inc(Line);
  until Line = ListSize;
  nWinColor(uw1,48);
//  nClrScr(uw1,48);
  nWriteScr(uw1,2,2,15,d1List[1]);
  nFrame(uw1);
  nRefresh(uw1);
  repeat
   kyb := readkey;
   case (kyb) of
     #27 : begin
              dListBox := 0;
              exit;
           end;
     #80 : begin
             if ListNo < ListSize - 1 then
              begin
                if CurrentLine > 13 then
                 begin
                   {Non Block}
                   nWriteScr(uw1,2,15,48,'                                              ');
                   nWriteScr(uw1,2,15,48,d1List[ListNo]);
                   nScroll(uw1,1,1);
                   {Block}
                   nWriteScr(uw1,2,15,48,'                                              ');
                   nWriteScr(uw1,2,15,15,d1List[ListNo + 1]);
                   //GotoXY(2,15);
                 end
                else
                 begin
                   {Non Block}
                   nWriteScr(uw1,2,CurrentLine + 1,48,d1List[ListNo]);
                   {Block}
                   nWriteScr(uw1,2,CurrentLine + 2,15,d1List[ListNo + 1]);
                   inc(CurrentLine);
                 end;
                inc(ListNo);
                nFrame(uw1);
                nRefresh(uw1);
             end;
           end;
    #72 : begin
             if ListNo > 1 then
              begin
                if CurrentLine = 1 then
                 begin
                   {Non Block}
                   nWriteScr(uw1,2,2,48,'                                              ');
                   nWriteScr(uw1,2,2,48,d1List[ListNo]);
                   nScroll(uw1,1,-1);
                   {Block}
                   nWriteScr(uw1,2,2,48,'                                              ');
                   nWriteScr(uw1,2,2,15,d1List[ListNo - 1]);
                 end
                else
                 begin
                   nWriteScr(uw1,2,CurrentLine + 1,48,d1List[ListNo]);
                   nWriteScr(uw1,2,CurrentLine,15,d1List[ListNo - 1]);
                   dec(CurrentLine);
                 end;
                if ListNo <> 1 then dec(ListNo);
                nFrame(uw1);
                nRefresh(uw1);
              end;
          end;
   end; { Case end }
  until kyb = #13;
  nDelWindow(uw1);
  nDelWindow(eWin);
  nDelWindow(aWin);
  dListBox := CurrentLine;
end;
{ ---------------------------------------------------------------------------
                                 LIST BOX
                           returns entry number
            requires the information to be put into cList first
  ---------------------------------------------------------------------------}
function cListBox(ListSize : integer; Title : string) : integer;
var
 Line,
 CurrentLine,
 ListNo,
 X, Y        : integer;
 Kyb         : char;
begin
  Line := 1;
  ListNo := 1;
  CurrentLine := 1;
  nNewWindow(eWin,15,5,60,5);
  nWinColor(eWin,48);
  nWriteScr(eWin,((47 - length(Title)) DIV 2),1,63,Title);
  nRefresh(eWin);
  nNewWindow(uw1,15,6,60,21);
  nWinColor(uw1,48);
  nClrScr(uw1,48);
  repeat
   if Line <= 14 then nWriteScr(uw1,2,Line + 1,48,cList[Line]);
   inc(Line);
  until Line = ListSize;
  nWinColor(uw1,48);
//  nClrScr(uw1,48);
  nWriteScr(uw1,2,2,15,cList[1]);
  nFrame(uw1);
  nRefresh(uw1);
  repeat
   kyb := readkey;
   case (kyb) of
     #27 : begin
              cListBox := 0;
              exit;
           end;
     #80 : begin
             if ListNo < ListSize - 1 then
              begin
                if CurrentLine > 13 then 
                 begin
                   {Non Block}
                   nWriteScr(uw1,2,15,48,'                                              ');
                   nWriteScr(uw1,2,15,48,cList[ListNo]);
                   nScroll(uw1,1,1);
                   {Block}
                   nWriteScr(uw1,2,15,48,'                                              ');
                   nWriteScr(uw1,2,15,15,cList[ListNo + 1]);
                   //GotoXY(2,15);
                 end
                else
                 begin
                   {Non Block}
                   nWriteScr(uw1,2,CurrentLine + 1,48,cList[ListNo]);
                   {Block}
                   nWriteScr(uw1,2,CurrentLine + 2,15,cList[ListNo + 1]);
                   inc(CurrentLine);
                 end;
                inc(ListNo);
                nFrame(uw1);
                nRefresh(uw1);
             end;
           end;
    #72 : begin
             if ListNo > 1 then
              begin
                if CurrentLine = 1 then
                 begin
                   {Non Block}
                   nWriteScr(uw1,2,2,48,'                                              ');
                   nWriteScr(uw1,2,2,48,cList[ListNo]);
                   nScroll(uw1,1,-1);
                   {Block}
                   nWriteScr(uw1,2,2,48,'                                              ');
                   nWriteScr(uw1,2,2,15,cList[ListNo - 1]);
                 end
                else
                 begin
                   nWriteScr(uw1,2,CurrentLine + 1,48,cList[ListNo]);
                   nWriteScr(uw1,2,CurrentLine,15,cList[ListNo - 1]);
                   dec(CurrentLine);
                 end;
                if ListNo <> 1 then dec(ListNo);
                nFrame(uw1);
                nRefresh(uw1);
              end;
          end;
   end; { Case end }
  until kyb = #13;
  nDelWindow(uw1);
  nDelWindow(eWin);
  cListBox := listno;
end;
{ ---------------------------------------------------------------------------
                                  EDIT BOX
  ---------------------------------------------------------------------------}
function cEditBox(TextSize : integer; EditStr, Title: string) : string;
var
 xPos, X,
 Counter,
 cText   : byte;
 Key     : char;
 keyIn,
 CentY1,
 CentY2   : integer;
 //eText   : array[1..100] of char;
 eText   :  string;
begin
  //ext := nWhereX(eWin) - 1;
  CentY1 := TextSize - Length(Title);
  CentY2 := Trunc(CentY1 DIV 2);
  cText := length(EditStr);
  eText := EditStr;
  xPos := ((80 - TextSize) DIV 2) - 3;
  nNewWindow(eWin,xPos,8,(xPos + TextSize) + 1 ,11);
  nWinColor(eWin,79);
  nClrScr(eWin,79);
  nWriteScr(eWin,CentY2,2,79,Title);
  nWriteScr(eWin,3,3,48,EditStr);
  nFrame(eWin);
  nRefresh(eWin);
  Counter := nWhereX(eWin) + 1;
  repeat
   Key := nreadkey(eWin);
   Keyin := ord(key);
   case keyin of
     32..125 : begin
                if ctext <= TextSize then
                 begin
                   inc(cText);
                   X := nWhereX(eWin);
                   nWriteScr(eWin,X,3,48,chr(keyin));
                   Insert(Chr(KeyIn), etext, cText);
                   //etext[cText] := chr(Keyin);
                   nFrame(eWin);
                   nRefresh(eWin);
                 end;
               end;
      8,127 : begin
                if ctext >= 1 then
                 begin
                   X := nWhereX(eWin);
                   nWriteScr(eWin,X - 1,3,48,' ');
                   nGotoXY(eWin,X - 1,3);
                   Counter := nWhereX(eWin) + 1;
                   Delete(etext, ctext, 1);
                   dec(cText);
                   //eText[cText] := #00;
                   nFrame(eWin);
                   nRefresh(eWin);
                 end;
               end;
    end;
  until KeyIn = 13;
  cEditBox := '';
     cEditBox := etext;
(*
  for loop := 1 to cText do
   begin
     cEditBox := etext;
    {  cEditBox := cEditBox + eText[loop]; }
   end;
*)
  nDelWindow(eWin);
end;

end.
