(*
$Id: slbbs.pp,v 1.4 2008-02-19 21:58:09 simon Exp $
*)
(*..........................................................................*)
(*        								    *)
(* MODULE	:   SLBBS.PAS        			                    *)
(*									    *)
(* DESCRIPTION	:   MAIN LINUX BBS CORE PROGRAM                             *)
(*									    *)
(* ENVIRONMENTS :   PPC386 PASCAL Ver 0.99.0+ LINUX KERNEL 2.2.30+          *)
(*									    *)
(* COPYRIGHT	:   SIMON HORTON 1995 - 2000                                *)
(*									    *)
(* VERSION      :   Linux Version 0.0.2-4                                   *)
(*..........................................................................*)
(* See the following documents regarding developement                       *)
(* History.Linux                                                            *)
(*..........................................................................*)
Program SLBBS;

  Uses Crt, linux, strings, Lib, Data, Start, Sf2U, ErrorLog, comdate, Unix, BaseUnix, BuildData, user, dates, sqldb;

  type
    UserPasswd = record
      pw_name,
      pw_passwd : pchar;
      pw_uid,
      pw_gid    : word;
      pw_gecos,
      pw_dir,
      pw_shell  : pchar;
  end;
  TUserPasswd = ^UserPasswd;

function getpwuid(UserIDs : longint) : TUserPasswd; cdecl; external;
(*..........................................................................*)
procedure BeginBBS;
Var
 Rec, Code : Integer;
begin
   ScriptFile    := 'logon.sfi';
   SessionLength := 0;
   Rec           := 0;
   if UserInfo.UserUID = BBSCfg.SysopUID then UserInfo.Userlevel := 9;
   Case UserInfo.UserLevel of
       1 : SessionTime := BBSCfg.L1T;
       2 : SessionTime := BBSCfg.L2T;
       3 : SessionTime := BBSCfg.L3T;
       4 : SessionTime := BBSCfg.L4T;
       5 : SessionTime := BBSCfg.L5T;
       6 : SessionTime := BBSCfg.L6T;
       7 : SessionTime := BBSCfg.L7T;
       8 : SessionTime := BBSCfg.L8T;
       9 : SessionTime := BBSCfg.L9T;
    Else
       SessionTime := 9999;
   end; { Case End }
   repeat
     Sfi(Scriptfile);
   until ScriptFile = 'end';
end;
(*..........................................................................*)
Var
  I,
  OrgMode  : Integer;
  CmdLine  : String[30];
  GetLine,
  Strgs    : string;
  UserID   : longint;
  TUserID  : TUserPasswd;
  Uts	   : utsname;
Begin
  Local   := True;
  OnLine  := false;
  SOnOff  := True;
  Finish  := False;
  TextBackGround(Black);
  If Online then Local := False;
  fpuname(uts);
  UserID  := fpGetUID;
  TUserID := getpwuid(UserID);
  {$IFDEF _LIB64_}
     Home_Directory := StrPas(TUserID^.pw_dir);
  {$ELSE}
     Home_Directory := StrPas(TUserID^.pw_shell);
     //ThisUser := TUserID^.pw_name;
  {$ENDIF}
   ThisUser := StrPas(TUserID^.pw_name);
  { Get current time }
  Str(fptime, timestamp);
  if fpGetenv('REMOTEHOST') = '' then
   begin
     RemoteHost := timestamp;
   end
  else
   begin
     RemoteHost := fpGetenv('REMOTEHOST');
   end;
  ReadINIFile; { Read Profiles Form linux.ini }
  if (Paramstr(1) = '--version')  then
    begin
      writeln(OSSystem,' version ', version,'      Copyright (C) Simon C horton 1998 - 2008');
      writeln('For information on Sauron Linux vist - http://www.sauron.uklinux.net');
      writeln;
      writeln('Release Name : ', RegTo);
      writeln('Compiled on  : ', cdate);
      writeln('Build Number : ', build);
      write('Running on a : ', uts.machine);
      writeln(' Linux Kernel Version ', uts.release);
    end
  else
    begin
      SQLConnect;
      ReadBBSConfig;
      StartBBS;
      UserInfo.CallNumber := BBSCfg.Calls;
      UpdateUserCallNumber(UserInfo.CallNumber, UserInfo.UserUID);
      UpdateBBSCalls;
      BeginBBS;
      CloseDataFiles;
      { Update User Data }
      UpdateUserLastCall(Today, UserInfo.UserUID);
      UpdateUserCalls(UserInfo.Calls + 1, UserInfo.UserUID);
      updateusertimestamp(UserInfo.UserTimeStamp, UserInfo.UserUID);
      UpdateUserCallsToday(UserInfo.CallsToday + 1, UserInfo.UserUID);
      UpdateUserTimeOnline(LastOnTime + MinutesPast, UserInfo.UserUID);
      UpdateUserLogonTime(fptime, UserInfo.UserUID);
      { dispose of PCHAR Vars }
      StrDispose(BBSCfg.SQLServer);
      StrDispose(BBSCfg.SQLUser);
      StrDispose(BBSCfg.SQLPass);
      StrDispose(BBSCfg.SQLDb);
      { Close Connection to SQL server }
      sql_close;
  end;
  Halt(0);
end.
